with System;
with System.Address_To_Access_Conversions;
with Interfaces.C;
with Interfaces.C.Strings;
with  Ada.Text_Io;

package body IOS_Interface is

   package To_Bool_Ptr is new System.Address_To_Access_Conversions( Boolean );

   package To_Int_Ptr is new System.Address_To_Access_Conversions( Integer );

   type Change_Var_Proc_Ptr_Type is access procedure( pData : System.Address );

   type Bool_Ptr is access all Boolean;

   type Int_Ptr is access all Integer;

   procedure hostAdd(  Host_Name       : Interfaces.C.Char_Array;
                       Host_IP_Address : Interfaces.C.Char_Array );

   pragma import( c, hostAdd, "hostAdd" );


   procedure RegisterIOSVariable( Annotation       : Interfaces.C.Char_Array;
                                  Variable_Address : System.address;
                                  Change_Value_Ptr : Change_Var_Proc_Ptr_Type;
                                  ucSize           : Interfaces.C.char);

   pragma import( c, RegisterIOSVariable, "RegisterIOSVariable" );

   Bool_Object_Ptr  : To_Bool_Ptr.Object_Pointer;

   Int_Object_Ptr   : To_Int_Ptr.Object_Pointer;

   Start_Simulation : boolean := false;
   --pragma Volatile( Start_Simulation );

   --Start_Simulation_Ptr : Bool_Ptr := Start_Simulation'access;  

   Int_Test_Var     : integer := 50;

   procedure set_Start_Simulation( pData : System.Address ) is

   begin

      Bool_Object_Ptr := To_Bool_Ptr.To_Pointer( pData );

      Start_Simulation := Bool_Ptr( Bool_Object_Ptr ).all;

      if ( Start_Simulation ) then

         Ada.Text_IO.Put_Line( "Flag is changed TO TRUE TRUE TRUE TRUE TRUE TRUE TRUE TRUE TRUE TRUE" );

      else

         Ada.Text_IO.Put_Line( "Flag is changed TO FALSE FALSE" );

      end if;

   end set_Start_Simulation;

   procedure set_Int_Test_Var( pData : System.Address ) is

   begin

      Int_Object_Ptr := To_Int_Ptr.To_Pointer( pData );

      Int_Test_Var := Int_Ptr( Int_Object_Ptr ).all;

      Ada.Text_IO.Put_Line( "Value of Int_Test_Var" & Integer'image( Int_Test_Var ) );

   end set_Int_Test_Var;

   function Is_Simulation_Started return boolean is

      Simulation_Is_Started : boolean;

   begin

      Simulation_Is_Started := Start_Simulation;

      return Start_Simulation;

   end Is_Simulation_Started;

   procedure Connect_To_IOS is

      ucSize : Interfaces.C.char := Interfaces.C.nul;

   begin

      hostAdd( Host_Name       => Interfaces.C.To_C( "jpats-tgt3" ),
               Host_IP_Address => Interfaces.C.To_C( "10,43,1,4" ) );


      RegisterIOSVariable( Annotation       => Interfaces.C.To_C( "Start_Simulation" ),
                           Variable_Address => Start_Simulation'address,
                           Change_Value_Ptr => set_Start_Simulation'access,
                           ucSize           => ucSize );

--      RegisterIOSVariable( Annotation       => Interfaces.C.To_C( "Integer_Test_Var" ),
--                           Variable_Address => Int_Test_Var'address,
--                           Change_Value_Ptr => set_Int_Test_Var'access,
--                           ucSize           => ucSize );

   end Connect_To_IOS;


end IOS_Interface;