/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : HostComms.h
//
// Date             : 06 May 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision$
//
// Description      : HostComms.h contains the defintions and #include needed
//                    for debugging and general compiling and linking.  It
//                    should be included by any code that uses *Protocol.cpp,
//                    and GenericSockets.cpp.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : None.
//
// Operational
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 4
//                                          Microsoft Windows NT 2000
//                                          VXWorks
//
//                    Compiler(s) - Visual C++ 6.0
//                                  Tornado 1.0.1
//
//                    Architechure(s) - Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log$
/////////////////////////////////////////////////////////////////////////////
#ifndef	_HOSTCOMMS_H_
#define _HOSTCOMMS_H_

#include <stdio.h>
#include <string.h>

#ifdef WIN32
    #pragma warning(disable:4786) // Disable the long identifier warnings
    #include <winsock2.h>
#else
    #ifdef VXWORKS
        #include "sockLib.h"
        #include "hostLib.h"
        #include "ioLib.h"
        #include "taskHookLib.h"
        #include "errnoLib.h"
        #include "tasklib.h"
        #include "netinet\tcp.h"

        #define WSAEWOULDBLOCK          EWOULDBLOCK
        #define WSAEINPROGRESS          EINPROGRESS
        #define WSAEALREADY             EALREADY
        #define WSAENOTSOCK             ENOTSOCK
        #define WSAEDESTADDRREQ         EDESTADDRREQ
        #define WSAEMSGSIZE             EMSGSIZE
        #define WSAEPROTOTYPE           EPROTOTYPE
        #define WSAENOPROTOOPT          ENOPROTOOPT
        #define WSAEPROTONOSUPPORT      EPROTONOSUPPORT
        #define WSAESOCKTNOSUPPORT      ESOCKTNOSUPPORT
        #define WSAEOPNOTSUPP           EOPNOTSUPP
        #define WSAEPFNOSUPPORT         EPFNOSUPPORT
        #define WSAEAFNOSUPPORT         EAFNOSUPPORT
        #define WSAEADDRINUSE           EADDRINUSE
        #define WSAEADDRNOTAVAIL        EADDRNOTAVAIL
        #define WSAENETDOWN             ENETDOWN
        #define WSAENETUNREACH          ENETUNREACH
        #define WSAENETRESET            ENETRESET
        #define WSAECONNABORTED         ECONNABORTED
        #define WSAECONNRESET           ECONNRESET
        #define WSAENOBUFS              ENOBUFS
        #define WSAEISCONN              EISCONN
        #define WSAENOTCONN             ENOTCONN
        #define WSAESHUTDOWN            ESHUTDOWN
        #define WSAETOOMANYREFS         ETOOMANYREFS
        #define WSAETIMEDOUT            ETIMEDOUT
        #define WSAECONNREFUSED         ECONNREFUSED
        #define WSAELOOP                ELOOP
        #define WSAENAMETOOLONG         ENAMETOOLONG
        #define WSAEHOSTDOWN            EHOSTDOWN
        #define WSAEHOSTUNREACH         EHOSTUNREACH
        #define WSAENOTEMPTY            ENOTEMPTY
        #define WSAEPROCLIM             EPROCLIM
        #define WSAEUSERS               EUSERS
        #define WSAEDQUOT               EDQUOT
        #define WSAESTALE               ESTALE
        #define WSAEREMOTE              EREMOTE
        #define GetLastError            errnoGet
        #define gethostbyname           hostGetByName
        #define closesocket             close
        #define ioctlsocket             ioctl

        #define	BOOL			        int
        #define FALSE			        0

        #define    INVALID_SOCKET       -1
        #define    PHOSTENT             int //struct hostent *
        #define    SOCKADDR_IN          struct sockaddr_in
        #define    SOCKET               int
        #define    SOCKET_ERROR	        -1
        #define    SD_BOTH              2
    #endif
#endif

#ifdef _DEBUG
    #define PRINT_ERRORS      1
    #define PRINT_STATISTICS  1
    #define PRINT_NOT_FOUND_ERRORS  1
#else
    #define PRINT_ERRORS      1
#endif

#endif /* _HOSTCOMMS_H_ */