/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : GenericHostSockets.h
//
// Date             : 06 May 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision$
//
// Description      : GenericHostSockets.h contains the definition of the 
//                    CGenericHostSockets class. CGenericHostSockets is meant to be 
//                    a generic class for creating a TCP strem socket.  Methods
//                    are also provided for reading to and writing data from 
//                    the stream socket.
//          
//                    To compile for VXWorks, the VXWORKS symbols must be 
//                    defined.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : CByteConversion.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 4
//                                          Microsoft Windows NT 2000
//                                          VXWorks
//
//                    Compiler(s) - Visual C++ 6.0
//                                  Tornado 1.0.1
//
//                    Architechure(s) - Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log$
/////////////////////////////////////////////////////////////////////////////
#ifndef _GENERIC_HOST_SOCKETS_H_
#define _GENERIC_HOST_SOCKETS_H_

// Typedefs for function pointers to byte ordering conversion routines.
typedef short (*GenericNtohs)(short s);
typedef long (*GenericNtohl)(long l);
typedef double (*GenericNtohd)(double d);
typedef short (*GenericHtons)(short s);
typedef long (*GenericHtonl)(long l);
typedef double (*GenericHtond)(double d);

enum BYTE_ORDERING
{
    LITTLE,
    BIG
};

class CGenericHostSockets
{
protected:
    // Function prototypes for byte ordering conversion routines.
    static inline short  ReverseS(short s);
    static inline long   ReverseL(long l);
    static inline double ReverseD(double d);
    static inline short  NoChangeS(short s);
    static inline long   NoChangeL(long l);
    static inline double NoChangeD(double d);

    unsigned long int       m_ulMaxReceiveBuffer;
    unsigned long int       m_ulReceiveCache;
    unsigned long int       m_ulMaxSendBuffer;
    BYTE_ORDERING           m_eNetworkByteOrdering;
    unsigned short          m_ushPort;
    unsigned short int      m_ushSendCache;

public:
    // Memory for receiving a command from the client.
    char*             m_cReceiveBuffer;

    // Memory for sending data to the client.
    char*            m_cSendBuffer;

    // Fuction pointers which get assigned either the Reverse
    // or NoChange functions depending on the type of architecture that
    // will run the code.
    GenericNtohs Ntohs;
    GenericNtohl Ntohl;
    GenericNtohd Ntohd;
    GenericHtons Htons;
    GenericHtonl Htonl;
    GenericHtond Htond;

    // The sockets
    SOCKET          m_socketAccept;
    SOCKET          m_socketListen;

    CGenericHostSockets(unsigned short ushPort = 3000,
                    unsigned long int ulMaxReceiveBuffer = 1460,
                    unsigned long int ulReceiveCache = 5,
                    unsigned long int ulMaxSendBuffer = 7300,
                    unsigned long int ulSendCache = 5,
                    BYTE_ORDERING eNetworkByteOrdering = BIG);

    ~CGenericHostSockets();

    void ReceiveData();
    void SendData();

    BOOL CloseAcceptSocket();
    BOOL CreateAcceptSocket();
    BOOL IsValidAcceptSocket();

    BOOL CloseListenSocket();
    BOOL CreateListenSocket();
    BOOL IsValidListenSocket();

    // Accessors
    inline unsigned long int MaxReceiveBuffer() { return m_ulMaxReceiveBuffer; }
    inline unsigned long int MaxSendBuffer()    { return m_ulMaxSendBuffer; }
};

#endif
