#include <math.h>
#include "HostComms.h"
#include "GenericHostSockets.h"
#include "Protocol.h"
#include "IOSProtocol.h"
#include "ZCTProtocol.h"
//#include "DCLSProtocol.h"
 
#define  PI          3.14159265358979323846264338327950288  // Standard value of PI (Radians in 180 Degrees).
#define  TWO_PI      2.0   *  PI                            // Standard value of PI * 2 (Radians in 360 Degrees).
#define  DEG_TO_RAD  (double)(PI    /  180.0)                         // Multiply an angle in Degrees by DEG_TO_RAD to convert the angle to Radians.
#define  RAD_TO_DEG  180.0 /  PI                            // Multiply an angle in Radians by RAD_TO_DEG to convert the angle to Degrees.

const double   NMI_FT         =  6076.1;
const double   NM_PER_DEGREE  =  60.0;

float    altitude =  -1000.0f;
float    barometric_pressure  =  22.0f;
float    torque      =  95.0f;
float    LeftItt     =  400.0f;
float    RightItt    =  800.0f;
float    LeftN1   =  0.0f;
float    RightN1  =  10.0f;
float    LeftN2   =  20.0f;
float    RightN2  =  40.0f;
float    RPM   =  0.0f;
float    EGT   =  10.0f;
float    np      =  0.0f;
float    oat      =  0.0f;
float    cockpit_alt      =  0.0f;
float    cockpit_diff_press      =  0.0f;
float    cockpit_rate_of_change      =  0.0f;
float    fuel_flow      =  0.0f;
float    raw_itt      =  700.0f;
float    leftFuelQuantity      =  0.0f;
float    rightFuelQuantity      =  0.0f;
float    temperature      =  85.0f;
float    oilPressure      =  0.0f;
float    hydraulicPressure      =  400.0f;
float    voltage      =  0.0f;
float    amperage       =  0.0f;
float    ac_pitch_lead  =  0.0f;
float    ac_roll_lead   =  0.0f;
float    ac_yaw_lead    =  0.0f;
float    ac_pitch_wing  =  0.0f;
float    ac_roll_wing   =  0.0f;
float    ac_yaw_wing    =  0.0f;
float    aoa      =  0.0f;
float    nav_frequency      =  0.0f;
float    acceleration      =  0.0f;
float    mission_time   =  0.0f;
float    flap_position      =  0.0f;
float    switch_position      =  0.0f;
float    glideslope_offset =  0.0f;
float    lateral_position_offset =  0.0f;
float    rudder_position_percentage =  0.0f;
float    throttle_position_percentage  =  0.0f;
float    test_value  =  0.0f;
float    stick_x_position  =  0.0f;
float    stick_y_position  =  0.0f;
float    left_landing_gear    =  0.0f;
float    nose_landing_gear    =  0.0f;
float    right_landing_gear   =  0.0f;
float    aileron_trim   =  0.0f;
float    rudder_trim    =  0.0f;
float    elevator_trim  =  0.0f;
float    map_scale      =  0.0f;
float    x_rotation     =  0.0f;
float    y_rotation     =  0.0f;
float    delta_altitude    =  0.0f;
float    delta_latitude    =  0.0f;
float    delta_longitude   =  0.0f;
float    viewer_distance   =  0.0f;
float    area_map_scale    =  0.0f;
float    area_map_latitude_center   =  0.0f;
float    area_map_longitude_center  =  0.0f;
float    ac_heading        =  0.0f;
double   ac_latitude       =  29.528889;
double   ac_longitude      =  -98.277778;
double   ac_latitude_requested       =  29.528889;
double   ac_longitude_requested      =  -98.277778;
float    ac_altitude       =  10.0f;
//float    lead_ac_heading   =  -10.0f;
float    lead_ac_heading   =  0.0f;
double   lead_ac_latitude  =  29.528889;
double   lead_ac_longitude =  -98.277778;
float    lead_ac_altitude  =  35.0f;
float    bearing1          =  0.0f;
float    bearing2          =  0.0f;
float    mach              =  0.0f;
float    ias               =  0.0f;
float    max_allowable_airspeed  =  300.0f;
float    vertical_speed    =  0.0f;
long     landing_lights    =  0;
bool     left_landing_gear_green    =  false;
bool     right_landing_gear_green   =  false;
bool     nose_landing_gear_green    =  false;
bool     left_landing_gear_red      =  false;
bool     right_landing_gear_red     =  false;
bool     nose_landing_gear_red      =  false;
bool     landing_gear_handle        =  false;
bool     landing_gear_handle_demanded = false;
bool     landing_gear_handle_light  = false;

long     Slewing  =  0;
long     nacws_display_range = 1;

bool     request_sortie_page  =  false;
bool     Demo_File_Valid   =  false;

float pcl_position   = 0.0f;
float   pcl_position_demanded = 0.0f;
bool  fire_test_1 = false;
bool  fire_test_2 = false;
bool  test_switch = false;
bool  firewall_shutoff = false;
bool  oxygen_handle = false;
long  inflow_switch = 1;
long  bld_inflow = 0;
bool  obogs_supply = 0;
bool  oxygen_max_sw = false;
long  ecs_press_switch = 1;
bool  master_bat_on_switch = true;
bool  master_gen_on_switch = true;
bool  aux_bat_on_switch = false;
bool  canopy_fracture = false;
long  gear_position = 1;
bool  pmu_switch = true;
bool  pmu_cb = true;
bool  start_cb = false;
bool  ign_cb = true;
bool  bat_cb = true;
bool  boost_pump_cb = true;
bool  rud_cb = true;
bool  ail_el_cb = false;
float N1 = 50.0;
long  start_sw = 1;
long  ignition_sw = 1;
bool  defog_sw = 1;
bool  ecs_man_hot_sw = false;
bool  ecs_man_cold_sw = false;
float ecs_temp = 50.0;
long  ram_air_fl = 1;
bool  gen_reset = false;
bool  bus_tie_sw = false;
bool  trim_interrupt_sw = true;
bool  trim_disconnect_sw = false;
bool  boost_pump_sw = true;
bool  fuel_bal_sw = true;
long  man_fuel_bal_sw = 1;
bool  emer_gear_ext_sw = true;
long  flap_ind_position = 1;
bool  gear_cb = true;
bool  lamp_test_sw = false;
bool  prop_sys_cb = false;
float total_fuel_qty = 10.0;
long  flap_handle = 1;
long    flap_handle_demanded = 1;
bool  parking_brake = false;
bool    parking_brake_demanded = false;
long  transponder = 1200;
bool  eject_handle = true;
bool  aux_bat_test_sw = true;
long  audio_test_sw = 1;
long  aoa_test_sw = 1;
long  fire_det_test_sw = 1;
bool  tad_sw = true;
bool  taxi_lights_sw = false;
bool  nav_lights_sw = false;
bool  anti_col_lights_sw = false;
bool  landing_lights_sw = true;
bool  elt_sw = false;
bool  avionics_master_sw = false;
bool  ahrs_compass_sw = true;
bool  probes_anti_ice_sw = true;
long  evap_blower_sw = 1;
bool  start_simulation = false;
float Itt = 235.0;
bool  canopy_lock_sw = true;
long  obogs_pressure_sw = 1;
bool  nacws_sw = false;
bool  backup_uhf_power_sw = false;
bool  anti_g_test_sw = true;
bool  speedbrake = false;
float oil_temperature = 56.2f;
bool  nosewheel_steering = false;
long  transponder_mode = 1;
bool  landing_gear_sw = false;    
float pressure_altitude = 18000.0f;
float altitude_agl = 1200.0f;
float Magnetic_Variation   =  20.0f;
double   Magvar_Latitude;
double   Magvar_Longitude;
bool     system_freeze;
bool     formation_flight  =  false;
bool     Formation_Lead_Profile_Driver =  false;
bool     Formation_Lead_Recorder_On    =  false;
char     Formation_Track_1_Name[16]    =  {  "Track 1"   };
char     Formation_Track_2_Name[16]    =  {  "Track 2"   };
char     Formation_Track_3_Name[16]    =  {  "Track 3"   };
char     Formation_Track_4_Name[16]    =  {  "Track 4"   };
char     Formation_Track_5_Name[16]    =  {  "Track 5"   };
char     Formation_Track_6_Name[16]    =  {  "Track 6"   };
char     Formation_Track_7_Name[16]    =  {  "Track 7"   };
char     Formation_Track_8_Name[16]    =  {  "Track 8"   };
char     Formation_Track_9_Name[16]    =  {  "Track 9"   };
char     Formation_Track_10_Name[16]   =  {  "Track 10"  };

char     Formation_Track_1_Name_R[16]  =  {  "Track 1"   };
char     Formation_Track_2_Name_R[16]  =  {  "Track 2"   };
char     Formation_Track_3_Name_R[16]  =  {  "Track 3"   };
char     Formation_Track_4_Name_R[16]  =  {  "Track 4"   };
char     Formation_Track_5_Name_R[16]  =  {  "Track 5"   };
char     Formation_Track_6_Name_R[16]  =  {  "Track 6"   };
char     Formation_Track_7_Name_R[16]  =  {  "Track 7"   };
char     Formation_Track_8_Name_R[16]  =  {  "Track 8"   };
char     Formation_Track_9_Name_R[16]  =  {  "Track 9"   };
char     Formation_Track_10_Name_R[16] =  {  "Track 10"  };

long     Formation_Number_of_Tracks    =  10;
long     Formation_Track_Number        =  1;
bool     Formation_Prev_Track          =  false;
bool     Formation_Next_Track          =  false;

bool     Formation_Load_Cmd            =  false;

float    Fore_Aft          =  0.0f;
float    Above_Below       =  0.0f;
float    Left_Right        =  0.0f;
long     Reposition_Select =  0;
long     Reposition_Formation_Id =  0;

bool  cb_command[78] = {false, false, false, false, false, false, false, false, false, false, false, false, false, false, 
                    false, false, false, false, false, false, false, false, false, false, false, false, false, false, 
                    false, false, false, false, false, false, false, false, false, false, false, false, false, false, 
                    false, false, false, false, false, false, false, false, false, false, false, false, false, false, 
                    false, false, false, false, false, false, false, false, false, false, false, false, false, false, 
                    false, false, false, false, false, false, false, false};

bool  cb_status[78] = {true, true, true, true, true, true, true, true, true, true, true, true, true, true, 
                    true, true, true, true, true, true, true, true, true, true, true, true, true, true, 
                    true, true, true, true, true, true, true, true, true, true, true, true, true, true, 
                    true, true, true, true, true, true, true, true, true, true, true, true, true, true, 
                    true, true, true, true, true, true, true, true, true, true, true, true, true, true, 
                    true, true, true, true, true, true, true, true};

bool  annunciator[33] = {false, false, false, false, false, false, false, false, false, false, false, false, false, false,
                     false, false, false, false, false, false, false, false, false, false, false, false, false, false,
                     false, false, false, false, false};

const int   MAX_STATION_KILL  =  16;
//char    navaid_ids[16][4];
char    navaid_ids[MAX_STATION_KILL*4]  =  {"ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890"};
int     navaid_status[MAX_STATION_KILL] = {0xf,0xe,0xd,0xc,0xb,0xa,0x9,0x8,0x7,0x6,0x5,0x4,0x3,0x2,0x1,0x0};
char  navaid_pending_id[4];
long  navaid_pending_status;
long  number_of_stations_killed  =  0;
long  reset_navaid_command =  0;
char    cText[16] = {"               "};

const int   MAX_SNAPSHOTS  =  20;
float    Snapshot_Time[MAX_SNAPSHOTS]        =  {  5.0f,    10.0f,   15.0f,   20.0f,   25.0f, 
                                                   30.0f,   35.0f,   40.0f,   45.0f,   50.0f,
                                                   55.0f,   60.0f,   65.0f,   70.0f,   75.0f,   
                                                   80.0f,   85.0f,   90.0f,   95.0f,   100.0f   };

double   Snapshot_Latitude[MAX_SNAPSHOTS]    =  {  29.00,   29.10,   29.20,   29.30,   29.40,
                                                   29.50,   29.60,   29.70,   29.80,   29.90,
                                                   30.00,   30.10,   30.20,   30.30,   30.40,
                                                   30.50,   30.60,   30.70,   30.80,   30.90    };   

double   Snapshot_Longitude[MAX_SNAPSHOTS]   =  {  -98.00,  -98.10,  -98.20,  -98.30,  -98.40,  
                                                   -98.50,  -98.60,  -98.70,  -98.80,  -98.90,
                                                   -99.00,  -99.10,  -99.20,  -99.30,  -99.40,
                                                   -99.50,  -99.60,  -99.70,  -99.80,  -99.90,};   

float    Snapshot_Altitude[MAX_SNAPSHOTS]    =  {  500.0f,  1000.0f, 1500.0f, 2000.0f, 2500.0f, 
                                                   3000.0f, 3500.0f, 4000.0f, 4500.0f, 5000.0f,
                                                   5500.0f, 6000.0f, 6500.0f, 7000.0f, 7500.0f,   
                                                   8000.0f, 8500.0f, 9000.0f, 9500.0f, 10000.0f   };

float    Snapshot_Heading[MAX_SNAPSHOTS]     =  {  10.0f,   20.0f,   30.0f,   40.0f,   50.0f, 
                                                   60.0f,   70.0f,   80.0f,   90.0f,   100.0f,
                                                   110.0f,  120.0f,  130.0f,  140.0f,  150.0f,   
                                                   160.0f,  170.0f,  180.0f,  190.0f,  200.0f   };

float    Snapshot_Airspeed[MAX_SNAPSHOTS]    =  {  15.0f,   25.0f,   35.0f,   45.0f,   55.0f, 
                                                   65.0f,   75.0f,   85.0f,   95.0f,   105.0f,
                                                   115.0f,  125.0f,  135.0f,  145.0f,  155.0f,   
                                                   165.0f,  175.0f,  185.0f,  195.0f,  205.0f   };

bool     Snapshot_Valid[MAX_SNAPSHOTS]       =  {  false,   false,   false,   false,   false,
                                                   false,   false,   false,   false,   false,
                                                   false,   false,   false,   false,   false,
                                                   false,   false,   false,   false,   false    };


bool     Replay_Pause_Play_Toggle   =  false;
bool     RMU_Power   =  true;
bool     EADI_Power  =  true;
bool     EHSI_Power  =  true;

char  Reposition_Airport[4];
char  Reposition_Runway[4];
char  Active_Airport[4];
char  Active_Runway[4];

bool  Reposition_Airport_Change  =  true;

bool    MFEN01 = true;
bool    MFEN02 = true;
bool    MFEN03 = true;
bool    MFEN04 = true;
bool    MFEN05 = true;
bool    MFEN06 = true;
bool    MFEN07 = true;
bool    MFEN08 = true;
bool    MFEN09 = true;
bool    MFEN10 = true;
bool    MFEN11 = true;

bool dummy_clear_all_cb;
bool dummy_reset_all_cb;
long  Adi_Mode =  0;

/* Start ATIS Stuff *****************/
char wxa1_airport_ident[5] = "MMCC";
char wxa2_airport_ident[5] = "KDRT";
char wxa3_airport_ident[5] = "KDLF";
char wxa4_airport_ident[5] = "T70 ";

char wxa1_active_rwy[4] = "13 ";
char wxa2_active_rwy[4] = "31 ";
char wxa3_active_rwy[4] = "13C";
char wxa4_active_rwy[4] = "31 ";

int wxa1_ceiling1 = 10000;
int wxa2_ceiling1 = 8000;
int wxa3_ceiling1 = 4000;
int wxa4_ceiling1 = 2000;

int wxa1_clouds1  = 0;
int wxa2_clouds1  = 1;
int wxa3_clouds1  = 2;
int wxa4_clouds1  = 3;

float wxa1_visibility_sm = 100.0f;
float wxa2_visibility_sm =  50.0f;
float wxa3_visibility_sm =  15.0f;
float wxa4_visibility_sm =   5.0f;

int wxa1_precip = 0;
int wxa2_precip = 0;
int wxa3_precip = 1;
int wxa4_precip = 2;

float wxa1_temperature_f = 150.0f;
float wxa2_temperature_f = 78.6f;
float wxa3_temperature_f = 80.4f;
float wxa4_temperature_f = 101.9f;

float wxa1_wind_dir = 15.0f;
float wxa2_wind_dir = 170.0f;
float wxa3_wind_dir = 185.0f;
float wxa4_wind_dir = 276.0f;

float wxa1_wind_speed = 5.0f;
float wxa2_wind_speed = 6.0f;
float wxa3_wind_speed = 10.0f;
float wxa4_wind_speed = 15.0f;

float wxa1_altimeter_inhg = 29.92f;
float wxa2_altimeter_inhg = 30.06f;
float wxa3_altimeter_inhg = 29.89f;
float wxa4_altimeter_inhg = 30.20f;
/* End ATIS Stuff ******************/


// IOS Pilot Stuff
bool  ios_pilot_enable              =  false;
bool  ios_pilot_takeoff             =  false;
long  ios_pilot_turn_direction      =  1;       // 1=Closest, 2=Left, 3=Right
long  ios_pilot_turn_rate           =  2;       // 1=0.5x,    2=1x,   3=1.5x
float ios_pilot_heading             =  0.0f;
float ios_pilot_altitude            =  0.0f;
long  ios_pilot_performance_mode    =  3;       // 1=IAS and Climb Rate, 2=Climb Rate and Torque, 3=Torque and IAS
bool  ios_pilot_ias_enabled         =  true;
bool  ios_pilot_climb_rate_enabled  =  false;
bool  ios_pilot_torque_enabled      =  true;
float ios_pilot_ias                 =  0.0f;
float ios_pilot_climb_rate          =  100.0f;
bool  ios_pilot_climb               =  false;
bool  ios_pilot_descend             =  false;
float ios_pilot_torque              =  0.0f;
long  ios_pilot_gear                =  0;       // 0=Up, 1=Down
long  ios_pilot_flaps               =  0;       // 0=Up, 1=Takeoff,  2=Landing
long  ios_pilot_speed_brake         =  0;       // 0=In, 1=Out
bool  ios_pilot_apply               =  false;
bool  ios_pilot_apply_enabled       =  false;
long  ios_pilot_error               =  0;

bool  ios_pilot_heading_increase    =  false;
bool  ios_pilot_heading_decrease    =  false;
bool  ios_pilot_altitude_increase   =  false;
bool  ios_pilot_altitude_decrease   =  false;
bool  ios_pilot_ias_increase        =  false;
bool  ios_pilot_ias_decrease        =  false;
bool  ios_pilot_torque_increase     =  false;
bool  ios_pilot_torque_decrease     =  false;

// End IOS Pilot Stuff

long  Comm_Updating;

void  set_Demo_File_Valid(void *pData)
{
   Demo_File_Valid   =  *((bool *)pData);
}

void set_request_sortie_page(void *pData)
{
  request_sortie_page = true;
}

void clear_all_cb(void *pData)
{
   for (int i=0; i<78; i++)
      cb_command[i] = false;
}

void reset_all_cb(void *pData)
{
   for (int i=0; i<78; i++)
      cb_status[i] = true;
}

void set_cb_command0(void *pData)
{
   cb_command[0] = *((bool *)pData);
   cb_status[0] = false;
}

void set_cb_command1(void *pData)
{
   cb_command[1] = *((bool *)pData);
   cb_status[1] = false;
}

void set_cb_command2(void *pData)
{
   cb_command[2] = *((bool *)pData);
   cb_status[2] = false;
}

void set_cb_command3(void *pData)
{
   cb_command[3] = *((bool *)pData);
   cb_status[3] = false;
}

void set_cb_command4(void *pData)
{
   cb_command[4] = *((bool *)pData);
   cb_status[4] = false;
}

void set_cb_command5(void *pData)
{
   cb_command[5] = *((bool *)pData);
   cb_status[5] = false;
}

void set_cb_command6(void *pData)
{
   cb_command[6] = *((bool *)pData);
   cb_status[6] = false;
}

void set_cb_command7(void *pData)
{
   cb_command[7] = *((bool *)pData);
   cb_status[7] = false;
}

void set_cb_command8(void *pData)
{
   cb_command[8] = *((bool *)pData);
   cb_status[8] = false;
}

void set_cb_command9(void *pData)
{
   cb_command[9] = *((bool *)pData);
   cb_status[9] = false;
}

void set_cb_command10(void *pData)
{
   cb_command[10] = *((bool *)pData);
   cb_status[10]= false;
}

void set_cb_command11(void *pData)
{
   cb_command[11] = *((bool *)pData);
   cb_status[11]= false;
}

void set_cb_command12(void *pData)
{
   cb_command[12] = *((bool *)pData);
   cb_status[12]= false;
}

void set_cb_command13(void *pData)
{
   cb_command[13] = *((bool *)pData);
   cb_status[13]= false;
}

void set_cb_command14(void *pData)
{
   cb_command[14] = *((bool *)pData);
   cb_status[14]= false;
}

void set_cb_command15(void *pData)
{
   cb_command[15] = *((bool *)pData);
   cb_status[15]= false;
}

void set_cb_command16(void *pData)
{
   cb_command[16] = *((bool *)pData);
   cb_status[16]= false;
}

void set_cb_command17(void *pData)
{
   cb_command[17] = *((bool *)pData);
   cb_status[17]= false;
}

void set_cb_command18(void *pData)
{
   cb_command[18] = *((bool *)pData);
   cb_status[18]= false;
}

void set_cb_command19(void *pData)
{
   cb_command[19] = *((bool *)pData);
   cb_status[19]= false;
}

void set_cb_command20(void *pData)
{
   cb_command[20] = *((bool *)pData);
   cb_status[20]= false;
}

void set_cb_command21(void *pData)
{
   cb_command[21] = *((bool *)pData);
   cb_status[21]= false;
}

void set_cb_command22(void *pData)
{
   cb_command[22] = *((bool *)pData);
   cb_status[22]= false;
}

void set_cb_command23(void *pData)
{
   cb_command[23] = *((bool *)pData);
   cb_status[23]= false;
}

void set_cb_command24(void *pData)
{
   cb_command[24] = *((bool *)pData);
   cb_status[24]= false;
}

void set_cb_command25(void *pData)
{
   cb_command[25] = *((bool *)pData);
   cb_status[25]= false;
}

void set_cb_command26(void *pData)
{
   cb_command[26] = *((bool *)pData);
   cb_status[26]= false;
}

void set_cb_command27(void *pData)
{
   cb_command[27] = *((bool *)pData);
   cb_status[27]= false;
}

void set_cb_command28(void *pData)
{
   cb_command[28] = *((bool *)pData);
   cb_status[28]= false;
}

void set_cb_command29(void *pData)
{
   cb_command[29] = *((bool *)pData);
   cb_status[29]= false;
}

void set_cb_command30(void *pData)
{
   cb_command[30] = *((bool *)pData);
   cb_status[30]= false;
}

void set_cb_command31(void *pData)
{
   cb_command[31] = *((bool *)pData);
   cb_status[31]= false;
}

void set_cb_command32(void *pData)
{
   cb_command[32] = *((bool *)pData);
   cb_status[32]= false;
}

void set_cb_command33(void *pData)
{
   cb_command[33] = *((bool *)pData);
   cb_status[33]= false;
}

void set_cb_command34(void *pData)
{
   cb_command[34] = *((bool *)pData);
   cb_status[34]= false;
}

void set_cb_command35(void *pData)
{
   cb_command[35] = *((bool *)pData);
   cb_status[35]= false;
}

void set_cb_command36(void *pData)
{
   cb_command[36] = *((bool *)pData);
   cb_status[36]= false;
}

void set_cb_command37(void *pData)
{
   cb_command[37] = *((bool *)pData);
   cb_status[37]= false;
}

void set_cb_command38(void *pData)
{
   cb_command[38] = *((bool *)pData);
   cb_status[38]= false;
}

void set_cb_command39(void *pData)
{
   cb_command[39] = *((bool *)pData);
   cb_status[39]= false;
}

void set_cb_command40(void *pData)
{
   cb_command[40] = *((bool *)pData);
   cb_status[40]= false;
}

void set_cb_command41(void *pData)
{
   cb_command[41] = *((bool *)pData);
   cb_status[41]= false;
}

void set_cb_command42(void *pData)
{
   cb_command[42] = *((bool *)pData);
   cb_status[42]= false;
}

void set_cb_command43(void *pData)
{
   cb_command[43] = *((bool *)pData);
   cb_status[43]= false;
}

void set_cb_command44(void *pData)
{
   cb_command[44] = *((bool *)pData);
   cb_status[44]= false;
}

void set_cb_command45(void *pData)
{
   cb_command[45] = *((bool *)pData);
   cb_status[45]= false;
}

void set_cb_command46(void *pData)
{
   cb_command[46] = *((bool *)pData);
   cb_status[46]= false;
}

void set_cb_command47(void *pData)
{
   cb_command[47] = *((bool *)pData);
   cb_status[47]= false;
}

void set_cb_command48(void *pData)
{
   cb_command[48] = *((bool *)pData);
   cb_status[48]= false;
}

void set_cb_command49(void *pData)
{
   cb_command[49] = *((bool *)pData);
   cb_status[49]= false;
}

void set_cb_command50(void *pData)
{
   cb_command[50] = *((bool *)pData);
   cb_status[50]= false;
}

void set_cb_command51(void *pData)
{
   cb_command[51] = *((bool *)pData);
   cb_status[51]= false;
}

void set_cb_command52(void *pData)
{
   cb_command[52] = *((bool *)pData);
   cb_status[52]= false;
}

void set_cb_command53(void *pData)
{
   cb_command[53] = *((bool *)pData);
   cb_status[53]= false;
}

void set_cb_command54(void *pData)
{
   cb_command[54] = *((bool *)pData);
   cb_status[54]= false;
}

void set_cb_command55(void *pData)
{
   cb_command[55] = *((bool *)pData);
   cb_status[55]= false;
}

void set_cb_command56(void *pData)
{
   cb_command[56] = *((bool *)pData);
   cb_status[56]= false;
}

void set_cb_command57(void *pData)
{
   cb_command[57] = *((bool *)pData);
   cb_status[57]= false;
}

void set_cb_command58(void *pData)
{
   cb_command[58] = *((bool *)pData);
   cb_status[58]= false;
}

void set_cb_command59(void *pData)
{
   cb_command[59] = *((bool *)pData);
   cb_status[59]= false;
}

void set_cb_command60(void *pData)
{
   cb_command[60] = *((bool *)pData);
   cb_status[60]= false;
}

void set_cb_command61(void *pData)
{
   cb_command[61] = *((bool *)pData);
   cb_status[61]= false;
}

void set_cb_command62(void *pData)
{
   cb_command[62] = *((bool *)pData);
   cb_status[62]= false;
}

void set_cb_command63(void *pData)
{
   cb_command[63] = *((bool *)pData);
   cb_status[63]= false;
}

void set_cb_command64(void *pData)
{
   cb_command[64] = *((bool *)pData);
   cb_status[64]= false;
}

void set_cb_command65(void *pData)
{
   cb_command[65] = *((bool *)pData);
   cb_status[65]= false;
}

void set_cb_command66(void *pData)
{
   cb_command[66] = *((bool *)pData);
   cb_status[66]= false;
}

void set_cb_command67(void *pData)
{
   cb_command[67] = *((bool *)pData);
   cb_status[67]= false;
}

void set_cb_command68(void *pData)
{
   cb_command[68] = *((bool *)pData);
   cb_status[68]= false;
}

void set_cb_command69(void *pData)
{
   cb_command[69] = *((bool *)pData);
   cb_status[69]= false;
}

void set_cb_command70(void *pData)
{
   cb_command[70] = *((bool *)pData);
   cb_status[70]= false;
}

void set_cb_command71(void *pData)
{
   cb_command[71] = *((bool *)pData);
   cb_status[71]= false;
}

void set_cb_command72(void *pData)
{
   cb_command[72] = *((bool *)pData);
   cb_status[72]= false;
}

void set_cb_command73(void *pData)
{
   cb_command[73] = *((bool *)pData);
   cb_status[73]= false;
}

void set_cb_command74(void *pData)
{
   cb_command[74] = *((bool *)pData);
   cb_status[74]= false;
}

void set_cb_command75(void *pData)
{
   cb_command[75] = *((bool *)pData);
   cb_status[75]= false;
}

void set_cb_command76(void *pData)
{
   cb_command[76] = *((bool *)pData);
   cb_status[76]= false;
}

void set_cb_command77(void *pData)
{
   cb_command[77] = *((bool *)pData);
   cb_status[77]= false;
}


void set_pressure_altitude(void *pData)
{
   pressure_altitude = *((float *)pData);
}

void set_altitude_agl(void *pData)
{
   altitude_agl = *((float *)pData);
}

void set_Magnetic_Variation(void *pData)
{
   Magnetic_Variation   =  *((float *)pData);
}

void set_Magvar_Latitude(void *pData)
{
   Magvar_Latitude   =  *((double *)pData);
//   printf("magvar_lat   =  %lf\n", Magvar_Latitude);
}

void set_Magvar_Longitude(void *pData)
{
   Magvar_Longitude  =  *((double *)pData);
//   printf("magvar_lon   =  %lf\n", Magvar_Longitude);
}

void set_landing_gear_sw(void *pData)
{
   landing_gear_sw = *((bool *)pData);
}

void set_system_freeze(void *pData)
{
   system_freeze  = *((bool *)pData);
}

void  set_formation_flight(void *pData)
{
   formation_flight  =  *((bool *)pData);
}

void  set_Formation_Lead_Profile_Driver(void *pData)
{
   Formation_Lead_Profile_Driver =  *((bool *)pData);
}

void  set_Formation_Lead_Recorder_On(void *pData)
{
   Formation_Lead_Recorder_On    =  *((bool *)pData);
}


void  set_Formation_Load_Cmd(void *pData)
{
   static   int   counter  =  0;

   Formation_Load_Cmd      =  *((bool *)pData);

   if (Formation_Load_Cmd)
   {
      Formation_Track_Number  =  1;
      sprintf(Formation_Track_1_Name,   "Track 1   -  %d",  counter);
      sprintf(Formation_Track_2_Name,   "Track 2   -  %d",  counter);
      sprintf(Formation_Track_3_Name,   "Track 3   -  %d",  counter);
      sprintf(Formation_Track_4_Name,   "Track 4   -  %d",  counter);
      sprintf(Formation_Track_5_Name,   "Track 5   -  %d",  counter);
      sprintf(Formation_Track_6_Name,   "Track 6   -  %d",  counter);
      sprintf(Formation_Track_7_Name,   "Track 7   -  %d",  counter);
      sprintf(Formation_Track_8_Name,   "Track 8   -  %d",  counter);
      sprintf(Formation_Track_9_Name,   "Track 9   -  %d",  counter);
      sprintf(Formation_Track_10_Name,  "Track 10  -  %d",  counter);
      counter++;
   }
   else
      Formation_Track_Number  =  0;
}


void  set_Formation_Prev_Track(void *pData)
{
   if (Formation_Track_Number >  1)
      Formation_Track_Number--;

   Formation_Prev_Track =  false;
}

void  set_Formation_Next_Track(void *pData)
{
   if (Formation_Track_Number <  Formation_Number_of_Tracks)
      Formation_Track_Number++;

   Formation_Next_Track =  false;
}


void  set_Formation_Track_Number(void *pData)
{
   Formation_Track_Number  = *((long *)pData);

   if (Formation_Track_Number <  1)
      Formation_Track_Number  =  1;
   else if (Formation_Track_Number >  Formation_Number_of_Tracks)
      Formation_Track_Number  =  Formation_Number_of_Tracks;
}

void  set_Formation_Number_of_Tracks(void *pData)
{
   Formation_Number_of_Tracks =  *((long *)pData);
}


void set_transponder_mode(void *pData)
{
   transponder_mode = *((long *)pData);
}

void set_nosewheel_steering(void *pData)
{
   nosewheel_steering = *((bool *)pData);
}

void set_oil_temperature(void *pData)
{
   oil_temperature = *((float *)pData);
}

void set_anti_g_test_sw(void *pData)
{
   anti_g_test_sw = *((bool *)pData);
}

void set_speedbrake(void *pData)
{
   speedbrake = *((bool *)pData);
}

void set_backup_uhf_power_sw(void *pData)
{
   backup_uhf_power_sw = *((bool *)pData);
}

void set_nacws_sw(void *pData)
{
   nacws_sw = *((bool *)pData);
}

void set_obogs_pressure_sw(void *pData)
{
   obogs_pressure_sw = *((long *)pData);
}

void set_canopy_lock_sw(void *pData)
{
   canopy_lock_sw = *((bool *)pData);
}

void set_Itt(void *pData)
{
   Itt = *((float *)pData);
}

void set_start_simulation(void *pData)
{
   start_simulation = *((bool *)pData);
}

void set_probes_anti_ice_sw(void *pData)
{
   probes_anti_ice_sw = *((bool *)pData);
}

void set_evap_blower_sw(void *pData)
{
   evap_blower_sw = *((long *)pData);
}

void set_elt_sw(void *pData)
{
   elt_sw = *((bool *)pData);
}

void set_avionics_master_sw(void *pData)
{
   avionics_master_sw = *((bool*)pData);
}

void set_ahrs_compass_sw(void *pData)
{
   ahrs_compass_sw = *((bool *)pData);
}

void set_taxi_lights_sw(void *pData)
{
   taxi_lights_sw = *((bool *)pData);
}

void set_landing_lights_sw(void *pData)
{
   landing_lights_sw = *((bool *)pData);
}

void set_nav_lights_sw(void *pData)
{
   nav_lights_sw = *((bool *)pData);
}

void set_anti_col_lights_sw(void *pData)
{
   anti_col_lights_sw = *((bool *)pData);
}


void set_tad_sw(void *pData)
{
   tad_sw = *((bool *)pData);
}

void set_fire_det_test_sw(void *pData)
{
   fire_det_test_sw = *((long *)pData);
}

void set_aoa_test_sw(void *pData)
{
   aoa_test_sw = *((long *)pData);
}

void set_audio_test_sw(void *pData)
{
   audio_test_sw = *((long *)pData);
}

void set_aux_bat_test_sw(void *pData)
{
   aux_bat_test_sw = *((bool *)pData);
}

void set_eject_handle(void *pData)
{
   eject_handle = *((bool *)pData);
}

void set_transponder(void *pData)
{
   transponder = *((long *)pData);
}

void set_parking_brake(void *pData)
{
   parking_brake = *((bool *)pData);
}

void set_parking_brake_demanded(void *pData)
{
    parking_brake_demanded = *((bool*)pData);
}

void set_flap_handle(void *pData)
{
   flap_handle = *((long *)pData);
}

void set_flap_handle_demanded(void *pData)
{
   flap_handle_demanded = *((long *)pData);
}

void set_total_fuel_qty(void *pData)
{
   total_fuel_qty = *((float *)pData);
}

void set_prop_sys_cb(void *pData)
{
   prop_sys_cb = *((bool*)pData);
}

void set_lamp_test_sw(void *pData)
{
   lamp_test_sw = *((bool*)pData);
}

void set_gear_cb(void *pData)
{
   gear_cb = *((bool*)pData);
}

void set_flap_ind_position(void *pData)
{
   flap_ind_position = *((bool*)pData);
}

void set_emer_gear_ext_sw(void *pData)
{
   emer_gear_ext_sw = *((bool*)pData);
}

void set_man_fuel_bal_sw(void *pData)
{
   man_fuel_bal_sw = *((long*)pData);
}

void set_fuel_bal_sw(void *pData)
{
   fuel_bal_sw = *((bool*)pData);
}

void set_boost_pump_sw(void *pData)
{
   boost_pump_sw = *((bool*)pData);
}

void set_rud_cb(void *pData)
{
   rud_cb = *((bool*)pData);
}

void set_ail_el_cb(void *pData)
{
   ail_el_cb = *((bool*)pData);
}

void set_trim_disconnect_sw(void *pData)
{
   trim_disconnect_sw = *((bool*)pData);
}

void set_trim_interrupt_sw(void *pData)
{
   trim_interrupt_sw = *((bool*)pData);
}

void set_bat_cb(void *pData)
{
   bat_cb = *((bool*)pData);
}

void set_bus_tie_sw(void *pData)
{
   bus_tie_sw = *((bool*)pData);
}

void set_gen_reset(void *pData)
{
   gen_reset = *((bool*)pData);
}

void set_ram_air_fl(void *pData)
{
   ram_air_fl = *((long*)pData);
}

void set_ecs_man_hot_sw(void *pData)
{
   ecs_man_hot_sw = *((bool*)pData);
}

void set_ecs_man_cold_sw(void *pData)
{
   ecs_man_cold_sw = *((bool*)pData);
}

void set_ecs_temp(void *pData)
{
   ecs_temp = *((float*)pData);
}

void set_defog_sw(void *pData)
{
   defog_sw = *((bool*)pData);
}

void set_ignition_sw(void *pData)
{
   ignition_sw = *((long*)pData);
}

void set_start_sw(void *pData)
{
   start_sw = *((long*)pData);
}

void set_N1(void *pData)
{
   N1 = *((float*)pData);
}

void set_boost_pump_cb(void *pData)
{
   boost_pump_cb = *((bool*)pData);
}

void set_pmu_cb(void *pData)
{
   pmu_cb = *((bool*)pData);
}

void set_ign_cb(void *pData)
{
   ign_cb = *((bool*)pData);
}

void set_start_cb(void *pData)
{
   start_cb = *((bool*)pData);
}

void set_pmu_switch(void *pData)
{
   gear_position = *((bool*)pData);
}

void set_gear_position(void *pData)
{
   gear_position = *((long*)pData);
}

void set_canopy_fracture(void *pData)
{
   canopy_fracture = *((bool*)pData);
}

void set_master_bat_on_switch(void *pData)
{
   master_bat_on_switch = *((bool*)pData);
}

void set_master_gen_on_switch(void *pData)
{
   master_gen_on_switch = *((bool*)pData);
}

void set_aux_bat_on_switch(void *pData)
{
   aux_bat_on_switch = *((bool*)pData);
}

void set_ecs_press_switch(void *pData)
{
   ecs_press_switch = *((long*)pData);
}

void set_oxygen_max_sw(void *pData)
{
   oxygen_max_sw = *((bool*)pData);
}

void set_obogs_supply(void *pData)
{
   obogs_supply = *((bool*)pData);
}

void set_bld_inflow(void *pData)
{
   bld_inflow = *((long*)pData);
}

void set_inflow_switch(void *pData)
{
   inflow_switch = *((long*)pData);
}

void set_oxygen_handle(void *pData)
{
   oxygen_handle = *((bool*)pData);
}

void set_firewall_shutoff(void *pData)
{
   firewall_shutoff = *((bool*)pData);
}

void set_test_switch(void *pData)
{
   test_switch = *((bool*)pData);
}


void set_fire_test_1(void* pData)
{
   fire_test_1 = *((bool*)pData);
}

void set_fire_test_2(void* pData)
{
   fire_test_2 = *((bool*)pData);
}

void set_altitude(void* pData)
{
    altitude = *((float*)pData);
}

void set_barometric_pressure(void* pData)
{
    barometric_pressure = *((float*)pData);
}

void set_torque(void* pData)
{
    torque = *((float*)pData);
}

void set_LeftItt(void* pData)
{
    LeftItt = *((float*)pData);
}

void set_RightItt(void* pData)
{
    RightItt = *((float*)pData);
}

void set_LeftN1(void* pData)
{
    LeftN1 = *((float*)pData);
}

void set_RightN1(void* pData)
{
    RightN1 = *((float*)pData);
}

void set_LeftN2(void* pData)
{
    LeftN2 = *((float*)pData);
}


void set_RightN2(void* pData)
{
    RightN2 = *((float*)pData);
}

void set_RPM(void* pData)
{
    RPM = *((float*)pData);
}

void set_EGT(void* pData)
{
    EGT = *((float*)pData);
}

void set_np(void* pData)
{
    np = *((float*)pData);
}

void set_oat(void* pData)
{
    oat = *((float*)pData);
}

void set_cockpit_alt(void* pData)
{
    cockpit_alt = *((float*)pData);
}

void set_cockpit_diff_press(void* pData)
{
    cockpit_diff_press = *((float*)pData);
}

void set_cockpit_rate_of_change(void* pData)
{
    cockpit_rate_of_change = *((float*)pData);
}

void set_fuel_flow(void* pData)
{
    fuel_flow = *((float*)pData);
}

void set_raw_itt(void* pData)
{
    raw_itt = *((float*)pData);
}

void set_leftFuelQuantity(void* pData)
{
    leftFuelQuantity = *((float*)pData);
}

void set_rightFuelQuantity(void* pData)
{
    rightFuelQuantity = *((float*)pData);
}

void set_temperature(void* pData)
{
    temperature = *((float*)pData);
}

void set_oilPressure(void* pData)
{
    oilPressure = *((float*)pData);
}

void set_hydraulicPressure(void* pData)
{
    hydraulicPressure = *((float*)pData);
}

void set_voltage(void* pData)
{
    voltage = *((float*)pData);
}

void set_amperage(void* pData)
{
    amperage = *((float*)pData);
}

void set_ac_pitch_lead(void* pData)
{
    ac_pitch_lead = *((float*)pData);
}

void set_ac_roll_lead(void* pData)
{
    ac_roll_lead  = *((float*)pData);
}

void set_ac_yaw_lead(void* pData)
{
    ac_yaw_lead = *((float*)pData);
}

void set_ac_pitch_wing(void* pData)
{
    ac_pitch_wing = *((float*)pData);
}

void set_ac_roll_wing(void* pData)
{
    ac_roll_wing  = *((float*)pData);
}

void set_ac_yaw_wing(void* pData)
{
    ac_yaw_wing = *((float*)pData);
}


void set_aoa(void* pData)
{
    aoa = *((float*)pData);
}

void set_nav_frequency(void* pData)
{
    nav_frequency = *((float*)pData);
}

void set_acceleration(void* pData)
{
    acceleration = *((float*)pData);
}

void set_mission_time(void* pData)
{
    mission_time = *((float*)pData);
}

void set_flap_position(void* pData)
{
    flap_position = *((float*)pData);
}

void set_switch_position(void* pData)
{
    switch_position = *((float*)pData);
}

void set_glideslope_offset(void* pData)
{
    glideslope_offset = *((float*)pData);
}

void set_lateral_position_offset(void* pData)
{
    lateral_position_offset = *((float*)pData);
}

void set_rudder_position_percentage(void* pData)
{
    rudder_position_percentage = *((float*)pData);
}

void set_throttle_position_percentage(void* pData)
{
    throttle_position_percentage = *((float*)pData);
}

void set_test_value(void* pData)
{
    test_value = *((float*)pData);
}

void set_stick_x_position(void* pData)
{
    stick_x_position = *((float*)pData);
}

void set_stick_y_position(void* pData)
{
    stick_y_position = *((float*)pData);
}

void set_left_landing_gear(void* pData)
{
    left_landing_gear = *((float*)pData);
}

void set_nose_landing_gear(void* pData)
{
    nose_landing_gear = *((float*)pData);
}

void set_right_landing_gear(void* pData)
{
    right_landing_gear = *((float*)pData);
}

void set_aileron_trim(void* pData)
{
    aileron_trim = *((float*)pData);
}

void set_rudder_trim(void* pData)
{
    rudder_trim = *((float*)pData);
}

void set_elevator_trim(void* pData)
{
    elevator_trim = *((float*)pData);
}

void set_map_scale(void* pData)
{
    map_scale = *((float*)pData);
}

void set_x_rotation(void* pData)
{
    x_rotation = *((float*)pData);
}

void set_y_rotation(void* pData)
{
    y_rotation = *((float*)pData);
}

void set_delta_altitude(void* pData)
{
    delta_altitude = *((float*)pData);
}

void set_delta_latitude(void* pData)
{
    delta_latitude = *((float*)pData);
}

void set_delta_longitude(void* pData)
{
    delta_longitude = *((float*)pData);
}

void set_viewer_distance(void* pData)
{
    viewer_distance = *((float*)pData);
}

void set_area_map_scale(void* pData)
{
    area_map_scale = *((float*)pData);
}

void set_area_map_latitude_center(void* pData)
{
    area_map_latitude_center = *((float*)pData);
}

void set_area_map_longitude_center(void* pData)
{
    area_map_longitude_center = *((float*)pData);
}

void set_ac_heading(void* pData)
{
    ac_heading = *((float*)pData);
}

void set_ac_latitude(void* pData)
{
//    ac_latitude = *((double*)pData);
    ac_latitude_requested = *((double*)pData);
}

void set_ac_longitude(void* pData)
{
//    ac_longitude = *((double*)pData);
    ac_longitude_requested = *((double*)pData);
}

void set_ac_altitude(void* pData)
{
    ac_altitude = *((float*)pData);
}

void  set_Fore_Aft(void* pData)
{
   Fore_Aft       =  *((float*)pData);
   ac_latitude    =  lead_ac_latitude  +  Fore_Aft /  (NMI_FT  *  NM_PER_DEGREE);
}

void  set_Above_Below(void* pData)
{
   Above_Below    =  *((float*)pData);
   ac_altitude    =  lead_ac_altitude  +  Above_Below;
}

void  set_Left_Right(void* pData)
{
   Left_Right        =  *((float*)pData);
   double   avg_lat  =  (lead_ac_latitude +  ac_latitude)   *  0.5;
   ac_longitude      =  lead_ac_longitude +  Left_Right  /  (NMI_FT  *  NM_PER_DEGREE  *  cos(avg_lat *  DEG_TO_RAD));
}

void  set_Reposition_Select(void* pData)
{
   Reposition_Select = *((long*)pData);
}

void  set_Reposition_Formation_Id(void* pData)
{
   Reposition_Formation_Id =  *((long*)pData);

   switch   (Reposition_Formation_Id)
   {
      case  0:          // "Touch"
         break;

      case  1:          // "Fingertip Left"
         Fore_Aft       =  -19.0f;
         ac_latitude    =  lead_ac_latitude  +  Fore_Aft    /  (NMI_FT  *  NM_PER_DEGREE);
         Above_Below    =  -3.0f;
         ac_altitude    =  lead_ac_altitude  +  Above_Below;
         Left_Right     =  -38.0f;
         ac_longitude   =  lead_ac_longitude +  Left_Right  /  (NMI_FT  *  NM_PER_DEGREE);
         break;
      
      case  2:          // "Fingertip Right"
         Fore_Aft       =  -19.0f;
         ac_latitude    =  lead_ac_latitude  +  Fore_Aft    /  (NMI_FT  *  NM_PER_DEGREE);
         Above_Below    =  -3.0f;
         ac_altitude    =  lead_ac_altitude  +  Above_Below;
         Left_Right     =  38.0f;
         ac_longitude   =  lead_ac_longitude +  Left_Right  /  (NMI_FT  *  NM_PER_DEGREE);
         break;
      
      case  3:          // "Close Trail"
         Fore_Aft       =  -52.0f;
         ac_latitude    =  lead_ac_latitude  +  Fore_Aft    /  (NMI_FT  *  NM_PER_DEGREE);
         Above_Below    =  -10.0f;
         ac_altitude    =  lead_ac_altitude  +  Above_Below;
         Left_Right     =  0.0f;
         ac_longitude   =  lead_ac_longitude +  Left_Right  /  (NMI_FT  *  NM_PER_DEGREE);
         break;

      case  4:          // "100ft Route Left"
         Fore_Aft       =  -64.25f;
         ac_latitude    =  lead_ac_latitude  +  Fore_Aft    /  (NMI_FT  *  NM_PER_DEGREE);
         Above_Below    =  -3.0f;
         ac_altitude    =  lead_ac_altitude  +  Above_Below;
         Left_Right     =  -132.5f;
         ac_longitude   =  lead_ac_longitude +  Left_Right  /  (NMI_FT  *  NM_PER_DEGREE);
         break;

      case  5:          // "100ft Route Right"
         Fore_Aft       =  -64.25f;
         ac_latitude    =  lead_ac_latitude  +  Fore_Aft    /  (NMI_FT  *  NM_PER_DEGREE);
         Above_Below    =  -3.0f;
         ac_altitude    =  lead_ac_altitude  +  Above_Below;
         Left_Right     =  132.5f;
         ac_longitude   =  lead_ac_longitude +  Left_Right  /  (NMI_FT  *  NM_PER_DEGREE);
         break;
   }
}


void set_lead_ac_heading(void* pData)
{
    lead_ac_heading = *((float*)pData);
}

void set_lead_ac_latitude(void* pData)
{
    lead_ac_latitude = *((double*)pData);
//    lead_ac_latitude_requested = *((double*)pData);
}

void set_lead_ac_longitude(void* pData)
{
    lead_ac_longitude = *((double*)pData);
//    lead_ac_longitude_requested = *((double*)pData);
}

void set_lead_ac_altitude(void* pData)
{
    lead_ac_altitude = *((float*)pData);
}

void set_bearing1(void* pData)
{
    bearing1 = *((float*)pData);
}

void set_bearing2(void* pData)
{
    bearing2 = *((float*)pData);
}

void set_mach(void* pData)
{
    mach = *((float*)pData);
}

void set_ias(void* pData)
{
    ias  = *((float*)pData);
}

void set_max_allowable_airspeed(void* pData)
{
    max_allowable_airspeed = *((float*)pData);
}

void set_vertical_speed(void* pData)
{
    vertical_speed= *((float*)pData);
}

void  set_landing_lights(void *pData)
{
    landing_lights   = *((long*)pData);
}


void  set_Slewing(void *pData)
{
    Slewing =  *((bool*)pData);
}


void  set_left_landing_gear_green(void *pData)
{
    left_landing_gear_green   =  *((bool*)pData);
}

void  set_right_landing_gear_green(void *pData)
{
    right_landing_gear_green  =  *((bool*)pData);
}

void  set_nose_landing_gear_green(void *pData)
{
    nose_landing_gear_green   =  *((bool*)pData);
}


void  set_left_landing_gear_red(void *pData)
{
    left_landing_gear_red  =  *((bool*)pData);
}

void  set_right_landing_gear_red(void *pData)
{
    right_landing_gear_red =  *((bool*)pData);
}

void  set_nose_landing_gear_red(void *pData)
{
    nose_landing_gear_red  =  *((bool*)pData);
}

void  set_landing_gear_handle(void *pData)
{
   landing_gear_handle     =  *((bool*)pData);
}

void  set_landing_gear_handle_demanded(void *pData)
{
   landing_gear_handle_demanded     =  *((bool*)pData);
}

void  set_landing_gear_handle_light(void *pData)
{
   landing_gear_handle_light     =  *((bool*)pData);
}

void set_pcl_position(void *pData)
{
   pcl_position = *((float*)pData);
}

void set_pcl_position_demanded(void *pData)
{
   pcl_position_demanded = *((float*)pData);
}


void  set_navaid_pending_id(void *pData, int nOffset_1D, int nOffset_2D, int nComplete)
{
   if (nOffset_1D< sizeof(navaid_pending_id)/sizeof(navaid_pending_id[0]))
   {
      memcpy(&navaid_pending_id[nOffset_1D], pData, sizeof(navaid_pending_id[0]));
   }
   if (nComplete)
   {
      int   length   =  strlen(navaid_pending_id);
      for (; length < 4; length++)
      {
         navaid_pending_id[length]  =  ' ';
      }
   }
}


void change_navaid_status(void *pData, int nOffset_1D, int nOffset_2D, int nComplete)
{
   navaid_pending_status   =  *(long*)pData;

   long  ii;
   for (ii = 0; ii < number_of_stations_killed * (long)sizeof(navaid_pending_id); ii += sizeof(navaid_pending_id))
   {
      if (!(strnicmp(&navaid_ids[ii], navaid_pending_id, sizeof(navaid_pending_id))))  // Found ident.
         break;
   }

   if (ii / (long)sizeof(navaid_pending_id) < number_of_stations_killed)    // Ident already exists, so update status.
   {
      if (navaid_pending_status)
      {
         navaid_status[ii / sizeof(navaid_pending_id)]   =  navaid_pending_status;
      }
      else                                // About to clear status so remove station from list.
      {
         long  jj =  ii / sizeof(navaid_pending_id);
         for (; jj < number_of_stations_killed; jj++)
         {
            navaid_status[jj]   =  navaid_status[jj + 1];

            strncpy(&navaid_ids[jj * sizeof(navaid_pending_id)], &navaid_ids[(jj + 1) * sizeof(navaid_pending_id)], sizeof(navaid_pending_id));
         }

         number_of_stations_killed--;
         if (number_of_stations_killed <  0)
            number_of_stations_killed  =  0;
      }
   }
   else                                   // Add ident and status.
   {
      strncpy(&navaid_ids[number_of_stations_killed * sizeof(navaid_pending_id)], navaid_pending_id, sizeof(navaid_pending_id));
      navaid_status[number_of_stations_killed]  =  navaid_pending_status;
      number_of_stations_killed++;

      if (number_of_stations_killed >  MAX_STATION_KILL)
         number_of_stations_killed  =  MAX_STATION_KILL;
   }
}

void  reset_navaid(void *pData)
{
   reset_navaid_command =  *(long*)pData;

   if (reset_navaid_command   == 2)
   {
      long  ii;
      for (ii = 0; ii < number_of_stations_killed * (long)sizeof(navaid_pending_id); ii += sizeof(navaid_pending_id))
      {
         if (!(strnicmp(&navaid_ids[ii], navaid_pending_id, sizeof(navaid_pending_id))))  // Found ident.
            break;
      }

      if (ii / (long)sizeof(navaid_pending_id) < number_of_stations_killed)    // Ident already exists, so update status.
      {
         long  jj =  ii / sizeof(navaid_pending_id);
         for (; jj < number_of_stations_killed; jj++)
         {
            navaid_status[jj]   =  navaid_status[jj + 1];

            strncpy(&navaid_ids[jj * sizeof(navaid_pending_id)], &navaid_ids[(jj + 1) * sizeof(navaid_pending_id)], sizeof(navaid_pending_id));
         }

         number_of_stations_killed--;
         if (number_of_stations_killed <  0)
            number_of_stations_killed  =  0;
      }
   }
   else
   {
      number_of_stations_killed  =  0;
      memset(&navaid_ids[0],     0, sizeof(navaid_ids));
      memset(&navaid_status[0],  0, sizeof(navaid_status));
   }
   reset_navaid_command =  0;
}


void  set_Formation_Track_1_Name_R(void *pData, int nOffset_1D, int nOffset_2D, int nComplete)
{
   if (nOffset_1D < sizeof(Formation_Track_1_Name_R)/sizeof(Formation_Track_1_Name_R[0]))
   {
      memcpy(&Formation_Track_1_Name_R[nOffset_1D], pData, sizeof(Formation_Track_1_Name_R[0]));
   }
}

void  set_Formation_Track_2_Name_R(void *pData, int nOffset_1D, int nOffset_2D, int nComplete)
{
   if (nOffset_1D < sizeof(Formation_Track_2_Name_R)/sizeof(Formation_Track_2_Name_R[0]))
   {
      memcpy(&Formation_Track_2_Name_R[nOffset_1D], pData, sizeof(Formation_Track_2_Name_R[0]));
   }
}

void  set_Formation_Track_3_Name_R(void *pData, int nOffset_1D, int nOffset_2D, int nComplete)
{
   if (nOffset_1D < sizeof(Formation_Track_3_Name_R)/sizeof(Formation_Track_3_Name_R[0]))
   {
      memcpy(&Formation_Track_3_Name_R[nOffset_1D], pData, sizeof(Formation_Track_3_Name_R[0]));
   }
}

void  set_Formation_Track_4_Name_R(void *pData, int nOffset_1D, int nOffset_2D, int nComplete)
{
   if (nOffset_1D < sizeof(Formation_Track_4_Name_R)/sizeof(Formation_Track_4_Name_R[0]))
   {
      memcpy(&Formation_Track_4_Name_R[nOffset_1D], pData, sizeof(Formation_Track_4_Name_R[0]));
   }
}

void  set_Formation_Track_5_Name_R(void *pData, int nOffset_1D, int nOffset_2D, int nComplete)
{
   if (nOffset_1D < sizeof(Formation_Track_5_Name_R)/sizeof(Formation_Track_5_Name_R[0]))
   {
      memcpy(&Formation_Track_5_Name_R[nOffset_1D], pData, sizeof(Formation_Track_5_Name_R[0]));
   }
}

void  set_Formation_Track_6_Name_R(void *pData, int nOffset_1D, int nOffset_2D, int nComplete)
{
   if (nOffset_1D < sizeof(Formation_Track_6_Name_R)/sizeof(Formation_Track_6_Name_R[0]))
   {
      memcpy(&Formation_Track_6_Name_R[nOffset_1D], pData, sizeof(Formation_Track_6_Name_R[0]));
   }
}

void  set_Formation_Track_7_Name_R(void *pData, int nOffset_1D, int nOffset_2D, int nComplete)
{
   if (nOffset_1D < sizeof(Formation_Track_7_Name_R)/sizeof(Formation_Track_7_Name_R[0]))
   {
      memcpy(&Formation_Track_7_Name_R[nOffset_1D], pData, sizeof(Formation_Track_7_Name_R[0]));
   }
}

void  set_Formation_Track_8_Name_R(void *pData, int nOffset_1D, int nOffset_2D, int nComplete)
{
   if (nOffset_1D < sizeof(Formation_Track_8_Name_R)/sizeof(Formation_Track_8_Name_R[0]))
   {
      memcpy(&Formation_Track_8_Name_R[nOffset_1D], pData, sizeof(Formation_Track_8_Name_R[0]));
   }
}

void  set_Formation_Track_9_Name_R(void *pData, int nOffset_1D, int nOffset_2D, int nComplete)
{
   if (nOffset_1D < sizeof(Formation_Track_9_Name_R)/sizeof(Formation_Track_9_Name_R[0]))
   {
      memcpy(&Formation_Track_9_Name_R[nOffset_1D], pData, sizeof(Formation_Track_9_Name_R[0]));
   }
}

void  set_Formation_Track_10_Name_R(void *pData, int nOffset_1D, int nOffset_2D, int nComplete)
{
   if (nOffset_1D < sizeof(Formation_Track_10_Name_R)/sizeof(Formation_Track_10_Name_R[0]))
   {
      memcpy(&Formation_Track_10_Name_R[nOffset_1D], pData, sizeof(Formation_Track_10_Name_R[0]));
   }
}



void set_Comm_Updating(void *pData)
{
    Comm_Updating = *((long*)pData);
}


void change_cText(void *pData, int nOffset_1D, int nOffset_2D, int nComplete)
{
    if (nOffset_1D < sizeof(cText)/sizeof(cText[0]))
    {
        memcpy(&cText[nOffset_1D], pData, sizeof(cText[0]));
    }
}

void change_Reposition_Airport(void *pData, int nOffset_1D, int nOffset_2D, int nComplete)
{
    if (nOffset_1D < sizeof(Reposition_Airport)/sizeof(Reposition_Airport[0]))
    {
        memcpy(&Reposition_Airport[nOffset_1D], pData, sizeof(Reposition_Airport[0]));
    }
}

void change_Reposition_Runway(void *pData, int nOffset_1D, int nOffset_2D, int nComplete)
{
    if (nOffset_1D < sizeof(Reposition_Runway)/sizeof(Reposition_Runway[0]))
    {
        memcpy(&Reposition_Runway[nOffset_1D], pData, sizeof(Reposition_Runway[0]));
    }
}

void  set_Reposition_Airport_Change(void *pData)
{
   Reposition_Airport_Change  =  *((bool*)pData);
}


void set_mfen01(void *pData)
{
    MFEN01 = *((bool*)pData);
}

void set_mfen02(void *pData)
{
    MFEN02 = *((bool*)pData);
}

void set_mfen03(void *pData)
{
    MFEN03 = *((bool*)pData);
}

void set_mfen04(void *pData)
{
    MFEN04 = *((bool*)pData);
}

void set_mfen05(void *pData)
{
    MFEN05 = *((bool*)pData);
}

void set_mfen06(void *pData)
{
    MFEN06 = *((bool*)pData);
}

void set_mfen07(void *pData)
{
    MFEN07 = *((bool*)pData);
}

void set_mfen08(void *pData)
{
    MFEN08 = *((bool*)pData);
}

void set_mfen09(void *pData)
{
    MFEN09 = *((bool*)pData);
}

void set_mfen10(void *pData)
{
    MFEN10 = *((bool*)pData);
}

void set_mfen11(void *pData)
{
    MFEN11 = *((bool*)pData);
}

void set_Adi_Mode(void *pData)
{
    Adi_Mode   = *((long*)pData);
}

void  set_Replay_Pause_Play_Toggle(void *pData)
{
   Replay_Pause_Play_Toggle   =  !  Replay_Pause_Play_Toggle;
}

void  set_RMU_Power(void *pData)
{
   RMU_Power   =  *((bool*)pData);
}

void  set_EADI_Power(void *pData)
{
   EADI_Power  =  *((bool*)pData);
}

void  set_EHSI_Power(void *pData)
{
   EHSI_Power  =  *((bool*)pData);
}



void  set_ios_pilot_enable(void  *pData)
{
    ios_pilot_enable          =  *((bool  *)pData);
    ios_pilot_apply_enabled   =  ios_pilot_enable;
}

void  set_ios_pilot_takeoff(void *pData)
{
   ios_pilot_takeoff          =  *((bool  *)pData);
   ios_pilot_apply_enabled    =  !ios_pilot_takeoff;
}

void  set_ios_pilot_turn_direction(void   *pData)
{
   ios_pilot_turn_direction   =  *((long  *)pData);      // 1=Closest, 2=Left, 3=Right
}

void  set_ios_pilot_turn_rate(void  *pData)
{
   ios_pilot_turn_rate  =  *((long  *)pData);            // 1=0.5x,    2=1x,   3=1.5x
}

void  set_ios_pilot_heading(void *pData)
{
   ios_pilot_heading =  *((float *)pData);
}

void  set_ios_pilot_altitude(void   *pData)
{
   ios_pilot_altitude   =  *((float *)pData);
}

void  set_ios_pilot_performance_mode(void *pData)
{
   ios_pilot_performance_mode =  *((long  *)pData);   

   switch   (ios_pilot_performance_mode)
   {
      case  1:                                           // 1=IAS and Climb Rate
            ios_pilot_ias_enabled         =  true;
            ios_pilot_climb_rate_enabled  =  true;
            ios_pilot_torque_enabled      =  false;
            break;

      case  2:                                           // 2=Climb Rate and Torque 
            ios_pilot_ias_enabled         =  false;
            ios_pilot_climb_rate_enabled  =  true;
            ios_pilot_torque_enabled      =  true;
            break;
      
      case  3:                                           // 3=Torque and IAS
            ios_pilot_ias_enabled         =  true;
            ios_pilot_climb_rate_enabled  =  false;
            ios_pilot_torque_enabled      =  true;
            break;
   }
}

void  set_ios_pilot_ias(void  *pData)
{
   ios_pilot_ias  =  *((float *)pData);
}

void  set_ios_pilot_climb_rate(void *pData)
{
   ios_pilot_climb_rate =  *((float *)pData);
}

void  set_ios_pilot_climb(void   *pData)
{
   ios_pilot_climb               =  false;
   ios_pilot_climb_rate          += 100.0f;
   if (ios_pilot_climb_rate      >  4000.0f)
      ios_pilot_climb_rate       =  4000.0f;
   else if (ios_pilot_climb_rate <  -4000.0f)
      ios_pilot_climb_rate       =  -4000.0f;
}

void  set_ios_pilot_descend(void *pData)
{
   ios_pilot_descend             =  false;
   ios_pilot_climb_rate          -= 100.0f;
   if (ios_pilot_climb_rate      >  4000.0f)
      ios_pilot_climb_rate       =  4000.0f;
   else if (ios_pilot_climb_rate <  -4000.0f)
      ios_pilot_climb_rate       =  -4000.0f;
}

void  set_ios_pilot_torque(void  *pData)
{
   ios_pilot_torque  =  *((float *)pData);
}

void  set_ios_pilot_gear(void *pData)
{
   ios_pilot_gear =  *((long  *)pData);               // 0=Up, 1=Down
}

void  set_ios_pilot_flaps(void   *pData)
{
   ios_pilot_flaps   =  *((long  *)pData);            // 0=Up, 1=Takeoff,  2=Landing
}

void  set_ios_pilot_speed_brake(void   *pData)
{
   ios_pilot_speed_brake   =  *((long  *)pData);      // 0=In, 1=Out
}

void  set_ios_pilot_apply(void   *pData)
{
   ios_pilot_apply   =  *((bool  *)pData);
   ios_pilot_apply   =  false;
}

void  set_ios_pilot_heading_increase(void *pData)
{
   ios_pilot_heading_increase =  false;
   ios_pilot_heading          += 1.0f;
   while (ios_pilot_heading   >= 360.0f)
      ios_pilot_heading       -= 360.0f;
}

void  set_ios_pilot_heading_decrease(void *pData)
{
   ios_pilot_heading_decrease =  false;
   ios_pilot_heading          -= 1.0f;
   while (ios_pilot_heading   <= 0.0f)
      ios_pilot_heading       += 360.0f;
}


void  set_ios_pilot_altitude_increase(void *pData)
{
   ios_pilot_altitude_increase   =  false;
   ios_pilot_altitude            += 100.0f;
   if (ios_pilot_altitude        >  31000.0f)
      ios_pilot_altitude         =  31000.0f;
   else if (ios_pilot_altitude   <  0.0f)
      ios_pilot_altitude         =  0.0f;
}

void  set_ios_pilot_altitude_decrease(void *pData)
{
   ios_pilot_altitude_decrease   =  false;
   ios_pilot_altitude            -= 100.0f;
   if (ios_pilot_altitude        >  31000.0f)
      ios_pilot_altitude         =  31000.0f;
   else if (ios_pilot_altitude   <  0.0f)
      ios_pilot_altitude         =  0.0f;
}


void  set_ios_pilot_ias_increase(void *pData)
{
   ios_pilot_ias_increase     =  false;
   ios_pilot_ias              += 5.0f;
   if (ios_pilot_ias          >  270.0f)
      ios_pilot_ias           =  270.0f;
   else if (ios_pilot_ias     <  80.0f)
      ios_pilot_ias           =  80.0f;
}

void  set_ios_pilot_ias_decrease(void *pData)
{
   ios_pilot_ias_decrease     =  false;
   ios_pilot_ias              -= 5.0f;
   if (ios_pilot_ias          >  270.0f)
      ios_pilot_ias           =  270.0f;
   else if (ios_pilot_ias     <  80.0f)
      ios_pilot_ias           =  80.0f;
}


void  set_ios_pilot_torque_increase(void *pData)
{
   ios_pilot_torque_increase  =  false;
   ios_pilot_torque           += 5.0f;
   if (ios_pilot_torque       >  100.0f)
      ios_pilot_torque        =  100.0f;
   else if (ios_pilot_torque  <  0.0f)
      ios_pilot_torque        =  0.0f;
}

void  set_ios_pilot_torque_decrease(void *pData)
{
   ios_pilot_torque_decrease  =  false;
   ios_pilot_torque           -= 5.0f;
   if (ios_pilot_torque       >  100.0f)
      ios_pilot_torque        =  100.0f;
   else if (ios_pilot_torque  <  0.0f)
      ios_pilot_torque        =  0.0f;
}


void  set_ios_pilot_error(void *pData)
{
   ios_pilot_error   =  *((long  *)pData);
}

void set_nacws_display_range(void *pData)
{
   nacws_display_range = *((long *)pData);
}

bool vsi_valid = true;
void set_vsi_valid(void *pData)
{
   vsi_valid = *((bool *)pData);
}

bool nacws_test = false;
void set_nacws_test(void *pData)
{
   nacws_test = *((bool*)pData);
}

long nacws_mode = 0;
void set_nacws_mode(void *pData)
{
   nacws_mode = *((long*)pData);
}


float  Nacws_Intr_Range_1 = 0.0f;
void set_Nacws_Intr_Range_1(void *pData)
{
   Nacws_Intr_Range_1=*((float*)pData);
}

float  Nacws_Intr_Range_2 = 0.0f;
void set_Nacws_Intr_Range_2(void *pData)
{
   Nacws_Intr_Range_2=*((float*)pData);
}

float Nacws_Intr_Rel_Alt_1 = 0.0f;
void set_Nacws_Intr_Rel_Alt_1(void *pData)
{
   Nacws_Intr_Rel_Alt_1=*((float*)pData);
}

float Nacws_Intr_Rel_Alt_2 = 0.0f;
void set_Nacws_Intr_Rel_Alt_2(void *pData)
{
   Nacws_Intr_Rel_Alt_2=*((float*)pData);
}

long  Nacws_Intr_Disp_Type_1 = 0;
void set_Nacws_Intr_Disp_Type_1(void *pData)
{
   Nacws_Intr_Disp_Type_1=*((long*)pData);
}

long  Nacws_Intr_Disp_Type_2 = 0;
void set_Nacws_Intr_Disp_Type_2(void *pData)
{
   Nacws_Intr_Disp_Type_2=*((long*)pData);
}

float Nacws_Intr_Brg_1 = 0.0f;
void set_Nacws_Intr_Brg_1(void *pData)
{
   Nacws_Intr_Brg_1=*((float*)pData);
}

float Nacws_Intr_Brg_2 = 0.0f;
void set_Nacws_Intr_Brg_2(void *pData)
{
   Nacws_Intr_Brg_2=*((float*)pData);
}

bool  Nacws_Intr_Active_1 = false;
void set_Nacws_Intr_Active_1(void *pData)
{
   Nacws_Intr_Active_1=*((bool*)pData);
}

bool  Nacws_Intr_Active_2 = false;
void set_Nacws_Intr_Active_2(void *pData)
{
   Nacws_Intr_Active_2=*((bool*)pData);
}

bool  Vsi_Power = true;
void set_Vsi_Power(void *pData)
{
   Vsi_Power=*((bool*)pData);
}

long Tas_Mode_Sw = 0;
void set_Tas_Mode_Sw(void *pData)
{
   Tas_Mode_Sw=*((long*)pData);
}

bool Nacws_Sw_Off = false;
void set_Nacws_Sw_Off(void *pData)
{
   Nacws_Sw_Off=*((bool*)pData);
}

#ifdef __cplusplus
extern "C"
{
#endif // __cplusplus

BOOL IOSHostCommsConnected ();
void IOSHostCommsProcessCommands(BOOL Replay, BOOL Restore);
BOOL IOSHostCommsReadValues ();
BOOL IOSHostCommsInitialize();

void IOSHostComms(long int lDelay);
//void DCLSHostComms(long int lDelay);
void ZCTHostComms(long int lDelay);
void RegisterIOSVariable(const char* pcName, void* pReadAddress,
                                Mutator pChangeValue, unsigned char ucSize, BOOL playBack);
void RegisterIOSVariableEx(const char* pcName, void* pReadAddress,
                                ArrayMutator pChangeValue, unsigned char ucSize,
                                BOOL playBack, float fLow, float fHigh, 
                                long lLength1D, long lLength2D);
#ifdef __cplusplus
}
#endif // __cplusplus


//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
void commstest(void)
{

#ifdef VXWORKS
   hostAdd("jpats-tgt1", "206.189.251.194");
   hostAdd("jpats-target", "206.189.251.194");
#endif
   RegisterIOSVariable("request_sortie_page",         &request_sortie_page,         set_request_sortie_page,         sizeof(request_sortie_page),           true);
   RegisterIOSVariable("Demo_File_Valid",             &Demo_File_Valid,             set_Demo_File_Valid,             sizeof(Demo_File_Valid),               true);

   RegisterIOSVariableEx("navaid_ids",                &navaid_ids,                  set_navaid_pending_id,           sizeof(navaid_ids[0]),                 true, 0.0f, 0.0f, sizeof(navaid_ids)   /sizeof(navaid_ids[0]),    1);
   RegisterIOSVariableEx("navaid_status",             &navaid_status,               change_navaid_status,            sizeof(navaid_status[0]),              true, 0.0f, 0.0f, sizeof(navaid_status)/sizeof(navaid_status[0]), 1);

   RegisterIOSVariableEx("Formation_Track_1_Name",    &Formation_Track_1_Name,      NULL,                            sizeof(Formation_Track_1_Name[0]),     true, 0.0f, 0.0f, sizeof(Formation_Track_1_Name)/sizeof(Formation_Track_1_Name[0]), 1);
   RegisterIOSVariableEx("Formation_Track_2_Name",    &Formation_Track_2_Name,      NULL,                            sizeof(Formation_Track_2_Name[0]),     true, 0.0f, 0.0f, sizeof(Formation_Track_2_Name)/sizeof(Formation_Track_2_Name[0]), 1);
   RegisterIOSVariableEx("Formation_Track_3_Name",    &Formation_Track_3_Name,      NULL,                            sizeof(Formation_Track_3_Name[0]),     true, 0.0f, 0.0f, sizeof(Formation_Track_3_Name)/sizeof(Formation_Track_3_Name[0]), 1);
   RegisterIOSVariableEx("Formation_Track_4_Name",    &Formation_Track_4_Name,      NULL,                            sizeof(Formation_Track_4_Name[0]),     true, 0.0f, 0.0f, sizeof(Formation_Track_4_Name)/sizeof(Formation_Track_4_Name[0]), 1);
   RegisterIOSVariableEx("Formation_Track_5_Name",    &Formation_Track_5_Name,      NULL,                            sizeof(Formation_Track_5_Name[0]),     true, 0.0f, 0.0f, sizeof(Formation_Track_5_Name)/sizeof(Formation_Track_5_Name[0]), 1);
   RegisterIOSVariableEx("Formation_Track_6_Name",    &Formation_Track_6_Name,      NULL,                            sizeof(Formation_Track_6_Name[0]),     true, 0.0f, 0.0f, sizeof(Formation_Track_6_Name)/sizeof(Formation_Track_6_Name[0]), 1);
   RegisterIOSVariableEx("Formation_Track_7_Name",    &Formation_Track_7_Name,      NULL,                            sizeof(Formation_Track_7_Name[0]),     true, 0.0f, 0.0f, sizeof(Formation_Track_7_Name)/sizeof(Formation_Track_7_Name[0]), 1);
   RegisterIOSVariableEx("Formation_Track_8_Name",    &Formation_Track_8_Name,      NULL,                            sizeof(Formation_Track_8_Name[0]),     true, 0.0f, 0.0f, sizeof(Formation_Track_8_Name)/sizeof(Formation_Track_8_Name[0]), 1);
   RegisterIOSVariableEx("Formation_Track_9_Name",    &Formation_Track_9_Name,      NULL,                            sizeof(Formation_Track_9_Name[0]),     true, 0.0f, 0.0f, sizeof(Formation_Track_9_Name)/sizeof(Formation_Track_9_Name[0]), 1);
   RegisterIOSVariableEx("Formation_Track_10_Name",   &Formation_Track_10_Name,     NULL,                            sizeof(Formation_Track_10_Name[0]),    true, 0.0f, 0.0f, sizeof(Formation_Track_10_Name)/sizeof(Formation_Track_10_Name[0]), 1);

   RegisterIOSVariableEx("Formation_Track_1_Name_R",  &Formation_Track_1_Name_R,    set_Formation_Track_1_Name_R,    sizeof(Formation_Track_1_Name_R[0]),   true, 0.0f, 0.0f, sizeof(Formation_Track_1_Name_R)/sizeof(Formation_Track_1_Name_R[0]), 1);
   RegisterIOSVariableEx("Formation_Track_2_Name_R",  &Formation_Track_2_Name_R,    set_Formation_Track_2_Name_R,    sizeof(Formation_Track_2_Name_R[0]),   true, 0.0f, 0.0f, sizeof(Formation_Track_2_Name_R)/sizeof(Formation_Track_2_Name_R[0]), 1);
   RegisterIOSVariableEx("Formation_Track_3_Name_R",  &Formation_Track_3_Name_R,    set_Formation_Track_3_Name_R,    sizeof(Formation_Track_3_Name_R[0]),   true, 0.0f, 0.0f, sizeof(Formation_Track_3_Name_R)/sizeof(Formation_Track_3_Name_R[0]), 1);
   RegisterIOSVariableEx("Formation_Track_4_Name_R",  &Formation_Track_4_Name_R,    set_Formation_Track_4_Name_R,    sizeof(Formation_Track_4_Name_R[0]),   true, 0.0f, 0.0f, sizeof(Formation_Track_4_Name_R)/sizeof(Formation_Track_4_Name_R[0]), 1);
   RegisterIOSVariableEx("Formation_Track_5_Name_R",  &Formation_Track_5_Name_R,    set_Formation_Track_5_Name_R,    sizeof(Formation_Track_5_Name_R[0]),   true, 0.0f, 0.0f, sizeof(Formation_Track_5_Name_R)/sizeof(Formation_Track_5_Name_R[0]), 1);
   RegisterIOSVariableEx("Formation_Track_6_Name_R",  &Formation_Track_6_Name_R,    set_Formation_Track_6_Name_R,    sizeof(Formation_Track_6_Name_R[0]),   true, 0.0f, 0.0f, sizeof(Formation_Track_6_Name_R)/sizeof(Formation_Track_6_Name_R[0]), 1);
   RegisterIOSVariableEx("Formation_Track_7_Name_R",  &Formation_Track_7_Name_R,    set_Formation_Track_7_Name_R,    sizeof(Formation_Track_7_Name_R[0]),   true, 0.0f, 0.0f, sizeof(Formation_Track_7_Name_R)/sizeof(Formation_Track_7_Name_R[0]), 1);
   RegisterIOSVariableEx("Formation_Track_8_Name_R",  &Formation_Track_8_Name_R,    set_Formation_Track_8_Name_R,    sizeof(Formation_Track_8_Name_R[0]),   true, 0.0f, 0.0f, sizeof(Formation_Track_8_Name_R)/sizeof(Formation_Track_8_Name_R[0]), 1);
   RegisterIOSVariableEx("Formation_Track_9_Name_R",  &Formation_Track_9_Name_R,    set_Formation_Track_9_Name_R,    sizeof(Formation_Track_9_Name_R[0]),   true, 0.0f, 0.0f, sizeof(Formation_Track_9_Name_R)/sizeof(Formation_Track_9_Name_R[0]), 1);
   RegisterIOSVariableEx("Formation_Track_10_Name_R", &Formation_Track_10_Name_R,   set_Formation_Track_10_Name_R,   sizeof(Formation_Track_10_Name_R[0]),  true, 0.0f, 0.0f, sizeof(Formation_Track_10_Name_R)/sizeof(Formation_Track_10_Name_R[0]), 1);


   RegisterIOSVariableEx("Snapshot_Time",             &Snapshot_Time,               NULL,                            sizeof(Snapshot_Time[0]),              true, 0.0f, 0.0f, sizeof(Snapshot_Time)/sizeof(Snapshot_Time[0]), 1);
   RegisterIOSVariableEx("Snapshot_Latitude",         &Snapshot_Latitude,           NULL,                            sizeof(Snapshot_Latitude[0]),          true, 0.0f, 0.0f, sizeof(Snapshot_Latitude)/sizeof(Snapshot_Latitude[0]), 1);
   RegisterIOSVariableEx("Snapshot_Longitude",        &Snapshot_Longitude,          NULL,                            sizeof(Snapshot_Longitude[0]),         true, 0.0f, 0.0f, sizeof(Snapshot_Longitude)/sizeof(Snapshot_Longitude[0]), 1);
   RegisterIOSVariableEx("Snapshot_Altitude",         &Snapshot_Altitude,           NULL,                            sizeof(Snapshot_Altitude[0]),          true, 0.0f, 0.0f, sizeof(Snapshot_Altitude)/sizeof(Snapshot_Altitude[0]), 1);
   RegisterIOSVariableEx("Snapshot_Heading",          &Snapshot_Heading,            NULL,                            sizeof(Snapshot_Heading[0]),           true, 0.0f, 0.0f, sizeof(Snapshot_Heading)/sizeof(Snapshot_Heading[0]), 1);
   RegisterIOSVariableEx("Snapshot_Airspeed",         &Snapshot_Airspeed,           NULL,                            sizeof(Snapshot_Airspeed[0]),          true, 0.0f, 0.0f, sizeof(Snapshot_Airspeed)/sizeof(Snapshot_Airspeed[0]), 1);
   RegisterIOSVariableEx("Snapshot_Valid",            &Snapshot_Valid,              NULL,                            sizeof(Snapshot_Valid[0]),             true, 0.0f, 0.0f, sizeof(Snapshot_Valid)/sizeof(Snapshot_Valid[0]), 1);

   RegisterIOSVariable("Replay_Pause_Play_Toggle",    &Replay_Pause_Play_Toggle,    set_Replay_Pause_Play_Toggle,    sizeof(Replay_Pause_Play_Toggle),      true);
   
   RegisterIOSVariable("RMU_Power",                   &RMU_Power,                   set_RMU_Power,                   sizeof(RMU_Power),                     true);
   RegisterIOSVariable("EADI_Power",                  &EADI_Power,                  set_EADI_Power,                  sizeof(EADI_Power),                    true);
   RegisterIOSVariable("EHSI_Power",                  &EHSI_Power,                  set_EHSI_Power,                  sizeof(EHSI_Power),                    true);


   RegisterIOSVariable("Comm Updating",               &Comm_Updating,               set_Comm_Updating,               sizeof(Comm_Updating),                 true);


   RegisterIOSVariable("reset_navaid_command",        &reset_navaid_command,        reset_navaid,                    sizeof(reset_navaid_command),          true);
   RegisterIOSVariable("navaid_kill_count",           &number_of_stations_killed,   NULL,                            sizeof(number_of_stations_killed),     true);

   RegisterIOSVariableEx("cText",                     &cText,                       change_cText,                    sizeof(cText[0]),                      true, 0.0f, 0.0f, sizeof(cText)/sizeof(cText[0]), 1);
   RegisterIOSVariableEx("Reposition_Airport",        &Reposition_Airport,          change_Reposition_Airport,       sizeof(Reposition_Airport[0]),         true, 0.0f, 0.0f, sizeof(Reposition_Airport)/sizeof(Reposition_Airport[0]), 1);
   RegisterIOSVariableEx("Reposition_Runway",         &Reposition_Runway,           change_Reposition_Runway,        sizeof(Reposition_Runway[0]),          true, 0.0f, 0.0f, sizeof(Reposition_Runway) /sizeof(Reposition_Runway[0]), 1);
   strncpy(Reposition_Airport, "KDLF", 4);
   strncpy(Reposition_Runway,  "13C ", 4);

   RegisterIOSVariableEx("Active_Airport",            &Active_Airport,              NULL,                            sizeof(Active_Airport[0]),             true, 0.0f, 0.0f, sizeof(Active_Airport)/sizeof(Active_Airport[0]), 1);
   RegisterIOSVariableEx("Active_Runway",             &Active_Runway,               NULL,                            sizeof(Active_Runway[0]),              true, 0.0f, 0.0f, sizeof(Active_Runway) /sizeof(Active_Runway[0]), 1);

   RegisterIOSVariable("Reposition_Airport Change",   &Reposition_Airport_Change,   set_Reposition_Airport_Change,   sizeof(Reposition_Airport_Change),     true);
  


   RegisterIOSVariable("Ann_Pnl_Bat_Bus_Lt",          &annunciator[0],              NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Canopy_Lt",           &annunciator[1],              NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Ckpt_Alt_Lt",         &annunciator[2],              NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Fuel_Bal_Lt",         &annunciator[3],              NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_L_Fuel_Lo_Lt",        &annunciator[4],              NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Trim_Off_Lt",         &annunciator[5],              NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Gen_Bus_Lt",          &annunciator[6],              NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Fuel_Px_Lt",          &annunciator[7],              NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Spare1_Lt",           &annunciator[8],              NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Pmu_Status_Lt",       &annunciator[9],              NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_R_Fuel_Lo_Lt",        &annunciator[10],             NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Boost_Pump_Lt",       &annunciator[11],             NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Pmu_Fail_Lt",         &annunciator[12],             NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Oil_Px_Lt",           &annunciator[13],             NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Hydr_Fl_Lo_Lt",       &annunciator[14],             NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Hydr_Px_Lo_Lt",       &annunciator[15],             NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Duct_Temp_Lt",        &annunciator[16],             NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Anti_Ice_Lt",         &annunciator[17],             NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Gen_Lt",              &annunciator[18],             NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Obogs_Fail_Lt",       &annunciator[19],             NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Spare2_Lt",           &annunciator[20],             NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Tad_Fail_Lt",         &annunciator[21],             NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Ign_Sel_Lt",          &annunciator[22],             NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Tad_Off_Lt",          &annunciator[23],             NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Ckpt_Px_Lt",          &annunciator[24],             NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Chip_Lt",             &annunciator[25],             NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Bus_Tie_Lt",          &annunciator[26],             NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_Obogs_Temp_Lt",       &annunciator[27],             NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_M_Fuel_Bal",          &annunciator[28],             NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Ann_Pnl_St_Ready_Lt",         &annunciator[29],             NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Master_Caution_Lt",           &annunciator[30],             NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Master_Warn_Lt",              &annunciator[31],             NULL,                            sizeof(annunciator[0]),                true);
   RegisterIOSVariable("Eng_Fire_Lt",                 &annunciator[32],             NULL,                            sizeof(annunciator[0]),                true);

   RegisterIOSVariable("MFEN01",                      &MFEN01,                      set_mfen01,                      sizeof(MFEN01),                        true);
   RegisterIOSVariable("MFEN02",                      &MFEN02,                      set_mfen02,                      sizeof(MFEN02),                        true);
   RegisterIOSVariable("MFEN03",                      &MFEN03,                      set_mfen03,                      sizeof(MFEN03),                        true);
   RegisterIOSVariable("MFEN04",                      &MFEN04,                      set_mfen04,                      sizeof(MFEN04),                        true);
   RegisterIOSVariable("MFEN05",                      &MFEN05,                      set_mfen05,                      sizeof(MFEN05),                        true);
   RegisterIOSVariable("MFEN06",                      &MFEN06,                      set_mfen06,                      sizeof(MFEN06),                        true);
   RegisterIOSVariable("MFEN07",                      &MFEN07,                      set_mfen07,                      sizeof(MFEN07),                        true);
   RegisterIOSVariable("MFEN08",                      &MFEN08,                      set_mfen08,                      sizeof(MFEN08),                        true);
   RegisterIOSVariable("MFEN09",                      &MFEN09,                      set_mfen09,                      sizeof(MFEN09),                        true);
   RegisterIOSVariable("MFEN10",                      &MFEN10,                      set_mfen10,                      sizeof(MFEN10),                        true);
   RegisterIOSVariable("MFEN11",                      &MFEN11,                      set_mfen11,                      sizeof(MFEN11),                        true);

   RegisterIOSVariable("altitude",                    &altitude,                    set_altitude,                    sizeof(altitude),                      true);
   RegisterIOSVariable("barometric_pressure",         &barometric_pressure,         set_barometric_pressure,         sizeof(barometric_pressure),           true);
   RegisterIOSVariable("torque",                      &torque,                      set_torque,                      sizeof(torque),                        true);
   RegisterIOSVariable("LeftItt",                     &LeftItt,                     set_LeftItt,                     sizeof(LeftItt),                       true);
   RegisterIOSVariable("RightItt",                    &RightItt,                    set_RightItt,                    sizeof(RightItt),                      true);
   RegisterIOSVariable("LeftN1",                      &LeftN1,                      set_LeftN1,                      sizeof(LeftN1),                        true);
   RegisterIOSVariable("RightN1",                     &RightN1,                     set_RightN1,                     sizeof(RightN1),                       true);
   RegisterIOSVariable("LeftN2",                      &LeftN2,                      set_LeftN2,                      sizeof(LeftN2),                        true);
   RegisterIOSVariable("RightN2",                     &RightN2,                     set_RightN2,                     sizeof(RightN2),                       true);
   RegisterIOSVariable("RPM",                         &RPM,                         set_RPM,                         sizeof(RPM),                           true);
   RegisterIOSVariable("EGT",                         &EGT,                         set_EGT,                         sizeof(EGT),                           true);
   RegisterIOSVariable("np",                          &np,                          set_np,                          sizeof(np),                            true);
   RegisterIOSVariable("oat",                         &oat,                         set_oat,                         sizeof(oat),                           true);
   RegisterIOSVariable("cockpit_alt",                 &cockpit_alt,                 set_cockpit_alt,                 sizeof(cockpit_alt),                   true);
   RegisterIOSVariable("cockpit_diff_press",          &cockpit_diff_press,          set_cockpit_diff_press,          sizeof(cockpit_diff_press),            true);
   RegisterIOSVariable("cockpit_rate_of_change",      &cockpit_rate_of_change,      set_cockpit_rate_of_change,      sizeof(cockpit_rate_of_change),        true);
   RegisterIOSVariable("fuel_flow",                   &fuel_flow,                   set_fuel_flow,                   sizeof(fuel_flow),                     true);
   RegisterIOSVariable("raw_itt",                     &raw_itt,                     set_raw_itt,                     sizeof(raw_itt),                       true);
   RegisterIOSVariable("leftFuelQuantity",            &leftFuelQuantity,            set_leftFuelQuantity,            sizeof(leftFuelQuantity),              true);
   RegisterIOSVariable("rightFuelQuantity",           &rightFuelQuantity,           set_rightFuelQuantity,           sizeof(rightFuelQuantity),             true);
   RegisterIOSVariable("temperature",                 &temperature,                 set_temperature,                 sizeof(temperature),                   true);
   RegisterIOSVariable("oilPressure",                 &oilPressure,                 set_oilPressure,                 sizeof(oilPressure),                   true);
   RegisterIOSVariable("hydraulicPressure",           &hydraulicPressure,           set_hydraulicPressure,           sizeof(hydraulicPressure),             true);
   RegisterIOSVariable("voltage",                     &voltage,                     set_voltage,                     sizeof(voltage),                       true);
   RegisterIOSVariable("current",                     &amperage,                    set_amperage,                    sizeof(amperage),                      true);
   RegisterIOSVariable("ac_pitch_lead",               &ac_pitch_lead,               set_ac_pitch_lead,               sizeof(ac_pitch_lead),                 true);
   RegisterIOSVariable("ac_roll_lead",                &ac_roll_lead,                set_ac_roll_lead,                sizeof(ac_roll_lead),                  true);
   RegisterIOSVariable("ac_yaw_lead",                 &ac_yaw_lead,                 set_ac_yaw_lead,                 sizeof(ac_yaw_lead),                   true);
   RegisterIOSVariable("ac_pitch_wing",               &ac_pitch_wing,               set_ac_pitch_wing,               sizeof(ac_pitch_wing),                 true);
   RegisterIOSVariable("ac_roll_wing",                &ac_roll_wing,                set_ac_roll_wing,                sizeof(ac_roll_wing),                  true);
   RegisterIOSVariable("ac_yaw_wing",                 &ac_yaw_wing,                 set_ac_yaw_wing,                 sizeof(ac_yaw_wing),                   true);
   RegisterIOSVariable("aoa",                         &aoa,                         set_aoa,                         sizeof(aoa),                           true);
   RegisterIOSVariable("nav_frequency",               &nav_frequency,               set_nav_frequency,               sizeof(nav_frequency),                 true);
   RegisterIOSVariable("acceleration",                &acceleration,                set_acceleration,                sizeof(acceleration),                  true);
   RegisterIOSVariable("mission_time",                &mission_time,                set_mission_time,                sizeof(mission_time),                  true);
   RegisterIOSVariable("flap_position",               &flap_position,               set_flap_position,               sizeof(flap_position),                 true);
   RegisterIOSVariable("switch_position",             &switch_position,             set_switch_position,             sizeof(switch_position),               true);
   RegisterIOSVariable("glideslope_offset",           &glideslope_offset,           set_glideslope_offset,           sizeof(glideslope_offset),             true);
   RegisterIOSVariable("lateral_position_offset",     &lateral_position_offset,     set_lateral_position_offset,     sizeof(lateral_position_offset),       true);
   RegisterIOSVariable("rudder_position_percentage",  &rudder_position_percentage,  set_rudder_position_percentage,  sizeof(rudder_position_percentage),    true);
   RegisterIOSVariable("throttle_position_percentage",&throttle_position_percentage,set_throttle_position_percentage,sizeof(throttle_position_percentage),  true);
   RegisterIOSVariable("test_value",                  &test_value,                  set_test_value,                  sizeof(test_value),                    true);
   RegisterIOSVariable("stick_x_position",            &stick_x_position,            set_stick_x_position,            sizeof(stick_x_position),              true);
   RegisterIOSVariable("stick_y_position",            &stick_y_position,            set_stick_y_position,            sizeof(stick_y_position),              true);
   RegisterIOSVariable("left_landing_gear",           &left_landing_gear,           set_left_landing_gear,           sizeof(left_landing_gear),             true);
   RegisterIOSVariable("nose_landing_gear",           &nose_landing_gear,           set_nose_landing_gear,           sizeof(nose_landing_gear),             true);
   RegisterIOSVariable("right_landing_gear",          &right_landing_gear,          set_right_landing_gear,          sizeof(right_landing_gear),            true);
   RegisterIOSVariable("aileron_trim",                &aileron_trim,                set_aileron_trim,                sizeof(aileron_trim),                  true);
   RegisterIOSVariable("rudder_trim",                 &rudder_trim,                 set_rudder_trim,                 sizeof(rudder_trim),                   true);
   RegisterIOSVariable("elevator_trim",               &elevator_trim,               set_elevator_trim,               sizeof(elevator_trim),                 true);
   RegisterIOSVariable("map_scale",                   &map_scale,                   set_map_scale,                   sizeof(map_scale),                     true);
   RegisterIOSVariable("x_rotation",                  &x_rotation,                  set_x_rotation,                  sizeof(x_rotation),                    true);
   RegisterIOSVariable("y_rotation",                  &y_rotation,                  set_y_rotation,                  sizeof(y_rotation),                    true);
   RegisterIOSVariable("delta_altitude",              &delta_altitude,              set_delta_altitude,              sizeof(delta_altitude),                true);
   RegisterIOSVariable("delta_latitude",              &delta_latitude,              set_delta_latitude,              sizeof(delta_latitude),                true);
   RegisterIOSVariable("delta_longitude",             &delta_longitude,             set_delta_longitude,             sizeof(delta_longitude),               true);

   RegisterIOSVariable("viewer_distance",             &viewer_distance,             set_viewer_distance,             sizeof(viewer_distance),               true);

   RegisterIOSVariable("area_map_scale",              &area_map_scale,              set_area_map_scale,              sizeof(area_map_scale),                true);
   RegisterIOSVariable("area_map_latitude_center",    &area_map_latitude_center,    set_area_map_latitude_center,    sizeof(area_map_latitude_center),      true);
   RegisterIOSVariable("area_map_longitude_center",   &area_map_longitude_center,   set_area_map_longitude_center,   sizeof(area_map_longitude_center),     true);
   RegisterIOSVariable("ac_heading",                  &ac_heading,                  set_ac_heading,                  sizeof(ac_heading),                    true);
   RegisterIOSVariable("ac_latitude",                 &ac_latitude,                 set_ac_latitude,                 sizeof(ac_latitude),                   true);
   RegisterIOSVariable("ac_longitude",                &ac_longitude,                set_ac_longitude,                sizeof(ac_longitude),                  true);
   RegisterIOSVariable("ac_altitude",                 &ac_altitude,                 set_ac_altitude,                 sizeof(ac_altitude),                   true);

   RegisterIOSVariable("Reposition_Latitude",         &ac_latitude_requested,       set_ac_latitude,                 sizeof(ac_latitude_requested),         true);
   RegisterIOSVariable("Reposition_Longitude",        &ac_longitude_requested,      set_ac_longitude,                sizeof(ac_longitude_requested),        true);
   RegisterIOSVariable("Reposition_Fore_Aft",         &Fore_Aft,                    set_Fore_Aft,                    sizeof(Fore_Aft),                      true);
   RegisterIOSVariable("Reposition_Above_Below",      &Above_Below,                 set_Above_Below,                 sizeof(Above_Below),                   true);
   RegisterIOSVariable("Reposition_Left_Right",       &Left_Right,                  set_Left_Right,                  sizeof(Left_Right),                    true);
   RegisterIOSVariable("Reposition_Select",           &Reposition_Select,           set_Reposition_Select,           sizeof(Reposition_Select),             true);
   RegisterIOSVariable("Reposition_Formation_Id",     &Reposition_Formation_Id,     set_Reposition_Formation_Id,     sizeof(Reposition_Formation_Id),       true);


   RegisterIOSVariable("lead_ac_heading",             &lead_ac_heading,             set_lead_ac_heading,             sizeof(lead_ac_heading),               true);
   RegisterIOSVariable("lead_ac_latitude",            &lead_ac_latitude,            set_lead_ac_latitude,            sizeof(lead_ac_latitude),              true);
   RegisterIOSVariable("lead_ac_longitude",           &lead_ac_longitude,           set_lead_ac_longitude,           sizeof(lead_ac_longitude),             true);
   RegisterIOSVariable("lead_ac_altitude",            &lead_ac_altitude,            set_lead_ac_altitude,            sizeof(lead_ac_altitude),              true);

   RegisterIOSVariable("bearing1",                    &bearing1,                    set_bearing1,                    sizeof(bearing1),                      true);
   RegisterIOSVariable("bearing2",                    &bearing2,                    set_bearing2,                    sizeof(bearing2),                      true);

   RegisterIOSVariable("mach",                        &mach ,                       set_mach,                        sizeof(mach),                          true);
   RegisterIOSVariable("ias",                         &ias,                         set_ias,                         sizeof(ias),                           true);
   RegisterIOSVariable("max_allowable_airspeed",      &max_allowable_airspeed,      set_max_allowable_airspeed,      sizeof(max_allowable_airspeed),        true);
   RegisterIOSVariable("rate of climb",               &vertical_speed,              set_vertical_speed,              sizeof(vertical_speed),                true);

   RegisterIOSVariable("landing_lights",              &landing_lights,              set_landing_lights,              sizeof(landing_lights),                true);
   RegisterIOSVariable("Slewing",                     &Slewing,                     set_Slewing,                     sizeof(Slewing),                       true);

   RegisterIOSVariable("left_landing_gear_green",     &left_landing_gear_green,     set_left_landing_gear_green,     sizeof(left_landing_gear_green),       true);
   RegisterIOSVariable("right_landing_gear_green",    &right_landing_gear_green,    set_right_landing_gear_green,    sizeof(right_landing_gear_green),      true);
   RegisterIOSVariable("nose_landing_gear_green",     &nose_landing_gear_green,     set_nose_landing_gear_green,     sizeof(nose_landing_gear_green),       true);
   RegisterIOSVariable("left_landing_gear_red",       &left_landing_gear_red,       set_left_landing_gear_red,       sizeof(left_landing_gear_red),         true);
   RegisterIOSVariable("right_landing_gear_red",      &right_landing_gear_red,      set_right_landing_gear_red,      sizeof(right_landing_gear_red),        true);
   RegisterIOSVariable("nose_landing_gear_red",       &nose_landing_gear_red,       set_nose_landing_gear_red,       sizeof(nose_landing_gear_red),         true);
   RegisterIOSVariable("landing_gear_handle",         &landing_gear_handle,         set_landing_gear_handle,         sizeof(landing_gear_handle),           true);
   RegisterIOSVariable("landing_gear_handle_demanded",&landing_gear_handle_demanded,set_landing_gear_handle_demanded,sizeof(landing_gear_handle_demanded),  true);
   RegisterIOSVariable("landing_gear_handle_light",   &landing_gear_handle_light,   set_landing_gear_handle_light,   sizeof(landing_gear_handle_light),     true);

   RegisterIOSVariable("Power_Control_Lever_Angle",   &pcl_position,                set_pcl_position,                sizeof(pcl_position),                  true);
   RegisterIOSVariable("Power_Control_Lever_Angle_Demanded",&pcl_position_demanded, set_pcl_position_demanded,       sizeof(pcl_position_demanded),         true);
   RegisterIOSVariable("Fire_Det_No_1_Test_Sw",       &fire_test_1,                 set_fire_test_1,                 sizeof(fire_test_1),                   true);
   RegisterIOSVariable("Fire_Det_No_2_Test_Sw",       &fire_test_2,                 set_fire_test_2,                 sizeof(fire_test_2),                   true);
   RegisterIOSVariable("Emer_Firewall_Shutoff",       &firewall_shutoff,            set_firewall_shutoff,            sizeof(firewall_shutoff),              true);
   RegisterIOSVariable("Oxygen_Handle",               &oxygen_handle,               set_oxygen_handle,               sizeof(oxygen_handle),                 true);
   RegisterIOSVariable("bld_inflow",                  &bld_inflow,                  set_bld_inflow,                  sizeof(bld_inflow),                    true);
   RegisterIOSVariable("Oxygen_Supply_On_Sw",         &obogs_supply,                set_obogs_supply,                sizeof(obogs_supply),                  true);
   RegisterIOSVariable("Oxygen_Max_Sw",               &oxygen_max_sw,               set_oxygen_max_sw,               sizeof(oxygen_max_sw),                 true);
   RegisterIOSVariable("ECS_Pressurization_Switch",   &ecs_press_switch,            set_ecs_press_switch,            sizeof(ecs_press_switch),              true);
   RegisterIOSVariable("io Master_Bat_On_Sw",         &master_bat_on_switch,        set_master_bat_on_switch,        sizeof(master_bat_on_switch),          true);
   RegisterIOSVariable("io Master_Gen_On_Sw",         &master_gen_on_switch,        set_master_gen_on_switch,        sizeof(master_gen_on_switch),          true);
   RegisterIOSVariable("io Aux_Bat_On_Sw",            &aux_bat_on_switch,           set_aux_bat_on_switch,           sizeof(aux_bat_on_switch),             true);
   RegisterIOSVariable("Canopy_Fracture",             &canopy_fracture,             set_canopy_fracture,             sizeof(canopy_fracture),               true);
   RegisterIOSVariable("Gear_Position",               &gear_position,               set_gear_position,               sizeof(gear_position),                 true);
   RegisterIOSVariable("PMU_Sw_Position",             &pmu_switch,                  set_pmu_switch,                  sizeof(pmu_switch),                    true);
   RegisterIOSVariable("PMU_CB",                      &pmu_cb,                      set_pmu_cb,                      sizeof(pmu_cb),                        true);
   RegisterIOSVariable("IGN_CB",                      &ign_cb,                      set_ign_cb,                      sizeof(ign_cb),                        true);
   RegisterIOSVariable("START_CB",                    &start_cb,                    set_start_cb,                    sizeof(start_cb),                      true);
   RegisterIOSVariable("BOOST_PUMP_CB",               &boost_pump_cb,               set_boost_pump_cb,               sizeof(start_cb),                      true);
   RegisterIOSVariable("N1",                          &N1,                          set_N1,                          sizeof(N1),                            true);
   RegisterIOSVariable("Start_Sw",                    &start_sw,                    set_start_sw,                    sizeof(start_sw),                      true);
   RegisterIOSVariable("Ignition_Sw",                 &ignition_sw,                 set_ignition_sw,                 sizeof(ignition_sw),                   true);
   RegisterIOSVariable("Defog_Sw",                    &defog_sw,                    set_defog_sw,                    sizeof(defog_sw),                      true);
   RegisterIOSVariable("ECS_Temp",                    &ecs_temp,                    set_ecs_temp,                    sizeof(ecs_temp),                      true);
   RegisterIOSVariable("ECS_Man_Hot_Sw",              &ecs_man_hot_sw,              set_ecs_man_hot_sw,              sizeof(ecs_man_hot_sw),                true);
   RegisterIOSVariable("ECS_Man_Cold_Sw",             &ecs_man_cold_sw,             set_ecs_man_cold_sw,             sizeof(ecs_man_cold_sw),               true);
   RegisterIOSVariable("Ram_Air_Sw",                  &ram_air_fl,                  set_ram_air_fl,                  sizeof(ram_air_fl),                    true);
   RegisterIOSVariable("io Gen_Reset_Sw",             &gen_reset,                   set_gen_reset,                   sizeof(gen_reset),                     true);
   RegisterIOSVariable("Bus_Tie_Sw",                  &bus_tie_sw,                  set_bus_tie_sw,                  sizeof(bus_tie_sw),                    true);
   RegisterIOSVariable("BAT_CB",                      &bat_cb,                      set_bat_cb,                      sizeof(bat_cb),                        true);
   RegisterIOSVariable("RUD_CB",                      &rud_cb,                      set_rud_cb,                      sizeof(rud_cb),                        true);
   RegisterIOSVariable("AIL_EL_CB",                   &ail_el_cb,                   set_ail_el_cb,                   sizeof(ail_el_cb),                     true);
   RegisterIOSVariable("Trim_Interrupt_Sw",           &trim_interrupt_sw,           set_trim_interrupt_sw,           sizeof(trim_interrupt_sw),             true);
   RegisterIOSVariable("Trim_Disconnect_Sw",          &trim_disconnect_sw,          set_trim_disconnect_sw,          sizeof(trim_disconnect_sw),            true);
   RegisterIOSVariable("Boost_Pump_Sw",               &boost_pump_sw,               set_boost_pump_sw,               sizeof(boost_pump_sw),                 true);
   RegisterIOSVariable("Fuel_Bal_Sw",                 &fuel_bal_sw,                 set_fuel_bal_sw,                 sizeof(fuel_bal_sw),                   true);
   RegisterIOSVariable("Man_Fuel_Bal_Sw",             &man_fuel_bal_sw,             set_man_fuel_bal_sw,             sizeof(man_fuel_bal_sw),               true);
   RegisterIOSVariable("Emergency_Gear_Ext_Sw",       &emer_gear_ext_sw,            set_emer_gear_ext_sw,            sizeof(emer_gear_ext_sw),              true);
   RegisterIOSVariable("Flap_Ind_Position",           &flap_ind_position,           set_flap_ind_position,           sizeof(flap_ind_position),             true);
   RegisterIOSVariable("GEAR_CB",                     &gear_cb,                     set_gear_cb,                     sizeof(gear_cb),                       true);
   RegisterIOSVariable("Lamp_Test_Sw",                &lamp_test_sw,                set_lamp_test_sw,                sizeof(lamp_test_sw),                  true);
   RegisterIOSVariable("PROP_SYS_CB",                 &prop_sys_cb,                 set_prop_sys_cb,                 sizeof(prop_sys_cb),                   true);
   RegisterIOSVariable("Total_Fuel_Qty",              &total_fuel_qty,              set_total_fuel_qty,              sizeof(total_fuel_qty),                true);
   RegisterIOSVariable("Flap_Handle",                 &flap_handle,                 set_flap_handle,                 sizeof(flap_handle),                   true);
   RegisterIOSVariable("Flap_Handle_Demanded",        &flap_handle_demanded,        set_flap_handle_demanded,        sizeof(flap_handle_demanded),          true);
   RegisterIOSVariable("Parking_Brake_Sw",            &parking_brake,               set_parking_brake,               sizeof(parking_brake),                 true);
   RegisterIOSVariable("Parking_Brake_Demanded",      &parking_brake_demanded,      set_parking_brake_demanded,      sizeof(parking_brake_demanded),        true);
   RegisterIOSVariable("Transponder",                 &transponder,                 set_transponder,                 sizeof(transponder),                   true);
   RegisterIOSVariable("Eject_Handle",                &eject_handle,                set_eject_handle,                sizeof(eject_handle),                  true);
   RegisterIOSVariable("Aux_Bat_Test_Sw",             &aux_bat_test_sw,             set_aux_bat_test_sw,             sizeof(aux_bat_test_sw),               true);
   RegisterIOSVariable("Audio_Test_Sw",               &audio_test_sw,               set_audio_test_sw,               sizeof(audio_test_sw),                 true);
   RegisterIOSVariable("AOA_Test_Sw",                 &aoa_test_sw,                 set_aoa_test_sw,                 sizeof(aoa_test_sw),                   true);
   RegisterIOSVariable("Fire_Det_Test_Sw",            &fire_det_test_sw,            set_fire_det_test_sw,            sizeof(fire_det_test_sw),              true);
   RegisterIOSVariable("Anti_Col_Lights_Sw",          &anti_col_lights_sw,          set_anti_col_lights_sw,          sizeof(anti_col_lights_sw),            true);
   RegisterIOSVariable("Nav_Lights_Sw",               &nav_lights_sw,               set_nav_lights_sw,               sizeof(nav_lights_sw),                 true);
   RegisterIOSVariable("Taxi_Lights_Sw",              &taxi_lights_sw,              set_taxi_lights_sw,              sizeof(taxi_lights_sw),                true);
   RegisterIOSVariable("Landing_Lights_Sw",           &landing_lights_sw,           set_landing_lights_sw,           sizeof(landing_lights_sw),             true);
   RegisterIOSVariable("ELT_Sw",                      &elt_sw,                      set_elt_sw,                      sizeof(elt_sw),                        true);
   RegisterIOSVariable("Avionics_Master_Sw",          &avionics_master_sw,          set_avionics_master_sw,          sizeof(avionics_master_sw),            true);
   RegisterIOSVariable("AHRS_Compass_Sw",             &ahrs_compass_sw,             set_ahrs_compass_sw,             sizeof(ahrs_compass_sw),               true);
   RegisterIOSVariable("Probes_Anti_Ice_Sw",          &probes_anti_ice_sw,          set_probes_anti_ice_sw,          sizeof(probes_anti_ice_sw),            true);
   RegisterIOSVariable("Evap_Blower_Sw",              &evap_blower_sw,              set_evap_blower_sw,              sizeof(evap_blower_sw),                true);
   RegisterIOSVariable("Start_Simulation",            &start_simulation,            set_start_simulation,            sizeof(start_simulation),              true);
   RegisterIOSVariable("TAD_Sw",                      &tad_sw,                      set_tad_sw,                      sizeof(tad_sw),                        true);
   RegisterIOSVariable("ITT",                         &Itt,                         set_Itt,                         sizeof(Itt),                           true);
   RegisterIOSVariable("Canopy_Lock_Sw",              &canopy_lock_sw,              set_canopy_lock_sw,              sizeof(canopy_lock_sw),                true);
   RegisterIOSVariable("OBOGS_Pressure_Sw",           &obogs_pressure_sw,           set_obogs_pressure_sw,           sizeof(obogs_pressure_sw),             true);
   RegisterIOSVariable("NACWS_Sw",                    &nacws_sw,                    set_nacws_sw,                    sizeof(nacws_sw),                      true);
   RegisterIOSVariable("Backup_UHF_Power_Sw",         &backup_uhf_power_sw,         set_backup_uhf_power_sw,         sizeof(backup_uhf_power_sw),           true);
   RegisterIOSVariable("Anti_G_Test_Sw",              &anti_g_test_sw,              set_anti_g_test_sw,              sizeof(anti_g_test_sw),                true);
   RegisterIOSVariable("Speedbrake",                  &speedbrake,                  set_speedbrake,                  sizeof(speedbrake),                    true);
   RegisterIOSVariable("Oil_Temperature_C",           &oil_temperature,             set_oil_temperature,             sizeof(oil_temperature),               true);
   RegisterIOSVariable("Nosewheel_Steering",          &nosewheel_steering,          set_nosewheel_steering,          sizeof(nosewheel_steering),            true);
   RegisterIOSVariable("Transponder_Mode",            &transponder_mode,            set_transponder_mode,            sizeof(transponder_mode),              true);
   RegisterIOSVariable("Landing_Gear_Sw",             &landing_gear_sw,             set_landing_gear_sw,             sizeof(landing_gear_sw),               true);
   RegisterIOSVariable("system_freeze",               &system_freeze,               set_system_freeze,               sizeof(system_freeze),                 true);
   RegisterIOSVariable("formation_flight",            &formation_flight,            set_formation_flight,            sizeof(formation_flight),              true);
   RegisterIOSVariable("Pressure_Altitude",           &pressure_altitude,           set_pressure_altitude,           sizeof(pressure_altitude),             true);
   RegisterIOSVariable("Altitude_AGL",                &altitude_agl,                set_altitude_agl,                sizeof(altitude_agl),                  true);
   RegisterIOSVariable("Magnetic_Variation",          &Magnetic_Variation,          set_Magnetic_Variation,          sizeof(Magnetic_Variation),            true);
   RegisterIOSVariable("Magvar_Latitude",             &Magvar_Latitude,             set_Magvar_Latitude,             sizeof(Magvar_Latitude),               true);
   RegisterIOSVariable("Magvar_Longitude",            &Magvar_Longitude,            set_Magvar_Longitude,            sizeof(Magvar_Longitude),              true);

   RegisterIOSVariable("Formation_Lead_Profile_Driver",&Formation_Lead_Profile_Driver,set_Formation_Lead_Profile_Driver,sizeof(Formation_Lead_Profile_Driver),true);
   RegisterIOSVariable("Formation_Lead_Recorder_On",  &Formation_Lead_Recorder_On,  set_Formation_Lead_Recorder_On,  sizeof(Formation_Lead_Recorder_On),    true);

   RegisterIOSVariable("Formation_Number_of_Tracks",  &Formation_Number_of_Tracks,  set_Formation_Number_of_Tracks,  sizeof(Formation_Number_of_Tracks),    true);
   RegisterIOSVariable("Formation_Track_Number",      &Formation_Track_Number,      set_Formation_Track_Number,      sizeof(Formation_Track_Number),        true);
   RegisterIOSVariable("Formation_Load_Cmd",          &Formation_Load_Cmd,          set_Formation_Load_Cmd,          sizeof(Formation_Load_Cmd),            true);
   RegisterIOSVariable("Formation_Prev_Track",        &Formation_Prev_Track,        set_Formation_Prev_Track,        sizeof(Formation_Prev_Track),          true);
   RegisterIOSVariable("Formation_Next_Track",        &Formation_Next_Track,        set_Formation_Next_Track,        sizeof(Formation_Next_Track),          true);

   RegisterIOSVariable("fire det 1 batt bus panel d/i",     &cb_status[0],          NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("fire det 1 batt bus panel d/o",     &cb_command[0],         set_cb_command0,                 sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Cws cb batt bus panel d/i",         &cb_status[1],          NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Cws cb batt bus panel d/o",         &cb_command[1],         set_cb_command1,                 sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Fuel_Qty_Lo cb batt bus panel d/i", &cb_status[2],          NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Fuel_Qty_Lo cb batt bus panel d/o", &cb_command[2],         set_cb_command2,                 sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Fldt cb batt bus panel d/i",        &cb_status[3],          NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Fldt cb batt bus panel d/o",        &cb_command[3],         set_cb_command3,                 sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Aux_Bat cb batt bus panel d/i",     &cb_status[4],          NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Aux_Bat cb batt bus panel d/o",     &cb_command[4],         set_cb_command4,                 sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Fwd_Avi cb batt bus panel d/i",     &cb_status[5],          NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Fwd_Avi cb batt bus panel d/o",     &cb_command[5],         set_cb_command5,                 sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Aft cb batt bus panel d/i",         &cb_status[6],          NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Aft cb batt bus panel d/o",         &cb_command[6],         set_cb_command6,                 sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Avi_Mstr cb batt bus panel d/i",    &cb_status[7],          NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Avi_Mstr cb batt bus panel d/o",    &cb_command[7],         set_cb_command7,                 sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Bat_Sw cb batt bus panel d/i",      &cb_status[8],          NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Bat_Sw cb batt bus panel d/o",      &cb_command[8],         set_cb_command8,                 sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Ldg cb batt bus panel d/i",         &cb_status[9],          NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Ldg cb batt bus panel d/o",         &cb_command[9],         set_cb_command9,                 sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Inst cb batt bus panel d/i",        &cb_status[10],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Inst cb batt bus panel d/o",        &cb_command[10],        set_cb_command10,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Coll cb batt bus panel d/i",        &cb_status[11],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Coll cb batt bus panel d/o",        &cb_command[11],        set_cb_command11,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Stby cb batt bus panel d/i",        &cb_status[12],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Stby cb batt bus panel d/o",        &cb_command[12],        set_cb_command12,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Util cb batt bus panel d/i",        &cb_status[13],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Util cb batt bus panel d/o",        &cb_command[13],        set_cb_command13,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Ail_El_Trim cb batt bus panel d/i", &cb_status[14],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Ail_El_Trim cb batt bus panel d/o", &cb_command[14],        set_cb_command14,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Rud_Trim cb batt bus panel d/i",    &cb_status[15],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Rud_Trim cb batt bus panel d/o",    &cb_command[15],        set_cb_command15,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Ldg_Gr_Cont cb batt bus panel d/i", &cb_status[16],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Ldg_Gr_Cont cb batt bus panel d/o", &cb_command[16],        set_cb_command16,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Flap_Cont cb batt bus panel d/i",   &cb_status[17],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Flap_Cont cb batt bus panel d/o",   &cb_command[17],        set_cb_command17,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Hyd_Sys cb batt bus panel d/i",     &cb_status[18],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Hyd_Sys cb batt bus panel d/o",     &cb_command[18],        set_cb_command18,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Inflow_Sys cb batt bus panel d/i",  &cb_status[19],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Inflow_Sys cb batt bus panel d/o",  &cb_command[19],        set_cb_command19,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Alt_Eng_Dis cb batt bus panel d/i", &cb_status[20],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Alt_Eng_Dis cb batt bus panel d/o", &cb_command[20],        set_cb_command20,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Edm cb batt bus panel d/i",         &cb_status[21],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Edm cb batt bus panel d/o",         &cb_command[21],        set_cb_command21,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Oil_Trx cb batt bus panel d/i",     &cb_status[22],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Oil_Trx cb batt bus panel d/o",     &cb_command[22],        set_cb_command22,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Start cb batt bus panel d/i",       &cb_status[23],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Start cb batt bus panel d/o",       &cb_command[23],        set_cb_command23,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Ign cb batt bus panel d/i",         &cb_status[24],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Ign cb batt bus panel d/o",         &cb_command[24],        set_cb_command24,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Boost_Pump cb batt bus panel d/i",  &cb_status[25],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Boost_Pump cb batt bus panel d/o",  &cb_command[25],        set_cb_command25,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Pmu cb batt bus panel d/i",         &cb_status[26],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Pmu cb batt bus panel d/o",         &cb_command[26],        set_cb_command26,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Radio_Rlys cb batt bus panel d/i",  &cb_status[27],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Radio_Rlys cb batt bus panel d/o",  &cb_command[27],        set_cb_command27,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Prop_Sys cb batt bus panel d/i",    &cb_status[28],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Prop_Sys cb batt bus panel d/o",    &cb_command[28],        set_cb_command28,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Fdr cb batt bus panel d/i",         &cb_status[29],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Fdr cb batt bus panel d/o",         &cb_command[29],        set_cb_command29,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Aoa cb batt bus panel d/i",         &cb_status[30],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Aoa cb batt bus panel d/o",         &cb_command[30],        set_cb_command30,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Turn_Rt cb batt bus panel d/i",     &cb_status[31],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Turn_Rt cb batt bus panel d/o",     &cb_command[31],        set_cb_command31,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Altm cb batt bus panel d/i",        &cb_status[32],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Altm cb batt bus panel d/o",        &cb_command[32],        set_cb_command32,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Gyro cb batt bus panel d/i",        &cb_status[33],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Gyro cb batt bus panel d/o",        &cb_command[33],        set_cb_command33,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Uhf_Comm cb batt bus panel d/i",    &cb_status[34],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Uhf_Comm cb batt bus panel d/o",    &cb_command[34],        set_cb_command34,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Aft_Inst cb batt bus panel d/i",    &cb_status[35],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Aft_Inst cb batt bus panel d/o",    &cb_command[35],        set_cb_command35,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Gps cb batt bus panel d/i",         &cb_status[36],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Gps cb batt bus panel d/o",         &cb_command[36],        set_cb_command36,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Eadi cb batt bus panel d/i",        &cb_status[37],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Eadi cb batt bus panel d/o",        &cb_command[37],        set_cb_command37,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Aft_Avi cb batt bus panel d/i",     &cb_status[38],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Aft_Avi cb batt bus panel d/o",     &cb_command[38],        set_cb_command38,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Ahrs cb batt bus panel d/i",        &cb_status[39],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Ahrs cb batt bus panel d/o",        &cb_command[39],        set_cb_command39,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Audio cb batt bus panel d/i",       &cb_status[40],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Audio cb batt bus panel d/o",       &cb_command[40],        set_cb_command40,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Fire_2 cb gen bus panel d/i",       &cb_status[41],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Fire_2 cb gen bus panel d/o",       &cb_command[41],        set_cb_command41,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Cws cb gen bus panel d/i",          &cb_status[42],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Cws cb gen bus panel d/o",          &cb_command[42],        set_cb_command42,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Aural_Warn cb gen bus panel d/i",   &cb_status[43],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Aural_Warn cb gen bus panel d/o",   &cb_command[43],        set_cb_command43,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Air_Cond cb gen bus panel d/i",     &cb_status[44],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Air_Cond cb gen bus panel d/o",     &cb_command[44],        set_cb_command44,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Evap_Blower cb gen bus panel d/i",  &cb_status[45],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Evap_Blower cb gen bus panel d/o",  &cb_command[45],        set_cb_command45,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Ckpt_Temp cb gen bus panel d/i",    &cb_status[46],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Ckpt_Temp cb gen bus panel d/o",    &cb_command[46],        set_cb_command46,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Aoa_Ht cb gen bus panel d/i",       &cb_status[47],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Aoa_Ht cb gen bus panel d/o",       &cb_command[47],        set_cb_command47,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Pitot_Ht cb gen bus panel d/i",     &cb_status[48],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Pitot_Ht cb gen bus panel d/o",     &cb_command[48],        set_cb_command48,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Fwd_Avi cb gen bus panel d/i",      &cb_status[49],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Fwd_Avi cb gen bus panel d/o",      &cb_command[49],        set_cb_command49,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Aft cb gen bus panel d/i",          &cb_status[50],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Aft cb gen bus panel d/o",          &cb_command[50],        set_cb_command50,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Gen_Sw cb gen bus panel d/i",       &cb_status[51],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Gen_Sw cb gen bus panel d/o",       &cb_command[51],        set_cb_command51,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Taxi cb gen bus panel d/i",         &cb_status[52],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Taxi cb gen bus panel d/o",         &cb_command[52],        set_cb_command52,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Side cb gen bus panel d/i",         &cb_status[53],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Side cb gen bus panel d/o",         &cb_command[53],        set_cb_command53,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Nav cb gen bus panel d/i",          &cb_status[54],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Nav cb gen bus panel d/o",          &cb_command[54],        set_cb_command54,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Test cb gen bus panel d/i",         &cb_status[55],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Test cb gen bus panel d/o",         &cb_command[55],        set_cb_command55,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Speed_Brake cb gen bus panel d/i",  &cb_status[56],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Speed_Brake cb gen bus panel d/o",  &cb_command[56],        set_cb_command56,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Nws cb gen bus panel d/i",          &cb_status[57],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Nws cb gen bus panel d/o",          &cb_command[57],        set_cb_command57,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Tad cb gen bus panel d/i",          &cb_status[58],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Tad cb gen bus panel d/o",          &cb_command[58],        set_cb_command58,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Trim_Ind cb gen bus panel d/i",     &cb_status[59],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Trim_Ind cb gen bus panel d/o",     &cb_command[59],        set_cb_command59,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Pri_Eng_Dis cb gen bus panel d/i",  &cb_status[60],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Pri_Eng_Dis cb gen bus panel d/o",  &cb_command[60],        set_cb_command60,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Edm cb gen bus panel d/i",          &cb_status[61],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Edm cb gen bus panel d/o",          &cb_command[61],        set_cb_command61,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Eng_Sys_Dis cb gen bus panel d/i",  &cb_status[62],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Eng_Sys_Dis cb gen bus panel d/o",  &cb_command[62],        set_cb_command62,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Fuel_Bal cb gen bus panel d/i",     &cb_status[63],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Fuel_Bal cb gen bus panel d/o",     &cb_command[63],        set_cb_command63,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Seat_Adj cb gen bus panel d/i",     &cb_status[64],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Seat_Adj cb gen bus panel d/o",     &cb_command[64],        set_cb_command64,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Radio_Rlys cb gen bus panel d/i",   &cb_status[65],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Radio_Rlys cb gen bus panel d/o",   &cb_command[65],        set_cb_command65,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Ehsi cb gen bus panel d/i",         &cb_status[66],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Ehsi cb gen bus panel d/o",         &cb_command[66],        set_cb_command66,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Asi cb gen bus panel d/i",          &cb_status[67],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Asi cb gen bus panel d/o",          &cb_command[67],        set_cb_command67,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Altm cb gen bus panel d/i",         &cb_status[68],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Altm cb gen bus panel d/o",         &cb_command[68],        set_cb_command68,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Vvi cb gen bus panel d/i",          &cb_status[69],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Vvi cb gen bus panel d/o",          &cb_command[69],        set_cb_command69,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Nacws cb gen bus panel d/i",        &cb_status[70],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Nacws cb gen bus panel d/o",        &cb_command[70],        set_cb_command70,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Xpdr cb gen bus panel d/i",         &cb_status[71],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Xpdr cb gen bus panel d/o",         &cb_command[71],        set_cb_command71,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Vhf_Comm cb gen bus panel d/i",     &cb_status[72],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Vhf_Comm cb gen bus panel d/o",     &cb_command[72],        set_cb_command72,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Vhf_Nav cb gen bus panel d/i",      &cb_status[73],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Vhf_Nav cb gen bus panel d/o",      &cb_command[73],        set_cb_command73,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Adc cb gen bus panel d/i",          &cb_status[74],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Adc cb gen bus panel d/o",          &cb_command[74],        set_cb_command74,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Dme cb gen bus panel d/i",          &cb_status[75],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Dme cb gen bus panel d/o",          &cb_command[75],        set_cb_command75,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Rmu cb gen bus panel d/i",          &cb_status[76],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Rmu cb gen bus panel d/o",          &cb_command[76],        set_cb_command76,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Aft_Avi cb gen bus panel d/i",      &cb_status[77],         NULL,                            sizeof(cb_status[0]),                  true);
   RegisterIOSVariable("Aft_Avi cb gen bus panel d/o",      &cb_command[77],        set_cb_command77,                sizeof(cb_command[0]),                 true);
   RegisterIOSVariable("Clear_All_CB",                      &dummy_clear_all_cb,    clear_all_cb,                    sizeof(dummy_clear_all_cb),            true);
   RegisterIOSVariable("Reset_All_CB",                      &dummy_reset_all_cb,    reset_all_cb,                    sizeof(dummy_reset_all_cb),            true);

   RegisterIOSVariable("Adi_Mode",                          &Adi_Mode,              set_Adi_Mode,                    sizeof(Adi_Mode), true);

   RegisterIOSVariableEx("Atis_Airport_Ident_1",            &wxa1_airport_ident,    NULL,                            sizeof(wxa1_airport_ident[0]),         true, 0.0f, 0.0f, sizeof(wxa1_airport_ident)/sizeof(wxa1_airport_ident[0]), 1);
   RegisterIOSVariableEx("Atis_Airport_Ident_2",            &wxa2_airport_ident,    NULL,                            sizeof(wxa2_airport_ident[0]),         true, 0.0f, 0.0f, sizeof(wxa2_airport_ident)/sizeof(wxa2_airport_ident[0]), 1);
   RegisterIOSVariableEx("Atis_Airport_Ident_3",            &wxa3_airport_ident,    NULL,                            sizeof(wxa3_airport_ident[0]),         true, 0.0f, 0.0f, sizeof(wxa3_airport_ident)/sizeof(wxa3_airport_ident[0]), 1);
   RegisterIOSVariableEx("Atis_Airport_Ident_4",            &wxa4_airport_ident,    NULL,                            sizeof(wxa4_airport_ident[0]),         true, 0.0f, 0.0f, sizeof(wxa4_airport_ident)/sizeof(wxa4_airport_ident[0]), 1);

   RegisterIOSVariableEx("Atis_Runway_1",                   &wxa1_active_rwy,       NULL,                            sizeof(wxa1_active_rwy[0]),            true, 0.0f, 0.0f, sizeof(wxa1_active_rwy)/sizeof(wxa1_active_rwy[0]), 1);
   RegisterIOSVariableEx("Atis_Runway_2",                   &wxa2_active_rwy,       NULL,                            sizeof(wxa2_active_rwy[0]),            true, 0.0f, 0.0f, sizeof(wxa2_active_rwy)/sizeof(wxa2_active_rwy[0]), 1);
   RegisterIOSVariableEx("Atis_Runway_3",                   &wxa3_active_rwy,       NULL,                            sizeof(wxa3_active_rwy[0]),            true, 0.0f, 0.0f, sizeof(wxa3_active_rwy)/sizeof(wxa3_active_rwy[0]), 1);
   RegisterIOSVariableEx("Atis_Runway_4",                   &wxa4_active_rwy,       NULL,                            sizeof(wxa4_active_rwy[0]),            true, 0.0f, 0.0f, sizeof(wxa4_active_rwy)/sizeof(wxa4_active_rwy[0]), 1);

   RegisterIOSVariable("Atis_Ceiling_1",                    &wxa1_ceiling1,         NULL,                            sizeof(wxa1_ceiling1),                 true);
   RegisterIOSVariable("Atis_Ceiling_2",                    &wxa2_ceiling1,         NULL,                            sizeof(wxa2_ceiling1),                 true);
   RegisterIOSVariable("Atis_Ceiling_3",                    &wxa3_ceiling1,         NULL,                            sizeof(wxa3_ceiling1),                 true);
   RegisterIOSVariable("Atis_Ceiling_4",                    &wxa4_ceiling1,         NULL,                            sizeof(wxa4_ceiling1),                 true);

   RegisterIOSVariable("Atis_Ceiling_Type_1",               &wxa1_clouds1,          NULL,                            sizeof(wxa1_clouds1),                  true);
   RegisterIOSVariable("Atis_Ceiling_Type_2",               &wxa2_clouds1,          NULL,                            sizeof(wxa2_clouds1),                  true);
   RegisterIOSVariable("Atis_Ceiling_Type_3",               &wxa3_clouds1,          NULL,                            sizeof(wxa3_clouds1),                  true);
   RegisterIOSVariable("Atis_Ceiling_Type_4",               &wxa4_clouds1,          NULL,                            sizeof(wxa4_clouds1),                  true);

   RegisterIOSVariable("Atis_Visibility_1",                 &wxa1_visibility_sm,    NULL,                            sizeof(wxa1_visibility_sm),            true);
   RegisterIOSVariable("Atis_Visibility_2",                 &wxa2_visibility_sm,    NULL,                            sizeof(wxa2_visibility_sm),            true);
   RegisterIOSVariable("Atis_Visibility_3",                 &wxa3_visibility_sm,    NULL,                            sizeof(wxa3_visibility_sm),            true);
   RegisterIOSVariable("Atis_Visibility_4",                 &wxa4_visibility_sm,    NULL,                            sizeof(wxa4_visibility_sm),            true);

   RegisterIOSVariable("Atis_Visibility_Condition_1",       &wxa1_precip,           NULL,                            sizeof(wxa1_precip),                   true);
   RegisterIOSVariable("Atis_Visibility_Condition_2",       &wxa2_precip,           NULL,                            sizeof(wxa2_precip),                   true);
   RegisterIOSVariable("Atis_Visibility_Condition_3",       &wxa3_precip,           NULL,                            sizeof(wxa3_precip),                   true);
   RegisterIOSVariable("Atis_Visibility_Condition_4",       &wxa4_precip,           NULL,                            sizeof(wxa4_precip),                   true);

   RegisterIOSVariable("Atis_Temperature_1",                &wxa1_temperature_f,    NULL,                            sizeof(wxa1_temperature_f),            true);
   RegisterIOSVariable("Atis_Temperature_2",                &wxa2_temperature_f,    NULL,                            sizeof(wxa2_temperature_f),            true);
   RegisterIOSVariable("Atis_Temperature_3",                &wxa3_temperature_f,    NULL,                            sizeof(wxa3_temperature_f),            true);
   RegisterIOSVariable("Atis_Temperature_4",                &wxa4_temperature_f,    NULL,                            sizeof(wxa4_temperature_f),            true);

   RegisterIOSVariable("Atis_Wind_Direction_1",             &wxa1_wind_dir,         NULL,                            sizeof(wxa1_wind_dir),                 true);
   RegisterIOSVariable("Atis_Wind_Direction_2",             &wxa2_wind_dir,         NULL,                            sizeof(wxa2_wind_dir),                 true);
   RegisterIOSVariable("Atis_Wind_Direction_3",             &wxa3_wind_dir,         NULL,                            sizeof(wxa3_wind_dir),                 true);
   RegisterIOSVariable("Atis_Wind_Direction_4",             &wxa4_wind_dir,         NULL,                            sizeof(wxa4_wind_dir),                 true);

   RegisterIOSVariable("Atis_Wind_Speed_1",                 &wxa1_wind_speed,       NULL,                            sizeof(wxa1_wind_speed),               true);
   RegisterIOSVariable("Atis_Wind_Speed_2",                 &wxa2_wind_speed,       NULL,                            sizeof(wxa2_wind_speed),               true);
   RegisterIOSVariable("Atis_Wind_Speed_3",                 &wxa3_wind_speed,       NULL,                            sizeof(wxa3_wind_speed),               true);
   RegisterIOSVariable("Atis_Wind_Speed_4",                 &wxa4_wind_speed,       NULL,                            sizeof(wxa4_wind_speed),               true);

   RegisterIOSVariable("Atis_Baro_Pressure_1",              &wxa1_altimeter_inhg,   NULL,                            sizeof(wxa1_altimeter_inhg),           true);
   RegisterIOSVariable("Atis_Baro_Pressure_2",              &wxa2_altimeter_inhg,   NULL,                            sizeof(wxa2_altimeter_inhg),           true);
   RegisterIOSVariable("Atis_Baro_Pressure_3",              &wxa3_altimeter_inhg,   NULL,                            sizeof(wxa3_altimeter_inhg),           true);
   RegisterIOSVariable("Atis_Baro_Pressure_4",              &wxa4_altimeter_inhg,   NULL,                            sizeof(wxa4_altimeter_inhg),           true);


   RegisterIOSVariable("ios_pilot_enable",                  &ios_pilot_enable,            set_ios_pilot_enable,            sizeof(ios_pilot_enable),              true);
   RegisterIOSVariable("ios_pilot_takeoff",                 &ios_pilot_takeoff,           set_ios_pilot_takeoff,           sizeof(ios_pilot_takeoff),             true);
   RegisterIOSVariable("ios_pilot_turn_direction",          &ios_pilot_turn_direction,    set_ios_pilot_turn_direction,    sizeof(ios_pilot_turn_direction),      true);
   RegisterIOSVariable("ios_pilot_turn_rate",               &ios_pilot_turn_rate,         set_ios_pilot_turn_rate,         sizeof(ios_pilot_turn_rate),           true);
   RegisterIOSVariable("ios_pilot_heading",                 &ios_pilot_heading,           set_ios_pilot_heading,           sizeof(ios_pilot_heading),             true);
   RegisterIOSVariable("ios_pilot_altitude",                &ios_pilot_altitude,          set_ios_pilot_altitude,          sizeof(ios_pilot_altitude),            true);
   RegisterIOSVariable("ios_pilot_performance_mode",        &ios_pilot_performance_mode,  set_ios_pilot_performance_mode,  sizeof(ios_pilot_performance_mode),    true);
   RegisterIOSVariable("ios_pilot_ias_enabled",             &ios_pilot_ias_enabled,          NULL,                         sizeof(ios_pilot_ias_enabled),         true);
   RegisterIOSVariable("ios_pilot_climb_rate_enabled",      &ios_pilot_climb_rate_enabled,   NULL,                         sizeof(ios_pilot_climb_rate_enabled),  true);
   RegisterIOSVariable("ios_pilot_torque_enabled",          &ios_pilot_torque_enabled,       NULL,                         sizeof(ios_pilot_torque_enabled),      true);
   RegisterIOSVariable("ios_pilot_ias",                     &ios_pilot_ias,               set_ios_pilot_ias,               sizeof(ios_pilot_ias),                 true);
   RegisterIOSVariable("ios_pilot_climb_rate",              &ios_pilot_climb_rate,        set_ios_pilot_climb_rate,        sizeof(ios_pilot_climb_rate),          true);
   RegisterIOSVariable("ios_pilot_climb",                   &ios_pilot_climb,             set_ios_pilot_climb,             sizeof(ios_pilot_climb),               true);
   RegisterIOSVariable("ios_pilot_descend",                 &ios_pilot_descend,           set_ios_pilot_descend,           sizeof(ios_pilot_descend),             true);
   RegisterIOSVariable("ios_pilot_torque",                  &ios_pilot_torque,            set_ios_pilot_torque,            sizeof(ios_pilot_torque),              true);
   RegisterIOSVariable("ios_pilot_gear",                    &ios_pilot_gear,              set_ios_pilot_gear,              sizeof(ios_pilot_gear),                true);
   RegisterIOSVariable("ios_pilot_flaps",                   &ios_pilot_flaps,             set_ios_pilot_flaps,             sizeof(ios_pilot_flaps),               true);
   RegisterIOSVariable("ios_pilot_speed_brake",             &ios_pilot_speed_brake,       set_ios_pilot_speed_brake,       sizeof(ios_pilot_speed_brake),         true);
   RegisterIOSVariable("ios_pilot_apply",                   &ios_pilot_apply,             set_ios_pilot_apply,             sizeof(ios_pilot_apply),               true);
   RegisterIOSVariable("ios_pilot_apply_enabled",           &ios_pilot_apply_enabled,     NULL,                            sizeof(ios_pilot_apply_enabled),       true);
   RegisterIOSVariable("ios_pilot_heading_increase",        &ios_pilot_heading_increase,  set_ios_pilot_heading_increase,  sizeof(ios_pilot_heading_increase),    true);
   RegisterIOSVariable("ios_pilot_heading_decrease",        &ios_pilot_heading_decrease,  set_ios_pilot_heading_decrease,  sizeof(ios_pilot_heading_decrease),    true);
   RegisterIOSVariable("ios_pilot_altitude_increase",       &ios_pilot_altitude_increase, set_ios_pilot_altitude_increase, sizeof(ios_pilot_altitude_increase),   true);
   RegisterIOSVariable("ios_pilot_altitude_decrease",       &ios_pilot_altitude_decrease, set_ios_pilot_altitude_decrease, sizeof(ios_pilot_altitude_decrease),   true);
   RegisterIOSVariable("ios_pilot_ias_increase",            &ios_pilot_ias_increase,      set_ios_pilot_ias_increase,      sizeof(ios_pilot_ias_increase),        true);
   RegisterIOSVariable("ios_pilot_ias_decrease",            &ios_pilot_ias_decrease,      set_ios_pilot_ias_decrease,      sizeof(ios_pilot_ias_decrease),        true);
   RegisterIOSVariable("ios_pilot_torque_increase",         &ios_pilot_torque_increase,   set_ios_pilot_torque_increase,   sizeof(ios_pilot_torque_increase),     true);
   RegisterIOSVariable("ios_pilot_torque_decrease",         &ios_pilot_torque_decrease,   set_ios_pilot_torque_decrease,   sizeof(ios_pilot_torque_decrease),     true);
   RegisterIOSVariable("ios_pilot_error",                   &ios_pilot_error,             set_ios_pilot_error,             sizeof(ios_pilot_error),               true);

   RegisterIOSVariable("Nacws_Display_Range",         &nacws_display_range,   set_nacws_display_range,   sizeof(nacws_display_range),     true);
   //RegisterIOSVariable("Vsi_Valid",                   &vsi_valid,             set_vsi_valid,             sizeof(vsi_valid),     true);
   RegisterIOSVariable("Nacws_Status",                &nacws_mode,            set_nacws_mode,            sizeof(nacws_mode),     true);
   //RegisterIOSVariable("Nacws_Test",                  &nacws_test,            set_nacws_test,            sizeof(nacws_test),     true);
   RegisterIOSVariable("Nacws_Intr_Range_1"    ,                  &Nacws_Intr_Range_1,      set_Nacws_Intr_Range_1,          sizeof(Nacws_Intr_Range_1),     true);
   RegisterIOSVariable("Nacws_Intr_Range_2"    ,                  &Nacws_Intr_Range_2,      set_Nacws_Intr_Range_2,          sizeof(Nacws_Intr_Range_2),     true);
   RegisterIOSVariable("Nacws_Intr_Rel_Alt_1"  ,                  &Nacws_Intr_Rel_Alt_1,    set_Nacws_Intr_Rel_Alt_1,        sizeof(Nacws_Intr_Rel_Alt_1),   true);
   RegisterIOSVariable("Nacws_Intr_Rel_Alt_2"  ,                  &Nacws_Intr_Rel_Alt_2,    set_Nacws_Intr_Rel_Alt_2,        sizeof(Nacws_Intr_Rel_Alt_2),   true);
   RegisterIOSVariable("Nacws_Intr_Disp_Type_1",                  &Nacws_Intr_Disp_Type_1,  set_Nacws_Intr_Disp_Type_1,      sizeof(Nacws_Intr_Disp_Type_1), true);
   RegisterIOSVariable("Nacws_Intr_Disp_Type_2",                  &Nacws_Intr_Disp_Type_2,  set_Nacws_Intr_Disp_Type_2,      sizeof(Nacws_Intr_Disp_Type_2), true);
   RegisterIOSVariable("Nacws_Intr_Brg_1"      ,                  &Nacws_Intr_Brg_1,        set_Nacws_Intr_Brg_1,            sizeof(Nacws_Intr_Brg_1),       true);
   RegisterIOSVariable("Nacws_Intr_Brg_2"      ,                  &Nacws_Intr_Brg_2,        set_Nacws_Intr_Brg_2,            sizeof(Nacws_Intr_Brg_2),       true);
   RegisterIOSVariable("Nacws_Intr_Active_1"   ,                  &Nacws_Intr_Active_1,     set_Nacws_Intr_Active_1,         sizeof(Nacws_Intr_Active_1),    true);
   RegisterIOSVariable("Nacws_Intr_Active_2"   ,                  &Nacws_Intr_Active_2,     set_Nacws_Intr_Active_2,         sizeof(Nacws_Intr_Active_2),    true);
   RegisterIOSVariable("Vsi_Power"             ,                  &Vsi_Power,               set_Vsi_Power,                   sizeof(Vsi_Power),    true);
   RegisterIOSVariable("Tas_Mode_Sw"           ,                  &Tas_Mode_Sw,             set_Tas_Mode_Sw,                 sizeof(Tas_Mode_Sw),    true);
   RegisterIOSVariable("Nacws_Sw_Off"          ,                  &Nacws_Sw_Off,            set_Nacws_Sw_Off,                sizeof(Nacws_Sw_Off),    true);

   for (;;)
   {
      if (IOSHostCommsConnected()   == 0)
      {
         fprintf(stderr, "IOS Connection failed. Retrying");
         continue;
      }

      IOSHostCommsProcessCommands(false, false);
      IOSHostCommsReadValues();

      IOSHostComms(66);
//     DCLSHostComms(33);
//     ZCTHostComms(200);

      Comm_Updating++;
//      mission_time   += 0.05f;
      mission_time   += 0.066f;


      if (system_freeze)
      {
         #ifdef WIN32
            Sleep(66);
         #else
            #ifdef VXWORKS
               taskDelay(6);
            #endif
         #endif
         continue;
      }


      static  int   count =  0;

      if (count  <  15)
      {
         Slewing =  1;
         count++;
      }
      else if (count  >=  15 && count < 30)
      {
         Slewing =  0;
         count++;
      }
      else if (count  >=  30 && count < 45)
      {
         Slewing =  2;
         count++;
      }
      else if (count  >=  45 && count < 60)
      {
         Slewing =  3;
         count++;
      }
      else if (count  >=  60 && count < 75)
      {
         Slewing =  4;
         count++;
      }
      else if (count >= 75)
         count =  0;



         static   float alt_sign =  1.0f;
/*
         if (altitude  > 15000.0f)
         {
            altitude =  15000.0f;
            alt_sign *= -1.0f;
         }
*/
         if (altitude  > 5500.0f)
         {
            altitude =  5500.0f;
            alt_sign *= -1.0f;
         }
         else if (altitude  <  -2000.0f)
         {
            altitude =  -2000.0f;
            alt_sign *= -1.0f;
         }
         else
            altitude += (1.0f  *  alt_sign);



         static   float baro_sign            =  1.0f;

         if (barometric_pressure  > 32.0f)
         {
            barometric_pressure  =  32.0f;
            baro_sign  *= -1.0f;
         }
         else if (barometric_pressure  <  22.0f)
         {
            barometric_pressure  =  22.0f;
            baro_sign  *= -1.0f;
         }
         else
            barometric_pressure  += (0.01f   *  baro_sign);




         static   float torque_sign =  1.0f;
         if (torque  > 150.0f)
         {
            torque      =  150.0f;
            torque_sign *= -1.0f;
         }
         else if (torque   <  -10.0f)
         {
            torque      =  -10.0f;
            torque_sign *= -1.0f;
         }
         else
            torque  += (0.5f  *  torque_sign);


       static   float pcl_position_sign =  1.0f;
         if (pcl_position  > 80.0f)
         {
            pcl_position      =  80.0f;
            pcl_position_sign *= -1.0f;
         }
         else if (pcl_position   <  0.0f)
         {
            pcl_position      =  0.0f;
            pcl_position_sign *= -1.0f;
         }
         else
            pcl_position  += (0.5f  *  pcl_position_sign);


         static   float Itt_sign = 1.0f;
         if (Itt > 1200.0f)
         {
             Itt      = 1200.0f;
             Itt_sign *= -1.0f;
         }
         else if (Itt < 300.0f)
         {
             Itt      = 300.0f;
             Itt_sign *= -1.0f;
         }
         else
             Itt += (5.0f * Itt_sign);

         static   float LeftItt_sign =  1.0f;
         if (LeftItt  > 1200.0f)
         {
            LeftItt      =  1200.0f;
            LeftItt_sign *= -1.0f;
         }
         else if (LeftItt   <  300.0f)
         {
            LeftItt      =  300.0f;
            LeftItt_sign *= -1.0f;
         }
         else
            LeftItt  += (5.0f  *  LeftItt_sign);

         static   float RightItt_sign =  1.0f;
         if (RightItt  > 1200.0f)
         {
            RightItt      =  1200.0f;
            RightItt_sign *= -1.0f;
         }
         else if (RightItt   <  300.0f)
         {
            RightItt      =  300.0f;
            RightItt_sign *= -1.0f;
         }
         else
            RightItt  += (5.0f  *  RightItt_sign);


         static   float N1_sign =  1.0f;
         if (N1  > 150.0f)
         {
            N1      =  150.0f;
            N1_sign *= -1.0f;
         }
         else if (N1   <  -10.0f)
         {
            N1      =  -10.0f;
            N1_sign *= -1.0f;
         }
         else
            N1  += (1.0f  *  N1_sign);

         static   float LeftN1_sign =  1.0f;
         if (LeftN1  >  150.0f)
         {
            LeftN1      =  150.0f;
            LeftN1_sign *= -1.0f;
         }
         else if (LeftN1   <  -10.0f)
         {
            LeftN1      =  -10.0f;
            LeftN1_sign *= -1.0f;
         }
         else
            LeftN1   += (1.0f  *  LeftN1_sign);

         static   float RightN1_sign   =  -1.0f;
         if (RightN1 >  150.0f)
         {
            RightN1        =  150.0f;
            RightN1_sign   *= -1.0f;
         }
         else if (RightN1  <  -10.0f)
         {
            RightN1        =  -10.0f;
            RightN1_sign   *= -1.0f;
         }
         else
            RightN1  += (1.0f  *  RightN1_sign);


         static   float LeftN2_sign =  1.0f;
         if (LeftN2  >  110.0f)
         {
            LeftN2      =  110.0f;
            LeftN2_sign *= -1.0f;
         }
         else if (LeftN2   <  0.0f)
         {
            LeftN2      =  0.0f;
            LeftN2_sign *= -1.0f;
         }
         else
            LeftN2   += (1.0f  *  LeftN2_sign);

         static   float RightN2_sign   =  -1.0f;
         if (RightN2 >  110.0f)
         {
            RightN2        =  110.0f;
            RightN2_sign   *= -1.0f;
         }
         else if (RightN2  <  0.0f)
         {
            RightN2        =  0.0f;
            RightN2_sign   *= -1.0f;
         }
         else
            RightN2  += (1.0f  *  RightN2_sign);


         static   float np_sign =  1.0f;
         if (np  > 256.0f)
         {
            np      =  256.0f;
            np_sign *= -1.0f;
         }
         else if (np   <  0.0f)
         {
            np      =  0.0f;
            np_sign *= -1.0f;
         }
         else
            np  += (1.0f  *  np_sign);



         static   float oat_sign =  1.0f;
         if (oat  > 128.0f)
         {
            oat      =  128.0f;
            oat_sign *= -1.0f;
         }
         else if (oat   <  -128.0f)
         {
            oat      =  -128.0f;
            oat_sign *= -1.0f;
         }
         else
            oat  += (1.0f  *  oat_sign);



         static   float RPM_sign =  1.0f;
         if (RPM  >  110.0f)
         {
            RPM      =  110.0f;
            RPM_sign *= -1.0f;
         }
         else if (RPM   <  0.0f)
         {
            RPM      =  0.0f;
            RPM_sign *= -1.0f;
         }
         else
            RPM   += (1.0f  *  RPM_sign);

         static   float EGT_sign   =  -1.0f;
         if (EGT >  110.0f)
         {
            EGT        =  110.0f;
            EGT_sign   *= -1.0f;
         }
         else if (EGT  <  0.0f)
         {
            EGT        =  0.0f;
            EGT_sign   *= -1.0f;
         }
         else
            EGT  += (1.0f  *  EGT_sign);



         static   float cockpit_alt_sign =  1.0f;
         if (cockpit_alt  > 131100.0f)
         {
            cockpit_alt      =  131100.0f;
            cockpit_alt_sign *= -1.0f;
         }
         else if (cockpit_alt   <  -131100.0f)
         {
            cockpit_alt      =  -131100.0f;
            cockpit_alt_sign *= -1.0f;
         }
         else
            cockpit_alt  += (5.0f  *  cockpit_alt_sign);




         static   float cockpit_diff_press_sign =  1.0f;
         if (cockpit_diff_press  > 64.0f)
         {
            cockpit_diff_press      =  64.0f;
            cockpit_diff_press_sign *= -1.0f;
         }
         else if (cockpit_diff_press   <  0.0f)
         {
            cockpit_diff_press      =  0.0f;
            cockpit_diff_press_sign *= -1.0f;
         }
         else
            cockpit_diff_press  += (0.015625f *  cockpit_diff_press_sign);




         static   float cockpit_rate_of_change_sign =  1.0f;
         if (cockpit_rate_of_change  > 6000.0f)
         {
            cockpit_rate_of_change      =  6000.0f;
            cockpit_rate_of_change_sign *= -1.0f;
         }
         else if (cockpit_rate_of_change   <  -6000.0f)
         {
            cockpit_rate_of_change      =  -6000.0f;
            cockpit_rate_of_change_sign *= -1.0f;
         }
         else
            cockpit_rate_of_change  += (100.0f *  cockpit_rate_of_change_sign);



         static   float fuel_flow_sign =  1.0f;
         if (fuel_flow  > 1025.0f)
         {
            fuel_flow      =  1025.0f;
            fuel_flow_sign *= -1.0f;
         }
         else if (fuel_flow   <  0.0f)
         {
            fuel_flow      =  0.0f;
            fuel_flow_sign *= -1.0f;
         }
         else
            fuel_flow  += (1.0f *  fuel_flow_sign);



         static   float raw_itt_sign =  1.0f;
         if (raw_itt  > 1000.0f)
         {
            raw_itt      =  1000.0f;
            raw_itt_sign *= -1.0f;
         }
         else if (raw_itt   <  400.0f)
         {
            raw_itt      =  400.0f;
            raw_itt_sign *= -1.0f;
         }
         else
            raw_itt  += (5.0f  *  raw_itt_sign);




         static   float leftFuelQuantity_sign =  1.0f;
         if (leftFuelQuantity  > 800.0f)
         {
            leftFuelQuantity      =  800.0f;
            leftFuelQuantity_sign *= -1.0f;
         }
         else if (leftFuelQuantity   <  -10.0f)
         {
            leftFuelQuantity      =  -10.0f;
            leftFuelQuantity_sign *= -1.0f;
         }
         else
            leftFuelQuantity  += (5.0f  *  leftFuelQuantity_sign);



         static   float rightFuelQuantity_sign =  1.0f;
         if (rightFuelQuantity  > 800.0f)
         {
            rightFuelQuantity      =  800.0f;
            rightFuelQuantity_sign *= -1.0f;
         }
         else if (rightFuelQuantity   <  -10.0f)
         {
            rightFuelQuantity      =  -10.0f;
            rightFuelQuantity_sign *= -1.0f;
         }
         else
            rightFuelQuantity  += (5.0f  *  rightFuelQuantity_sign);









         static   float temperature_sign =  1.0f;
         if (temperature  > 128.0f)
         {
            temperature      =  128.0f;
            temperature_sign *= -1.0f;
         }
         else if (temperature   <  -128.0f)
         {
            temperature      =  -128.0f;
            temperature_sign *= -1.0f;
         }
         else
            temperature  += (0.5f  *  temperature_sign);


         static   float oil_temperature_sign =  1.0f;
         if (oil_temperature  > 250.0f)
         {
            oil_temperature      =  250.0f;
            oil_temperature_sign *= -1.0f;
         }
         else if (oil_temperature   <  -100.0f)
         {
            oil_temperature      =  -100.0f;
            oil_temperature_sign *= -1.0f;
         }
         else
            oil_temperature  += (0.5f  *  oil_temperature_sign);


         static   float oilPressure_sign =  1.0f;
         if (oilPressure  > 256.0f)
         {
            oilPressure      =  256.0f;
            oilPressure_sign *= -1.0f;
         }
         else if (oilPressure   <  0.0f)
         {
            oilPressure      =  0.0f;
            oilPressure_sign *= -1.0f;
         }
         else
            oilPressure  += (1.0f  *  oilPressure_sign);



         static   float hydraulicPressure_sign =  1.0f;
         if (hydraulicPressure  > 3700.0f)
         {
            hydraulicPressure      =  3700.0f;
            hydraulicPressure_sign *= -1.0f;
         }
         else if (hydraulicPressure   <  1600.0f)
         {
            hydraulicPressure      =  1600.0f;
            hydraulicPressure_sign *= -1.0f;
         }
         else
            hydraulicPressure  += (1.0f   *  hydraulicPressure_sign);



         static   float voltage_sign =  1.0f;
         if (voltage  > 64.0f)
         {
            voltage      =  64.0f;
            voltage_sign *= -1.0f;
         }
         else if (voltage   <  0.0f)
         {
            voltage      =  0.0f;
            voltage_sign *= -1.0f;
         }
         else
            voltage  += (0.1f *  voltage_sign);




         static   float amperage_sign =  1.0f;
         if (amperage   > 512.0f)
         {
            amperage      =  512.0f;
            amperage_sign *= -1.0f;
         }
         else if (amperage <  -512.0f)
         {
            amperage      =  -512.0f;
            amperage_sign *= -1.0f;
         }
         else
            amperage  += (1.0f  *  amperage_sign);




         static   float ac_pitch_lead_sign  =  1.0f;
         float    ac_pitch_lead_max_min     =  90.0f;

         if (ac_pitch_lead   >  ac_pitch_lead_max_min)
         {
            ac_pitch_lead       =   ac_pitch_lead_max_min;
            ac_pitch_lead_sign  *= -1.0f;
         }
         else if (ac_pitch_lead <  -ac_pitch_lead_max_min)
         {
            ac_pitch_lead       =  -ac_pitch_lead_max_min;
            ac_pitch_lead_sign  *= -1.0f;
         }
         else
            ac_pitch_lead += (0.167f  *  ac_pitch_lead_sign);



         static   float ac_roll_lead_sign   =  1.0f;
         float    ac_roll_lead_max_min      =  30.0f;

         if (ac_roll_lead >  ac_roll_lead_max_min)
         {
            ac_roll_lead        =  ac_roll_lead_max_min;
            ac_roll_lead_sign   *= -1.0f;
         }
         else if (ac_roll_lead  <  -ac_roll_lead_max_min)
         {
            ac_roll_lead        =  -ac_roll_lead_max_min;
            ac_roll_lead_sign   *= -1.0f;
         }
         else
            ac_roll_lead  += (1.0f *  ac_roll_lead_sign);




         static   float ac_yaw_lead_sign =  1.0f;
         float    ac_yaw_lead_max_min    =  30.0f;

         if (ac_yaw_lead  >  ac_yaw_lead_max_min)
         {
            ac_yaw_lead         =  ac_yaw_lead_max_min;
            ac_yaw_lead_sign    *= -1.0f;
         }
         else if (ac_yaw_lead   <  -ac_yaw_lead_max_min)
         {
            ac_yaw_lead         =  -ac_yaw_lead_max_min;
            ac_yaw_lead_sign    *= -1.0f;
         }
         else
            ac_yaw_lead   += (1.0f *  ac_yaw_lead_sign);




         static   float ac_pitch_wing_sign  =  1.0f;
         float    ac_pitch_wing_max_min     =  90.0f;

         if (ac_pitch_wing   >  ac_pitch_wing_max_min)
         {
            ac_pitch_wing       =   ac_pitch_wing_max_min;
            ac_pitch_wing_sign  *= -1.0f;
         }
         else if (ac_pitch_wing <  -ac_pitch_wing_max_min)
         {
            ac_pitch_wing       =  -ac_pitch_wing_max_min;
            ac_pitch_wing_sign  *= -1.0f;
         }
         else
            ac_pitch_wing += (0.167f  *  ac_pitch_wing_sign);



         static   float ac_roll_wing_sign   =  1.0f;
         float    ac_roll_wing_max_min      =  30.0f;

         if (ac_roll_wing >  ac_roll_wing_max_min)
         {
            ac_roll_wing        =  ac_roll_wing_max_min;
            ac_roll_wing_sign   *= -1.0f;
         }
         else if (ac_roll_wing  <  -ac_roll_wing_max_min)
         {
            ac_roll_wing        =  -ac_roll_wing_max_min;
            ac_roll_wing_sign   *= -1.0f;
         }
         else
            ac_roll_wing  += (1.0f *  ac_roll_wing_sign);




         static   float ac_yaw_wing_sign =  1.0f;
         float    ac_yaw_wing_max_min    =  30.0f;

         if (ac_yaw_wing  >  ac_yaw_wing_max_min)
         {
            ac_yaw_wing         =  ac_yaw_wing_max_min;
            ac_yaw_wing_sign    *= -1.0f;
         }
         else if (ac_yaw_wing   <  -ac_yaw_wing_max_min)
         {
            ac_yaw_wing         =  -ac_yaw_wing_max_min;
            ac_yaw_wing_sign    *= -1.0f;
         }
         else
            ac_yaw_wing   += (1.0f *  ac_yaw_wing_sign);


         


         static   float aoa_sign =  1.0f;

         if (aoa  >  18.0f)
         {
            aoa      =   18.0f;
            aoa_sign *= -1.0f;
         }
         else if (aoa   <  0.0f)
         {
            aoa      =  0.0f;
            aoa_sign *= -1.0f;
         }
         else
            aoa   += (0.25f *  aoa_sign);



         static   float nav_frequency_sign =  1.0f;

         if (nav_frequency  >  118.0f)
         {
            nav_frequency      =   118.0f;
            nav_frequency_sign *= -1.0f;
         }
         else if (nav_frequency   <  108.0f)
         {
            nav_frequency      =  108.0f;
            nav_frequency_sign *= -1.0f;
         }
         else
            nav_frequency   += (0.05f *  nav_frequency_sign);



         static   float acceleration_sign =  1.0f;

         if (acceleration  >  10.0f)
         {
            acceleration      =  10.0f;
            acceleration_sign *= -1.0f;
         }
         else if (acceleration   <  -5.0f)
         {
            acceleration      =  -5.0f;
            acceleration_sign *= -1.0f;
         }
         else
            acceleration   += (0.05f *  acceleration_sign);



         static   float flap_position_sign =  1.0f;

         if (flap_position >  50.0f)
         {
            flap_position        =  50.0f;
            flap_position_sign   *= -1.0f;
         }
         else if (flap_position  <  0.0f)
         {
            flap_position        =  0.0f;
            flap_position_sign   *= -1.0f;
         }
         else
            flap_position   += (1.0f *  flap_position_sign);



         static   float switch_position_sign =  1.0f;

         if (switch_position >=  29.0f)
            switch_position   =  0.0f;
         else
            switch_position++;


         static   float glideslope_offset_sign =  1.0f;

         if (glideslope_offset >  8.0f)
         {
            glideslope_offset        =  8.0f;
            glideslope_offset_sign   *= -1.0f;
         }
         else if (glideslope_offset  <  -8.0f)
         {
            glideslope_offset        =  -8.0f;
            glideslope_offset_sign   *= -1.0f;
         }
         else
            glideslope_offset   += (0.05f *  glideslope_offset_sign);



         static   float lateral_position_offset_sign =  1.0f;

         if (lateral_position_offset >  8.0f)
         {
            lateral_position_offset        =  8.0f;
            lateral_position_offset_sign   *= -1.0f;
         }
         else if (lateral_position_offset  <  -8.0f)
         {
            lateral_position_offset        =  -8.0f;
            lateral_position_offset_sign   *= -1.0f;
         }
         else
            lateral_position_offset   += (0.05f *  lateral_position_offset_sign);



         static   float rudder_position_percentage_sign  =  1.0f;

         if (rudder_position_percentage >  100.0f)
         {
            rudder_position_percentage        =  100.0f;
            rudder_position_percentage_sign   *= -1.0f;
         }
         else if (rudder_position_percentage  <  -100.0f)
         {
            rudder_position_percentage        =  -100.0f;
            rudder_position_percentage_sign   *= -1.0f;
         }
         else
            rudder_position_percentage   += (1.0f *  rudder_position_percentage_sign);


         static   float throttle_position_percentage_sign   =  1.0f;

         if (throttle_position_percentage >  110.0f)
         {
            throttle_position_percentage        =  110.0f;
            throttle_position_percentage_sign   *= -1.0f;
         }
         else if (throttle_position_percentage  <  0.0f)
         {
            throttle_position_percentage        =  0.0f;
            throttle_position_percentage_sign   *= -1.0f;
         }
         else
            throttle_position_percentage   += (1.0f *  throttle_position_percentage_sign);


         static   float stick_x_position_sign   =  1.0f;

         if (stick_x_position >  30.0f)
         {
            stick_x_position        =  30.0f;
            stick_x_position_sign   *= -1.0f;
         }
         else if (stick_x_position  <  -30.0f)
         {
            stick_x_position        =  -30.0f;
            stick_x_position_sign   *= -1.0f;
         }
         else
            stick_x_position   += (1.0f *  stick_x_position_sign);


         static   float stick_y_position_sign   =  1.0f;

         if (stick_y_position >  30.0f)
         {
            stick_y_position        =  30.0f;
            stick_y_position_sign   *= -1.0f;
         }
         else if (stick_y_position  <  -30.0f)
         {
            stick_y_position        =  -30.0f;
            stick_y_position_sign   *= -1.0f;
         }
         else
            stick_y_position   += (1.5f *  stick_y_position_sign);



         static   float left_landing_gear_sign  =  1.0f;
         static   float left_gear_position      =  0.0f;

         if (left_gear_position        >  2.0f)
         {
            left_gear_position         =  2.0f;
            left_landing_gear_sign     *= -1.0f;
         }
         else if (left_gear_position   <  -1.0f)
         {
            left_gear_position         =  -1.0f;
            left_landing_gear_sign     *= -1.0f;
         }
         else
            left_gear_position    += (0.025f *  left_landing_gear_sign);

         if (left_gear_position   <= 0.0f)
            left_landing_gear    =  0.0f;
         else if (left_gear_position >= 1.0f)
            left_landing_gear    =  1.0f;
         else
            left_landing_gear    =  left_gear_position;


         static   float nose_landing_gear_sign  =  1.0f;
         static   float nose_gear_position      =  0.0f;

         if (nose_gear_position        >  2.0f)
         {
            nose_gear_position         =  2.0f;
            nose_landing_gear_sign     *= -1.0f;
         }
         else if (nose_gear_position   <  -1.0f)
         {
            nose_gear_position         =  -1.0f;
            nose_landing_gear_sign     *= -1.0f;
         }
         else
            nose_gear_position   += (0.030f *  nose_landing_gear_sign);

         if (nose_gear_position  <= 0.0f)
            nose_landing_gear    =  0.0f;
         else if (nose_gear_position >= 1.0f)
            nose_landing_gear    =  1.0f;
         else
            nose_landing_gear    =  nose_gear_position;


         static   float right_landing_gear_sign =  1.0f;
         static   float right_gear_position     =  0.0f;

         if (right_gear_position       >  2.0f)
         {
            right_gear_position        =  2.0f;
            right_landing_gear_sign    *= -1.0f;
         }
         else if (right_gear_position  <  -1.0f)
         {
            right_gear_position        =  -1.0f;
            right_landing_gear_sign    *= -1.0f;
         }
         else
            right_gear_position        += (0.035f *  right_landing_gear_sign);

         if (right_gear_position <= 0.0f)
            right_landing_gear   =  0.0f;
         else if (right_gear_position  >= 1.0f)
            right_landing_gear   =  1.0f;
         else
            right_landing_gear   =  right_gear_position;


         static   float aileron_trim_sign =  1.0f;
         if (aileron_trim  > 6.0f)
         {
            aileron_trim      =  6.0f;
            aileron_trim_sign *= -1.0f;
         }
         else if (aileron_trim   <  -6.0f)
         {
            aileron_trim      =  -6.0f;
            aileron_trim_sign *= -1.0f;
         }
         else
            aileron_trim  += (0.5f  *  aileron_trim_sign);



         static   float rudder_trim_sign =  1.0f;
         if (rudder_trim  > 11.0f)
         {
            rudder_trim      =  11.0f;
            rudder_trim_sign *= -1.0f;
         }
         else if (rudder_trim   <  -6.0f)
         {
            rudder_trim      =  -6.0f;
            rudder_trim_sign *= -1.0f;
         }
         else
            rudder_trim  += (0.5f  *  rudder_trim_sign);


      
         static   float elevator_trim_sign =  1.0f;
         if (elevator_trim  > 20.0f)
         {
            elevator_trim      =  20.0f;
            elevator_trim_sign *= -1.0f;
         }
         else if (elevator_trim   <  -7.0f)
         {
            elevator_trim      =  -7.0f;
            elevator_trim_sign *= -1.0f;
         }
         else
            elevator_trim  += (0.5f  *  elevator_trim_sign);



         static   float lpv_test_value =  1.0f;
         if (lpv_test_value   != test_value)
         {
            fprintf(stderr,"test value = %f\n", test_value);
            lpv_test_value =  test_value;
         }


         static   float lpv_x_rotation =  1.0f;
         if (lpv_x_rotation   != x_rotation)
         {
            fprintf(stderr,"x_rotation = %f\n", x_rotation);
            lpv_x_rotation =  x_rotation;
         }

         static   float lpv_y_rotation =  1.0f;
         if (lpv_y_rotation   != y_rotation)
         {
            fprintf(stderr,"y_rotation = %f\n", y_rotation);
            lpv_y_rotation =  y_rotation;
         }


         static   float delta_altitude_sign  =  1.0f;
         float    delta_altitude_max_min     =  100.0f;

         if (delta_altitude   >  delta_altitude_max_min)
         {
            delta_altitude       =   delta_altitude_max_min;
//            delta_altitude_sign  *= -1.0f;
         }
         else if (delta_altitude <  -delta_altitude_max_min)
         {
            delta_altitude       =  -delta_altitude_max_min;
//            delta_altitude_sign  *= -1.0f;
         }
         else
         {
//            delta_altitude += (0.33f *  delta_altitude_sign);
            if (ac_pitch_lead   <  0.0)
               delta_altitude -= 0.33f;
            else
               delta_altitude += 0.33f;
         }


         static   float lpv_delta_altitude =  1.0f;
         if (lpv_delta_altitude   != delta_altitude)
         {
//            fprintf(stderr,"delta_altitude = %f\n", delta_altitude);
            lpv_delta_altitude =  delta_altitude;
         }


         static   float delta_latitude_sign  =  1.0f;
         float    delta_latitude_max_min     =  100.0f;

         if (delta_latitude   >  delta_latitude_max_min)
         {
            delta_latitude       =   delta_latitude_max_min;
//            delta_latitude_sign  *= -1.0f;
         }
         else if (delta_latitude <  -delta_latitude_max_min)
         {
            delta_latitude       =  -delta_latitude_max_min;
//            delta_latitude_sign  *= -1.0f;
         }
         else
         {
//            delta_latitude += (0.33f *  delta_latitude_sign);
            if (ac_roll_lead <  0.0)
               delta_latitude -= 0.33f;
            else
               delta_latitude += 0.33f;
         }

         static   float lpv_delta_latitude =  1.0f;
         if (lpv_delta_latitude   != delta_latitude)
         {
//            fprintf(stderr,"delta_latitude = %f\n", delta_latitude);
            lpv_delta_latitude =  delta_latitude;
         }


         static   float delta_longitude_sign  =  1.0f;
         float    delta_longitude_max_min     =  100.0f;
         
         if (delta_longitude   >  delta_longitude_max_min)
         {
            delta_longitude       =   delta_longitude_max_min;
            delta_longitude_sign  *= -1.0f;
         }
         else if (delta_longitude <  -delta_longitude_max_min)
         {
            delta_longitude       =  -delta_longitude_max_min;
            delta_longitude_sign  *= -1.0f;
         }
         else
            delta_longitude += (0.33f *  delta_longitude_sign);

         static   float lpv_delta_longitude =  1.0f;
         if (lpv_delta_longitude   != delta_longitude)
         {
//            fprintf(stderr,"delta_longitude = %f\n", delta_longitude);
            lpv_delta_longitude =  delta_longitude;
         }


         if (  (delta_altitude   >   75.0f   || delta_latitude >   75.0f   || delta_longitude   >   75.0f)     ||
               (delta_altitude   <  -75.0f   || delta_latitude <  -75.0f   || delta_longitude   <  -75.0f))
         {
            map_scale         =  0.25f;
         }
         else if ((delta_altitude   >   50.0f   || delta_latitude >   50.0f   || delta_longitude   >   50.0f)  ||
                  (delta_altitude   <  -50.0f   || delta_latitude <  -50.0f   || delta_longitude   <  -50.0f))
         {
            map_scale         =  0.33333333f;
         }
         else if ((delta_altitude   >   25.0f   || delta_latitude >   25.0f   || delta_longitude   >   25.0f)  ||
                  (delta_altitude   <  -25.0f   || delta_latitude <  -25.0f   || delta_longitude   <  -25.0f))
         {
            map_scale         =  0.5f;
         }
         else
            map_scale         =  1.0f;


         static   double   radius   =  5.0   /  60.0;

         ac_heading  *= -1.0f;

//         ac_heading     += 0.01f;
//         ac_heading     += 0.05f;
         ac_heading     += 0.25f;
         if (ac_heading >= 360.0f)
         {
            ac_heading  =  0.0f;
            radius      += 1.0   /  1800.0;
         }

         static   float    another_angle        =  ac_heading;
         static   bool     lpv_formation_flight =  false;
         static   double   ac_longitude_saved   =  ac_longitude;
         static   float    angle                =  0.0f;

         if (formation_flight && !lpv_formation_flight)
         {
            lead_ac_latitude     =  ac_latitude;
            lead_ac_longitude    =  ac_longitude;
            another_angle        =  ac_heading;
            ac_longitude_saved   =  ac_longitude;
         }
         lpv_formation_flight =  formation_flight;

         if (Reposition_Select == 20)
         {
            ac_longitude_saved   =  ac_longitude;
            Reposition_Select    =  0;
         }

         if (formation_flight)
         {
            angle += 0.25f;
            if (angle   >= 360.0f)
               angle =  0.0f;
            else if (angle  <= -360.0f)
               angle =  0.0f;

            another_angle     -= 0.375f;
            if (another_angle >= 360.0f)
               another_angle  =  0.0f;
            else if (another_angle  <= -360.0f)
               another_angle  =  0.0f;

            const    double   delta =  0.000096004;   // 0.000096004 *  60 *  6076.1   =  35ft.

            ac_latitude       += 0.00001;
            ac_longitude      =  ac_longitude_saved   +  4.0   *  delta *  cos(angle         *  DEG_TO_RAD);
            lead_ac_latitude  =  ac_latitude          +  16.0  *  delta *  cos(another_angle *  DEG_TO_RAD);
            lead_ac_heading   =  0.0f;
            ac_heading        =  0.0f;
         }
         else
         {
            ac_latitude       =  ac_latitude_requested   +  radius   *  sin(ac_heading *  DEG_TO_RAD);

            if (ac_latitude   != 90.0)
               ac_longitude   =  ac_longitude_requested  +  radius   *  cos(ac_heading *  DEG_TO_RAD) /  cos(ac_latitude   *  DEG_TO_RAD);
            else
               ac_longitude   =  ac_longitude_requested  +  radius   *  cos(ac_heading *  DEG_TO_RAD) /  0.000001;

            static   double   lead_radius   =  5.0  /  60.0;

            lead_ac_heading  *= -1.0f;

//            lead_ac_heading     += 0.01f;
            lead_ac_heading     += 0.15f;
            if (lead_ac_heading >= 360.0f)
            {
               lead_ac_heading  =  0.0f;
               lead_radius      += 1.0   /  1800.0;
            }

            lead_ac_latitude       =  29.528889   +  lead_radius   *  sin(lead_ac_heading   *  DEG_TO_RAD);
            if (lead_ac_latitude   != 90.0)
               lead_ac_longitude   =  -98.277778  +  lead_radius   *  cos(lead_ac_heading   *  DEG_TO_RAD)  /  cos(lead_ac_latitude   *  DEG_TO_RAD);
            else
               lead_ac_longitude   =  -98.277778  +  lead_radius   *  cos(lead_ac_heading   *  DEG_TO_RAD)  /  0.000001;


            lead_ac_heading  *= -1.0f;

            if (lead_ac_latitude   >  360.0)
               lead_ac_latitude    -= 360.0;
            else if (lead_ac_latitude    <  -360.0)
               lead_ac_latitude    += 360.0;


            if (lead_ac_longitude  >  360.0)
               lead_ac_longitude   -= 360.0;
            else if (lead_ac_longitude   <  -360.0)
               lead_ac_longitude   += 360.0;
         }

         ac_heading  *= -1.0f;


/*
         if (ac_latitude   >  360.0)
            ac_latitude    -= 360.0;
         else if (ac_latitude    <  -360.0)
            ac_latitude    += 360.0;

         if (ac_longitude  >  360.0)
            ac_longitude   -= 360.0;
         else if (ac_longitude   <  -360.0)
            ac_longitude   += 360.0;
*/


         static   float ac_altitude_sign   =  1.0f;
         if (ac_altitude   >  3000.0f)
         {
            ac_altitude       =  3000.0f;
            ac_altitude_sign  *= -1.0f;
         }
         else if (ac_altitude <  0.0f)
         {
            ac_altitude       =  0.0f;
            ac_altitude_sign  *= -1.0f;
         }
         else
            ac_altitude       += (0.5f  *  ac_altitude_sign);



         static   float lead_ac_altitude_sign   =  1.0f;
         if (lead_ac_altitude       >  3000.0f)
         {
            lead_ac_altitude        =  3000.0f;
            lead_ac_altitude_sign   *= -1.0f;
         }
         else if (lead_ac_altitude  <  0.0f)
         {
            lead_ac_altitude        =  0.0f;
            lead_ac_altitude_sign   *= -1.0f;
         }
         else
            lead_ac_altitude        += (0.65f  *  lead_ac_altitude_sign);

         
         static long lpv_nacws_display_range = 1;
         if (lpv_nacws_display_range != nacws_display_range)
         {
            //fprintf(stderr, "NACWS Display Range = %d\n", nacws_display_range);
            lpv_nacws_display_range = nacws_display_range;
         }

         static   float lpv_map_scale =  1.0f;
         if (lpv_map_scale   != map_scale)
         {
//            fprintf(stderr,"map scale = %f\n", map_scale);
            lpv_map_scale =  map_scale;
         }

         static   float lpv_viewer_distance =  1.0f;
         if (lpv_viewer_distance   != viewer_distance)
         {
//            fprintf(stderr,"viewer distance = %f\n", viewer_distance);
            lpv_viewer_distance =  viewer_distance;
         }

         static   float lpv_area_map_scale =  1.0f;
         if (lpv_area_map_scale  != area_map_scale)
         {
//            fprintf(stderr,"area_map_scale = %f\n", area_map_scale);
            lpv_area_map_scale   =  area_map_scale;
         }

         static   float lpv_area_map_latitude_center  =  1.0f;
         if (lpv_area_map_latitude_center != area_map_latitude_center)
         {
//            fprintf(stderr,"area_map_latitude_center = %f\n", area_map_latitude_center);
            lpv_area_map_latitude_center  =  area_map_latitude_center;
         }

         static   float lpv_area_map_longitude_center =  1.0f;
         if (lpv_area_map_longitude_center   != area_map_longitude_center)
         {
//            fprintf(stderr,"area_map_longitude_center = %f\n", area_map_longitude_center);
            lpv_area_map_longitude_center    =  area_map_longitude_center;
         }

         static   float bearing1_sign =  1.0f;
         if (bearing1  > 360.0f)
         {
            bearing1      =  360.0f;
            bearing1_sign *= -1.0f;
         }
         else if (bearing1   <  0.0f)
         {
            bearing1      =  0.0f;
            bearing1_sign *= -1.0f;
         }
         else
            bearing1  += (1.5f  *  bearing1_sign);


         static   float bearing2_sign =  1.0f;
         if (bearing2  > 360.0f)
         {
            bearing2      =  360.0f;
            bearing2_sign *= -1.0f;
         }
         else if (bearing2   <  0.0f)
         {
            bearing2      =  0.0f;
            bearing2_sign *= -1.0f;
         }
         else
            bearing2  += (0.75f *  bearing2_sign);


         static   float mach_sign =  1.0f;
         if (mach  > 0.99f)
         {
            mach      =  0.99f;
            mach_sign *= -1.0f;
         }
         else if (mach   <  0.0f)
         {
            mach      =  0.0f;
            mach_sign *= -1.0f;
         }
         else
            mach  += (0.005f *  mach_sign);


         static   float ias_sign =  1.0f;
         if (ias  > 400.0f)
         {
            ias      =  400.0f;
            ias_sign *= -1.0f;
         }
         else if (ias   <  0.0f)
         {
            ias      =  0.0f;
            ias_sign *= -1.0f;
         }
         else
            ias  += (0.5f *  ias_sign);


         static   float max_allowable_airspeed_sign =  1.0f;
         if (max_allowable_airspeed  > 330.0f)
         {
            max_allowable_airspeed      =  330.0f;
            max_allowable_airspeed_sign *= -1.0f;
         }
         else if (max_allowable_airspeed   <  300.0f)
         {
            max_allowable_airspeed      =  300.0f;
            max_allowable_airspeed_sign *= -1.0f;
         }
         else
            max_allowable_airspeed  += (0.15f *  max_allowable_airspeed_sign);
         

         static   float vertical_speed_sign  =  1.0f;
         if (vertical_speed      >  8000.0f)
         {
            vertical_speed       =  8000.0f;
            vertical_speed_sign  *= -1.0f;
            landing_lights       =  1;

            left_landing_gear_green    =  true;
            right_landing_gear_green   =  true;
            nose_landing_gear_green    =  true;
            left_landing_gear_red      =  true;
            right_landing_gear_red     =  true;
            nose_landing_gear_red      =  true;
            landing_gear_handle        =  true;
            landing_gear_handle_light  =  true;


            fire_test_1 = true;
            fire_test_2 = true;
         }
         else if (vertical_speed <  -8000.0f)
         {
            vertical_speed       =  -8000.0f;
            vertical_speed_sign  *= -1.0f;
            landing_lights       =  0;

            left_landing_gear_green    =  false;
            right_landing_gear_green   =  false;
            nose_landing_gear_green    =  false;
            left_landing_gear_red      =  false;
            right_landing_gear_red     =  false;
            nose_landing_gear_red      =  false;
            landing_gear_handle        =  false;
            landing_gear_handle_light  =  false;

            fire_test_1 = false;
            fire_test_2 = false;
         }
         else
            vertical_speed += (30.0f *  vertical_speed_sign);

         if (request_sortie_page == true)
            request_sortie_page = false;


         if (Reposition_Airport_Change == true)
         {
            strncpy(Active_Airport, Reposition_Airport,  4);
            strncpy(Active_Runway,  Reposition_Runway,   4);
            Reposition_Airport_Change  =  false;
         }

#ifdef WIN32
         Sleep(66);
#else
#ifdef VXWORKS
      taskDelay(6);
#endif
#endif
   }

}

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
#ifdef WIN32

void main()
{
   IOSHostCommsInitialize();

   commstest();
}

#endif

