/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : XYPlotWidget.cpp
//
// Date             : 01 February 2000
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.3 $
//
// Description      : xyplotwidget.cpp contains the implementation of the 
//                    CXYPlotWidget class.  This class draws a plot based
//                    on the values of two variables.  The x and y min and
//                    max can be set.  The color of the plot can be 
//                    changed.  The grids can be toggled on and off.  The
//                    number of grid divisions can be set between 2 and 
//                    10.  The current x,y value is shown as is the name
//                    of the host and rate of data from the host.  
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : General::CPlotWidget, General::CPlotData, 
//                    Core::CXMLWidget, Comms::CCommsAction, 
//                    Core::CVariant, _FSI_STL::string, CString, 
//                    Core::CWidget, Core::CChangeValue, and
//                    General::COpenGLWidget.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: XYPlotWidget.cpp $                                                                   
// Revision 1.3  2000/03/07 20:46:59  billyb                                                                   
// Changed function signatures to eliminate warnings.                                                                   
// Changed calls to AddElementValue.                                                                   
// Revision 1.2  2000/02/01 19:59:41  billyb                                                                   
// New file with comments and drawing of a 10 minute xy plot.  The                                                                   
// drawing of inspection values is not currently functional.                                                                   
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include <gl\gl.h>
#include <gl\glu.h>

#include <map>
#include <string>

#include "OpenGLWidget.h"

#include "XYPlotWidget.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/////////////////////////////////////////////////////////////////////////////
//
// CXYPlotWidget::CXYPlotWidget()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 21 January 2000
//
// Engineer         : Billy Baker
//
// Description      : Default contructor.  Adds required variables for the x
//                    variable name, the x min and max, and the color of the
//                    plot.
//
/////////////////////////////////////////////////////////////////////////////
CXYPlotWidget::CXYPlotWidget()
{
    m_stlStrWidgetName  = _FSI_STL::string("XY_Plot");

    m_listGraphicalElementVars.push_back("Plot X Var Name");
    m_listGraphicalElementVars.push_back("Plot X Var");

    m_listGraphicalElementVars.push_back("X Var Min");
    m_listGraphicalElementVars.push_back("X Var Max");

    m_listGraphicalElementVars.push_back("Color");

    m_mapCommsActions["Plot X Var Name"]    = NULL;

    // Must be set once for InitReinit to work correctly;
    m_pfXPlotData = NULL;

    CXYPlotWidget::InitReinit();
}

void CXYPlotWidget::InitReinit()
{
    CPlotWidget::InitReinit();

    if (m_pfXPlotData != NULL)
    {
        delete m_pfXPlotData;
    }

    m_pfXPlotData   = NULL;
    m_ulSizeOfXData = 0;

    m_fPlotMinX     = 0.0f;
    m_fPlotMaxX     = m_fRate;

    m_mapVarName2PlotData["Plot Y Var 1"].m_bShow       = true;
    m_mapVarName2PlotData_cv["Plot Y Var 1"].m_bShow    = true;
}

/////////////////////////////////////////////////////////////////////////////
//
// CXYPlotWidget::~CXYPlotWidget()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 21 January 2000
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.  Deallocates any memory for the x 
//                    data.
//
/////////////////////////////////////////////////////////////////////////////
CXYPlotWidget::~CXYPlotWidget()
{
    if (m_pfXPlotData != NULL)
    {
        delete m_pfXPlotData;
        m_pfXPlotData   = NULL;
        m_ulSizeOfXData = 0;
    }
}

BEGIN_MESSAGE_MAP(CXYPlotWidget, CButtonWidget)
	//{{AFX_MSG_MAP(CXYPlotWidget)
  	ON_WM_WINDOWPOSCHANGED()
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//
// CWidget* CXYPlotWidget::CreateObject()
//
// Inputs           : None.
//
// Return Values    : A pointer to a new instance of CXYPlotWidget.
//
// Date             : 21 January 2000
//
// Engineer         : Billy Baker
//
// Description      : CXYPlotWidget::CreateObject() is a common 
//                    framework method used to create a new instance of 
//                    CXYPlotWidget.  It is a static member.  The 
//                    address of this method is stored in a map of 
//                    widget name to CreateObject address in the 
//                    component interface for the DLL that contains the 
//                    CXYPlotWidget.  Using this data structure, a 
//                    new instance of CXYPlotWidget can be created 
//                    when one is encountered in the XML page 
//                    description file.
//
/////////////////////////////////////////////////////////////////////////////
CWidget* CXYPlotWidget::CreateObject()
{
    return new CXYPlotWidget();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CXYPlotWidget::Initialize()
//
// Inputs           : CXMLWidget*& rpXMLWidget - reference to a pointer 
//                                               that holds the data to 
//                                               create a CXYPlotWidget.
//                    CWnd* pWnd               - the parent CWnd object.
//                    const long lId           - identifier.
//                    bool bEditMode           - whether editing is taking 
//                                               place.
//
// Return Values    : None.
//
// Date             : 21 January 2000
//
// Engineer         : Billy Baker
//
// Description      : CXYPlotWidget::Initialize() is a common 
//                    framework method.  It is called after an instance 
//                    of CXYPlotWidget has been created.  It is 
//                    responsible for initializing most of the internal 
//                    data members with data from the XMLWidget.  This 
//                    is done using the call to ResetProperties.  If 
//                    the XMLWidget pointer is NULL, a new XMLWidget 
//                    instance is created with default settings.  
//                    Generic help text is set here and any CWnd 
//                    derived Create() calls are made to create the 
//                    Windows object that allows for the use of the MFC 
//                    messages.  The HWND for the CWnd derived object 
//                    that is created is then added to a map in CWidget 
//                    that keeps track of what CWidget derived pointers 
//                    are valid.  This is to make sure that all of the 
//                    threads do not try to dereference bad pointers.
//
/////////////////////////////////////////////////////////////////////////////
void CXYPlotWidget::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                               const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    CXYPlotWidget::InitReinit();

    if (rpXMLWidget != NULL)
    {
        ResetProperties();
    }

    if (GetSafeHwnd() == NULL)
    {
        CreateEx(WS_EX_TRANSPARENT, "BUTTON","",
            WS_CHILD | WS_VISIBLE  | CS_OWNDC | BS_OWNERDRAW | WS_CLIPCHILDREN | WS_CLIPSIBLINGS, 
                 CRect(m_exPtUpperLeft, m_exPtLowerRight),
                (CWnd*)pWnd, lId);
    }
    else
    {
        SetParent(pWnd);
        MoveWindow(m_exPtUpperLeft.X(), m_exPtUpperLeft.Y(),
                   m_exPtLowerRight.X() - m_exPtUpperLeft.X(),
                   m_exPtLowerRight.Y() - m_exPtUpperLeft.Y(), FALSE);
        ShowWindow(SW_NORMAL);
    }


    m_pWnd = this;
    m_mapValidAddresses[this] = m_pWnd->GetSafeHwnd();

    // Do OpenGL setup 
    Setup();

    // Create a comms action to get a default XMLWidget
    // instance that can be modified as the user wants
    // different varaibles.
    CCommsAction* pCommsAction = new CCommsAction();
    if (pCommsAction != NULL)
    {
        CXMLWidget* pXMLWidget = NULL;
        pCommsAction->Initialize(pXMLWidget, this, 1, false);
        if (pXMLWidget != NULL)
        {
            m_xmlCommsSampleWidget = *pXMLWidget;
        }

        delete pXMLWidget;
        pCommsAction->Deleting(true);

        // Set the read mode to always and the write mode to never.
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        if (m_xmlCommsSampleWidget.FindElement(pXMLElement, pos, _FSI_STL::string("VARIABLE")) == true)
        {
            pXMLElement->AddElementValue(_FSI_STL::string("None"));

            STRING2STRING_MAP::iterator s2sIt;
            CString strValue;
            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("READ_MODE")) == true)
            {
                CString strValue;
                strValue.Format("%d",READ_ALWAYS);
                (*s2sIt).second = _FSI_STL::string((LPCTSTR)strValue);
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("WRITE_MODE")) == true)
            {
                (*s2sIt).second = _FSI_STL::string("NO");
            }
        }
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CXYPlotWidget::Render()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 21 January 2000
//
// Engineer         : Billy Baker
//
// Description      : Common method among the OpenGL related classes.  Render()
//                    makes OpenGL calls to draw.  This method is invoked in
//                    COpenGLWidget::DrawItem().
//
/////////////////////////////////////////////////////////////////////////////
void CXYPlotWidget::Render()
{
    CPlotWidget::Render();

    DrawXLabels();

    _FSI_STL::map<_FSI_STL::string, CPlotData>::iterator mIt;
    _FSI_STL::map<_FSI_STL::string, CPlotData>::iterator mendIt;
    mIt     = m_mapVarName2PlotData.begin();
    mendIt  = m_mapVarName2PlotData.end();
    float fPlotCount = 0.0f;
    COpenGLtext oglTextLastValue;
    CString     strLastValue; 

    while (mIt != mendIt)
    {
        // Draw last value.
        glPushMatrix();
        {
            glTranslatef(fPlotCount / 8.0f * m_width, m_height + 13.0f, 0.0f);
            oglTextLastValue.SetForegroundColor((*mIt).second.m_color.Red(), 
                                                (*mIt).second.m_color.Green(), 
                                                (*mIt).second.m_color.Blue());
            if ((*mIt).second.m_pfPlotData != NULL)
            {
                float fLastXValue   = (*mIt).second.m_pfPlotData[((*mIt).second.m_ulSizeOfData - 1) * 2];
                float fLastYValue   = (*mIt).second.m_pfPlotData[((*mIt).second.m_ulSizeOfData - 1) * 2 + 1];
                strLastValue.Format("%.2f ,  %.2f", fLastXValue, fLastYValue);
                if (fLastYValue < (*mIt).second.m_fPlotMinY ||
                    fLastYValue > (*mIt).second.m_fPlotMaxY ||
                    fLastXValue < m_fPlotMinX ||
                    fLastXValue > m_fPlotMaxX)
                {
                    // In case something special is needed for out of bounds
                    // data.
                    oglTextLastValue.Draw(strLastValue, true, 0.0f, 175.0f);
                }
                else
                {
                    oglTextLastValue.Draw(strLastValue, true, 0.0f, 175.0f);
                }
            }
            else
            {
                strLastValue.Format("N/A , N/A");
                oglTextLastValue.Draw(strLastValue, true, 0.0f, 175.0f);
            }
        }
        glPopMatrix();

        fPlotCount += 1.0f;

        DrawYLabels((*mIt).first);
        mIt++;
    }

    glPushMatrix();
    if (m_bPlot == true || m_bClearPlot == false)
    {
        glStencilFunc(GL_NOTEQUAL, 1, 1);
        glStencilOp(GL_KEEP, GL_KEEP, GL_KEEP);

        // Graph the lines 
        mIt = m_mapVarName2PlotData.begin();
        double dXOffset = (fXBORDER + fSMALLOFFSET) / (m_width) * 
                          (m_fPlotMaxX - m_fPlotMinX);

        while (mIt != mendIt)
        {
            if ((*mIt).second.m_pfPlotData != NULL)
            {
                if ((*mIt).second.m_bShow == true)
                {
                    glColor3ub((*mIt).second.m_color.Red(), 
                               (*mIt).second.m_color.Green(), 
                               (*mIt).second.m_color.Blue());

                    glVertexPointer(2, GL_FLOAT, 0, (void*)(*mIt).second.m_pfPlotData);
                    double dYOffset = (fYBORDER + fSMALLOFFSET) / m_height * 
                                      ((*mIt).second.m_fPlotMaxY - (*mIt).second.m_fPlotMinY);
                    glLoadIdentity();
                    gluOrtho2D(m_fPlotMinX - dXOffset,
                               m_fPlotMaxX  + dXOffset,
                               (*mIt).second.m_fPlotMinY - dYOffset, 
                               (*mIt).second.m_fPlotMaxY + dYOffset);

                    glDrawArrays(GL_LINE_STRIP, 0, (*mIt).second.m_ulSizeOfData);
                }
            }

            mIt++;
        }
    }
    glPopMatrix();

    if (m_bInspectValues == true)
    {
        // Draw a box with values from the current 
        // min/max time.
        DrawInspection();
    }

    glStencilFunc(GL_ALWAYS, 0, 0);
    glStencilOp(GL_KEEP, GL_KEEP, GL_KEEP);

    m_width_old     = m_width;
    m_height_old    = m_height;
    m_bGridChanged  = false;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CXYPlotWidget::UpdatePlotData()
//
// Inputs           : _FSI_STL::string& rstlStrVariable - internal name of 
//                                                        variable
//                    CVariant* pVariant                - y data
//
// Return Values    : None.
//
// Date             : 21 January 2000
//
// Engineer         : Billy Baker
//
// Description      : CXYPlotWidget::UpdatePlotData() is called from 
//                    ChangeValue() whenever new y data arrives.
//
/////////////////////////////////////////////////////////////////////////////
void CXYPlotWidget::UpdatePlotData(const _FSI_STL::string& rstlStrVariable, 
                                   CVariant* pVariant)
{
    CPlotData& rPlotData = m_mapVarName2PlotData_cv[rstlStrVariable];

    if (rPlotData.m_pfPlotData == NULL)
    {
        // Create array and assign first value.
        rPlotData.m_pfPlotData      = new float[(int)(m_fRate * 60 * 
                                                      nMINUTES_OF_DATA * 2)];
        rPlotData.m_pfPlotData[1]   = (float)(*pVariant);
        rPlotData.m_ulSizeOfData    = 1;
    }
    else
    {
        // If the max size has been reached, then move the data down.
        if (rPlotData.m_ulSizeOfData == (int)(m_fRate * 60 * nMINUTES_OF_DATA))
        {
            int nLast   = ((int)(m_fRate * 60 * nMINUTES_OF_DATA - 1)) * 2;
            // Don't really care about the x values since they will
            // be copied in UpdateRenderVariables.  So, start at 1
            // rather than 0.
            int i       = 1;
            while (i < nLast)
            {
                rPlotData.m_pfPlotData[i] = rPlotData.m_pfPlotData[i+2];

                i += 2;
            }

            rPlotData.m_ulSizeOfData--;
        }

        // Add the data to the array.
        rPlotData.m_pfPlotData[rPlotData.m_ulSizeOfData * 2 + 1]    = (float)(*pVariant);
        rPlotData.m_ulSizeOfData++;
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CXYPlotWidget::DrawXLabels()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 01 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CXYPlotWidget::DrawXLabels() is called from Render().
//                    This method will check to see if the width or height 
//                    of the widget has changed since the last pass.  If it 
//                    has, then the map of x label position to label will
//                    be recreated.  For the time based plot, the map
//                    would need to regenerate the labels if the width and
//                    height didn't change but the graph either wrapped or
//                    erased.
//
/////////////////////////////////////////////////////////////////////////////
void CXYPlotWidget::DrawXLabels()
{
    if (m_width != m_width_old || m_height != m_height_old || 
        m_bGridChanged == true)
    {
        m_mapXLabels.clear();

        CString strLabel;
        COpenGLtext oglText;
        float fLabel;
        float fWidthDivDivisions    = m_width  / (float)m_ulXDivisions;
        float fSizePerDivision      = (m_fPlotMaxX - m_fPlotMinX) / (float)m_ulXDivisions;
        unsigned long int ul = 0; 
        while (ul <= m_ulXDivisions)
        {
            fLabel = (float)ul * fSizePerDivision + m_fPlotMinX;
            strLabel.Format("%.2f",fLabel);
            oglText.Text(strLabel);
            m_mapXLabels[(float)ul * fWidthDivDivisions] = oglText;
            ul++;
        }
    }

    // Draw all of the x labels.
    _FSI_STL::map<float, COpenGLtext>::iterator mIt = m_mapXLabels.begin();
    _FSI_STL::map<float, COpenGLtext>::iterator mendIt = m_mapXLabels.end();
    while (mIt != mendIt)
    {
        glPushMatrix();
        {
            glTranslatef((*mIt).first, -13.0f, 0.0f);
            (*mIt).second.Draw((*mIt).second.Text(), true, 0.0f, 175.0f);
        }
        glPopMatrix();
        mIt++;
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CXYPlotWidget::DrawYLabels()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 31 January 2000
//
// Engineer         : Billy Baker
//
// Description      : CXYPlotWidget::DrawYLabels() is called from Render().
//                    This method will check to see if the width or height 
//                    of the widget has changed since the last pass.  If it 
//                    has, then the map of y label position to label will
//                    be recreated.  Unlike the time based plot, the xy plot
//                    only has one y variable.  Thus, only one set of
//                    labels should be drawn.
//
/////////////////////////////////////////////////////////////////////////////
void CXYPlotWidget::DrawYLabels(const _FSI_STL::string& rstlStrVarName)
{
    CPlotData& rPlotData = m_mapVarName2PlotData[rstlStrVarName];
    
    if (m_width != m_width_old || m_height != m_height_old ||
        rPlotData.m_bRecomputeYLabels == true || m_bGridChanged == true)
    {
        m_mapVarName2YLabels[rstlStrVarName].clear();

        CString strLabel;
        COpenGLtext oglText;
        float fLabel = rPlotData.m_fPlotMaxY - rPlotData.m_fPlotMinY;
        fLabel /= (float)m_ulYDivisions;

        float fHeightDivDivisions    = m_height  / (float)m_ulYDivisions;
        unsigned long int ul = 0; 
        while (ul <= m_ulYDivisions)
        {
            strLabel.Format("%.2f",(float)ul * fLabel + rPlotData.m_fPlotMinY);
            oglText.Text(strLabel);
            oglText.SetForegroundColor(rPlotData.m_color.Red(), 
                                       rPlotData.m_color.Green(), 
                                       rPlotData.m_color.Blue());

            // Put the labels in to line up with the major tic marks.
            if (ul == 0)
            {
                (m_mapVarName2YLabels[rstlStrVarName])[(float)ul * fHeightDivDivisions ] = oglText;
            }
            else if (ul == m_ulYDivisions)
            {
                (m_mapVarName2YLabels[rstlStrVarName])[(float)ul * fHeightDivDivisions] = oglText;
            }
            else
            {
                (m_mapVarName2YLabels[rstlStrVarName])[(float)ul * fHeightDivDivisions] = oglText;
            }

            ul++;
        }

        rPlotData.m_bRecomputeYLabels = false;
    }

    if (rPlotData.m_bShow == true)
    {
        // Draw all of the y labels.
        _FSI_STL::map<float, COpenGLtext>::iterator mIt = 
                                  m_mapVarName2YLabels[rstlStrVarName].begin();
        _FSI_STL::map<float, COpenGLtext>::iterator mendIt = 
                                  m_mapVarName2YLabels[rstlStrVarName].end();
        while (mIt != mendIt)
        {
            glPushMatrix();
            {
                glTranslatef(-49.0f, (*mIt).first, 0.0f);
                (*mIt).second.Draw((*mIt).second.Text(), true, 0.0f, 175.0f);
            }
            glPopMatrix();

            mIt++;
        }
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CXYPlotWidget::DrawInspection()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 21 January 2000
//
// Engineer         : Billy Baker
//
// Description      : CXYPlotWidget::DrawInspection() is called from Render().
//                    This method will draw information related to the data
//                    that would be intersect by a line passing throught the
//                    mouse's current position and perpendicular to the 
//                    bounding box of the plot area.
//
/////////////////////////////////////////////////////////////////////////////
void CXYPlotWidget::DrawInspection()
{
    return; 

    // Translate the mouse position to a position within the plotting region.
    float fTransX = (m_width + 2 * fXBORDER + 2 * fSMALLOFFSET) / 
                     m_width * (float)m_ptMouse.x               - 
                     fXBORDER - fSMALLOFFSET;
    float fTransY = (m_height + 2 * fYBORDER + 2 * fSMALLOFFSET) / 
                     m_height * (m_height - (float)m_ptMouse.y)  - 
                     fYBORDER - fSMALLOFFSET;

    if (fTransX < 0.0f || fTransX > m_width || 
        fTransY < 0.0f || fTransY > m_height)
    {
        return;
    }

    COpenGLtext oglInspection;
    oglInspection.SetBackgroundColor(true, 0, 0, 0);
    CString strValues   = "";

    _FSI_STL::map<_FSI_STL::string, CPlotData>::iterator mIt;
    _FSI_STL::map<_FSI_STL::string, CPlotData>::iterator mendIt;
    mIt     = m_mapVarName2PlotData.begin();
    mendIt  = m_mapVarName2PlotData.end();
    float fMousePos             = m_fPlotMinX + 
                                  fTransX * (m_fPlotMaxX - m_fPlotMinX) / 
                                  m_width;
    float fHeightDiv5Divisions  = m_height / (10.0f * 5.0f);

    while (mIt != mendIt)
    {
        if ((*mIt).second.m_ulSizeOfData > 0)
        {
/*            if (fFirstTime <= fMouseTime && fMouseTime <= fLastTime)
            {
                strValues.Format("%12.3f , %12.3f", (*mIt).second.m_pfPlotData[(int)(fMousePos - fFirstTime) * 2],
                                                    (*mIt).second.m_pfPlotData[(int)(fMousePos - fFirstTime) * 2 + 1]);
                oglInspection.SetForegroundColor((*mIt).second.m_color.Red(), 
                                                 (*mIt).second.m_color.Green(),
                                                 (*mIt).second.m_color.Blue());
            }
*/
        }

        mIt++;
    }

    glPushMatrix();

    // Draw line from top to bottom at current mouse position.
    glBegin(GL_LINES);
      glColor3ub(255, 255, 255);
      glVertex2f(fTransX, 0.0f);
      glVertex2f(fTransX, m_height);
    glEnd();

    // Make sure the entire box of data will fit in the plotting region.
    if (fTransX < m_width / 9.0f)
    {
        fTransX = m_width / 9.0f ;
    }
    else if (fTransX > 8.0f * m_width / 9.0f)
    {
        fTransX = 8.0f * m_width / 9.0f;
    }

    if (fTransY < 2 * fHeightDiv5Divisions)
    {
        fTransY = 2 * fHeightDiv5Divisions;
    }
    else if (fTransY > m_height - 2 * fHeightDiv5Divisions)
    {
        fTransY = m_height - 2 * fHeightDiv5Divisions;
    }

    glTranslatef(fTransX, fTransY, 0.0f);

    // Draw a black background for the data.
    glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
    glBegin(GL_QUADS);
        glColor3ub(0, 0, 0);
        glVertex2f(-m_width/10.0f,  fHeightDiv5Divisions);
        glVertex2f( m_width/10.0f,  fHeightDiv5Divisions);
        glVertex2f( m_width/10.0f, -fHeightDiv5Divisions);
        glVertex2f(-m_width/10.0f, -fHeightDiv5Divisions);
    glEnd();

    // Surround the black background with a white border.
    glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
    glBegin(GL_LINE_STRIP);
        glColor3ub(255, 255, 255);
        glVertex2f(-m_width/10.0f,  fHeightDiv5Divisions);
        glVertex2f( m_width/10.0f,  fHeightDiv5Divisions);
        glVertex2f( m_width/10.0f, -fHeightDiv5Divisions);
        glVertex2f(-m_width/10.0f, -fHeightDiv5Divisions);
        glVertex2f(-m_width/10.0f,  fHeightDiv5Divisions);
    glEnd();

    // Draw the data.
    glPushMatrix();
    if (strValues != "")
    {
        oglInspection.Draw(strValues, true, 0.0f, 175.0f);
        glTranslatef(0.0f, -fHeightDiv5Divisions, 0.0f);
    }

    glPopMatrix();

    glPopMatrix();
}

/////////////////////////////////////////////////////////////////////////////
//
// Methods called from Comms thread 
//
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
// void CXYPlotWidget::ChangeValue()
//
// Inputs           : CString& rstrElementVar - the internal name of a 
//                                              variable that needs to be 
//                                              updated.
//                    CChangeValue* pCV       - pointer to data used to 
//                                              update an internal 
//                                              variable.
//
// Return Values    : None.
//
// Date             : 21 January 2000
//
// Engineer         : Billy Baker
//
// Description      : CXYPlotWidget::ChangeValue() is a common framework 
//                    method that is used by the Comms thread to send 
//                    new data to the graphical elements.  Since it is 
//                    called from another thread, the special internal 
//                    variables are used to store the updates.  Before 
//                    the graphical element is redrawn, 
//                    UpdateRenderVariables is called to copy the 
//                    updated values to the values used for rendering.  
//                    This causes more memory to be used but prevents 
//                    the use of synchronization objects that may stall 
//                    the Comms thread.
//
/////////////////////////////////////////////////////////////////////////////
void CXYPlotWidget::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
    if (pCV == NULL)
    {
        return;
    }

    if (rstrElementVar   == "Start/Stop")
    {
        // Change the state of plotting.
        m_bPlot_cv = !m_bPlot;
        if (m_bPlot_cv == true)
        {
            // Erase all of the x,y data.
            _FSI_STL::map<_FSI_STL::string, CPlotData>::iterator mIt;
            _FSI_STL::map<_FSI_STL::string, CPlotData>::iterator mendIt;
            mIt = m_mapVarName2PlotData_cv.begin();
            mendIt = m_mapVarName2PlotData_cv.end();
            while (mIt != mendIt)
            {
                if ((*mIt).second.m_pfPlotData != NULL)
                {
                    delete [] (*mIt).second.m_pfPlotData;
                    (*mIt).second.m_pfPlotData      = NULL;
                    (*mIt).second.m_ulSizeOfData    = 0;
                }

                mIt++;
            }

            if (m_pfXPlotData != NULL)
            {
                delete [] m_pfXPlotData;
                m_pfXPlotData   = NULL;
                m_ulSizeOfXData = 0;
            }
        }
    }
    else if (rstrElementVar   == "Clear")
    {
        // Erase all of the x,y data.
        _FSI_STL::map<_FSI_STL::string, CPlotData>::iterator mIt;
        _FSI_STL::map<_FSI_STL::string, CPlotData>::iterator mendIt;
        mIt = m_mapVarName2PlotData_cv.begin();
        mendIt = m_mapVarName2PlotData_cv.end();
        while (mIt != mendIt)
        {
            if ((*mIt).second.m_pfPlotData != NULL)
            {
                delete [] (*mIt).second.m_pfPlotData;
                (*mIt).second.m_pfPlotData      = NULL;
                (*mIt).second.m_ulSizeOfData    = 0;
            }

            mIt++;
        }

        if (m_pfXPlotData != NULL)
        {
            delete [] m_pfXPlotData;
            m_pfXPlotData   = NULL;
            m_ulSizeOfXData = 0;
        }
    }
    else if (rstrElementVar   == "Plot X Var Name")
    {
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        if (m_xmlCommsSampleWidget.FindElement(pXMLElement, pos, _FSI_STL::string("VARIABLE")) == true)
        {
            pXMLElement->AddElementValue((_FSI_STL::string)*pCV->Variant());

            STRING2STRING_MAP::iterator s2sIt;

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("ELEMENT_VAR")) == true)
            {
                (*s2sIt).second = _FSI_STL::string("Plot X Var");
            }
        }

        m_xmlCommsWidget = m_xmlCommsSampleWidget;
        if (m_pfXPlotData != NULL)
        {
            delete m_pfXPlotData;
            m_pfXPlotData   = NULL;
            m_ulSizeOfXData = 0;
        }

        if (m_mapCommsActions["Plot X Var"] != NULL)
        {
            (m_mapCommsActions["Plot X Var"])->Deleting(true);
            m_mapCommsActions["Plot X Var"] = NULL;
        }
    }
    else if (rstrElementVar  == "Plot X Var")
    {
        if (m_bPlot_cv == true && m_bStopped == false)
        {
            if (m_pfXPlotData == NULL)
            {
                m_pfXPlotData       = new float[(int)(m_fRate * 60 * nMINUTES_OF_DATA)];
                m_pfXPlotData[0]    = (float)(*(pCV->Variant()));
                m_ulSizeOfXData     = 1;
            }
            else
            {
                // If the max size has been reached, then move the data down.
                if (m_ulSizeOfXData == (int)(m_fRate * 60 * nMINUTES_OF_DATA))
                {
                    int nLast   = ((int)(m_fRate * 60 * nMINUTES_OF_DATA - 1));
                    // Don't really care about the y values since they will
                    // be copied in UpdatePlotData.  So, start at 0.
                    int i       = 0;
                    while (i < nLast)
                    {
                        m_pfXPlotData[i] = m_pfXPlotData[i+1];

                        i += 1;
                    }

                    m_ulSizeOfXData--;
                }

                // Add the data to the array.
                m_pfXPlotData[m_ulSizeOfXData]   = (float)(*(pCV->Variant()));
                m_ulSizeOfXData++;
            }
        }
    }
    else if (rstrElementVar == "X Var Min")
    {
        m_fPlotMinX_cv = (float)*pCV->Variant();
    }
    else if (rstrElementVar == "X Var Max")
    {
        m_fPlotMaxX_cv = (float)*pCV->Variant();
    }
    else if (rstrElementVar == "Color")
    {
        CColor& rColor = m_mapColors[pCV->Text()];
        m_mapVarName2PlotData_cv["Plot Y Var 1"].m_color = rColor;
    }
    else
    {
        CPlotWidget::ChangeValue(rstrElementVar, pCV);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CXYPlotWidget::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : true  - all of the render variables were updated.
//                    false - a problem occurred updating the render 
//                            variables.
//
// Date             : 21 January 2000
//
// Engineer         : Billy Baker
//
// Description      : CXYPlotWidget::UpdateRenderVariables is a 
//                    common framework method that is called by the 
//                    Comms thread to make sure that all of the 
//                    variables used for rendering have the most up to 
//                    date data.
//
/////////////////////////////////////////////////////////////////////////////
bool CXYPlotWidget::UpdateRenderVariables()
{
    // Copy the x data into the CPlotData array.
    if (m_pfXPlotData != NULL)
    {
        _FSI_STL::map<_FSI_STL::string, CPlotData>::iterator mIt;
        _FSI_STL::map<_FSI_STL::string, CPlotData>::iterator mendIt;
        mIt     = m_mapVarName2PlotData_cv.begin();
        mendIt  = m_mapVarName2PlotData_cv.end();
        unsigned long int ul;
        while (mIt != mendIt)
        {
            if ((*mIt).second.m_pfPlotData != NULL)
            {
                if ((*mIt).second.m_ulSizeOfData == m_ulSizeOfXData)
                {
                    ul = 0;
                    while (ul < m_ulSizeOfXData)
                    {
                        (*mIt).second.m_pfPlotData[2 * ul] = m_pfXPlotData[ul];

                        ul++;
                    }
                }
            }

            mIt++;
        }
    }

    bool bRetVal = CPlotWidget::UpdateRenderVariables();

    if (bRetVal == true)
    {
        m_fPlotMinX             = m_fPlotMinX_cv;
        m_fPlotMaxX             = m_fPlotMaxX_cv;

        if (m_mapCommsActions["Plot X Var"] == NULL)
        {
            m_mapCommsActions["Plot X Var"] = new CCommsAction();

            if (m_mapCommsActions["Plot X Var"] != NULL)
            {
                CXMLWidget* pXMLWidget = &m_xmlCommsWidget;
                m_mapCommsActions["Plot X Var"]->ParentWidget(this);
                m_mapCommsActions["Plot X Var"]->Initialize(pXMLWidget,
                                                            this, 1, false);
                m_mapCommsActions["Plot X Var"]->BaseWidget(BaseWidget());
            }
        }
    }

    return bRetVal;
}
