/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : vertcollaraction.cpp
//
// Date             : 11 September 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.3 $
//
// Description      : VertCollarAction.cpp contains the implementation of the 
//                    CVertCollarAction class.  This class is used to 
//                    change out the content in the vertical collar.  This
//                    is almost the same as the pageaction which changes the
//                    view's content.  The only change is the message that
//                    is posted in OnLButtonUp.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CXMLWidget, Core::CWidget, Core::CAction, CWnd.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: vertcollaraction.cpp $                                                                   
// Revision 1.3  1999/10/20 18:47:08  billyb                                                                   
// Changed OnLButtonUp to return an enum.                                                                   
// Revision 1.2  1999/09/11 18:30:09  billyb                                                                   
// Made the CVertCollarAction class descend from CPageAction                                                                   
// since the only difference is the OnLButtonUp method.                                                                   
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "VertCollarAction.h"

#include "..\core\LinkPage.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

CString CVertCollarAction::m_strPageInfo;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CVertCollarAction::CVertCollarAction()
{
    m_stlStrWidgetName = _FSI_STL::string("Change_Vertical_Collar");
    m_listWidgetPropPages.push_back(CLinkPage::CreateObject);
}

CVertCollarAction::~CVertCollarAction()
{
}

CWidget* CVertCollarAction::CreateObject()
{
    return new CVertCollarAction();
}

enum LButtonUpReturn CVertCollarAction::OnLButtonUp()
{
    m_strPageInfo = CString(m_strComponent + "^" + m_strSubComponent + 
							"^" + m_strPage);

    CFrameWnd* pFrame = m_pBaseWidget->Wnd()->GetParentFrame(); 

	pFrame->PostMessage(WM_CHANGE_VERT_COLLAR, 0, (long)(LPCTSTR)m_strPageInfo); 

    return LBU_OK;
}
