// TreeWidget.cpp : implementation file
//

#include "..\core\stdafx.h"
#include "TreeWidget.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTreeWidget

CTreeWidget::CTreeWidget()
{
    m_stlStrWidgetName = _FSI_STL::string("Tree");
    m_exPtUpperLeft = CExtentsPoint(CPoint(0,0)); 
    m_exPtLowerRight = CExtentsPoint(CPoint(300,300));
    m_bFirstPosChange = true;
    m_listWidgetPropPages.push_back(CHeaderPage::CreateObject);
}

CTreeWidget::~CTreeWidget()
{
    _FSI_STL::list<HeaderData*>::iterator lIt = m_listHeaderData.begin();
    _FSI_STL::list<HeaderData*>::iterator lendIt = m_listHeaderData.end();
    while (lIt != lendIt)
    {
        delete (*lIt);
        lIt++;
    }
    m_listHeaderData.clear();
}


BEGIN_MESSAGE_MAP(CTreeWidget, CWnd)
	//{{AFX_MSG_MAP(CTreeWidget)
	ON_WM_LBUTTONDBLCLK()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_SETCURSOR()
	ON_WM_WINDOWPOSCHANGED()
	ON_WM_RBUTTONUP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTreeWidget message handlers
void CTreeWidget::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                               const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    if (rpXMLWidget != NULL)
    {
        ResetProperties();
    }

    if (GetSafeHwnd() == NULL)
    {
        CreateEx(WS_EX_CLIENTEDGE, NULL, NULL, WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE,
               CRect(m_exPtUpperLeft, m_exPtLowerRight),
               (CWnd*)pWnd, lId);
        ModifyStyle(GetStyle(), 0x50810000, 0);
    }
    else
    {
        SetParent(pWnd);
        MoveWindow(m_exPtUpperLeft.X(), m_exPtUpperLeft.Y(),
                   m_exPtLowerRight.X() - m_exPtUpperLeft.X(),
                   m_exPtLowerRight.Y() - m_exPtUpperLeft.Y(), FALSE);
        ShowWindow(SW_NORMAL);
    }


    CTLFrame::Initialize();

    _FSI_STL::list<HeaderData*>::iterator lIt = m_listHeaderData.begin();
    _FSI_STL::list<HeaderData*>::iterator lendIt = m_listHeaderData.end();
    while (lIt != lendIt)
    {
        m_tree.InsertColumn((*lIt)->m_ushPosition, (*lIt)->m_stlStrHeader.c_str(), 
                            LVCFMT_LEFT, (*lIt)->m_ushSize);

        lIt++;
    }

    m_pWnd = this;
    m_mapValidAddresses[this] = m_pWnd->GetSafeHwnd();
}

CWidget* CTreeWidget::CreateObject()
{
    return new CTreeWidget();
}

void CTreeWidget::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
    if (pCV == NULL || GetSafeHwnd() == NULL)
    {
        return;
    }

    HTREEITEM hTreeSel = m_tree.GetSelectedItem();
    HTREEITEM hItem = GetItemByName(m_tree.GetSafeHwnd(), NULL, 
                                    ((_FSI_STL::string)*(pCV->Variant())).c_str());

    if (hItem == NULL)
    {
        if (hTreeSel != NULL)
        {
            m_tree.InsertItem(((_FSI_STL::string)*(pCV->Variant())).c_str(), 0, 0, hTreeSel);
        }
        else
        {
            m_tree.InsertItem(((_FSI_STL::string)*(pCV->Variant())).c_str(),0,0);
        }
    }
}

CVariant* CTreeWidget::GetValue(const CString &rstrValue)
{
    HTREEITEM hTreeSel = m_tree.GetSelectedItem();
    if (hTreeSel != NULL)
    {
        CString strSel = m_tree.GetItemText(hTreeSel, 0);

        m_variant.Value(_FSI_STL::string((LPCTSTR)strSel));
    }
    else
    {
        m_variant.Value(_FSI_STL::string(""));
    }

    return &m_variant;
}

void CTreeWidget::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	OnLButtonDown(nFlags, point);
}

void CTreeWidget::OnLButtonDown(UINT nFlags, CPoint point) 
{
    if (m_bEditing == true)
    {
        CWidget::Track(point);
    }
    else
    {
        if (m_bFocus != true)
        {
	        m_bFocus = true;
            m_bRedraw = true;
        }

        if (nFlags & MK_LBUTTON)
        {
            if (m_bLButtonDown != true)
            {
                m_bRedraw = true;
                m_bLButtonDown = true;
            }
        }
        else
        {
            if (m_bLButtonDown != false)
            {
                m_bRedraw = true;
                m_bLButtonDown = false;
            }
        }
    }
}

void CTreeWidget::OnLButtonUp(UINT nFlags, CPoint point) 
{
    if (m_bEditing == true)
    {
    }
    else
    {
        if (m_bFocus != true)
        {
	        m_bFocus = true;
            m_bRedraw = true;
        }

        if (m_bLButtonDown != false)
        {
            m_bRedraw = true;
            m_bLButtonDown = false;
        }

        if (m_bEditing == false)
        {
            _FSI_STL::list<CAction*>::iterator lIt = m_listActions.begin();
            _FSI_STL::list<CAction*>::iterator lendIt = m_listActions.end();
            while (lIt != lendIt)
            {
                (*lIt)->OnLButtonUp();
                lIt++;
            }
        }
    }
}

BOOL CTreeWidget::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
    if (m_bEditing == true && m_pTracker != NULL)
    {
        if (pWnd == this && m_pTracker->SetCursor(pWnd, nHitTest))
        {
            return TRUE;
        }
    }
	
	return CTLFrame::OnSetCursor(pWnd, nHitTest, message);
}

void CTreeWidget::OnWindowPosChanged(WINDOWPOS* lpwndpos) 
{
	CTLFrame::OnWindowPosChanged(lpwndpos);

    if (m_bFirstPosChange == false)
    {
//        lpwndpos->x -= 2;
//        lpwndpos->y -= 2;
//        lpwndpos->cx += 4;
//        lpwndpos->cy += 4;
    }
    else
    {
        m_bFirstPosChange = false;
    }

    CWidget::PosChanged(CRect(lpwndpos->x, lpwndpos->y,
                              lpwndpos->x + lpwndpos->cx,
                              lpwndpos->y + lpwndpos->cy));

    if (m_bFirstPosChange == false)
    {
//        lpwndpos->x -= 2;
//        lpwndpos->y -= 2;
//        lpwndpos->cx += 4;
//        lpwndpos->cy += 4;
    }
    else
    {
        m_bFirstPosChange = true;
        CTLFrame::Initialize();
    }
}

void CTreeWidget::OnRButtonUp(UINT nFlags, CPoint point) 
{
	CWidget::RButtonUp(nFlags, point);
}

void CTreeWidget::ResetProperties()
{
    CWidget::ResetProperties();
    CWidget::ExtentsProperties();

    CXMLElement* pXMLElement = NULL;
    POSITION pos = NULL;

    _FSI_STL::list<HeaderData*>::iterator lIt = m_listHeaderData.begin();
    _FSI_STL::list<HeaderData*>::iterator lendIt = m_listHeaderData.end();
    while (lIt != lendIt)
    {
        delete (*lIt);
        lIt++;
    }
    m_listHeaderData.clear();

    while (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("HEADER")) == true)
    {
        HeaderData* pData = new HeaderData;

        pData->m_stlStrHeader = pXMLElement->ElementValue();

        STRING2STRING_MAP::iterator s2sIt = NULL;
        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("POSITION")) == true)
        {
            pData->m_ushPosition = (unsigned short)atoi((*s2sIt).second.c_str());
        }
        else
        {
            pXMLElement->AddAttribute(_FSI_STL::string("POSITION"),
                                      _FSI_STL::string("0"));
        }

        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SIZE")) == true)
        {
            pData->m_ushSize = (unsigned short)atoi((*s2sIt).second.c_str());
        }
        else
        {
            pXMLElement->AddAttribute(_FSI_STL::string("SIZE"),
                                  _FSI_STL::string("100"));
        }
        m_listHeaderData.push_back(pData);
    }

    if (m_listHeaderData.size() == 0)
    {
        // No element was found.  
        CString strValue;
        m_pXMLWidget->AddElement(_FSI_STL::string("HEADER"), 
                                 _FSI_STL::string("Blank"),
                                 NULL);
        pXMLElement = NULL;
        if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("HEADER")) == true)
        {
            strValue.Format("%d",0);
            pXMLElement->AddAttribute(_FSI_STL::string("POSITION"),
                                  _FSI_STL::string((LPCTSTR)strValue));
            strValue.Format("%d",100);
            pXMLElement->AddAttribute(_FSI_STL::string("SIZE"),
                                  _FSI_STL::string((LPCTSTR)strValue));
        }
    }

    if (GetSafeHwnd() != NULL)
    {
        long lId = GetDlgCtrlID();
        CWnd* pWnd = GetParent();
        m_tree.m_headerFont.DeleteObject();
        m_tree.m_wndHeader.DestroyWindow();
        m_tree.DestroyWindow();
        m_horScrollBar.DestroyWindow();
        DestroyWindow();
        CreateEx(WS_EX_CLIENTEDGE, NULL, NULL, WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE,
               CRect(m_exPtUpperLeft, m_exPtLowerRight),
               (CWnd*)pWnd, lId);
        ModifyStyle(GetStyle(), 0x50810000, 0);

        CTLFrame::Initialize();

        _FSI_STL::list<HeaderData*>::iterator lIt = m_listHeaderData.begin();
        _FSI_STL::list<HeaderData*>::iterator lendIt = m_listHeaderData.end();
        while (lIt != lendIt)
        {
            m_tree.InsertColumn((*lIt)->m_ushPosition, (*lIt)->m_stlStrHeader.c_str(), 
                                LVCFMT_LEFT, (*lIt)->m_ushSize);

            lIt++;
        }
    }
}

HTREEITEM CTreeWidget::GetItemByName(HWND hWnd, HTREEITEM hItem, LPCTSTR szItemName)
{
    // If hItem is NULL, start search from root item.
    if (hItem == NULL)
    {
        hItem = m_tree.GetNextItem(TVGN_ROOT, 0);
    }

    while (hItem != NULL)
    {
        CString strBuffer;
        TV_ITEM item;

        item.hItem = hItem;
        item.mask = TVIF_CHILDREN | TVIF_PARAM;
        m_tree.GetItem(&item);

        // Did we find it?
        if (item.lParam != NULL)
        {
            CTLItem* tlItem = (CTLItem*)item.lParam;
            strBuffer = tlItem->GetItemString();
            if (strBuffer == CString(szItemName))
            {
                return hItem;
            }
        }


        // Check whether we have child items.
        if (item.cChildren)
        {
            // Recursively traverse child items.
            HTREEITEM hItemFound, hItemChild;

            hItemChild = m_tree.GetNextItem(hItem, TVGN_CHILD);

            hItemFound = GetItemByName(hWnd, hItemChild, szItemName);

            // Did we find it?
            if (hItemFound != NULL)
                return hItemFound;
        }

        // Go to next sibling item.
        hItem = m_tree.GetNextItem(hItem, TVGN_NEXT);
    }

    // Not found.
    return NULL;
} 
