// TreePage.cpp: implementation of the CTreePage class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "TreePage.h"

#include "..\core\widget.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CTreePage::CTreePage()
{
	//{{AFX_DATA_INIT(CTreePage)
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Tree");
}

CTreePage::~CTreePage()
{

}

void CTreePage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTreePage)
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTreePage, CBasePage)
	//{{AFX_MSG_MAP(CTreePage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//
// CBasePage* CTreePage::CreateObject()
//
// Inputs           : None.
//
// Return Values    : A pointer to a new instance of the CTreePage class.
//
// Date             : 22 November 1998
//
// Engineer         : Billy Baker
//
// Description      : CreateObject is a static member method that 
//                    creates a new instance of the CTreePage.  
//                    Every class derived from CBasePage must 
//                    implmement CreateObject as each Widget contains a 
//                    list of pointers to the CreateObject methods that 
//                    correspond to the property pages needed for that Widget.
//
/////////////////////////////////////////////////////////////////////////////
CBasePage* CTreePage::CreateObject()
{
    return new CTreePage;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CTreePage::SetProperties()
//
// Inputs           : void* pWidget - a pointer to be cast to a CWidget*
//
// Return Values    : None.
//
// Date             : 29 January 1999
//
// Engineer         : Billy Baker
//
// Description      : CTreePage::SetProperties is the standard 
//                    interface for initializing the dialog controls 
//                    with data from the CXMLWidget instance that is 
//                    associated with the CWidget instance that is 
//                    passed to the method.  Every ...::SetProperties 
//                    method does has a similar implmemenation--find 
//                    each element that is used in the property page 
//                    and for each find their attributes if there are 
//                    any.  Note: UpdateData is not called here since 
//                    SetProperties is called before Create.
//
/////////////////////////////////////////////////////////////////////////////
void CTreePage::SetProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL)
    {
        ELEMENT_LIST::iterator elIt = NULL;
        if (pXMLWidget->FindElement(elIt,_FSI_STL::string("OPTIONS")) == true)
        {
            long int lOptions = atoi((*elIt)->ElementValue().c_str());

            if ((lOptions & SIMPLE) != 0)
            {
                m_nType = 0;
            }
            else if ((lOptions & DROPLIST) != 0)
            {
                m_nType = 1;
            }
        }

        elIt = NULL;
        if (pXMLWidget->FindElement(elIt,_FSI_STL::string("ENTRIES")) == true)
        {
            CString strEntries = CString((*elIt)->ElementValue().c_str());
            CString strEntry;

            while (strEntries.Find(",") > -1)
            {
                strEntry = strEntries.Left(strEntries.Find(","));
                m_listEntries.push_back(strEntry);
                strEntries = strEntries.Mid(strEntries.Find(",") + 1);
            }

            m_listEntries.push_back(strEntries);
        }
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CTreePage::UpdateProperties()
//
// Inputs           : void* pWidget - a void pointer to be case to a CWidget*
//
// Return Values    : None.
//
// Date             : 29 January 1999
//
// Engineer         : Billy Baker
//
// Description      : CTreePage::UpdateProperties is another 
//                    standard interface method for dealing with 
//                    property pages derived from CBasePage.  When the 
//                    data from the property page needs to be applied, 
//                    the UpdateProperties method is called.  The 
//                    implementatin is similar in every CBasePage 
//                    derived class--find the elements in the 
//                    CXMLWidget that is associated with the CWidget 
//                    that is passed and update each element and any 
//                    associated attributes.
//
/////////////////////////////////////////////////////////////////////////////
void CTreePage::UpdateProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL && GetSafeHwnd() != NULL)
    {
        UpdateData(TRUE);
        ELEMENT_LIST::iterator elIt = NULL;
        if (pXMLWidget->FindElement(elIt,_FSI_STL::string("OPTIONS")) == true) 
        {
            long int lOptions = 0;
            if (m_nType == 0)
            {
                lOptions |= SIMPLE;
            }
            else if (m_nType == 1)
            {
                lOptions |= DROPLIST;
            }

            CString strValue;
            strValue.Format("%d",lOptions);
            (*elIt)->AddElementValue(_FSI_STL::string((LPCTSTR)strValue),true);
        }

        elIt = NULL;
        if (pXMLWidget->FindElement(elIt,_FSI_STL::string("ENTRIES")) == true)
        {
            long int lEntryCount = m_ctrlEntryList.GetItemCount();
            long int lEntryStep = 0;

            CString strEntries;

            while (lEntryStep < lEntryCount)
            {
                strEntries += m_ctrlEntryList.GetItemText(lEntryStep,0) + ",";
                lEntryStep++;
            }

            // Get rid of the trailing ",".
            strEntries = strEntries.Left(strEntries.GetLength() - 1);
            (*elIt)->AddElementValue(_FSI_STL::string((LPCTSTR)strEntries),true);

        }
    }
}

