/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : TimePlotWidget.h
//
// Date             : 01 February 2000
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.3 $
//
// Description      : TimePlotWidget.h contains the definition of the 
//                    CTimePlotWidget class.  This class draws a plot based
//                    on the values of a variable (for y) and time.  A maximum
//                    of six plots may be drawn.  Each plot may have a 
//                    different color, and differt y limits.  The grids can be 
//                    toggled on and off.  The number of grid divisions can be 
//                    set between 2 and 10.  The current x,y value is shown as 
//                    is the name of the host and rate of data from the host.  
//                    Inspection of values is possible.  Three plotting modes
//                    exist--stop, wrap, erase.  Stop will stop when the right
//                    side maximum is reached.  But, if the time on the x-axis
//                    grows before the plot has stopped, then the plot will
//                    continue.  Erase will erase the plotting region when the 
//                    right hand side of the region is reached.  Wrap mode will
//                    continue to plot values until the maximum size is reached.
//                    The maximum size is based on the rate of data from the 
//                    host and the constant nMINUTES_OF_DATA.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : General::CPlotWidget, General::CPlotData, 
//                    Core::CXMLWidget, Comms::CCommsAction, 
//                    Core::CVariant, _FSI_STL::string, CString, 
//                    Core::CWidget, Core::CChangeValue, and
//                    General::COpenGLWidget.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: TimePlotWidget.h $                                                                   
// Revision 1.3  2000/03/07 20:47:22  billyb                                                                   
// Changed function signatures to eliminate warnings.                                                                   
// Revision 1.2  2000/02/01 19:59:05  billyb                                                                   
// New file with comments, independent grid toggling, drawing of                                                                   
// inspection values, the host name, the data rate, and current                                                                   
// y values, and support for 10 minutes of data.                                                                   
/////////////////////////////////////////////////////////////////////////////
#if !defined(_TIMEPLOTWIDGET_H_)
#define _TIMEPLOTWIDGET_H_

#include "PlotWidget.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

enum
{
    STOP_MODE,
    ERASE_MODE,
    WRAP_MODE
};

class CTimePlotWidget : public CPlotWidget
{
private:
    unsigned char                       m_ucPlotMode;
    unsigned char                       m_ucPlotMode_cv;

    float                               m_fSecondsPerDivision;
    float                               m_fSecondsPerDivision_cv;

    float                               m_fCurrentMaxDatapointTime;


    virtual void            UpdatePlotData(const _FSI_STL::string& rstlStrVariable, CVariant* pVariant);
    virtual void            DrawXLabels();
    virtual void            DrawYLabels(const _FSI_STL::string& rstlStrVarName);
    virtual void            DrawInspection();

protected:

    virtual void    InitReinit();


public:
	CTimePlotWidget();
    virtual void Render();

// Attributes
public:
   	enum { IDB = IDB_TIME_PLOT_WIDGET };

// Operations
public:
    static CWidget* CreateObject();
    virtual void    Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                               const long int lId, bool bEditMode);

    virtual void    ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);
    virtual bool    UpdateRenderVariables();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTimePlotWidget)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CTimePlotWidget();

	// Generated message map functions
protected:
	//{{AFX_MSG(CTimePlotWidget)
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

#endif // !defined(_TIMEPLOTWIDGET_H_)
