/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : TimeofDayAction.cpp
//
// Date             : 17 August 2000
//
// Engineer         : Michael F Lawson
//
// Revision         : $Revision: 1.00 $
//
// Description      : Attach this action to a text widget, to display the
//                    current Windows time of day.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : 
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 4
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: TimeofDayAction.cpp $
// Revision 1.1  1999/04/02 19:41:28  billyb
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "..\general\ComboWidget.h"
#include "TimeofDayAction.h"

#include "..\core\DataConversion.h"

#include <algorithm>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


/////////////////////////////////////////////////////////////////////////////
//
// CTimeofDayAction::CTimeofDayAction
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  Sets the name of the widget.
//                    Adds the CTimeofDayActionPage to the list of widget
//                    property pages.
/////////////////////////////////////////////////////////////////////////////
CTimeofDayAction::CTimeofDayAction()
{
    m_stlStrWidgetName = _FSI_STL::string("Time_of_Day_Action");
}

/////////////////////////////////////////////////////////////////////////////
//
// CWidget* CTimeofDayAction::CreateObject()
//
// Inputs           : None.
//
// Return Values    : Address of a new instance of CTimeofDayAction.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CreateObject() is a common framework method that must be
//                    implemented by each CWidget derived class.  The main
//                    application associates the name of this widget with this
//                    static CreateObject method so that a new object can be
//                    created without linking against the library that contains
//                    this class.
//
/////////////////////////////////////////////////////////////////////////////
CWidget* CTimeofDayAction::CreateObject()
{
    return new CTimeofDayAction();
}


/////////////////////////////////////////////////////////////////////////////
//
// void CTimeofDayAction::OnUpdate()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : OnUpdate() is a common framework method for CAction
//                    derived classes.  Its purpose is to send a new value
//                    to its parent graphical widget.  OnUpdate should 
//                    generally be called by some other class than the parent 
//                    graphical element.
//
/////////////////////////////////////////////////////////////////////////////
void CTimeofDayAction::OnUpdate()
{
   time_t now;
   time(&now);

   // No point doing painting at 30 Hz if the time hasn't changed
   if ((long)now == m_lLastPassTime)
      return;

   m_lLastPassTime = now;
   
   m_sync.Lock();

   if (m_bDeleting == true)
   {
      m_sync.Unlock();
      return;
   }

   // Make sure there is a Variant will a value to send to the parent
   // graphical widget.
   if (m_pVariant == NULL)
   {
      m_sync.Unlock();
      return;
   }

   // Make sure this instance is attached to a graphical element.
   if (CWidget::IsValidAddress(m_pParentWidget) != VALID )
   {
      m_sync.Unlock();
      return;
   }


   // Depending on the read_mode--read always, read changed, read never, 
   // or read_once-- update the parent graphical widget.  Also, if a read
   // has not been performed once and the read_mode is not read never, then
   // go ahead and get an initial value. 
   if ( /* (  (m_bReadOnce      == true  && m_bRead  == false)   || 
            (m_bReadChanged   == true  && m_pVariant->WasChanged(m_lElement)  == true) || 
            (m_bReadAlways    == true) || (m_bInitialRead   == true))   && 
         (m_bReadOnce   == true  || m_bReadChanged == true  || m_bReadAlways  == true)*/ true)
   {
      CString strElementVar   = CString(m_stlStrElementVar.c_str());
      CVariant variant        = (*m_pVariant)[m_lElement];

    // Get the current time.
    struct tm* sTime;


    sTime=localtime(&now);

    char cTimeFormat[32];
    strftime(cTimeFormat, 32, "%d %b %Y %H:%M:%S", sTime);
    cTimeFormat[31] = '\0';

	variant.Value(cTimeFormat, VAR_STRING, sizeof cTimeFormat);
  
      // Send the new value to the parent graphical widget.
      // m_bUseRange will tell the parent whether to use the m_pVariant
      // value of the data for colors and text.
      m_ChangeValue.Variant(&variant);
      m_ChangeValue.UseRange(false);

      m_pParentWidget->ChangeValue(strElementVar, &m_ChangeValue);

      CWnd* pWnd = m_pParentWidget->FrameworkParent();

      if (pWnd != NULL && m_pCommsSystemInterface != NULL)
      {
         (m_pCommsSystemInterface->m_mapWidgetsToRefresh[pWnd->GetSafeHwnd()])[m_pParentWidget] = true;
      }

      // If this is a read once initializer, then mark as being read.
      if (m_bReadOnce == true)
      {
         m_bRead = true;
      }

      m_bInitialRead = false;
   }

   m_sync.Unlock();
}
