/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : TextWidget.h
//
// Date             : 30 August 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.9 $
//
// Description      : TextWidget.h contains the definition of the 
//                    CTextWidget class.  This class is used to display 
//                    textual data which may be static as entered by 
//                    the creator of the page or a static max/min value 
//                    for a variable that has range data.  Alignment 
//                    and justification of the text is allowed as is 
//                    font selection and fore and background colors.  
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : _FSI_STL::string, General::CButtonWidget, CFont.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: TextWidget.h $                                                                   
// Revision 1.9  2000/05/05 16:56:40  billyb                                                                   
// Added InitReinit for object reuse.  Changed shadow offset                                                                   
// from string to unsigned char.  Added member varibles for                                                                    
// foreground and background colors to prevent extra lookups.                                                                   
// Revision 1.8  2000/03/07 20:45:56  billyb                                                                   
// Changed function signatures to eliminate warnings.                                                                   
// Revision 1.7  2000/02/03 07:29:37  billyb                                                                   
// Added boolean for telling if the font was reset so that font                                                                   
// changes in the editor would redraw correctly.                                                                   
// Revision 1.6  2000/01/21 10:22:45  billyb                                                                   
// Moved bitmap and DC pointers to CButtonWidget.                                                                   
// Revision 1.5  1999/11/10 07:51:10  billyb                                                                   
// Added a pointer for a CBitmap and for a CDC for offscreen                                                                   
// drawing.                                                                   
// Revision 1.4  1999/10/22 01:46:06  billyb                                                                   
// Corrected problem with editor not reparsing when the                                                                   
// size changes.                                                                   
// Revision 1.3  1999/10/21 01:24:59  billyb                                                                   
// Changed signature of DrawText.  Added TextFormat to allow                                                                   
// other classes to reset the text formatting if either or both of                                                                   
// the alignment variables change.  Added data structures so                                                                   
// that the same text would not have to be reparsed.                                                                   
// Revision 1.2  1999/08/30 22:09:05  billyb                                                                   
// Added comments.  Removed precision member variables.                                                                   
/////////////////////////////////////////////////////////////////////////////
#if !defined(_TEXTWIDGET_H_)
#define _TEXTWIDGET_H_

#include "ButtonWidget.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class GENERALAPI CTextWidget : public CButtonWidget
{
protected:
    long int                    m_lAlign;
    long int                    m_lVAlign;
    long int                    m_lPixelsPerInch;
    int                         m_nTextMinMax;
    int                         m_nFormat;

    bool                        m_bFontChanged;
    unsigned char               m_ucShadowOffset;
    CRect                       m_rectLastDraw;
    CFont                       m_font;
    CString                     m_strValue;
    CColor                      m_clrFore;
    CColor                      m_clrBack;
    _FSI_STL::string            m_stlStrValue;
    _FSI_STL::string            m_stlStrValue_cv;
    _FSI_STL::string            m_stlStrFont;
    _FSI_STL::string            m_stlStrSize;
    _FSI_STL::string            m_stlStrStyle;
    _FSI_STL::vector<CString>   m_vectTextLines;
    _FSI_STL::vector<CString>   m_vectBrokenLines;

    virtual void InitReinit();

// Construction
public:
	CTextWidget();

// Attributes
public:
   	enum { IDB = IDB_TEXT_WIDGET };

// Operations
protected:
   void DrawText(CDC*& pDC, CString& strText, CRect& rect);

public:
   virtual void Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                            const long int lId, bool bEditMode);
   virtual void ResetProperties();
   static CWidget* CreateObject();
   virtual void ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);
	virtual CVariant * GetValue(const CString &rstrValue);
   virtual void Scale(CExtentsPoint& rextPt, bool bPageLoadScale);
   virtual bool UpdateRenderVariables();
   void TextFormat();

   void DrawMultilineText(CDC*& pDC, CRect& rect, CString &strValue);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTextWidget)
	public:
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CTextWidget();

	// Generated message map functions
protected:
	//{{AFX_MSG(CTextWidget)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnWindowPosChanged(WINDOWPOS FAR* lpwndpos);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(_TEXTWIDGET_H_)
