/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : TextWidget.cpp
//
// Date             : 30 August 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.15 $
//
// Description      : TextWidget.cpp contains the implementation of the 
//                    CTextWidget class.  This class is used to display 
//                    textual data which may be static as entered by 
//                    the creator of the page or a static max/min value 
//                    for a variable that has range data.  Alignment 
//                    and justification of the text is allowed as is 
//                    font selection and fore and background colors.  
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : _FSI_STL::string, General::CButtonWidget, CFont.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: TextWidget.cpp $                                                                   
// Revision 1.15  2000/05/05 16:59:16  billyb                                                                   
// Removed help text.  Changed shadow offset from string to                                                                   
// unsigned char.  Added InitReinit for object reuse.  Prevented                                                                   
// creation of offscreen bitmaps each time a draw is needed.                                                                     
// Optimized drawing for nonchanging text.  Fixed possible crash                                                                   
// from memcpy of LOGFONT lfFaceName.                                                                   
// Revision 1.14  2000/03/07 20:46:03  billyb                                                                   
// Changed function signatures to eliminate warnings.                                                                   
// Removed unused variables.                                                                   
// Revision 1.13  2000/02/03 07:29:26  billyb                                                                   
// Added boolean for telling if the font was reset so that font                                                                   
// changes in the editor would redraw correctly.                                                                   
// Revision 1.12  2000/01/21 10:22:44  billyb                                                                   
// Moved bitmap and DC pointers to CButtonWidget.                                                                   
// Revision 1.11  1999/12/08 17:50:43  billyb                                                                   
// Added CS_OWNDC.                                                                   
// Revision 1.10  1999/11/10 07:52:26  billyb                                                                   
// Changed FillRect to FillSolidRect or PatBlt.  Changed                                                                   
// BEGIN_MESSAGE_MAP to have CButtonWidget as base.                                                                   
// Removed unneeded message map entries.  Optimized loops.                                                                   
// Added WS_CLIPCHILDREN.  Added offscreen drawing with                                                                   
// bliting to onscreen.                                                                   
// Revision 1.9  1999/10/22 04:39:25  billyb                                                                   
// Changed previous fix.                                                                   
// Revision 1.8  1999/10/22 01:46:05  billyb                                                                   
// Corrected problem with editor not reparsing when the                                                                   
// size changes.                                                                   
// Revision 1.7  1999/10/21 22:00:50  billyb                                                                   
// Fixed problem where action for only enable/disable would                                                                   
// cause blank to be displayed.                                                                   
// Revision 1.6  1999/10/21 01:25:41  billyb                                                                   
// Changed signature of DrawText.  Added TextFormat to allow                                                                   
// other classes to reset the text formatting if either or both of                                                                   
// the alignment variables change.  Optimized drawing for                                                                    
// non-changing text and blank text.                                                                   
// Revision 1.5  1999/10/20 18:44:00  billyb                                                                   
// Changed range data display to use new map of variable                                                                   
// name to range data.  If text is displaying the high or low,                                                                   
// it is assumed that it will be for the default variable.                                                                   
// Revision 1.4  1999/10/14 19:46:43  billyb                                                                   
// Fixed parsing error of global font data.  Added check of                                                                   
// m_bEnabled when drawing text and made the text look like                                                                   
// Windows disabled text.                                                                   
// Revision 1.3  1999/09/08 04:21:36  billyb                                                                   
// Changed the way brushes and pens are created in                                                                   
// DrawItem.  This was done to fix a crash caused by                                                                    
// calling DeleteObject in the COMMS thread which                                                                    
// is not where the brush was created.  Also, changed                                                                   
// the use of range colors.                                                                   
// Revision 1.2  1999/08/30 22:10:21  billyb                                                                   
// Added comments.  Removed code for changing the precision of the output.                                                                   
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "TextWidget.h"

#include "..\core\ValuePage.h"
#include "..\core\FontPage.h"
#include "PushButtonWidget.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTextWidget

CTextWidget::CTextWidget()
{
    m_stlStrWidgetName  = _FSI_STL::string("Text");

    m_listWidgetPropPages.push_back(CValuePage::CreateObject);
    m_listWidgetPropPages.push_back(CFontPage::CreateObject);

    CTextWidget::InitReinit();
}

void CTextWidget::InitReinit()
{
    m_lAlign            = 1;
    m_lVAlign           = 1;

    m_nTextMinMax       = 0;

    LOGFONT logfont;	
    CWindowDC dc(GetDesktopWindow() );

	m_lPixelsPerInch = GetDeviceCaps(dc, LOGPIXELSY);	
	CFont *pfont = dc.GetCurrentFont();		
    pfont->GetLogFont( &logfont );
    
    m_font.DeleteObject();	
    m_font.CreateFontIndirect( &logfont );
    m_stlStrFont = _FSI_STL::string(logfont.lfFaceName);

    CString strNumber;
    strNumber.Format( "%d", MulDiv(logfont.lfHeight, 72, m_lPixelsPerInch) );

    m_stlStrSize        = _FSI_STL::string((LPCTSTR)strNumber);
    m_stlStrStyle       = _FSI_STL::string(_T("Regular"));	
    m_ucShadowOffset    = 0;	

    if( logfont.lfWeight >= 700 && logfont.lfItalic)
    {
        m_stlStrStyle   = _FSI_STL::string(_T("Bold Italic"));	
    }
    else if( logfont.lfItalic )
    {
        m_stlStrStyle   = _FSI_STL::string(_T("Italic"));	
    }
    else if ( logfont.lfWeight >= 700 )
    {
        m_stlStrStyle   = _FSI_STL::string(_T("Bold"));
    }

    m_stlStrValue       = _FSI_STL::string("Blank");
    m_stlStrValue_cv    = m_stlStrValue;
    m_stlStrGlobalFont  = _FSI_STL::string("Not Used");

    m_strValue          = "";
    m_bFontChanged      = false;

    m_vectBrokenLines.clear();
    m_vectTextLines.clear();
}

CTextWidget::~CTextWidget()
{
    m_font.DeleteObject();
}


BEGIN_MESSAGE_MAP(CTextWidget, CButtonWidget)
	//{{AFX_MSG_MAP(CTextWidget)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_WINDOWPOSCHANGED()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTextWidget message handlers
void CTextWidget::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                               const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    CTextWidget::InitReinit();

    if (rpXMLWidget != NULL)
    {
        ResetProperties();
    }

    if (GetSafeHwnd() == NULL)
    {
        Create(m_stlStrValue.c_str(),
               WS_CHILD | WS_VISIBLE | BS_OWNERDRAW | CS_OWNDC, 
                 CRect(m_exPtUpperLeft, m_exPtLowerRight),
                (CWnd*)pWnd, lId);

    }
    else
    {
        SetParent(pWnd);
        MoveWindow(m_exPtUpperLeft.X(), m_exPtUpperLeft.Y(),
                   m_exPtLowerRight.X() - m_exPtUpperLeft.X(),
                   m_exPtLowerRight.Y() - m_exPtUpperLeft.Y(), FALSE);
        ShowWindow(SW_NORMAL);
    }

    CDC* pDCur = GetDC();
    if (m_pDC->GetSafeHdc() != NULL)
    {
        m_pDC->DeleteDC();
    }
    m_pDC->CreateCompatibleDC(pDCur);

    if (m_pBMP->GetSafeHandle() != NULL)
    {
        m_pBMP->DeleteObject();
    }
    m_pBMP->CreateCompatibleBitmap(pDCur, m_exPtLowerRight.X() - m_exPtUpperLeft.X(),
                                    m_exPtLowerRight.Y() - m_exPtUpperLeft.Y());
    ReleaseDC(pDCur);

    m_pDC->SelectObject(m_pBMP);
    m_pDC->SetBkMode(TRANSPARENT);
    m_pDC->SelectObject(&m_font);

    m_pWnd = this;
    m_mapValidAddresses[this] = m_pWnd->GetSafeHwnd();
}

CWidget* CTextWidget::CreateObject()
{
    return new CTextWidget;
}

void CTextWidget::OnLButtonDown(UINT nFlags, CPoint point) 
{
    if (m_bEditing == true)
    {
        CButtonWidget::OnLButtonDown(nFlags, point);    
    }
    else
    {
        CButtonWidget::OnLButtonDown(nFlags, point);

        NMHDR nmhdr;
        nmhdr.idFrom = GetDlgCtrlID();
        nmhdr.hwndFrom = GetSafeHwnd();
        nmhdr.code = WM_LBUTTONDOWN;
        GetParent()->SendMessage(WM_NOTIFY,GetDlgCtrlID(),(long)&nmhdr);
    }
}

void CTextWidget::OnLButtonUp(UINT nFlags, CPoint point) 
{
    if (m_bEditing == true)
    {
    }
    else
    {
        CButtonWidget::OnLButtonUp(nFlags, point);

        CButton::OnLButtonUp(nFlags, point);
        NMHDR nmhdr;
        nmhdr.idFrom = GetDlgCtrlID();
        nmhdr.hwndFrom = GetSafeHwnd();
        nmhdr.code = WM_LBUTTONUP;
        GetParent()->SendMessage(WM_NOTIFY,GetDlgCtrlID(),(long)&nmhdr);
    }
}

void CTextWidget::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
   CRect rect(&(lpDrawItemStruct->rcItem));

   CString  strValue;
   switch (m_nTextMinMax)
   {
      case 0:
         strValue.Format("%s",m_stlStrValue.c_str());
         break;

      case 1:
         strValue.Format("%s",((_FSI_STL::string)m_mapRangeData["Default"].s_varLow).c_str());
         break;

      case 2:
         strValue.Format("%s",((_FSI_STL::string)m_mapRangeData["Default"].s_varHigh).c_str());
         break;

      default:
         strValue.Format("%s",m_stlStrValue.c_str());
         break;
   }

   rect.InflateRect(-m_ucShadowOffset,-m_ucShadowOffset);

   if (true == m_bRepaint           || 
       true == m_bTraverseUpdate    ||
       m_strValue       != strValue || 
       m_rectLastDraw   != rect     || 
       m_bFontChanged   == true)
   {
      CDC *pDCur  = CDC::FromHandle(lpDrawItemStruct->hDC);
      CDC* pDC    = m_pDC;

      long int lSavedDC = pDC->SaveDC();

      // fill the extents rectangle with the color for the background
      pDC->SetBkColor(m_clrBack);

      rect.InflateRect(m_ucShadowOffset, m_ucShadowOffset);
      ::ExtTextOut(pDC->GetSafeHdc(), 0, 0, ETO_OPAQUE, (LPRECT)rect, NULL, 0, NULL);
      rect.InflateRect(-m_ucShadowOffset,-m_ucShadowOffset);

      DrawMultilineText(pDC, rect, strValue);

      rect.InflateRect(m_ucShadowOffset,m_ucShadowOffset);
      pDCur->BitBlt(rect.left, rect.top, rect.Width(), rect.Height(), pDC, rect.left, rect.top, SRCCOPY);
      pDC->RestoreDC(lSavedDC);

      // Move and invalidate the children for the different states.
      if (m_bLButtonDown != m_bLButtonDownLastPass)
      {
         m_bLButtonDownLastPass = m_bLButtonDown;

         if (m_bTraverseUpdate == false)
            TraverseBaseWidgets((CWidget*)this, true);
      }
      else
      {
         if (m_bTraverseUpdate == false)
            TraverseBaseWidgets((CWidget*)this, false);
      }

      m_bTraverseUpdate = false;
   }
}

void CTextWidget::ResetProperties()
{
    CButtonWidget::ResetProperties();

    m_clrBack = Background();
    m_clrFore = Foreground();

    CString strValue;
    CXMLElement* pXMLElement = NULL;
    POSITION pos = NULL;
    STRING2STRING_MAP::iterator s2sIt;

    if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("VALUE")) == true)
    {
        m_stlStrValue = pXMLElement->ElementValue();
        CString strToReplace = m_stlStrValue.c_str();
//        strToReplace.Replace("&nbsp;"," ");
        m_stlStrValue = _FSI_STL::string((LPCTSTR)strToReplace);
        m_stlStrValue_cv = m_stlStrValue;
        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("ALIGN")) == true)
        {
            m_lAlign = atoi((*s2sIt).second.c_str());
        }
        else
        {
            strValue.Format("%d",m_lAlign);
            pXMLElement->AddAttribute(_FSI_STL::string("ALIGN"),
                                      _FSI_STL::string((LPCTSTR)strValue));
        }

        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("VALIGN")) == true)
        {
            m_lVAlign = atoi((*s2sIt).second.c_str());
        }
        else
        {
            strValue.Format("%d",m_lVAlign);
            pXMLElement->AddAttribute(_FSI_STL::string("VALIGN"),
                                      _FSI_STL::string((LPCTSTR)strValue));
        }

        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("STYLE")) == true)
        {
            m_nTextMinMax = atoi((*s2sIt).second.c_str());
        }
        else
        {
            strValue.Format("%d",m_nTextMinMax);
            pXMLElement->AddAttribute(_FSI_STL::string("STYLE"),
                                      _FSI_STL::string((LPCTSTR)strValue));
        }
    }
    else
    {
        m_pXMLWidget->AddElement(_FSI_STL::string("VALUE"), m_stlStrValue,
                                 NULL);
        pXMLElement = NULL;
        if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("VALUE")) == true)
        {
            strValue.Format("%d",m_lAlign);
            pXMLElement->AddAttribute(_FSI_STL::string("ALIGN"),
                                      _FSI_STL::string((LPCTSTR)strValue));
            strValue.Format("%d",m_lVAlign);
            pXMLElement->AddAttribute(_FSI_STL::string("VALIGN"),
                                      _FSI_STL::string((LPCTSTR)strValue));

            strValue = "0";
            pXMLElement->AddAttribute(_FSI_STL::string("STYLE"),
                                      _FSI_STL::string((LPCTSTR)strValue));
        }
    }

    CString strOffset   = "";
    pXMLElement         = NULL;
    if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("FONT")) == true)
    {
        m_stlStrFont = pXMLElement->ElementValue();

        CString strFontName = "";
        CString strSize     = "";
        CString strStyle    = "";

        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("GLOBALFONT")) == true)
        {
            m_stlStrGlobalFont = (*s2sIt).second;
            if (m_mapGlobalFonts.find(m_stlStrGlobalFont) != m_mapGlobalFonts.end())
            {
                CString strFont(m_mapGlobalFonts[m_stlStrGlobalFont].c_str());
                if (strFont.Find(",") > -1)
                {
                    strFontName = strFont.Left(strFont.Find(","));
                    m_stlStrFont = _FSI_STL::string((LPCTSTR)strFontName);

                    strSize = strFont.Mid(strFont.Find(",") + 1);
                    if (strSize.Find(",") > -1)
                    {
                        strStyle = strSize.Left(strSize.Find(","));
                        strSize = strSize.Mid(strSize.Find(",") + 1);
                        if (strSize.Find(",") > 0)
                        {
                            strOffset = strSize.Mid(strSize.Find(",") + 1);
                            strSize = strSize.Left(strSize.Find(","));
                        }
                        else
                        {
                            strOffset = "0";
                        }
                    }
                    else
                    {
                        strStyle = strSize;
                        strSize = "8";
                        strOffset = "0";
                    }
                }
            }
        }
        else
        {
            pXMLElement->AddAttribute(_FSI_STL::string("GLOBALFONT"),
                                      _FSI_STL::string("Not Used"));
            m_stlStrGlobalFont = "Not Used";
        }

        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SIZE")) == true)
        {
            m_stlStrSize = (*s2sIt).second;

            if (m_stlStrGlobalFont != "Not Used" && strSize != "")
            {
                m_stlStrSize = _FSI_STL::string((LPCTSTR)strSize);
            }
        }
        else
        {
            pXMLElement->AddAttribute(_FSI_STL::string("SIZE"), m_stlStrSize);
        }

        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("STYLE")) == true)
        {
            m_stlStrStyle = (*s2sIt).second;

            if (m_stlStrGlobalFont != "Not Used" && strStyle != "")
            {
                m_stlStrStyle = _FSI_STL::string((LPCTSTR)strStyle);
            }
        }
        else
        {
            pXMLElement->AddAttribute(_FSI_STL::string("STYLE"),m_stlStrStyle);
        }

        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SHADOW_OFFSET")) == true)
        {
            m_ucShadowOffset = atoi((*s2sIt).second.c_str());

            if (m_stlStrGlobalFont != "Not Used" && strOffset != "")
            {
                m_ucShadowOffset = atoi(strOffset);
            }
        }
        else
        {
            strOffset.Format("%d", m_ucShadowOffset);
            pXMLElement->AddAttribute(_FSI_STL::string("SHADOW_OFFSET"),
                                        _FSI_STL::string((LPCTSTR)strOffset));
        }

        m_bFontChanged = true;
        LOGFONT logfont;
	    m_font.GetLogFont( &logfont );	
        logfont.lfStrikeOut = false;
	    logfont.lfUnderline = false;
        int nFaceLength = __min(LF_FACESIZE - 1, m_stlStrFont.size());
	    strncpy( logfont.lfFaceName, m_stlStrFont.c_str(), nFaceLength );
        logfont.lfFaceName[nFaceLength] = '\0';

	    logfont.lfHeight = -MulDiv(atoi(m_stlStrSize.c_str()), 
                                  m_lPixelsPerInch, 72);	 
    	logfont.lfWidth = 0;			
	    logfont.lfWeight = 400;			
        //Regular	
        logfont.lfItalic = FALSE;
	    if( strstr(m_stlStrStyle.c_str(), _T("Italic")) != NULL )		
        {
            logfont.lfItalic = TRUE;
        }

	    if( strstr(m_stlStrStyle.c_str(), _T("Bold") ) != NULL )		
        {
            logfont.lfWeight = 700;
        }

	    m_font.DeleteObject();	
        m_font.CreateFontIndirect( &logfont );
        if (m_pDC->GetSafeHdc() != NULL)
            m_pDC->SelectObject(&m_font);
    }
    else
    {
        strOffset.Format("%d", m_ucShadowOffset);
        m_pXMLWidget->AddElement(_FSI_STL::string("FONT"), m_stlStrFont,
                                 NULL);
        pXMLElement = NULL;
        if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("FONT")) == true)
        {
            pXMLElement->AddAttribute(_FSI_STL::string("SIZE"),m_stlStrSize);
            pXMLElement->AddAttribute(_FSI_STL::string("STYLE"),m_stlStrStyle);
            pXMLElement->AddAttribute(_FSI_STL::string("SHADOW_OFFSET"),
                                      _FSI_STL::string((LPCSTR)strOffset));
            pXMLElement->AddAttribute(_FSI_STL::string("GLOBALFONT"),
                                      _FSI_STL::string("Not Used"));
        }
    }

    TextFormat();
}

void CTextWidget::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
    if (pCV == NULL)
    {
        return;
    }

    if (rstrElementVar == "Default")
    {
        if (pCV->UseRange() == true)
        {
            m_stlStrValue_cv = pCV->Text();
            m_mapColorSelectables["FOREGROUND"].s_color_cv = pCV->Foreground();
            m_mapColorSelectables["BACKGROUND"].s_color_cv = pCV->Background();
        }
        else
        {
            m_stlStrValue_cv = (_FSI_STL::string)*(pCV->Variant());
        }
    }
    else
    {
        CWidget::ChangeValue(rstrElementVar, pCV);
    }
}

CVariant* CTextWidget::GetValue(const CString &rstrValue)
{
    m_variant.Value(m_stlStrValue);
    return &m_variant;
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CTextWidget::DrawText()
//
// Inputs           : CDC*& pDC - CDC to draw text to
//                    CString& strText - text to draw
//                    CRect& rect - bounding rectangle
//
// Return Values    : None.
//
// Date             : 06 January 1999
//
// Engineer         : Billy Baker
//
// Description      : CTextWidget::DrawText is a helper method that is 
//                    used to draw text with a drop shadow if the 
//                    offset is greater than zero.  Because of the 
//                    addition of top, bottom, and vertical centering 
//                    code in CTextWidget::DrawItem, the code in 
//                    CTextWidget::DrawText was duplicated a number of 
//                    times.  Thus, the code was moved to its own method.
//                    
//
/////////////////////////////////////////////////////////////////////////////
void CTextWidget::DrawText(CDC*& pDC, CString& strText, CRect& rect)
{
   CRect rectShadow = rect;

   rectShadow.left     += m_ucShadowOffset;
   rectShadow.right    += m_ucShadowOffset;
   rectShadow.top      += m_ucShadowOffset;
   rectShadow.bottom   += m_ucShadowOffset;

   if (m_bEnabled == true)
   {
      if (m_ucShadowOffset > 0)
      {
         pDC->SetTextColor(RGB(0,0,0));
         pDC->DrawText(strText, strText.GetLength(), rectShadow, m_nFormat);
      }

      pDC->SetTextColor(m_clrFore);
      pDC->DrawText(strText, strText.GetLength(), rect, m_nFormat);
   }
   else 
   {
      if (m_ucShadowOffset > 0)
      {
         pDC->SetTextColor(m_clrBack.HighlightColor());
         pDC->DrawText(strText, strText.GetLength(), rectShadow, m_nFormat);
      }

      pDC->SetTextColor(m_clrBack.DarkColor());
      pDC->DrawText(strText, strText.GetLength(), rect, m_nFormat);
   }
}

void CTextWidget::Scale(CExtentsPoint& rextPt, bool bPageLoadScale)
{
    CWidget::Scale(rextPt, bPageLoadScale);

    if (m_pWnd == NULL)
    {
        return;
    }

    if (m_pWnd->GetSafeHwnd() == NULL)
    {
        return;
    }

    if (bPageLoadScale == true)
    {
        // page was loaded and a scaling may be needed if the 
        // extents of the page is different from the current
        // monitor resolution.
        long int lYOldRes = rextPt.Y();
        long int lYNewRes = GetSystemMetrics(SM_CYSCREEN);
        if (m_pBaseWidget != NULL)
        {
            if (m_pBaseWidget->Wnd() != NULL)
            {
                CRect rectView;
                CFrameWnd* pWnd = GetParentFrame(); //m_pBaseWidget->Wnd()->GetParentFrame();
                CView* pView = pWnd->GetActiveView();
                pView->GetWindowRect(&rectView);

                lYNewRes = rectView.Height();
            }
        }

        if (lYNewRes == lYOldRes)
        {
            return;
        }

        long int lFontSize = atoi(m_stlStrSize.c_str());
        lFontSize = lFontSize * lYNewRes / lYOldRes;
        CString strValue;
        strValue.Format("%d",lFontSize);
        m_stlStrSize = _FSI_STL::string((LPCTSTR)strValue);

        m_ucShadowOffset = m_ucShadowOffset * lYNewRes / lYOldRes;;

        if (m_pXMLWidget != NULL)
        {
            CXMLElement* pXMLElement = NULL;
            POSITION pos = NULL;
            if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("FONT")) == true)
            {
                STRING2STRING_MAP::iterator s2sIt;
                CString strValue;
                if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SIZE")) == true)
                {
                    (*s2sIt).second = m_stlStrSize;
                }

                if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SHADOW_OFFSET")) == 
                                                                              true)
                {
                    CString strOffset;
                    strOffset.Format("%d", m_ucShadowOffset);
                    (*s2sIt).second = _FSI_STL::string((LPCTSTR)strOffset);
                }
            }
        }
    }
    else
    {
    }

    m_bFontChanged = true;
    LOGFONT logfont;
	m_font.GetLogFont( &logfont );	
    logfont.lfStrikeOut = false;
	logfont.lfUnderline = false;
    int nFaceLength = __min(LF_FACESIZE - 1, m_stlStrFont.size());
	strncpy( logfont.lfFaceName, m_stlStrFont.c_str(), nFaceLength );
    logfont.lfFaceName[nFaceLength] = '\0';

	logfont.lfHeight = -MulDiv(atoi(m_stlStrSize.c_str()), 
                              m_lPixelsPerInch, 72);	 
    logfont.lfWidth = 0;			
	logfont.lfWeight = 400;			
    //Regular	
    logfont.lfItalic = FALSE;
	if( strstr(m_stlStrStyle.c_str(), _T("Italic")) != NULL )		
    {
        logfont.lfItalic = TRUE;
    }

	if( strstr(m_stlStrStyle.c_str(), _T("Bold") ) != NULL )		
    {
        logfont.lfWeight = 700;
    }

	m_font.DeleteObject();	
    m_font.CreateFontIndirect( &logfont );
    if (m_pDC->GetSafeHdc() != NULL)
        m_pDC->SelectObject(&m_font);
}

bool CTextWidget::UpdateRenderVariables()
{
    if (m_clrFore != Foreground() ||
        m_clrBack != Background())
    {
        m_bRepaint  = true;
        m_clrBack   = Background();
        m_clrFore   = Foreground();
    }

    m_stlStrValue = m_stlStrValue_cv;

    bool bRetVal =  CWidget::UpdateRenderVariables();

    if (m_clrFore != Foreground() ||
        m_clrBack != Background())
    {
        m_bRepaint  = true;
        m_clrBack   = Background();
        m_clrFore   = Foreground();
    }

    return bRetVal;
}

void CTextWidget::TextFormat()
{
    m_nFormat = DT_WORDBREAK;
    switch (m_lAlign)
    {
    case 0:
        m_nFormat |= DT_LEFT;
        break;
    case 1:
        m_nFormat |= DT_CENTER;
        break;
    case 2:
        m_nFormat |= DT_RIGHT;
        break;
    default:
        m_nFormat |= DT_CENTER;
        break;
    };

    switch (m_lVAlign)
    {
    case 0:
        m_nFormat |= DT_TOP;
        break;
    case 1:
        m_nFormat |= DT_VCENTER;
        break;
    case 2:
        m_nFormat |= DT_BOTTOM;
        break;
    default:
        m_nFormat |= DT_VCENTER;
        break;
    };
}

void CTextWidget::OnWindowPosChanged(WINDOWPOS FAR* lpwndpos) 
{
	CButtonWidget::OnWindowPosChanged(lpwndpos);

    if (m_pBMP)
    {
        m_pBMP->DeleteObject();
        CDC* pDCur = GetDC();
        m_pBMP->CreateCompatibleBitmap(pDCur, m_exPtLowerRight.X() - m_exPtUpperLeft.X(),
                                       m_exPtLowerRight.Y() - m_exPtUpperLeft.Y());
        ReleaseDC(pDCur);

        if (m_pDC->GetSafeHdc() != NULL)
            m_pDC->SelectObject(m_pBMP);
    }
}


void  CTextWidget::DrawMultilineText(CDC*& pDC, CRect& rect, CString &strValue)
{
   pDC->SelectObject(&m_font);

   long  int   lRowCol  =  0;
   CSize       sizeText;
   m_bRepaint  =  false;

   if (m_strValue != strValue || m_rectLastDraw != rect  || m_bFontChanged == true)
   {
      m_bFontChanged =  false;
      m_strValue     =  strValue;
      m_rectLastDraw =  rect;
      m_vectTextLines.clear();
      m_vectBrokenLines.clear();

      long  int   lNewline =  strValue.Find("\\n");
      while (lNewline   >  -1)
      {
         strValue.SetAt(lNewline,'\n');
         strValue =  strValue.Left(lNewline+1) + strValue.Mid(lNewline+2);
         lNewline =  strValue.Find("\\n");
      }

      // Find all single character \n and put each substring created by the \n into the vector of broken strings.
      lNewline = strValue.Find("\n");
      if (lNewline > -1)
      {
         while (lNewline > -1)
         {
            m_vectBrokenLines.push_back(strValue.Left(lNewline));
            strValue =  strValue.Mid(lNewline + 1);
            lNewline =  strValue.Find("\n");
            if (lNewline   == -1)
               m_vectBrokenLines.push_back(strValue);
         }
      }
      else
      {
         m_vectBrokenLines.push_back(strValue);
      }

      // For each broken string, make sure that it will fit in the width of the window.  If it can't, further break it down.
      bool        bDone;
      int         nBrokenSize = m_vectBrokenLines.size();
      int         nWidth      = rect.Width();
      long  int   lBrokenLine = 0;
      long  int   lSpace;
      CSize       sizeSubText;
      CString     strSubTextEnd;
      CString     strSubTextBegin;

      while (lBrokenLine   <  nBrokenSize)
      {
         sizeText          =  pDC->GetOutputTextExtent(m_vectBrokenLines[lBrokenLine]);
         strSubTextBegin   =  m_vectBrokenLines[lBrokenLine];
         bDone             =  false;

         // Run through the string of text and break into substrings at a space.
         // The substrings should fit the extents rectangle if possible.
         while (sizeText.cx   >  nWidth   && bDone == false)
         {
            sizeSubText    =  sizeText;
            lSpace         =  -1;
            strSubTextEnd  =  "";
            while (sizeSubText.cx   >  nWidth   && bDone == false)
            {
               lSpace   =  strSubTextBegin.ReverseFind(' ');
               if (lSpace  >  -1)
               {
                  if (strSubTextEnd != "")   // First substring
                     strSubTextEnd  =  strSubTextBegin.Mid(lSpace+1) +  " "   +  strSubTextEnd;
                  else                       // beyond the first substring
                     strSubTextEnd  =  strSubTextBegin.Mid(lSpace+1);
                  strSubTextBegin   =  strSubTextBegin.Left(lSpace);
                  sizeSubText       =  pDC->GetOutputTextExtent(strSubTextBegin);
               }
               else  // no break
                  bDone =  true;
            }

            // Add the substring and continue
            m_vectTextLines.push_back(strSubTextBegin);
            strSubTextBegin = strSubTextEnd;
            sizeText = pDC->GetOutputTextExtent(strSubTextBegin);
            lRowCol++;
         }

         if (bDone == false)
         {
            // all of the substrings were found and the last is still in strSubTextBegin.
            m_vectTextLines.push_back(strSubTextBegin);
            lRowCol++;
         }
         lBrokenLine++;
      }
   }

   if (m_strValue != "")
   {
      // Based on the vertical alignment, draw the strings.
      if (m_lVAlign == 0)           // Align top.
      {
         CRect rectBounds                          =  rect;
         _FSI_STL::vector<CString>::iterator lIt   =  m_vectTextLines.begin();
         _FSI_STL::vector<CString>::iterator endIt =  m_vectTextLines.end();

         while (lIt != endIt)
         {
            sizeText          =  pDC->GetOutputTextExtent(*lIt);
            rectBounds.bottom =  rectBounds.top + sizeText.cy;
            DrawText(pDC,  *lIt, rectBounds);
            rectBounds.top    =  rectBounds.bottom;
            lIt++;
         }
      }
      else if (m_lVAlign   == 1)    // Align vertical center
      {
         lRowCol           =  0;
         int   nTextLines  =  m_vectTextLines.size();

         if ((nTextLines & 0x01) != 0)    // odd number of lines
         {
            long  int   lMiddleLine =  nTextLines  /  2;
            CRect       rectCenter  =  rect;

            sizeText          =  pDC->GetOutputTextExtent(m_vectTextLines[lMiddleLine]);
            rectCenter.top    =  rect.top       +  rect.Height()/2   -  sizeText.cy/2;
            rectCenter.bottom =  rectCenter.top +  sizeText.cy;
            CRect rectBounds  =  rectCenter;

            // Draw center line and up
            while ((lMiddleLine  -  lRowCol) >  -1)
            {
               DrawText(pDC, m_vectTextLines[lMiddleLine - lRowCol], rectBounds);
               lRowCol++;
               if ((lMiddleLine - lRowCol) > -1)
               {
                  sizeText          =  pDC->GetOutputTextExtent(m_vectTextLines[lMiddleLine -   lRowCol]);
                  rectBounds.bottom =  rectBounds.top;
                  rectBounds.top    =  rectBounds.bottom - sizeText.cy;
               }
            }

            lRowCol     =  1;
            rectBounds  =  rectCenter;

            // Draw line below center and down--for a single line of text, the
            // above code should be executed but not the code below.
            if ((lMiddleLine + 1)   <  nTextLines)
            {
               sizeText          =  pDC->GetOutputTextExtent(m_vectTextLines[lMiddleLine  +  1]);
               rectBounds.top    = rectCenter.bottom;
               rectBounds.bottom = rectBounds.top  +  sizeText.cy;
               while ((lMiddleLine + lRowCol) < nTextLines)
               {
                  DrawText(pDC, m_vectTextLines[lMiddleLine + lRowCol], rectBounds);
                  lRowCol++;
                  if ((lMiddleLine + lRowCol) < nTextLines)
                  {
                     sizeText          =  pDC->GetOutputTextExtent(m_vectTextLines[lMiddleLine  +  lRowCol]);
                     rectBounds.top    =  rectBounds.bottom;
                     rectBounds.bottom =  rectBounds.top +  sizeText.cy;
                  }
               }
            }
         }
         else                             // even number of lines
         {
            long  int   lMiddleLineUpper  =  (nTextLines -  1) /  2;
            long  int   lMiddleLineLower  =  nTextLines  /  2;
            CRect rectCenterUpper   =  rect; 
            CRect rectCenterLower   =  rect; 
            CSize sizeTextUpper     =  pDC->GetOutputTextExtent(m_vectTextLines[lMiddleLineUpper]);
            CSize sizeTextLower     =  pDC->GetOutputTextExtent(m_vectTextLines[lMiddleLineLower]);
            rectCenterUpper.top     =  rect.top +  rect.Height()/2   -  sizeTextUpper.cy;
            rectCenterUpper.bottom  =  rectCenterUpper.top  +  sizeTextUpper.cy;
            rectCenterLower.top     =  rectCenterUpper.bottom;
            rectCenterLower.bottom  =  rectCenterLower.top  +  sizeTextLower.cy;
            CRect rectBounds        =  rectCenterUpper;

            // Draw upper center line and up
            while ((lMiddleLineUpper - lRowCol) > -1)
            {
               DrawText(pDC, m_vectTextLines[lMiddleLineUpper - lRowCol], rectBounds);
               lRowCol++;
               if ((lMiddleLineUpper - lRowCol) > -1)
               {
                  sizeTextUpper     =  pDC->GetOutputTextExtent(m_vectTextLines[lMiddleLineUpper   -  lRowCol]);
                  rectBounds.bottom =  rectBounds.top;
                  rectBounds.top    =  rectBounds.bottom -  sizeTextUpper.cy;
               }
            }

            lRowCol     =  0;
            rectBounds  =  rectCenterLower;

            // Draw lower center line and down
            while ((lMiddleLineLower + lRowCol) < nTextLines)
            {
               DrawText(pDC, m_vectTextLines[lMiddleLineLower + lRowCol], rectBounds);
               lRowCol++;
               if ((lMiddleLineLower + lRowCol) < nTextLines)
               {
                  sizeTextLower     =  pDC->GetOutputTextExtent(m_vectTextLines[lMiddleLineLower   +  lRowCol]);
                  rectBounds.top    =  rectBounds.bottom;
                  rectBounds.bottom =  rectBounds.top + sizeTextLower.cy;
               }
            }
         }
      }
      else if (m_lVAlign   == 2) // align bottom
      {
         CRect rectBounds                                      =  rect;
         _FSI_STL::vector<CString>::reverse_iterator  lIt      =  m_vectTextLines.rbegin();
         _FSI_STL::vector<CString>::reverse_iterator  rendIt   =  m_vectTextLines.rend();

         while (lIt != rendIt)
         {
            sizeText          =  pDC->GetOutputTextExtent(*lIt);
            rectBounds.top    =  rectBounds.bottom -  sizeText.cy;
            DrawText(pDC,  *lIt, rectBounds);
            rectBounds.bottom =  rectBounds.top;
            lIt++;
         }
      }
   }
}
