// StartSortieEditAppAction.cpp: implementation of the CStartSortieEditAppAction class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "StartSortieEditAppAction.h"
#include "..\comms\CommsShared.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CStartSortieEditAppAction::CStartSortieEditAppAction()
{
   m_stlStrWidgetName   =  _FSI_STL::string("Start_Sortie_Edit_Application");
}

CStartSortieEditAppAction::~CStartSortieEditAppAction()
{
}

void CStartSortieEditAppAction::Initialize(CXMLWidget* &rpXMLWidget, CWnd* pWnd, const long lId, bool bEditMode)
{
   CWidget::Initialize(rpXMLWidget, pWnd, lId,  bEditMode);

   if (rpXMLWidget   != NULL)
   {
      ResetProperties();
   }

   m_pAction   =  this;
   m_pWidget   =  (CWidget*)this;
}

CWidget  *CStartSortieEditAppAction::CreateObject()
{
   return   new   CStartSortieEditAppAction();
}

enum LButtonUpReturn CStartSortieEditAppAction::OnLButtonUp()
{

   CWnd  *pWndPrev; 
   pWndPrev = CWnd::FindWindow(NULL, "IOS - Sortie Load Page");

   if (pWndPrev)
   {
	   AfxMessageBox( _T("Please close the Load Sortie window first"), MB_OK | MB_ICONINFORMATION );
	  return LBU_OK;
   }

   CString  strPageInfo(m_strComponent + "^" +  m_strSubComponent +  "^"   +  m_strPage);

   ExpandPath(strPageInfo);

   CVariant var;
   CCommsShared::GetLocalValue(var, _FSI_STL::string("selected_sortie_base"));
   long  old_type =  var.Type();
   var.Value(_FSI_STL::string(""));
   var.ChangeType(old_type);
   CCommsShared::SetLocalValue(var, _FSI_STL::string("selected_sortie_base"), 0);

   CCommsShared::GetLocalValue(var, _FSI_STL::string("selected_sortie_lesson"));
   old_type =  var.Type();
   var.Value(_FSI_STL::string(""));
   var.ChangeType(old_type);
   CCommsShared::SetLocalValue(var, _FSI_STL::string("selected_sortie_lesson"), 0);

   CCommsShared::GetLocalValue(var, _FSI_STL::string("selected_sortie_base"));
   CString  base(((_FSI_STL::string)var).c_str());

   CCommsShared::GetLocalValue(var, _FSI_STL::string("selected_sortie_lesson"));
   CString  lesson(((_FSI_STL::string)var).c_str());

   CString  options;
   options.Format("/Base %s /Lesson %s", base, lesson);

   ShellExecute(NULL,   "open",  strPageInfo,   LPCTSTR(options), NULL, SW_SHOWNORMAL);

   return LBU_OK;
}
