/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : SliderWidget.h
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.4 $
//
// Description      : SliderWidget.h contains the definition of 
//                    the CSliderWidget class.  This class is used to 
//                    draw a slider that looks similar to the common 
//                    Windows slider control.  The biggest change is 
//                    that the slider will resize as the size of the 
//                    graphical element changes.  Tics are available.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CWidget, _FSI_STL::string, _FSI_STL::list, 
//                    Core::CVariant, CString, Core::CExtentsPoint.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: SliderWidget.h $                                                                   
// Revision 1.4  2000/03/07 20:47:32  billyb                                                                   
// Changed function signatures to eliminate warnings.                                                                   
// Revision 1.3  1999/10/04 17:00:49  billyb                                                                   
// Fixed problems with OnMouseMove and OnMouseLeave                                                                   
// where the pointer may have been moved to a bogus position                                                                   
// if it was not dragged.  Also added support for doing nothing                                                                   
// when the widget is disabled.                                                                   
// Revision 1.2  1999/10/04 03:22:44  billyb                                                                   
// Added comments.  Removed usage of m_variant_cv.                                                                   
/////////////////////////////////////////////////////////////////////////////
#if !defined(_SLIDERWIDGET_H_)
#define _SLIDERWIDGET_H_

#include "ButtonWidget.h"

#include "resource.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CSliderWidget : public CButtonWidget
{
// Construction
public:
	CSliderWidget();

// Attributes
private:
    long int            m_lOptions;

    CVariant            m_varSliding;
    CVariant            m_varSliding_cv;

    CVariant            m_varLastPosition;

    CRect               m_rectPointer;
    CRect               m_rectChannel;

    unsigned char       m_ucNumberOfTics;

    bool                m_bShowTics;
    bool                m_bDarkTics;

public:
    enum { IDB = IDB_SLIDER_WIDGET };

// Operations
protected:
    void DrawHorizontalSlider(CDC* pDC, CRect& rect);
    void DrawVerticalSlider(CDC* pDC, CRect& rect);
    virtual void InitReinit();

public:
    static CWidget* CreateObject();
    virtual void Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                            const long int lId, bool bEditMode);
    virtual void ResetProperties();

	virtual CVariant * GetValue(const CString &rstrValue);

    virtual void ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);
    virtual bool UpdateRenderVariables();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSliderWidget)
	public:
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CSliderWidget();

	// Generated message map functions
protected:
	//{{AFX_MSG(CSliderWidget)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	//}}AFX_MSG
    afx_msg long OnMouseLeave(WPARAM wParam, LPARAM lParam);

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(_SLIDERWIDGET_H_)
