// SliderPage.cpp: implementation of the CSliderPage class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "SliderPage.h"

#include "..\core\widget.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSliderPage::CSliderPage() : CBasePage(CSliderPage::IDD)
{
	//{{AFX_DATA_INIT(CSliderPage)
    m_lPointer = 0;
    m_lSliderOrientation = 1;
	m_ucNumberOfTics = 0;
	m_bShowTics = FALSE;
	m_bDarkTics = FALSE;
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Slider");
}

CSliderPage::~CSliderPage()
{
}

void CSliderPage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSliderPage)
	DDX_Radio(pDX, IDC_POINTER_BOTH, m_lPointer);
	DDX_Radio(pDX, IDC_SLIDER_VERTICAL, m_lSliderOrientation);
	DDX_Text(pDX, IDC_NUMBER_OF_TICS, m_ucNumberOfTics);
	DDV_MinMaxByte(pDX, m_ucNumberOfTics, 2, 128);
	DDX_Check(pDX, IDC_USE_TIC_MARKS, m_bShowTics);
	DDX_Check(pDX, IDC_DARK_TICS, m_bDarkTics);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSliderPage, CBasePage)
	//{{AFX_MSG_MAP(CSliderPage)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//
// CBasePage* CSliderPage::CreateObject()
//
// Inputs           : None.
//
// Return Values    : A pointer to a new instance of the CSliderPage class.
//
// Date             : 12 January 1999
//
// Engineer         : Billy Baker
//
// Description      : CreateObject is a static member method that 
//                    creates a new instance of the CSliderPage.  
//                    Every class derived from CBasePage must 
//                    implmement CreateObject as each Widget contains a 
//                    list of pointers to the CreateObject methods that 
//                    correspond to the property pages needed for that Widget.
//
/////////////////////////////////////////////////////////////////////////////
CBasePage* CSliderPage::CreateObject()
{
    return new CSliderPage;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CSliderPage::SetProperties()
//
// Inputs           : void* pWidget - a pointer to be cast to a CWidget*
//
// Return Values    : None.
//
// Date             : 12 January 1999
//
// Engineer         : Billy Baker
//
// Description      : CSliderPage::SetProperties is the standard 
//                    interface for initializing the dialog controls 
//                    with data from the CXMLWidget instance that is 
//                    associated with the CWidget instance that is 
//                    passed to the method.  Every ...::SetProperties 
//                    method does has a similar implmemenation--find 
//                    each element that is used in the property page 
//                    and for each find their attributes if there are 
//                    any.  Note: UpdateData is not called here since 
//                    SetProperties is called before Create.
//
/////////////////////////////////////////////////////////////////////////////
void CSliderPage::SetProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL)
    {
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("OPTIONS")) == true)
        {
            long int lOptions = atoi(pXMLElement->ElementValue().c_str());

            // Is it vertical?
            if ((lOptions & VERTICAL) != 0)
            {
                m_lSliderOrientation = 0;
            }
            else
            {
                m_lSliderOrientation = 1;
            }

            // Do we show the OK button?
            if ((lOptions & BOTH) != 0)
            {
                m_lPointer = 0;
            }
            else if((lOptions & LEFT_UP) != 0)
            {
                m_lPointer = 1;
            }
            else
            {
                m_lPointer = 2;
            }

            STRING2STRING_MAP::iterator s2sIt = NULL;
            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SHOW_TICS")) == true)
            {
                CString strValue((*s2sIt).second.c_str());
                strValue.MakeUpper();
                if (strValue == "YES")
                {
                    m_bShowTics = TRUE;
                }
                else
                {
                    m_bShowTics = FALSE;
                }
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SIZE")) == true)
            {
                m_ucNumberOfTics = atoi((*s2sIt).second.c_str());
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("DARK_TICS")) == true)
            {
                CString strValue((*s2sIt).second.c_str());
                strValue.MakeUpper();
                if (strValue == "YES")
                {
                    m_bDarkTics = TRUE;
                }
                else
                {
                    m_bDarkTics = FALSE;
                }
            }
        }
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CSliderPage::UpdateProperties()
//
// Inputs           : void* pWidget - a void pointer to be case to a CWidget*
//
// Return Values    : None.
//
// Date             : 12 January 1999
//
// Engineer         : Billy Baker
//
// Description      : CSliderPage::UpdateProperties is another 
//                    standard interface method for dealing with 
//                    property pages derived from CBasePage.  When the 
//                    data from the property page needs to be applied, 
//                    the UpdateProperties method is called.  The 
//                    implementatin is similar in every CBasePage 
//                    derived class--find the elements in the 
//                    CXMLWidget that is associated with the CWidget 
//                    that is passed and update each element and any 
//                    associated attributes.
//
/////////////////////////////////////////////////////////////////////////////
void CSliderPage::UpdateProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL && GetSafeHwnd() != NULL)
    {
        UpdateData(TRUE);
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("OPTIONS")) == true)
        {
            CString strOptions;
            long int lOptions = 0;

            if (m_lSliderOrientation == 0)
            {
                lOptions |= VERTICAL;
            }
            else
            {
                lOptions |= HORIZONTAL;
            }

            if (m_lPointer == 0)
            {
                lOptions |= BOTH;
            }
            else if (m_lPointer == 1)
            {
                lOptions |= LEFT_UP;
            }
            else
            {
                lOptions |= RIGHT_DOWN;
            }
            strOptions.Format("%d",lOptions);
            pXMLElement->AddElementValue(_FSI_STL::string((LPCTSTR)strOptions));

            STRING2STRING_MAP::iterator s2sIt = NULL;

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SIZE")) == true)
            {
                CString strValue;
                strValue.Format("%d",m_ucNumberOfTics);
                (*s2sIt).second = _FSI_STL::string((LPCTSTR)strValue);
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SHOW_TICS")) == true)
            {
                if (m_bShowTics == TRUE)
                {
                    (*s2sIt).second = _FSI_STL::string("YES");
                }
                else
                {
                    (*s2sIt).second = _FSI_STL::string("NO");
                }
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("DARK_TICS")) == true)
            {
                if (m_bDarkTics == TRUE)
                {
                    (*s2sIt).second = _FSI_STL::string("YES");
                }
                else
                {
                    (*s2sIt).second = _FSI_STL::string("NO");
                }
            }
        }
    }
}
