// RectButtonWidget.cpp : implementation file
//

#include "..\core\stdafx.h"
#include "RectButtonWidget.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRectButtonWidget

CRectButtonWidget::CRectButtonWidget()
{
    m_stlStrWidgetName = _FSI_STL::string("Button");
}

CRectButtonWidget::~CRectButtonWidget()
{
}


BEGIN_MESSAGE_MAP(CRectButtonWidget, CButtonWidget)
	//{{AFX_MSG_MAP(CRectButtonWidget)
	ON_WM_LBUTTONUP()
	ON_WM_LBUTTONDOWN()
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
    ON_MESSAGE(WM_MOUSELEAVE, OnMouseLeave)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRectButtonWidget message handlers
void CRectButtonWidget::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                               const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    if (rpXMLWidget != NULL)
    {
        ResetProperties();
    }

    if (GetSafeHwnd() == NULL)
    {
        CRect rect(m_exPtUpperLeft, m_exPtLowerRight);
        Create("", WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN | BS_OWNERDRAW | 
                   CS_OWNDC, 
                   rect, (CWnd*)pWnd, lId);
    }
    else
    {
        SetParent(pWnd);
        MoveWindow(m_exPtUpperLeft.X(), m_exPtUpperLeft.Y(),
                   m_exPtLowerRight.X() - m_exPtUpperLeft.X(),
                   m_exPtLowerRight.Y() - m_exPtUpperLeft.Y(), FALSE);
        ShowWindow(SW_NORMAL);
    }

    CDC* pDCur = GetDC();
    if (m_pDC->GetSafeHdc() != NULL)
    {
        m_pDC->DeleteDC();
    }
    m_pDC->CreateCompatibleDC(pDCur);

    if (m_pBMP->GetSafeHandle() != NULL)
    {
        m_pBMP->DeleteObject();
    }
    m_pBMP->CreateCompatibleBitmap(pDCur, m_exPtLowerRight.X() - m_exPtUpperLeft.X(),
                                    m_exPtLowerRight.Y() - m_exPtUpperLeft.Y());
    ReleaseDC(pDCur);

    m_pDC->SelectObject(m_pBMP);
    m_pDC->SetBkMode(TRANSPARENT);
    m_pDC->SelectObject(&m_font);

    m_pWnd = this;
    m_mapValidAddresses[this] = m_pWnd->GetSafeHwnd();
}

CWidget* CRectButtonWidget::CreateObject()
{
    return new CRectButtonWidget();
}

void CRectButtonWidget::OnLButtonUp(UINT nFlags, CPoint point) 
{
    
	// TODO: Add your message handler code here and/or call default
    if (m_bEditing == true)
    {
    }
    else
    {
        m_bRedraw = false;

        CButtonWidget::OnLButtonUp(nFlags, point);

        if (m_bRedraw == true)
        {
            Invalidate(FALSE);
        }
    }
}

void CRectButtonWidget::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
    if (m_bEditing == true)
    {
        CButtonWidget::OnLButtonDown(nFlags, point);
    }
    else
    {
        m_bRedraw = false;

        CButtonWidget::OnLButtonDown(nFlags, point);

        if (m_bRedraw == true)
        {
            Invalidate(FALSE);
        }
    }
}

BOOL CRectButtonWidget::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult) 
{
	// TODO: Add your specialized code here and/or call the base class
    NMHDR* pHdr = (NMHDR*)lParam;
    CWnd* pWnd = FromHandle(pHdr->hwndFrom);
    if (IsChild(pWnd))
    {
        switch(pHdr->code)
        {
        case WM_LBUTTONDBLCLK:
        case WM_LBUTTONDOWN:
            {
                CRect rect;
                GetClientRect(rect);
                OnLButtonDown(MK_LBUTTON,rect.TopLeft());

                return TRUE;
            }

        case WM_LBUTTONUP:
            {

                // If the button was down when the LButtonUp message
                // was sent to a child, then call OnLButtonUp here with a 
                // point on the boundary of the button.
                CRect rect;
                GetClientRect(rect);
                OnLButtonUp(0,rect.TopLeft());
                return TRUE;
            }
        };
    }
	
	return CButtonWidget::OnNotify(wParam, lParam, pResult);
}

void CRectButtonWidget::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
    m_bRedraw = false;
    CRect rect;
    GetClientRect(rect);

    if (rect.PtInRect(point) == TRUE)
    {
        CButtonWidget::OnMouseMove(nFlags, point);
    }
    else
    {
        if (m_bFocus != false || m_bLButtonDown != false)
        {
            m_bFocus = false;
            m_bLButtonDown = false;
            m_bRedraw = true;
        }
    }

    if (m_bRedraw == true)
    {
        Invalidate(FALSE);
    }
}

long CRectButtonWidget::OnMouseLeave(WPARAM wParam, LPARAM lParam)
{
    CPoint ptCursor;
    GetCursorPos(&ptCursor);
    ScreenToClient(&ptCursor);
    CRect rect(m_exPtUpperLeft, m_exPtLowerRight);

    if (rect.PtInRect(ptCursor) != TRUE)
    {
        CButtonWidget::OnMouseLeave(wParam, lParam);
    }
    else
    {
        TRACKMOUSEEVENT tme;  

        tme.cbSize      = sizeof(TRACKMOUSEEVENT); 
        tme.dwFlags     = TME_LEAVE; 
        tme.hwndTrack   = GetSafeHwnd();  
        TrackMouseEvent(&tme); 
    }

    return 0;
}

void CRectButtonWidget::ResetProperties()
{
   CTextWidget::ResetProperties();
}

void CRectButtonWidget::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
   CRect rect(&(lpDrawItemStruct->rcItem));

   CDC   *pDCur   =  CDC::FromHandle(lpDrawItemStruct->hDC);
   CDC   *pDC     =  m_pDC;
   long  int   lSavedDC =  pDC->SaveDC();

   // Fill the entire button with the button brush
   CColor   colorBackground   =  Background();
   pDC->FillSolidRect(rect, (COLORREF)colorBackground);

   // Draw the button down.
   if (m_bLButtonDown == true)
   {
      CPen penD(PS_SOLID, 1, RGB(0,0,0));
      pDC->SelectObject(&penD);
	   pDC->MoveTo(rect.right-1,rect.top);
	   pDC->LineTo(rect.left,rect.top);
	   pDC->LineTo(rect.left,rect.bottom-1);

      CPen penS(PS_SOLID, 1, colorBackground.DarkColor());
      pDC->SelectObject(&penS);
      pDC->MoveTo(rect.right - 1,rect.top + 1);
      pDC->LineTo(rect.left  + 1,rect.top + 1);
      pDC->LineTo(rect.left  + 1,rect.bottom-1);

      CPen penW(PS_SOLID, 1, colorBackground.HighlightColor());
      pDC->SelectObject(&penW);
	   pDC->MoveTo(rect.left,rect.bottom-1);
	   pDC->LineTo(rect.right-1,rect.bottom-1);
	   pDC->LineTo(rect.right-1,rect.top-1);

      CPen penH(PS_SOLID, 1, RGB(colorBackground.Red(), colorBackground.Green(), colorBackground.Blue()));
      pDC->SelectObject(&penH);
      pDC->MoveTo(rect.left+2,rect.bottom-2);
      pDC->LineTo(rect.right-2,rect.bottom-2);
      pDC->LineTo(rect.right-2,rect.top+1);

      CString  strValue(m_stlStrValue.c_str());
      rect.left   += 2;
      rect.top    += 2;
      DrawMultilineText(pDC, rect, strValue);
      rect.left   -= 2;
      rect.top    -= 2;
   }
   else
   {
      CPen penW(PS_SOLID, 1, colorBackground.HighlightColor());
      pDC->SelectObject(&penW);
      pDC->MoveTo(rect.right-2,rect.top);
      pDC->LineTo(rect.left,rect.top);
      pDC->LineTo(rect.left,rect.bottom-1);

      CPen penD(PS_SOLID, 1, RGB(0,0,0));
      pDC->SelectObject(&penD);
      pDC->MoveTo(rect.left,rect.bottom-1);
      pDC->LineTo(rect.right-1,rect.bottom-1);
      pDC->LineTo(rect.right-1,rect.top-1);

      CPen penS(PS_SOLID, 1, colorBackground.DarkColor());
      pDC->SelectObject(&penS);
      pDC->MoveTo(rect.left+1,rect.bottom-2);
      pDC->LineTo(rect.right-2,rect.bottom-2);
      pDC->LineTo(rect.right-2,rect.top);

      CString  strValue(m_stlStrValue.c_str());
      DrawMultilineText(pDC, rect, strValue);
   }

   pDCur->BitBlt(rect.left, rect.top, rect.Width(), rect.Height(), pDC, rect.left, rect.top, SRCCOPY);
   pDC->RestoreDC(lSavedDC);

   // Move and invalidate the children for the different states.
   if (m_bLButtonDown   != m_bLButtonDownLastPass)
   {
      m_bLButtonDownLastPass = m_bLButtonDown;

      // Make sure that only the base widget updates all of the children.
      if (m_bTraverseUpdate == false)
         TraverseBaseWidgets((CWidget*)this, true);
   }
   else
   {
      if (m_bTraverseUpdate == false)
         TraverseBaseWidgets((CWidget*)this, false);
   }

   m_bTraverseUpdate = false;
}
