/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : RadioWidget.h
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.3 $
//
// Description      : RadioWidget.h contains the definition of 
//                    the CRadioWidget class.  This class draws a radio 
//                    button that the user can turn on.  To turn off, 
//                    the user must select another radio widget in the gr
//                    oup.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CWidget, _FSI_STL::string, _FSI_STL::list, 
//                    Core::CVariant, General::CButtonWidget.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: RadioWidget.h $                                                                   
// Revision 1.3  2000/01/10 18:46:26  billyb                                                                   
// Changed widget to owner draw.  and made it derive from                                                                   
// CCheckBoxWidget.                                                                   
// Revision 1.2  1999/10/04 03:35:16  billyb                                                                   
// Added comments.  Removed usage of m_variant_cv.                                                                   
#if !defined(_RADIOWIDGET_H_)
#define _RADIOWIDGET_H_

#include "CheckboxWidget.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// Put 1 pixel between left edge of widget and left edge of
// ellipse for check.  Also, put 5 pixels between right edge of
// ellipse and the text.
static const unsigned int unLeftSideBorder  =  1;
static const unsigned int unRightSideBorder =  5;

// By inspection, normal circular part of radio button is 12 by 12.
static const unsigned int unRadioCircleSize = 12;

class CRadioWidget : public CCheckBoxWidget
{
// Construction
public:
	CRadioWidget();

// Attributes
protected:
    unsigned int        m_unCircleArray[unRadioCircleSize][unRadioCircleSize];
    unsigned int        m_unCircleArrayChecked[unRadioCircleSize][unRadioCircleSize];
    CBitmap             m_bmpCircle;
    CBitmap             m_bmpCircleChecked;

public:
  	enum { IDB = IDB_RADIO_WIDGET };

// Operations
public:
    static CWidget*     CreateObject();
    virtual void        Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                   const long int lId, bool bEditMode);
    virtual void        ResetProperties();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CRadioWidget)
	public:
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CRadioWidget();

	// Generated message map functions
protected:
	//{{AFX_MSG(CRadioWidget)
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(_RADIOWIDGET_H_)
