/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : RadioWidget.cpp
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.6 $
//
// Description      : RadioWidget.cpp contains the implementation of 
//                    the CRadioWidget class.  This class draws a radio 
//                    button that the user can turn on.  To turn off, 
//                    the user must select another radio widget in the gr
//                    oup.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CWidget, _FSI_STL::string, _FSI_STL::list, 
//                    Core::CVariant, General::CButtonWidget.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: RadioWidget.cpp $                                                                   
// Revision 1.6  2000/01/10 18:46:22  billyb                                                                   
// Changed widget to owner draw.  and made it derive from                                                                   
// CCheckBoxWidget.                                                                   
// Revision 1.5  1999/12/08 17:49:17  billyb                                                                   
// Added CS_OWNDC.                                                                   
// Revision 1.4  1999/11/09 21:45:54  billyb                                                                   
// Changed BEGIN_MESSAGE_MAP to have CButtonWidget                                                                   
// as base.  Removed unneeded message map entries.  Added                                                                   
// WS_CLIPCHILDREN.                                                                   
// Revision 1.3  1999/10/05 00:54:23  billyb                                                                   
// Removed SetFont and SetWindowText calls in Initialize and                                                                   
// ResetProperties.                                                                   
// Revision 1.2  1999/10/04 03:35:15  billyb                                                                   
// Added comments.  Removed usage of m_variant_cv.                                                                   
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "RadioWidget.h"

#include "RadioPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
//
// CRadioWidget::CRadioWidget()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  Set the name of the widget which
//                    is used in the XML data and under the icons in the 
//                    editor.  Initialize other member variables.
//
/////////////////////////////////////////////////////////////////////////////
CRadioWidget::CRadioWidget()
{
    m_stlStrWidgetName  = _FSI_STL::string("Radio_Button");

    memset(m_unCircleArray, 255, sizeof(m_unCircleArray));
    memset(m_unCircleArrayChecked, 255, sizeof(m_unCircleArrayChecked));
}

/////////////////////////////////////////////////////////////////////////////
//
// CRadioWidget::~CRadioWidget()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.
//
/////////////////////////////////////////////////////////////////////////////
CRadioWidget::~CRadioWidget()
{
    if (m_bmpCircle.operator HGDIOBJ())
    {
        m_bmpCircle.DeleteObject();
    }

    if (m_bmpCircleChecked.operator HGDIOBJ())
    {
        m_bmpCircleChecked.DeleteObject();
    }
}


BEGIN_MESSAGE_MAP(CRadioWidget, CButtonWidget)
	//{{AFX_MSG_MAP(CRadioWidget)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
  	ON_WM_WINDOWPOSCHANGED()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//
// CWidget* CRadioWidget::CreateObject()
//
// Inputs           : None.
//
// Return Values    : A pointer to a new instance of CRadioWidget.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CRadioWidget::CreateObject() is a common 
//                    framework method used to create a new instance of 
//                    CRadioWidget.  It is a static member.  The 
//                    address of this method is stored in a map of 
//                    widget name to CreateObject address in the 
//                    component interface for the DLL that contains the 
//                    CRadioWidget.  Using this data structure, a 
//                    new instance of CRadioWidget can be created 
//                    when one is encountered in the XML page 
//                    description file.
//
/////////////////////////////////////////////////////////////////////////////
CWidget* CRadioWidget::CreateObject()
{
    return new CRadioWidget();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CRadioWidget::Initialize()
//
// Inputs           : CXMLWidget*& rpXMLWidget - reference to a pointer 
//                                               that holds the data to 
//                                               create a CRadioWidget.
//                    CWnd* pWnd               - the parent CWnd object.
//                    const long lId           - identifier.
//                    bool bEditMode           - whether editing is taking 
//                                               place.
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CRadioWidget::Initialize() is a common 
//                    framework method.  It is called after an instance 
//                    of CRadioWidget has been created.  It is 
//                    responsible for initializing most of the internal 
//                    data members with data from the XMLWidget.  This 
//                    is done using the call to ResetProperties.  If 
//                    the XMLWidget pointer is NULL, a new XMLWidget 
//                    instance is created with default settings.  
//                    Generic help text is set here and any CWnd 
//                    derived Create() calls are made to create the 
//                    Windows object that allows for the use of the MFC 
//                    messages.  The HWND for the CWnd derived object 
//                    that is created is then added to a map in CWidget 
//                    that keeps track of what CWidget derived pointers 
//                    are valid.  This is to make sure that all of the 
//                    threads do not try to dereference bad pointers.
//
/////////////////////////////////////////////////////////////////////////////
void CRadioWidget::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                               const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    if (rpXMLWidget != NULL)
    {
        ResetProperties();
    }

    if (GetSafeHwnd() == NULL)
    {
        Create(m_stlStrValue.c_str(),
               WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN | BS_OWNERDRAW | CS_OWNDC, 
               CRect(m_exPtUpperLeft, m_exPtLowerRight),
               (CWnd*)pWnd, lId);
    }
    else
    {
        SetParent(pWnd);
        MoveWindow(m_exPtUpperLeft.X(), m_exPtUpperLeft.Y(),
                   m_exPtLowerRight.X() - m_exPtUpperLeft.X(),
                   m_exPtLowerRight.Y() - m_exPtUpperLeft.Y(), FALSE);
        ShowWindow(SW_NORMAL);
    }

    CDC* pDCur = GetDC();
    if (m_pDC->GetSafeHdc() != NULL)
    {
        m_pDC->DeleteDC();
    }
    m_pDC->CreateCompatibleDC(pDCur);

    if (m_pBMP->GetSafeHandle() != NULL)
    {
        m_pBMP->DeleteObject();
    }
    m_pBMP->CreateCompatibleBitmap(pDCur, m_exPtLowerRight.X() - m_exPtUpperLeft.X(),
                                    m_exPtLowerRight.Y() - m_exPtUpperLeft.Y());
    ReleaseDC(pDCur);

    m_pDC->SelectObject(m_pBMP);
    m_pDC->SetBkMode(TRANSPARENT);
    m_pDC->SelectObject(&m_font);

    m_pWnd = this;

    // For use with CWidget::IsValidAddress().
    m_mapValidAddresses[this] = m_pWnd->GetSafeHwnd();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CRadioWidget::ResetProperties()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 10 January 2000
//
// Engineer         : Billy Baker
//
// Description      : CRadioWidget::ResetProperties will call its 
//                    parent's ResetProperties method.  Afterwards, it
//                    will reset the colors in the circle bitmaps to match
//                    the background color and its associated dark and 
//                    highlight colors.
//
/////////////////////////////////////////////////////////////////////////////
void CRadioWidget::ResetProperties()
{
    CCheckBoxWidget::ResetProperties();

    // Change colors of m_unCircleArray and m_unCircleArrayChecked.
    // To use the CreateBitmap call, the colors must be in
    // ARGB order.
    unsigned char ucRed     = m_clrBack.DarkColor().Red();
    unsigned char ucGreen   = m_clrBack.DarkColor().Green();
    unsigned char ucBlue    = m_clrBack.DarkColor().Blue();
    int clrDark    = ucRed << 16 | ucGreen << 8 | ucBlue;

    ucRed     = m_clrBack.HighlightColor().Red();
    ucGreen   = m_clrBack.HighlightColor().Green();
    ucBlue    = m_clrBack.HighlightColor().Blue();
    int clrLight   = ucRed << 16 | ucGreen << 8 | ucBlue;

    ucRed     = m_clrBack.Red();
    ucGreen   = m_clrBack.Green();
    ucBlue    = m_clrBack.Blue();
    int clrBack    = ucRed << 16 | ucGreen << 8 | ucBlue;

    m_unCircleArray[0][0]    = clrBack;
    m_unCircleArray[0][1]    = clrBack;
    m_unCircleArray[0][2]    = clrBack;
    m_unCircleArray[0][3]    = clrBack;
    m_unCircleArray[0][4]    = clrDark;
    m_unCircleArray[0][5]    = clrDark;
    m_unCircleArray[0][6]    = clrDark;
    m_unCircleArray[0][7]    = clrDark;
    m_unCircleArray[0][8]    = clrBack;
    m_unCircleArray[0][9]    = clrBack;
    m_unCircleArray[0][10]   = clrBack;
    m_unCircleArray[0][11]   = clrBack;

    m_unCircleArray[1][0]    = clrBack;
    m_unCircleArray[1][1]    = clrBack;
    m_unCircleArray[1][2]    = clrDark;
    m_unCircleArray[1][3]    = clrDark;
    m_unCircleArray[1][4]    = 0;
    m_unCircleArray[1][5]    = 0;
    m_unCircleArray[1][6]    = 0;
    m_unCircleArray[1][7]    = 0;
    m_unCircleArray[1][8]    = clrDark;
    m_unCircleArray[1][9]    = clrDark;
    m_unCircleArray[1][10]   = clrBack;
    m_unCircleArray[1][11]   = clrBack;

    m_unCircleArray[2][0]    = clrBack;
    m_unCircleArray[2][1]    = clrDark;
    m_unCircleArray[2][2]    = 0;
    m_unCircleArray[2][3]    = 0;
    m_unCircleArray[2][8]    = 0;
    m_unCircleArray[2][9]    = 0;
    m_unCircleArray[2][10]   = clrLight;
    m_unCircleArray[2][11]   = clrBack;

    m_unCircleArray[3][0]    = clrBack;
    m_unCircleArray[3][1]    = clrDark;
    m_unCircleArray[3][2]    = 0;
    m_unCircleArray[3][9]    = clrBack;
    m_unCircleArray[3][10]   = clrLight;
    m_unCircleArray[3][11]   = clrBack;

    m_unCircleArray[4][0]    = clrDark;
    m_unCircleArray[4][1]    = 0;
    m_unCircleArray[4][10]   = clrBack;
    m_unCircleArray[4][11]   = clrLight;

    m_unCircleArray[5][0]    = clrDark;
    m_unCircleArray[5][1]    = 0;
    m_unCircleArray[5][10]   = clrBack;
    m_unCircleArray[5][11]   = clrLight;

    m_unCircleArray[6][0]    = clrDark;
    m_unCircleArray[6][1]    = 0;
    m_unCircleArray[6][10]   = clrBack;
    m_unCircleArray[6][11]   = clrLight;

    m_unCircleArray[7][0]    = clrDark;
    m_unCircleArray[7][1]    = 0;
    m_unCircleArray[7][10]   = clrBack;
    m_unCircleArray[7][11]   = clrLight;

    m_unCircleArray[8][0]    = clrBack;
    m_unCircleArray[8][1]    = clrDark;
    m_unCircleArray[8][2]    = 0;
    m_unCircleArray[8][9]    = clrBack;
    m_unCircleArray[8][10]   = clrLight;
    m_unCircleArray[8][11]   = clrBack;

    m_unCircleArray[9][0]    = clrBack;
    m_unCircleArray[9][1]    = clrDark;
    m_unCircleArray[9][2]    = clrBack;
    m_unCircleArray[9][3]    = clrBack;
    m_unCircleArray[9][8]    = clrBack;
    m_unCircleArray[9][9]    = clrBack;
    m_unCircleArray[9][10]   = clrLight;
    m_unCircleArray[9][11]   = clrBack;

    m_unCircleArray[10][0]   = clrBack;
    m_unCircleArray[10][1]   = clrBack;
    m_unCircleArray[10][2]   = clrLight;
    m_unCircleArray[10][3]   = clrLight;
    m_unCircleArray[10][4]   = clrBack;
    m_unCircleArray[10][5]   = clrBack;
    m_unCircleArray[10][6]   = clrBack;
    m_unCircleArray[10][7]   = clrBack;
    m_unCircleArray[10][8]   = clrLight;
    m_unCircleArray[10][9]   = clrLight;
    m_unCircleArray[10][10]  = clrBack;
    m_unCircleArray[10][11]  = clrBack;

    m_unCircleArray[11][0]   = clrBack;
    m_unCircleArray[11][1]   = clrBack;
    m_unCircleArray[11][2]   = clrBack;
    m_unCircleArray[11][3]   = clrBack;
    m_unCircleArray[11][4]   = clrLight;
    m_unCircleArray[11][5]   = clrLight;
    m_unCircleArray[11][6]   = clrLight;
    m_unCircleArray[11][7]   = clrLight;
    m_unCircleArray[11][8]   = clrBack;
    m_unCircleArray[11][9]   = clrBack;
    m_unCircleArray[11][10]  = clrBack;
    m_unCircleArray[11][11]  = clrBack;

    memcpy(m_unCircleArrayChecked, m_unCircleArray, sizeof(m_unCircleArray));

    // Put black check in.
    m_unCircleArrayChecked[4][5] = 0;
    m_unCircleArrayChecked[4][6] = 0;

    m_unCircleArrayChecked[5][4] = 0;
    m_unCircleArrayChecked[5][5] = 0;
    m_unCircleArrayChecked[5][6] = 0;
    m_unCircleArrayChecked[5][7] = 0;

    m_unCircleArrayChecked[6][4] = 0;
    m_unCircleArrayChecked[6][5] = 0;
    m_unCircleArrayChecked[6][6] = 0;
    m_unCircleArrayChecked[6][7] = 0;

    m_unCircleArrayChecked[7][5] = 0;
    m_unCircleArrayChecked[7][6] = 0;

    if (m_bmpCircle.operator HGDIOBJ())
    {
        m_bmpCircle.DeleteObject();
    }

    if (m_bmpCircleChecked.operator HGDIOBJ())
    {
        m_bmpCircleChecked.DeleteObject();
    }

    m_bmpCircle.CreateBitmap(12, 12, 1, 32, &(m_unCircleArray[0][0]));
    m_bmpCircleChecked.CreateBitmap(12, 12, 1, 32, &(m_unCircleArrayChecked[0][0]));
}

/////////////////////////////////////////////////////////////////////////////
//
// void CRadioWidget::DrawItem()
//
// Inputs           : LPDRAWITEMSTRUCT lpDrawItemStruct - pointer to a 
//                                                        Win32 structure
//                    .
//
// Return Values    : None.
//
// Date             : 10 January 2000
//
// Engineer         : Billy Baker
//
// Description      : CRadioWidget::DrawItem() is an override of a 
//                    standard MFC method for use with owner drawn 
//                    controls.  It is overriden here to allow the 
//                    background to be whatever the user wants and have
//                    the colors for the radio circle match the background 
//                    color.
//
/////////////////////////////////////////////////////////////////////////////
void CRadioWidget::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
    CRect rect(&(lpDrawItemStruct->rcItem));
    CDC *pDC = CDC::FromHandle(lpDrawItemStruct->hDC);

    CDC* pDCur = pDC;
    pDC = m_pDC;

    long int lSavedDC = pDC->SaveDC();

    // save the DC and set formatting parameters for 
    // horizontal and vertical alignment

    // fill the extents rectangle with the color for the background
    pDC->SetBkColor(m_clrBack);

    ::ExtTextOut(pDC->GetSafeHdc(), 0, 0, ETO_OPAQUE, (LPRECT)rect, NULL, 0, NULL);

    CRect rectRadio(rect.left + unLeftSideBorder,
                    rect.top  + (rect.Height() - unRadioCircleSize)/2, 
                    rect.left + unRadioCircleSize, 
                    rect.top  + (rect.Height() + unRadioCircleSize)/2);

    rect.left += rectRadio.right + unRightSideBorder;

    // Move the background color to the screen
    CRect rectO(&(lpDrawItemStruct->rcItem));
    pDCur->BitBlt(rectO.left, rectO.top, 
                  rectO.Width(), rectO.Height(), 
                  pDC, rectO.left, rectO.top, SRCCOPY);

    // Move the correct bitmap for the circle to the screen
    if ((long)m_varChecked == 0)
    {
        if (m_bEnabled == true)
        {
            pDC->SelectObject(&m_bmpCircle);
            pDCur->BitBlt(rectRadio.left, rectRadio.top, 
                          rectRadio.Width() + 1, rectRadio.Height() + 1, 
                          pDC, 0, 0, SRCCOPY);
        }
        else
        {
            pDC->SelectObject(&m_bmpCircle);
            pDCur->BitBlt(rectRadio.left, rectRadio.top, 
                          rectRadio.Width() + 1, rectRadio.Height() + 1, 
                          pDC, 0, 0, SRCCOPY);
        }
    }
    else
    {
        if (m_bEnabled == true)
        {
            pDC->SelectObject(&m_bmpCircleChecked);
            pDCur->BitBlt(rectRadio.left, rectRadio.top, 
                          rectRadio.Width() + 1, rectRadio.Height() + 1,
                          pDC, 0, 0, SRCCOPY);
        }
        else
        {
            pDC->SelectObject(&m_bmpCircleChecked);
            pDCur->BitBlt(rectRadio.left, rectRadio.top, 
                          rectRadio.Width() + 1, rectRadio.Height() + 1,
                          pDC, 0, 0, SRCCOPY);
        }
    }

    pDC->RestoreDC(lSavedDC);

    // Draw the text on the screen.
    m_bRepaint = true;
    CRect rectOld(&(lpDrawItemStruct->rcItem));
    lpDrawItemStruct->rcItem = rect;
    CTextWidget::DrawItem(lpDrawItemStruct);
    lpDrawItemStruct->rcItem = rectOld;
}

