#include "..\core\stdafx.h"
#include "RadioPage.h"

#include "..\core\widget.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CRadioPage::CRadioPage() : CBasePage(CRadioPage::IDD)
{
	//{{AFX_DATA_INIT(CRadioPage)
	m_bFirstInGroup = FALSE;
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Radio");
}

CRadioPage::~CRadioPage()
{
}

void CRadioPage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRadioPage)
	DDX_Check(pDX, IDC_GROUP_CHECK, m_bFirstInGroup);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CRadioPage, CBasePage)
	//{{AFX_MSG_MAP(CRadioPage)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//
// CBasePage* CRadioPage::CreateObject()
//
// Inputs           : None.
//
// Return Values    : A pointer to a new instance of the CRadioPage class.
//
// Date             : 12 January 1999
//
// Engineer         : Billy Baker
//
// Description      : CreateObject is a static member method that 
//                    creates a new instance of the CRadioPage.  
//                    Every class derived from CBasePage must 
//                    implmement CreateObject as each Widget contains a 
//                    list of pointers to the CreateObject methods that 
//                    correspond to the property pages needed for that Widget.
//
/////////////////////////////////////////////////////////////////////////////
CBasePage* CRadioPage::CreateObject()
{
    return new CRadioPage;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CRadioPage::SetProperties()
//
// Inputs           : void* pWidget - a pointer to be cast to a CWidget*
//
// Return Values    : None.
//
// Date             : 12 January 1999
//
// Engineer         : Billy Baker
//
// Description      : CRadioPage::SetProperties is the standard 
//                    interface for initializing the dialog controls 
//                    with data from the CXMLWidget instance that is 
//                    associated with the CWidget instance that is 
//                    passed to the method.  Every ...::SetProperties 
//                    method does has a similar implmemenation--find 
//                    each element that is used in the property page 
//                    and for each find their attributes if there are 
//                    any.  Note: UpdateData is not called here since 
//                    SetProperties is called before Create.
//
/////////////////////////////////////////////////////////////////////////////
void CRadioPage::SetProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL)
    {
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("OPTIONS")) == true)
        {
            STRING2STRING_MAP::iterator s2sIt = NULL;
            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("GROUP")) == true)
            {
                CString strValue((*s2sIt).second.c_str());
                strValue.MakeUpper();
                if (strValue == "YES")
                {
                    m_bFirstInGroup = TRUE;
                }
                else
                {
                    m_bFirstInGroup = FALSE;
                }
            }
        }
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CRadioPage::UpdateProperties()
//
// Inputs           : void* pWidget - a void pointer to be case to a CWidget*
//
// Return Values    : None.
//
// Date             : 12 January 1999
//
// Engineer         : Billy Baker
//
// Description      : CRadioPage::UpdateProperties is another 
//                    standard interface method for dealing with 
//                    property pages derived from CBasePage.  When the 
//                    data from the property page needs to be applied, 
//                    the UpdateProperties method is called.  The 
//                    implementatin is similar in every CBasePage 
//                    derived class--find the elements in the 
//                    CXMLWidget that is associated with the CWidget 
//                    that is passed and update each element and any 
//                    associated attributes.
//
/////////////////////////////////////////////////////////////////////////////
void CRadioPage::UpdateProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL && GetSafeHwnd() != NULL)
    {
        UpdateData(TRUE);
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("OPTIONS")) == true)
        {
            CString strOptions;
            long int lOptions = 0;

            strOptions.Format("%d",lOptions);
            pXMLElement->AddElementValue(_FSI_STL::string((LPCTSTR)strOptions));

            STRING2STRING_MAP::iterator s2sIt = NULL;

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("GROUP")) == true)
            {
                if (m_bFirstInGroup == TRUE)
                {
                    (*s2sIt).second = _FSI_STL::string("YES");
                }
                else
                {
                    (*s2sIt).second = _FSI_STL::string("NO");
                }
            }
        }
    }
}
