/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : PushButtonWidget.h
//
// Date             : 15 October 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.2 $
//
// Description      : PushButtonWidget.h contains the definition of the 
//                    CPushButtonWidget class. The only colors that may 
//                    be changed in the editor are the background color 
//                    and the foreground text color.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CWidget, General::CButtonWidget, 
//                    General::CTextWidget, Core::CVariant.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: PushButtonWidget.h $                                                                   
// Revision 1.2  1999/10/19 17:44:47  billyb                                                                   
// Added bitmap for down state drawing.  Handled WM_NOTIFY                                                                   
// for objects on top of the button telling the button about clicks.                                                                   
// Made button stay down until the next UpdateRenderVaraibles                                                                   
// where the up/down state is resolved.                                                                   
/////////////////////////////////////////////////////////////////////////////
#if !defined(_PUSHBUTTONWIDGET_H_)
#define _PUSHBUTTONWIDGET_H_

#include "CheckBoxWidget.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CPushButtonWidget : public CCheckBoxWidget
{
// Construction
public:
	CPushButtonWidget();

// Attributes
protected:
    bool                m_bVarChangePending;
    int*                m_pBits;

    virtual void InitReinit();
    virtual void ResetProperties();

public:
  	enum { IDB = IDB_BUTTON_WIDGET };

// Operations
public:
    static  CWidget*  CreateObject();
    virtual void      Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                 const long int lId, bool bEditMode);

    virtual bool      UpdateRenderVariables();


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPushButtonWidget)
	public:
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	protected:
	virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CPushButtonWidget();

	// Generated message map functions
protected:
	//{{AFX_MSG(CPushButtonWidget)
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
 	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(_PushButtonWIDGET_H_)
