/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : PushButtonWidget.cpp
//
// Date             : 15 October 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.6 $
//
// Description      : PushButtonWidget.cpp contains the implementation of the 
//                    CPushButtonWidget class.  The only 
//                    colors that may be changed in the editor are the 
//                    background color and the foreground text color.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CWidget, General::CButtonWidget, 
//                    General::CTextWidget, Core::CVariant.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: PushButtonWidget.cpp $
// Revision 1.6  2000/01/21 10:23:46  billyb
// Made drawing occur offscreen before being copied to the
// screen.
// Revision 1.5  1999/12/08 17:48:42  billyb
// Added CS_OWNDC.
// Revision 1.4  1999/11/09 21:45:06  billyb
// Changed FillRect to FillSolidRect or PatBlt.  Changed 
// BEGIN_MESSAGE_MAP to have CButtonWidget as base.
// Optimized loops.   Removed unneeded message map entries.
// Revision 1.3  1999/10/21 03:07:24  billyb
// Set background mode to transparent for drawing focus 
// rectangle.
// Revision 1.2  1999/10/19 17:44:44  billyb
// Added bitmap for down state drawing.  Handled WM_NOTIFY
// for objects on top of the button telling the button about clicks.
// Made button stay down until the next UpdateRenderVaraibles
// where the up/down state is resolved.
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "PushButtonWidget.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
//
// CPushButtonWidget::CPushButtonWidget()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  Set the name of the widget which
//                    is used in the XML data and under the icons in the 
//                    editor.
//
/////////////////////////////////////////////////////////////////////////////
CPushButtonWidget::CPushButtonWidget()
{
    m_stlStrWidgetName  = _FSI_STL::string("PushButton");

    // Must be set once for InitReinit to work correctly.
    m_pBits = NULL;
}

void CPushButtonWidget::InitReinit()
{
    if (m_pBits != NULL)
    {
        delete [] m_pBits;
    }

    m_bVarChangePending = false;
    m_pBits             = NULL;
    m_stlStrValue       = _FSI_STL::string("Blank");
}

/////////////////////////////////////////////////////////////////////////////
//
// CPushButtonWidget::~CPushButtonWidget()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.
//
/////////////////////////////////////////////////////////////////////////////
CPushButtonWidget::~CPushButtonWidget()
{
    if (m_pBits != NULL)
    {
        delete [] m_pBits;
    }
}


BEGIN_MESSAGE_MAP(CPushButtonWidget, CButtonWidget)
	//{{AFX_MSG_MAP(CPushButtonWidget)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//
// CWidget* CPushButtonWidget::CreateObject()
//
// Inputs           : None.
//
// Return Values    : A pointer to a new instance of CPushButtonWidget.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CPushButtonWidget::CreateObject() is a common 
//                    framework method used to create a new instance of 
//                    CPushButtonWidget.  It is a static member.  The 
//                    address of this method is stored in a map of 
//                    widget name to CreateObject address in the 
//                    component interface for the DLL that contains the 
//                    CPushButtonWidget.  Using this data structure, a 
//                    new instance of CPushButtonWidget can be created 
//                    when one is encountered in the XML page 
//                    description file.
//
/////////////////////////////////////////////////////////////////////////////
CWidget* CPushButtonWidget::CreateObject()
{
    return new CPushButtonWidget();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CPushButtonWidget::Initialize()
//
// Inputs           : CXMLWidget*& rpXMLWidget - reference to a pointer 
//                                               that holds the data to 
//                                               create a CPushButtonWidget.
//                    CWnd* pWnd               - the parent CWnd object.
//                    const long lId           - identifier.
//                    bool bEditMode           - whether editing is taking 
//                                               place.
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CPushButtonWidget::Initialize() is a common 
//                    framework method.  It is called after an instance 
//                    of CPushButtonWidget has been created.  It is 
//                    responsible for initializing most of the internal 
//                    data members with data from the XMLWidget.  This 
//                    is done using the call to ResetProperties.  If 
//                    the XMLWidget pointer is NULL, a new XMLWidget 
//                    instance is created with default settings.  
//                    Generic help text is set here and any CWnd 
//                    derived Create() calls are made to create the 
//                    Windows object that allows for the use of the MFC 
//                    messages.  The HWND for the CWnd derived object 
//                    that is created is then added to a map in CWidget 
//                    that keeps track of what CWidget derived pointers 
//                    are valid.  This is to make sure that all of the 
//                    threads do not try to dereference bad pointers.
//
/////////////////////////////////////////////////////////////////////////////
void CPushButtonWidget::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                 const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    CPushButtonWidget::InitReinit();

    if (rpXMLWidget != NULL)
    {
        ResetProperties();
    }

    if (GetSafeHwnd() == NULL)
    {
        Create(m_stlStrValue.c_str(),
               WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN | BS_OWNERDRAW | CS_OWNDC, 
               CRect(m_exPtUpperLeft, m_exPtLowerRight),
               (CWnd*)pWnd, lId);
    }
    else
    {
        SetParent(pWnd);
        MoveWindow(m_exPtUpperLeft.X(), m_exPtUpperLeft.Y(),
                   m_exPtLowerRight.X() - m_exPtUpperLeft.X(),
                   m_exPtLowerRight.Y() - m_exPtUpperLeft.Y(), FALSE);
        ShowWindow(SW_NORMAL);
    }

    CDC* pDCur = GetDC();
    if (m_pDC->GetSafeHdc() != NULL)
    {
        m_pDC->DeleteDC();
    }
    m_pDC->CreateCompatibleDC(pDCur);

    if (m_pBMP->GetSafeHandle() != NULL)
    {
        m_pBMP->DeleteObject();
    }
    m_pBMP->CreateCompatibleBitmap(pDCur, m_exPtLowerRight.X() - m_exPtUpperLeft.X(),
                                    m_exPtLowerRight.Y() - m_exPtUpperLeft.Y());
    ReleaseDC(pDCur);

    m_pDC->SelectObject(m_pBMP);
    m_pDC->SetBkMode(TRANSPARENT);
    m_pDC->SelectObject(&m_font);

    m_pWnd = this;
    m_mapValidAddresses[this] = m_pWnd->GetSafeHwnd();
}



/////////////////////////////////////////////////////////////////////////////
//
// void CPushButtonWidget::DrawItem()
//
// Inputs           : LPDRAWITEMSTRUCT lpDrawItemStruct - pointer to a 
//                                                        Win32 structure
//                    .
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CPushButtonWidget::DrawItem() is an override of a 
//                    standard MFC method for use with owner drawn 
//                    controls.  It is overriden here to allow the 
//                    background to be whatever the user wants and to 
//                    make the square for the check resize as the size 
//                    of the widget resizes.
//
/////////////////////////////////////////////////////////////////////////////
void CPushButtonWidget::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
   CRect rect(&(lpDrawItemStruct->rcItem));

   CDC   *pDCur   =  CDC::FromHandle(lpDrawItemStruct->hDC);
   CDC   *pDC     =  m_pDC;
   long  int   lSavedDC =  pDC->SaveDC();

   // Fill the entire button with the button brush
   CColor   colorBackground   =  Background();
   CRect    edgeRect(rect);

   if (m_bLButtonDown   == true)
   {
      unsigned char  red   =  (colorBackground.Red()     *  1.6   >  255)  ?  255   :  (colorBackground.Red()     *  1.6);
      unsigned char  green =  (colorBackground.Green()   *  1.6   >  255)  ?  255   :  (colorBackground.Green()   *  1.6);
      unsigned char  blue  =  (colorBackground.Blue()    *  1.6   >  255)  ?  255   :  (colorBackground.Blue()    *  1.6);
      pDC->FillSolidRect(rect, RGB(red, green, blue));

      CPen penD(PS_SOLID, 1, RGB(0,0,0));
      pDC->SelectObject(&penD);
	   pDC->MoveTo(edgeRect.right-1,edgeRect.top);
	   pDC->LineTo(edgeRect.left,edgeRect.top);
	   pDC->LineTo(edgeRect.left,edgeRect.bottom-1);

      CPen penS(PS_SOLID, 1, colorBackground.DarkColor());
      pDC->SelectObject(&penS);
	   pDC->MoveTo(edgeRect.right - 2,edgeRect.top + 1);
	   pDC->LineTo(edgeRect.left  + 1,edgeRect.top + 1);
	   pDC->LineTo(edgeRect.left  + 1,edgeRect.bottom-2);

      CPen penW(PS_SOLID, 1, colorBackground.HighlightColor());
      pDC->SelectObject(&penW);
	   pDC->MoveTo(edgeRect.left,edgeRect.bottom-1);
	   pDC->LineTo(edgeRect.right-1,edgeRect.bottom-1);
	   pDC->LineTo(edgeRect.right-1,edgeRect.top-1);

      CPen penH(PS_SOLID, 1, RGB(colorBackground.Red(), colorBackground.Green(), colorBackground.Blue()));
      pDC->SelectObject(&penH);
	   pDC->MoveTo(edgeRect.left+1,edgeRect.bottom-2);
	   pDC->LineTo(edgeRect.right-2,edgeRect.bottom-2);
	   pDC->LineTo(edgeRect.right-2,edgeRect.top);

      CString  strValue(m_stlStrValue.c_str());
      rect.left   += 2;
      rect.top    += 2;
      DrawMultilineText(pDC, rect, strValue);
      rect.left   -= 2;
      rect.top    -= 2;
   }
   else if ((bool)m_varChecked   == true  || m_bVarChangePending  == true)
   {
      unsigned char  red   =  (colorBackground.Red()     *  1.4   >  255)  ?  255   :  (colorBackground.Red()     *  1.4);
      unsigned char  green =  (colorBackground.Green()   *  1.4   >  255)  ?  255   :  (colorBackground.Green()   *  1.4);
      unsigned char  blue  =  (colorBackground.Blue()    *  1.4   >  255)  ?  255   :  (colorBackground.Blue()    *  1.4);
      pDC->FillSolidRect(rect, RGB(red, green, blue));

      CPen penD(PS_SOLID, 1, RGB(0,0,0));
      pDC->SelectObject(&penD);
	   pDC->MoveTo(edgeRect.right-1,edgeRect.top);
	   pDC->LineTo(edgeRect.left,edgeRect.top);
	   pDC->LineTo(edgeRect.left,edgeRect.bottom-1);

      CPen penS(PS_SOLID, 1, colorBackground.DarkColor());
      pDC->SelectObject(&penS);
	   pDC->MoveTo(edgeRect.right - 2,edgeRect.top + 1);
	   pDC->LineTo(edgeRect.left  + 1,edgeRect.top + 1);
	   pDC->LineTo(edgeRect.left  + 1,edgeRect.bottom-2);

      CPen penW(PS_SOLID, 1, colorBackground.HighlightColor());
      pDC->SelectObject(&penW);
	   pDC->MoveTo(edgeRect.left,edgeRect.bottom-1);
	   pDC->LineTo(edgeRect.right-1,edgeRect.bottom-1);
	   pDC->LineTo(edgeRect.right-1,edgeRect.top-1);

      CPen penH(PS_SOLID, 1, RGB(colorBackground.Red(), colorBackground.Green(), colorBackground.Blue()));
      pDC->SelectObject(&penH);
	   pDC->MoveTo(edgeRect.left+1,edgeRect.bottom-2);
	   pDC->LineTo(edgeRect.right-2,edgeRect.bottom-2);
	   pDC->LineTo(edgeRect.right-2,edgeRect.top);

      CString  strValue(m_stlStrValue.c_str());
      rect.left   += 2;
      rect.top    += 2;
      DrawMultilineText(pDC, rect, strValue);
      rect.left   -= 2;
      rect.top    -= 2;
   }
   else
   {
      pDC->FillSolidRect(rect, (COLORREF)colorBackground);

      CPen penW(PS_SOLID, 1, colorBackground.HighlightColor());
      pDC->SelectObject(&penW);
      pDC->MoveTo(edgeRect.right-2,edgeRect.top);
      pDC->LineTo(edgeRect.left,edgeRect.top);
      pDC->LineTo(edgeRect.left,edgeRect.bottom-1);

      CPen penD(PS_SOLID, 1, RGB(0,0,0));
      pDC->SelectObject(&penD);
      pDC->MoveTo(edgeRect.left,edgeRect.bottom-1);
      pDC->LineTo(edgeRect.right-1,edgeRect.bottom-1);
      pDC->LineTo(edgeRect.right-1,edgeRect.top-1);

      CPen penS(PS_SOLID, 1, colorBackground.DarkColor());
      pDC->SelectObject(&penS);
      pDC->MoveTo(edgeRect.left+1,edgeRect.bottom-2);
      pDC->LineTo(edgeRect.right-2,edgeRect.bottom-2);
      pDC->LineTo(edgeRect.right-2,edgeRect.top);

      CString  strValue(m_stlStrValue.c_str());
      DrawMultilineText(pDC, rect, strValue);
   }

//   CString  strValue(m_stlStrValue.c_str());
//   DrawMultilineText(pDC, rect, strValue);

   pDCur->BitBlt(rect.left, rect.top, rect.Width(), rect.Height(), pDC, rect.left, rect.top, SRCCOPY);
   pDC->RestoreDC(lSavedDC);

   // Move and invalidate the children for the different states.
   if (m_bLButtonDown   != m_bLButtonDownLastPass)
   {
      m_bLButtonDownLastPass = m_bLButtonDown;

      // Make sure that only the base widget updates all of the children.
      if (m_bTraverseUpdate == false)
         TraverseBaseWidgets((CWidget*)this, true);
   }
   else
   {
      if (m_bTraverseUpdate == false)
         TraverseBaseWidgets((CWidget*)this, false);
   }

   m_bTraverseUpdate = false;
}


/////////////////////////////////////////////////////////////////////////////
//
// void CPushButtonWidget::OnLButtonUp()
//
// Inputs           : UINT nFlags  - flags that tell what other keys may 
//                                   have been pressed when the click 
//                                   occurred.
//                    CPoint point - the position of the click.
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CCheckBoxWidget::OnLButtonUp() is an override of 
//                    the standard MFC method for CWnd derived classes. 
//                    Here, it is used to flip the state of the 
//                    checkbox and to tell all comms actions to update 
//                    via the call to CButtonWidget::OnLButtonUp().
//
/////////////////////////////////////////////////////////////////////////////
void CPushButtonWidget::OnLButtonUp(UINT nFlags, CPoint point) 
{
    m_bVarChangePending = true;

    CCheckBoxWidget::OnLButtonUp(nFlags, point);

}

void CPushButtonWidget::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
    if (m_bEditing == true)
    {
        CButtonWidget::OnLButtonDown(nFlags, point);
    }
    else
    {
        m_bRedraw = false;

        CButtonWidget::OnLButtonDown(nFlags, point);

        if (m_bRedraw == true)
        {
            Invalidate(FALSE);
        }
    }
}

void CPushButtonWidget::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
    m_bRedraw = false;
    CRect rect;
    GetClientRect(rect);

    if (rect.PtInRect(point) == TRUE)
    {
        CButtonWidget::OnMouseMove(nFlags, point);
    }
    else
    {
        if (m_bFocus != false || m_bLButtonDown != false)
        {
            m_bFocus = false;
            m_bLButtonDown = false;
            m_bRedraw = true;
        }
    }

    if (m_bRedraw == true)
    {
        Invalidate(FALSE);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// BOOL CPushButtonWidget::OnNotify()
//
// Inputs           : WPARAM wParam -   not used.
//                    LPARAM lParam -   address of a notify message 
//                                      structure
//                    LRESULT pResult - not used.
//
// Return Values    : TRUE if handled.
//                    FALSE otherwise.
//
// Date             : 18 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CPushButtonWidget::OnNotify is used to handle 
//                    WM_NOTIFY messages.  It is overriden here so that 
//                    graphical elements may be placed on top of the 
//                    push button and click message will be sent to the 
//                    CPushButtonWidget class rather than the 
//                    CButtonWidget class.
//
/////////////////////////////////////////////////////////////////////////////
BOOL CPushButtonWidget::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult) 
{
    NMHDR* pHdr = (NMHDR*)lParam;
    CWnd* pWnd = FromHandle(pHdr->hwndFrom);
    if (IsChild(pWnd))
    {
        switch(pHdr->code)
        {
        case WM_LBUTTONDBLCLK:
        case WM_LBUTTONDOWN:
            {
                CRect rect;
                GetClientRect(rect);
                OnLButtonDown(MK_LBUTTON,rect.TopLeft());

                return TRUE;
            }

        case WM_LBUTTONUP:
            {
                // If the button was down when the LButtonUp message
                // was sent to a child, then call OnLButtonUp here with a 
                // point on the boundary of the button.
                CRect rect;
                GetClientRect(rect);
                OnLButtonUp(0,rect.TopLeft());
                return TRUE;
            }
        };
    }
	
	return CButtonWidget::OnNotify(wParam, lParam, pResult);
}

//////////////////////////////////////////////////////////////////////
// Methods called from Comms thread
//////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
// bool CPushButtonWidget::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : true  - all of the render variables were updated.
//                    false - a problem occurred updating the render 
//                            variables.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CCheckBoxWidget::UpdateRenderVariables is a 
//                    common framework method that is called by the 
//                    Comms thread to make sure that all of the 
//                    variables used for rendering have the most up to 
//                    date data.
//
/////////////////////////////////////////////////////////////////////////////
bool CPushButtonWidget::UpdateRenderVariables()
{
    m_bVarChangePending = false;

    return CCheckBoxWidget::UpdateRenderVariables();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CCheckBoxWidget::ResetProperties()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 20 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CPushButtonWidget4::ResetProperties will call its 
//                    parent's ResetProperties method.  Afterwards, it
//                    will reset the alignment variables and call 
//                    TextFormat to reset the text formatting.
//
/////////////////////////////////////////////////////////////////////////////
void CPushButtonWidget::ResetProperties()
{
    CTextWidget::ResetProperties();
}
