// ProgressWidget.cpp : implementation file
//

#include "..\core\stdafx.h"
#include "ProgressWidget.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
                    
/////////////////////////////////////////////////////////////////////////////
// CProgressWidget

CProgressWidget::CProgressWidget()
{
    m_stlStrWidgetName = _FSI_STL::string("Progress");

    m_listColorSelectable.push_back("TIME_PROGRESS");

    CProgressWidget::InitReinit();
}

void CProgressWidget::InitReinit()
{
    m_ulLower       = 0;
    m_dPos          = 0.0;
    m_dPos_cv       = 0.0;

    // rate times seconds in min times minutes in 1.5 hours
    m_ulUpper       = 60 * 90;  
    m_ulUpper_cv    = m_ulUpper;

    m_mapMarks.clear();
    m_mapMarks_cv.clear();
}

CProgressWidget::~CProgressWidget()
{
}


BEGIN_MESSAGE_MAP(CProgressWidget, CButtonWidget)
	//{{AFX_MSG_MAP(CProgressWidget)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CProgressWidget message handlers
CWidget* CProgressWidget::CreateObject()
{
    return new CProgressWidget();
}

void CProgressWidget::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                 const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    CProgressWidget::InitReinit();

    if (rpXMLWidget != NULL)
    {
        ResetProperties();
    }

    if (GetSafeHwnd() == NULL)
    {
        Create("", WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN | BS_OWNERDRAW | CS_OWNDC,
                   CRect(m_exPtUpperLeft, m_exPtLowerRight),
                   (CWnd*)pWnd, lId);
    }
    else
    {
        SetParent(pWnd);
        MoveWindow(m_exPtUpperLeft.X(), m_exPtUpperLeft.Y(),
                   m_exPtLowerRight.X() - m_exPtUpperLeft.X(),
                   m_exPtLowerRight.Y() - m_exPtUpperLeft.Y(), FALSE);
        ShowWindow(SW_NORMAL);
    }

    m_pWnd = this;
    m_mapValidAddresses[this] = m_pWnd->GetSafeHwnd();
}

void CProgressWidget::ResetProperties()
{
   CButtonWidget::ResetProperties();
}

void CProgressWidget::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 

{
    CString strCaption;

    long ulHours, ulMinutes, ulSeconds;

   if ((unsigned long)m_dPos != m_ulAllSeconds || m_bEditing)
   
    {
        UINT nRange = m_ulUpper - m_ulLower;

        CRect rect(&(lpDrawItemStruct->rcItem));

        CDC *pDC = CDC::FromHandle(lpDrawItemStruct->hDC);

        CDC* pDCur = pDC;
        pDC = m_pDC;
        pDC->CreateCompatibleDC(pDCur);

        long int lSavedDC = pDC->SaveDC();

        m_pBMP->CreateCompatibleBitmap(pDCur, m_exPtLowerRight.X() - m_exPtUpperLeft.X(),
                                        m_exPtLowerRight.Y() - m_exPtUpperLeft.Y());
        pDC->SelectObject(m_pBMP);

        // Fill the rectCheckBox area with white.
        CColor colorBackground = Background();
        CColor colorForeground = Foreground();

        // fill the extents rectangle with the color for the background
        pDC->SetBkMode(TRANSPARENT);
        pDC->SetBkColor(colorBackground);
//        pDC->SelectObject(&m_font);
        pDC->FillSolidRect(rect, (COLORREF)(Background().HighlightColor()));

        // Put a black highlight in the upper left.
        pDC->MoveTo(rect.left + 1, rect.bottom - 3);
        pDC->LineTo(rect.left + 1, rect.top + 1);
        pDC->LineTo(rect.right - 2, rect.top + 1);

        long int lSavedDC2 = pDC->SaveDC();

        // Upper left highlight.
        CPen penD(PS_SOLID, 1, Background().DarkColor());
        pDC->SelectObject(&penD);
	    pDC->MoveTo(rect.left, rect.bottom - 2);
	    pDC->LineTo(rect.left, rect.top);
	    pDC->LineTo(rect.right - 1, rect.top);

        // Lower right highlight.
        CPen penH(PS_SOLID, 1, Background());
        pDC->SelectObject(&penH);
	    pDC->MoveTo(rect.left + 1, rect.bottom - 2);
	    pDC->LineTo(rect.right - 2, rect.bottom - 2);
	    pDC->LineTo(rect.right - 2, rect.top);

        pDC->RestoreDC(lSavedDC2);

        if (m_bEnabled == true)
        {
            rect.DeflateRect(2, 2);
            pDC->PatBlt(rect.left, rect.top, 
                        rect.Width(), rect.Height(), 
                        WHITENESS);
            rect.InflateRect(2, 2);
        }
        else
        {
            rect.DeflateRect(2, 2);
            pDC->FillSolidRect(rect, (COLORREF)colorBackground);
            rect.InflateRect(2, 2);
        }

        // Figure out the left and right rectangles
        CRect rLeft = rect;
        CRect rRight = rect;

        rLeft.DeflateRect(2,2);
        rLeft.right = ((m_dPos - (float)m_ulLower) / nRange)*(rect.Width() - 3);
        rRight.DeflateRect(2,2);
        rRight.left = rLeft.right;

        CRgn rgnLeft, rgnRight;
        rgnLeft.CreateRectRgnIndirect(rLeft);
        rgnRight.CreateRectRgnIndirect(rRight);

        // Draw the left part of the meter
        // (The right side was handled in OnEraseBkgnd
        pDC->FillSolidRect(rLeft, m_mapColorSelectables["TIME_PROGRESS"].s_color);

        m_ulAllSeconds = (unsigned long)m_dPos;
        ulHours = m_ulAllSeconds / 3600;
        ulMinutes = (m_ulAllSeconds % 3600) / 60;
        ulSeconds = (m_ulAllSeconds % 60);
        strCaption.Format("%02d:%02d:%02d",ulHours,
                                           ulMinutes,
                                           ulSeconds);

        pDC->SelectClipRgn(&rgnLeft);
        pDC->SetBkMode(TRANSPARENT);
        pDC->SetTextColor(0);
        rect.DeflateRect(3,3);
        pDC->DrawText(strCaption, rect, DT_VCENTER | DT_CENTER);

        pDC->SelectClipRgn(&rgnRight);
        pDC->SetTextColor(colorForeground);
        pDC->DrawText(strCaption, rect, DT_VCENTER | DT_CENTER);
        rect.InflateRect(3,3);

        _FSI_STL::map<unsigned long int, COLORREF>::iterator mIt = m_mapMarks.begin();
        _FSI_STL::map<unsigned long int, COLORREF>::iterator mendIt = m_mapMarks.end();
        CRect rMark;
        CBrush brush;
        while (mIt != mendIt)
        {
            if ((*mIt).first > m_ulLower && (*mIt).first < m_ulUpper)
            {
                // Figure out the left and right rectangles
                rMark = rect;

                rMark.left = ((float)((*mIt).first - m_ulLower) / nRange)*(rect.Width()-3);
                rMark.right = rLeft.left + 1;

                // Draw the left part of the meter
                pDC->FillSolidRect(rMark, (*mIt).second);
            }
            mIt++;
        }

        pDCur->BitBlt(rect.left, rect.top, rect.Width(), rect.Height(), pDC, rect.left, rect.top, SRCCOPY);
        pDC->RestoreDC(lSavedDC);

        pDC = pDCur;

        m_pDC->DeleteDC();
        m_pBMP->DeleteObject();
    }

    // Move and invalidate the children for the different states.
    if (m_bLButtonDown != m_bLButtonDownLastPass)
    {
        m_bLButtonDownLastPass = m_bLButtonDown;

        // Make sure that only the base widget updates all of the children.
        if (m_bTraverseUpdate == false)
        {
            TraverseBaseWidgets((CWidget*)this, true);
        }
    }
    else
    {
        if (m_bTraverseUpdate == false)
        {
            TraverseBaseWidgets((CWidget*)this, false);
        }
    }

    m_bTraverseUpdate = false;
}

void CProgressWidget::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
    

    if (pCV == NULL)
    {
        return;
    }

    if (pCV->Text() == "Mark")
    {
        m_mapMarks_cv[(unsigned long)m_dPos] = pCV->Background();
    }
    else if (rstrElementVar == "Default")
    {
        CVariant* pVariant = pCV->Variant();
        m_dPos_cv = *pVariant;

        if ((unsigned long)m_dPos_cv > m_ulUpper)
        {
            // Increase the upper by 15 minutes.
            m_ulUpper_cv = m_ulUpper + 60 * 15;
        }
    }
    else
    {
        CWidget::ChangeValue(rstrElementVar, pCV);
    }
}

bool CProgressWidget::UpdateRenderVariables()
{
    m_dPos          = m_dPos_cv;
    m_ulUpper       = m_ulUpper_cv;
    m_mapMarks      = m_mapMarks_cv;

    return CWidget::UpdateRenderVariables();
}