/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : plotwidget.h
//
// Date             : 21 January 2000
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.5 $
//
// Description      : PlotWidget.h contains the definition of the 
//                    CPlotWidget class.  This class is used as a starting
//                    point for both the XY and Time Based Plot Widgets.
//                    As such, CPlotWidget contains the minimum code
//                    for a plot.  This includes the number of x and y
//                    divisions, the min and max for the x axis, etc.
//                    A number of virtual methods are defined which 
//                    deal with drawing the the tics and labels on each
//                    axis and drawing the inspection tool.
//
//                    PlotWidget.h also contains the definition of the
//                    CPlotData class.  This class holds information that
//                    can be unique for each plot.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : _FSI_STL::map, _FSI_STL::string, Core::COpenGLtext,
//                    Comms::CCommsAction, Core::CXMLWidget, _FSI_STL::list.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: plotwidget.h $                                                                   
// Revision 1.5  2000/03/07 20:44:57  billyb                                                                   
// Changed function signatures to eliminate warnings.                                                                   
// Revision 1.4  2000/02/02 20:31:17  billyb                                                                   
// Changed nMINUTES_OF_DATA from 1 to 10.                                                                   
// Revision 1.3  2000/02/01 19:56:40  billyb                                                                   
// Added comments.  Stripped out time based specific code.  Add                                                                   
// virtual methods for drawing labels, grid lines, inspection data. tick                                                                   
// marks, and updating the plot data.  Stripped out CWidget creation                                                                   
// code since a CPlotWidget should never be created.                                                                   
/////////////////////////////////////////////////////////////////////////////
#if !defined(_PLOTWIDGET_H_)
#define _PLOTWIDGET_H_

#include "..\core\OpenGLtext.h"
#include "..\comms\CommsAction.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

static const float      fSMALLOFFSET      =    0.35f;
static const float      fXBORDER          =   90.0f;
static const float      fYBORDER          =   20.0f;
static const int        nMINUTES_OF_DATA  =   10;

class CPlotData
{
public:
    // The minimum y value that the user sets.
    float                           m_fPlotMinY;

    // The maximum y value that the user sets.
    float                           m_fPlotMaxY;

    // A pointer to memory for plot data.
    float*                          m_pfPlotData;

    // The number of xy pairs in m_pfPlotData.
    unsigned long                   m_ulSizeOfData;

    // Whether the plot should be displayed.
    bool                            m_bShow;

    // Whether the labels on the y axis need to be
    // recomputed.
    bool                            m_bRecomputeYLabels;

    // The color of the plot.
    CColor                          m_color;

    // Contains information to construct a CCommsAction.
    // When a new variable is desired, the new variable name
    // is placed in the XMLWidget and a new CCommsAction is
    // then created from the XMLWidget.
    CXMLWidget                      m_xmlCommsWidget;

    // Constuctor, copy constructor, destructor
    CPlotData();
    CPlotData(const CPlotData& rPlotData);
    ~CPlotData();
    
    // Assignment overload
    CPlotData& operator=(const CPlotData& rPlotData);
};

class CPlotWidget : public COpenGLWidget  
{
protected:
    // The minimum x value for the plot.  This may be
    // user specified or computed in the case of the time
    // based plot.
    float                               m_fPlotMinX;
    float                               m_fPlotMinX_cv;

    // The maximum x value for the plot.  This may be
    // user specified or computed in the case of the time
    // based plot.
    float                               m_fPlotMaxX;
    float                               m_fPlotMaxX_cv;

    // The number of divisions on the x axis.
    unsigned long int                   m_ulXDivisions;
    unsigned long int                   m_ulXDivisions_cv;

    // The number of divisions on the y axis.
    unsigned long int                   m_ulYDivisions;
    unsigned long int                   m_ulYDivisions_cv;

    // The width of the plot widget.  If it changes, then
    // a number of labels need their positions recomputed.
    float                               m_width;
    float                               m_width_old;

    // The height of the plot widget.  If it changes, then
    // a number of labels need their positions recomputed.
    float                               m_height;
    float                               m_height_old;

    // Whether the vertical grid lines are drawn.
    bool                                m_bGridLinesX;
    bool                                m_bGridLinesX_cv;

    // Whether the horizontal grid lines are drawn.
    bool                                m_bGridLinesY;
    bool                                m_bGridLinesY_cv;

    // Whether something with the way the grid should be
    // drawn has changed.  Labels and grid lines probably
    // need their positions recomputed.
    bool                                m_bGridChanged;

    // Whether the graph should continue to draw.
    bool                                m_bStopped;

    // Whether the user wants to inspect values on the graph.
    bool                                m_bInspectValues;
    bool                                m_bInspectValues_cv;

    // Whether plotting should continue.
    bool                                m_bPlot;
    bool                                m_bPlot_cv;

    // Whether the user wants to clear the graph.
    bool                                m_bClearPlot;
    bool                                m_bClearPlot_cv;

    // The rate of data coming from the host.
    float                               m_fRate;

    // Positions of the vertical grid lines.
    GLfloat*                            m_gridX;

    // Positions of the horizontal grid lines.
    GLfloat*                            m_gridY;

    // Positions of the small tic marks.
    GLfloat*                            m_small_ticks;

    // Positions of the large tic marks.
    GLfloat*                            m_large_ticks;

    // An XMLWidget that holds the base XML needed to construct
    // a CCommsAction.
    CXMLWidget                          m_xmlCommsSampleWidget;

    // Last position of the mouse.
    CPoint                              m_ptMouse;

    // The name of the host that is supplying the data.
    _FSI_STL::string                    m_stlStrHost;

    // Maps of internal variable name to the data for the variable - Var 1,
    // Var 2, etc.
    _FSI_STL::map<_FSI_STL::string, CPlotData>      m_mapVarName2PlotData;
    _FSI_STL::map<_FSI_STL::string, CPlotData>      m_mapVarName2PlotData_cv;

    // The text for the x labels.
    _FSI_STL::map<float, COpenGLtext>               m_mapXLabels;

    // Map of internal variable name to the y labels for that variable.
    _FSI_STL::map<_FSI_STL::string, _FSI_STL::map<float, COpenGLtext> > m_mapVarName2YLabels;

    // Map of color name, Red, Green, Blue, Yellow, Orange, Purple, to a CColor
    // object that has the specific color data for that color.  This is shared by
    // all plot objects.
    static _FSI_STL::map<_FSI_STL::string, CColor>  m_mapColors;

    // Map of internal var name to a CCommsActin pointer that gets data to 
    // the plot.
    _FSI_STL::map<_FSI_STL::string, CCommsAction*>  m_mapCommsActions;

    virtual void            UpdatePlotData(const _FSI_STL::string& rstlStrVariable, 
                                           CVariant* pVariant);
    virtual void            DrawGrid();
    virtual void            DrawSmallTicks();
    virtual void            DrawLargeTicks();
    virtual void            DrawXLabels();
    virtual void            DrawYLabels(const _FSI_STL::string& rstlStrVarName);
    virtual void            DrawInspection();
    virtual void            InitReinit();

public:
	CPlotWidget();
    virtual void Setup();
    virtual void Render();

// Attributes
public:
   	enum { IDB = IDB_TIME_PLOT_WIDGET };

    // Size of the plot.  Used in Setup and any Render methods.
    CRect rectViewCoord;
    CRect rectView;

// Operations
public:
    virtual void    ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);
    virtual bool    UpdateRenderVariables();
    virtual void    Deleting(bool bDeleting);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPlotWidget)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CPlotWidget();

	// Generated message map functions
protected:
	//{{AFX_MSG(CPlotWidget)
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

#endif // !defined(_PLOTWIDGET_H_)
