// PageAction.h: interface for the CPageAction class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(_PAGEACTION_H_)
#define _PAGEACTION_H_

#ifdef GENERAL
#define GENERALAPI __declspec( dllexport )
#else
#define GENERALAPI __declspec( dllimport )
#endif

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\core\Action.h"
#include "..\core\Widget.h"

class GENERALAPI CPageAction : public CAction, public CWidget
{
protected:
    CString       m_strComponent;
    CString       m_strSubComponent;
    CString       m_strPage;

public:
	CPageAction();
	virtual ~CPageAction();

    virtual void Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                            const long int lId, bool bEditMode);
    virtual void ResetProperties();
    static CWidget* CreateObject();

	virtual enum LButtonUpReturn OnLButtonUp();
};

#endif // !defined(_PAGEACTION_H_)
