// PageAction.cpp: implementation of the CPageAction class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "PageAction.h"

#include "..\core\LinkPage.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CPageAction::CPageAction()
{
    m_stlStrWidgetName = _FSI_STL::string("Change_Pages");

    m_listWidgetPropPages.push_back(CLinkPage::CreateObject);

    m_strPage           = "Untitled.fml";
    m_strComponent      = "IOS";
    m_strSubComponent   = "PAGES";
}

CPageAction::~CPageAction()
{
}

void CPageAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    if (rpXMLWidget != NULL)
    {
        ResetProperties();
    }

    m_pAction = this;
    m_pWidget = (CWidget*)this;
}

CWidget* CPageAction::CreateObject()
{
    return new CPageAction();
}

void CPageAction::ResetProperties()
{
    CWidget::ResetProperties();
    CXMLElement* pXMLElement = NULL;
    POSITION pos = NULL;

    // Find the element.
    if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("LINK")) == true)
    {
        m_strPage = pXMLElement->ElementValue().c_str();
        STRING2STRING_MAP::iterator s2sIt = NULL;
        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("COMPONENT")) == true)
        {
            m_strComponent = (*s2sIt).second.c_str();
        }
        else
        {
            pXMLElement->AddAttribute(_FSI_STL::string("COMPONENT"),
                                  _FSI_STL::string("IOS"));
        }
        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SUBCOMPONENT")) == true)
        {
            m_strSubComponent = (*s2sIt).second.c_str();
        }
        else
        {
            pXMLElement->AddAttribute(_FSI_STL::string("SUBCOMPONENT"),
                                  _FSI_STL::string("PAGES"));
        }
    }
    else
    {
        // No element.  Add a new one.
        m_pXMLWidget->AddElement(_FSI_STL::string("LINK"), 
                                 _FSI_STL::string((LPCTSTR)m_strPage),
                                 NULL);
        pXMLElement = NULL;
        if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("LINK")) == true)
        {
            pXMLElement->AddAttribute(_FSI_STL::string("COMPONENT"),
                                      _FSI_STL::string("IOS"));
            pXMLElement->AddAttribute(_FSI_STL::string("SUBCOMPONENT"),
                                      _FSI_STL::string("PAGES"));
        }
    }
}

enum LButtonUpReturn CPageAction::OnLButtonUp()
{
    CString* pstrPageInfo = new CString(m_strComponent + 
                                        "^" + m_strSubComponent + 
							            "^" + m_strPage);

    CFrameWnd* pFrame = m_pBaseWidget->Wnd()->GetParentFrame(); 

    if (pFrame != NULL)
    {
       pFrame->BeginWaitCursor();
	   pFrame->PostMessage(WM_CHANGE_PAGE, 0, (long)pstrPageInfo); 
    }

    return LBU_OK;
}
