/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : OverlayPage.h
//
// Date             : 22 November 1998
//
// Engineer         : Billy Baker
//
// Revision         :
//
// Description      : OverlayPage.h contains the definition of the 
//                    COverlayPage class which is derived from 
//                    CBasePage.  COverlayPage serves as a property 
//                    page for OverlayWidget types that need to be able 
//                    to change the buttons that are shown on an 
//                    overlay as well as whether it is persistent.  
//
//                    CreateObject, SetProperties, UpdateProperties, and
//                    Initialize must all be implemented as class that is
//                    derived from CBasePage.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : MFC.
//
// Components Used  : CBasePage.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
#if !defined(_OVERLAYPAGE_H_)
#define _OVERLAYPAGE_H_

#include "resource.h"

#include "..\core\BasePage.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// COverlayPage dialog
class COverlayPage : public CBasePage
{
// Construction
public:
	COverlayPage();
	~COverlayPage();
    static CBasePage* CreateObject();

// Dialog Data
	//{{AFX_DATA(COverlayPage)
	enum { IDD = IDD_GENERAL_PAGE_OVERLAY };
	CListBox	m_ctrlOverlaysList;
	BOOL	m_bApply;
	BOOL	m_bCancel;
	BOOL	m_bOk;
	BOOL	m_bPersist;
	CString	m_strName;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(COverlayPage)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(COverlayPage)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

    virtual void SetProperties(void* pWidget);
    virtual void UpdateProperties(void* pWidget);

};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(_OVERLAYPAGE_H_)
