/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : OverlayPage.cpp
//
// Date             : 22 November 1998
//
// Engineer         : Billy Baker
//
// Revision         :
//
// Description      : OverlayPage.cpp contains the implementation of 
//                    the COverlayPage class.  An instance of this 
//                    class would be used in a widget property sheet.  
//                    Normal usage includes creating a new page using 
//                    the CreateObject method.  Before a call to Create for
//                    a COverlayPage, the SetProperties member can be 
//                    called. And then, when changes need to be 
//                    applied, the UpdateProperties method should be call
//                    ed.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : MFC.
//
// Components Used  : CBasePage, CWidget.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "OverlayPage.h"

#include "..\core\widget.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
//
// COverlayPage::COverlayPage()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 22 November 1998
//
// Engineer         : Billy Baker
//
// Description      : COverlayPage::COverlayPage is the default 
//                    constructor for the COverlayPage class.  A call 
//                    is also made to CBasePage with the resource ID 
//                    for the dialog template that corresponds to the 
//                    COverlayPage class.  Member variables associated 
//                    with the controls in the dialog template are 
//                    initialized here and the name of the page is set.
//
/////////////////////////////////////////////////////////////////////////////
COverlayPage::COverlayPage() : CBasePage(COverlayPage::IDD)
{
	//{{AFX_DATA_INIT(COverlayPage)
	m_bApply = FALSE;
	m_bCancel = FALSE;
	m_bOk = FALSE;
	m_bPersist = FALSE;
	m_strName = _T("");
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Overlay");
}

/////////////////////////////////////////////////////////////////////////////
//
// COverlayPage::~COverlayPage()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 22 November 1998
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.
//
/////////////////////////////////////////////////////////////////////////////
COverlayPage::~COverlayPage()
{
}

void COverlayPage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COverlayPage)
	DDX_Control(pDX, IDC_PARENT_OVERLAYS, m_ctrlOverlaysList);
	DDX_Check(pDX, IDC_OVERLAY_APPLY, m_bApply);
	DDX_Check(pDX, IDC_OVERLAY_CANCEL, m_bCancel);
	DDX_Check(pDX, IDC_OVERLAY_OK, m_bOk);
	DDX_Check(pDX, IDC_OVERLAY_PERSIST, m_bPersist);
	DDX_LBString(pDX, IDC_PARENT_OVERLAYS, m_strName);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COverlayPage, CBasePage)
	//{{AFX_MSG_MAP(COverlayPage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//
// CBasePage* COverlayPage::CreateObject()
//
// Inputs           : None.
//
// Return Values    : A pointer to a new instance of the COverlayPage class.
//
// Date             : 22 November 1998
//
// Engineer         : Billy Baker
//
// Description      : CreateObject is a static member method that 
//                    creates a new instance of the COverlayPage.  
//                    Every class derived from CBasePage must 
//                    implmement CreateObject as each Widget contains a 
//                    list of pointers to the CreateObject methods that 
//                    correspond to the property pages needed for that Widget.
//
/////////////////////////////////////////////////////////////////////////////
CBasePage* COverlayPage::CreateObject()
{
    return new COverlayPage;
}

/////////////////////////////////////////////////////////////////////////////
//
// void COverlayPage::SetProperties()
//
// Inputs           : void* pWidget - a pointer to be cast to a CWidget*
//
// Return Values    : None.
//
// Date             : 22 November 1998
//
// Engineer         : Billy Baker
//
// Description      : COverlayPage::SetProperties is the standard 
//                    interface for initializing the dialog controls 
//                    with data from the CXMLWidget instance that is 
//                    associated with the CWidget instance that is 
//                    passed to the method.  Every ...::SetProperties 
//                    method does has a similar implmemenation--find 
//                    each element that is used in the property page 
//                    and for each find their attributes if there are 
//                    any.  Note: UpdateData is not called here since 
//                    SetProperties is called before Create.
//
/////////////////////////////////////////////////////////////////////////////
void COverlayPage::SetProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL)
    {
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("OPTIONS")) == true)
        {
            long int lOptions = atoi(pXMLElement->ElementValue().c_str());

            // Does it Persist?
            if ((lOptions & PERSIST) != 0)
            {
                m_bPersist = true;
            }

            // Do we show the OK button?
            if ((lOptions & OK) != 0)
            {
                m_bOk = true;
            }

            // Do we show the Cancel button?
            if ((lOptions & CANCEL) != 0)
            {
                m_bCancel = true;
            }

            // Do we show the apply button?
            if ((lOptions & APPLY) != 0)
            {
                m_bApply = true;
            }

            STRING2STRING_MAP::iterator s2sIt = NULL;
            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("NAME")) == true)
            {
                m_strName = (*s2sIt).second.c_str();;
            }
            else
            {
                m_strName = "Default_Overlay";
                pXMLElement->AddAttribute(_FSI_STL::string("NAME"),
                                          _FSI_STL::string("Default_Overlay"));
            }
        }
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void COverlayPage::UpdateProperties()
//
// Inputs           : void* pWidget - a void pointer to be case to a CWidget*
//
// Return Values    : None.
//
// Date             : 22 November 1998
//
// Engineer         : Billy Baker
//
// Description      : COverlayPage::UpdateProperties is another 
//                    standard interface method for dealing with 
//                    property pages derived from CBasePage.  When the 
//                    data from the property page needs to be applied, 
//                    the UpdateProperties method is called.  The 
//                    implementatin is similar in every CBasePage 
//                    derived class--find the elements in the 
//                    CXMLWidget that is associated with the CWidget 
//                    that is passed and update each element and any 
//                    associated attributes.
//
/////////////////////////////////////////////////////////////////////////////
void COverlayPage::UpdateProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL && GetSafeHwnd() != NULL)
    {
        UpdateData(TRUE);
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("OPTIONS")) == true)
        {
            CString strOptions;
            long int lOptions = 0;

            if (m_bPersist == TRUE)
            {
                lOptions |= PERSIST;
            }

            if (m_bOk == TRUE)
            {
                lOptions |= OK;
            }

            if (m_bCancel == TRUE)
            {
                lOptions |= CANCEL;
            }

            if (m_bApply == TRUE)
            {
                lOptions |= APPLY;
            }
            strOptions.Format("%d",lOptions);
            pXMLElement->AddElementValue(_FSI_STL::string((LPCTSTR)strOptions));

            STRING2STRING_MAP::iterator s2sIt = NULL;

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("NAME")) == true)
            {
                (*s2sIt).second = _FSI_STL::string((LPCTSTR)m_strName);
            }
        }
    }
}

BOOL COverlayPage::OnInitDialog() 
{
	CBasePage::OnInitDialog();
	
    if (m_pWidget == NULL)
    {
        return TRUE;
    }
	
    STRING_LIST& listOverlays = ((CWidget*)m_pWidget)->ParentWidget()->Overlays();
    STRING_LIST::iterator lIt = listOverlays.begin();
    STRING_LIST::iterator lendIt = listOverlays.end();
    long int lOverlaysStep = 0;
    while (lIt != lendIt)
    {
        m_ctrlOverlaysList.AddString((*lIt).c_str());
        lIt++;
        lOverlaysStep++;
    }

    m_ctrlOverlaysList.SelectString(-1, m_strName);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
