// OverlayAction.cpp: implementation of the COverlayAction class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "OverlayAction.h"

#include "..\core\OverlayDlg.h"
#include "OverlayPage.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

COverlayAction::COverlayAction()
{
    m_stlStrWidgetName = _FSI_STL::string("Display_Overlay");

    m_listWidgetPropPages.push_back(COverlayPage::CreateObject);

    m_lOptions          = OK | CANCEL | APPLY;
    m_strPage           = "Untitled.fml";
    m_strComponent      = "IOS";
    m_strSubComponent   = "PAGES";
    m_stlStrName        = "Default_Overlay";
}

COverlayAction::~COverlayAction()
{

}

void COverlayAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    if (rpXMLWidget != NULL)
    {
        ResetProperties();
    }

    m_pAction = this;
    m_pWidget = (CWidget*)this;
}

CWidget* COverlayAction::CreateObject()
{
    return new COverlayAction();
}

void COverlayAction::ResetProperties()
{
    CWidget::ResetProperties();

    // Find the OPTIONS element and get the options data.
    CXMLElement* pXMLElement = NULL;
    POSITION pos = NULL;
    if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("OPTIONS")) == true)
    {
        m_lOptions = atoi(pXMLElement->ElementValue().c_str());
        STRING2STRING_MAP::iterator s2sIt = NULL;

        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("NAME")) == true)
        {
            m_stlStrName = (*s2sIt).second;
        }
        else
        {
            pXMLElement->AddAttribute(_FSI_STL::string("NAME"),
                                      _FSI_STL::string("Default_Overlay"));
        }
    }
    else
    {
        // No element was found.  Add an OPTIONS element and set it to
        // the default options.
        CString strOptions;
        strOptions.Format("%d",m_lOptions);
        m_pXMLWidget->AddElement(_FSI_STL::string("OPTIONS"), 
                                 _FSI_STL::string((LPCTSTR)strOptions),
                                 NULL);
        pXMLElement = NULL;
        if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("OPTIONS")) == true)
        {
            pXMLElement->AddAttribute(_FSI_STL::string("NAME"),
                                      _FSI_STL::string("Default_Overlay"));
        }
    }

    pXMLElement = NULL;

    // Find the element.
    if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("LINK")) == true)
    {
        m_strPage = pXMLElement->ElementValue().c_str();
        STRING2STRING_MAP::iterator s2sIt = NULL;
        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("COMPONENT")) == true)
        {
            m_strComponent = (*s2sIt).second.c_str();
        }
        else
        {
            pXMLElement->AddAttribute(_FSI_STL::string("COMPONENT"),
                                      _FSI_STL::string("IOS"));
        }
        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SUBCOMPONENT")) == true)
        {
            m_strSubComponent = (*s2sIt).second.c_str();
        }
        else
        {
            pXMLElement->AddAttribute(_FSI_STL::string("SUBCOMPONENT"),
                                      _FSI_STL::string("PAGES"));
        }
    }
    else
    {
        // No element.  Add a new one.
        m_pXMLWidget->AddElement(_FSI_STL::string("LINK"), 
                                 _FSI_STL::string((LPCTSTR)m_strPage),
                                 NULL);
        pXMLElement = NULL;
        if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("LINK")) == true)
        {
            pXMLElement->AddAttribute(_FSI_STL::string("COMPONENT"),
                                      _FSI_STL::string("IOS"));
            pXMLElement->AddAttribute(_FSI_STL::string("SUBCOMPONENT"),
                                      _FSI_STL::string("PAGES"));
        }
    }
}

enum LButtonUpReturn COverlayAction::OnLButtonUp()
{
    // Perform widget specific LButtonUp handling.
    bool bDisplayOverlay = false;

    CVariant* pVariant = NULL;

    if (IsValidAddress(m_pParentWidget) == VALID)
    {
        pVariant = m_pParentWidget->GetValue(CString(m_stlStrName.c_str()));
    }

    if (pVariant != NULL || m_stlStrName == _FSI_STL::string("Default_Overlay"))
    {
        // An attempt may be made to display an overlay.        

        // Check to see a dialog has not been created.
        // If one has, check to see if it has been destroyed--a NULL
        // Hwnd.  If it has been destroyed, delete the memory for the
        // COverlayDlg.
        if (m_pOverlayDlg == NULL)
        {
            bDisplayOverlay = true;
        }
        else
        {
            if (m_pOverlayDlg->GetSafeHwnd() == NULL)
            {
                delete m_pOverlayDlg;
                m_pOverlayDlg = NULL;
                bDisplayOverlay = true;
            }
        }

        // Create a new dialog, set its options, set its parent Widget,
        // create the dialog, and then send a message to the main frame
        // to have it read the file for the overlay, resize it, and display
        // it if it isn't already displayed.
        if (bDisplayOverlay == true)
        {
            m_pOverlayDlg = new COverlayDlg;
            if (m_pOverlayDlg != NULL)
            {
                if (m_pOverlayDlg->GetParentFrame() != NULL)
                   m_pOverlayDlg->GetParentFrame()->BeginWaitCursor();
                ((COverlayDlg*)m_pOverlayDlg)->Options(m_lOptions);
                ((COverlayDlg*)m_pOverlayDlg)->ParentWidget(this);
                CWnd* pWnd = BaseWidget()->Wnd()->GetParent();
                ((COverlayDlg*)m_pOverlayDlg)->Create(pWnd);

                CString strPageInfo(m_strComponent + "^" + 
                                    m_strSubComponent + "^" + m_strPage);

                m_pBaseWidget->Wnd()->GetParentFrame()->SendMessage(WM_DISPLAY_OVERLAY, 
                                                                    (long)m_pOverlayDlg,
                                                                    (long)(LPCTSTR)strPageInfo);
            }
        }
    }

    return LBU_OK;
}

void COverlayAction::OnUnload()
{
    if (m_pOverlayDlg != NULL)
    {
        // Overlay has been created.
        if ((m_lOptions & PERSIST) == 0)
        {
            // Overlay is not persistent
            if (m_pOverlayDlg->GetSafeHwnd() != NULL)
            {
                // Overlay has not been closed by the user.
                m_pOverlayDlg->DestroyWindow();
            }
        }
        else
        {
            ((COverlayDlg*)m_pOverlayDlg)->ParentWidget(NULL);
        }
    }
}

