// OpenGLWidget.h: interface for the COpenGLWidget class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(_OPENGLWIDGET_H_)
#define _OPENGLWIDGET_H_

#ifdef GENERAL
#define GENERALAPI __declspec( dllexport )
#else
#define GENERALAPI __declspec( dllimport )
#endif

#include <gl\gl.h>
#include <gl\glu.h>

#include "ButtonWidget.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class GENERALAPI CPosition3D  
{
public:
	CPosition3D();
   virtual ~CPosition3D();

   double   m_latitude;
   double   m_longitude;
   float    m_altitude;
};

class GENERALAPI COpenGLWidget : public CButtonWidget  
{
public:
	COpenGLWidget();
    virtual void Setup();
    virtual void Render();

// Attributes
protected:

public:
   	enum { IDB = IDB_TEXT_WIDGET };

// Operations
public:
    virtual void InitReinit();
    virtual void Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                            const long int lId, bool bEditMode);
    virtual void ResetProperties();
    static CWidget* CreateObject();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(COpenGLWidget)
	public:
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~COpenGLWidget();

	// Generated message map functions
protected:
	//{{AFX_MSG(COpenGLWidget)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
    afx_msg void OnWindowPosChanged(WINDOWPOS FAR* lpwndpos);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

#endif // !defined(_OPENGLWIDGET_H_)
