// OpenGLWidget.cpp: implementation of the COpenGLWidget class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include <gl\gl.h>
#include "OpenGLWidget.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CPosition3D::CPosition3D()
{
   m_altitude  =  0.0f;
   m_latitude  =  0.0;
   m_longitude =  0.0;
}

CPosition3D::~CPosition3D()
{
}


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

COpenGLWidget::COpenGLWidget()
{
    m_stlStrWidgetName      = _FSI_STL::string("OpenGL");
}

void COpenGLWidget::InitReinit()
{
    m_bDrawsOpenGL = true;
}

COpenGLWidget::~COpenGLWidget()
{
}

BEGIN_MESSAGE_MAP(COpenGLWidget, CButtonWidget)
	//{{AFX_MSG_MAP(COpenGLWidget)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_WINDOWPOSCHANGED()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void COpenGLWidget::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                               const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    InitReinit();

    if (rpXMLWidget != NULL)
    {
        ResetProperties();
    }

    if (GetSafeHwnd() == NULL)
    {
        CreateEx(WS_EX_TRANSPARENT, "BUTTON","",
                   WS_CHILD | WS_VISIBLE  | WS_CLIPCHILDREN | 
                   WS_CLIPSIBLINGS | BS_OWNERDRAW, 
                   CRect(m_exPtUpperLeft, m_exPtLowerRight),
                   (CWnd*)pWnd, lId);
    }
    else
    {
        SetParent(pWnd);
        MoveWindow(m_exPtUpperLeft.X(), m_exPtUpperLeft.Y(),
                   m_exPtLowerRight.X() - m_exPtUpperLeft.X(),
                   m_exPtLowerRight.Y() - m_exPtUpperLeft.Y(), FALSE);
        ShowWindow(SW_NORMAL);
    }

    m_pWnd = this;
    m_mapValidAddresses[this] = m_pWnd->GetSafeHwnd();

    // Do OpenGL setup 
    Setup();
}

CWidget* COpenGLWidget::CreateObject()
{
    return new COpenGLWidget();
}

void COpenGLWidget::OnLButtonDown(UINT nFlags, CPoint point) 
{
    if (m_bEditing == true)
    {
        CButtonWidget::OnLButtonDown(nFlags, point);    
    }
    else
    {
        CButtonWidget::OnLButtonDown(nFlags, point);

        NMHDR nmhdr;
        nmhdr.idFrom = GetDlgCtrlID();
        nmhdr.hwndFrom = GetSafeHwnd();
        nmhdr.code = WM_LBUTTONDOWN;
        GetParent()->SendMessage(WM_NOTIFY,GetDlgCtrlID(),(long)&nmhdr);
    }
}

void COpenGLWidget::OnLButtonUp(UINT nFlags, CPoint point) 
{
    if (m_bEditing == true)
    {
    }
    else
    {
        CButtonWidget::OnLButtonUp(nFlags, point);

        CButton::OnLButtonUp(nFlags, point);
        NMHDR nmhdr;
        nmhdr.idFrom = GetDlgCtrlID();
        nmhdr.hwndFrom = GetSafeHwnd();
        nmhdr.code = WM_LBUTTONUP;
        GetParent()->SendMessage(WM_NOTIFY,GetDlgCtrlID(),(long)&nmhdr);
    }
}

void COpenGLWidget::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
    if (m_pBaseWidget != NULL)
    {
        CWnd* pWnd = m_pBaseWidget->Wnd();
        if (pWnd != NULL)
        {
            m_mapSwapNeeded[pWnd->GetParent()->GetSafeHwnd()] = true;
        }
    }

    Render();

    // Move and invalidate the children for the different states.
    if (m_bLButtonDown != m_bLButtonDownLastPass)
    {
        m_bLButtonDownLastPass = m_bLButtonDown;
        if (m_bTraverseUpdate == false)
        {
            TraverseBaseWidgets((CWidget*)this, true);
        }
    }
    else
    {
        if (m_bTraverseUpdate == false)
        {
            TraverseBaseWidgets((CWidget*)this, false);
        }
    }

    m_bTraverseUpdate = false;
}

void COpenGLWidget::ResetProperties()
{
   CButtonWidget::ResetProperties();
}

void COpenGLWidget::Setup()
{
}

void COpenGLWidget::Render()
{
}

void COpenGLWidget::OnWindowPosChanged(WINDOWPOS FAR* lpwndpos) 
{
	CButtonWidget::OnWindowPosChanged(lpwndpos);

//    if (GetSafeHwnd() != NULL && IsWindowVisible() == TRUE)
//    {
//        Setup();
//    }
}

