#if !defined(_LISTWIDGET_H_)
#define _LISTWIDGET_H_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// ListWidget.h : header file
//
#include "HeaderPage.h"

#include "..\core\Widget.h"

#include "resource.h"
/////////////////////////////////////////////////////////////////////////////
// CListWidget window

class CListWidget : public CListCtrl, public CWidget
{
// Construction
public:
	CListWidget();

// Attributes
protected:
    _FSI_STL::list<HeaderData*>         m_listHeaderData;
    _FSI_STL::list<_FSI_STL::string>    m_listEntriesToAdd;
    _FSI_STL::list<_FSI_STL::string>    m_listEntriesToAdd_cv;

public:
  	enum { IDB = IDB_BUTTON_WIDGET };

// Operations
protected:
//    BOOL TrackMouseEvent(LPTRACKMOUSEEVENT ptme);

public:
    virtual void Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                            const long int lId, bool bEditMode);
    virtual void ResetProperties();
    static CWidget* CreateObject();
    virtual void ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);
	virtual CVariant * GetValue(const CString &rstrValue);
    virtual bool UpdateRenderVariables();
    virtual void Deleting(bool bDeleting);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CListWidget)
	public:
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CListWidget();

	// Generated message map functions
protected:
	HTREEITEM GetItemByName(HWND hWnd, HTREEITEM hItem, LPCTSTR szItemName);

	//{{AFX_MSG(CListWidget)
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnWindowPosChanged(WINDOWPOS FAR* lpwndpos);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnDestroy();
	afx_msg void OnPaint();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	//}}AFX_MSG
//    afx_msg long OnMouseLeave(WPARAM wParam, LPARAM lParam);
    afx_msg void OnRClickNotify(NMHDR * pNotifyStruct, LRESULT * result);

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(_LISTWIDGET_H_)
