// ListWidget.cpp : implementation file
//

#include "..\core\stdafx.h"
#include "ListWidget.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CListWidget

CListWidget::CListWidget()
{
    m_stlStrWidgetName = _FSI_STL::string("List");
    m_exPtUpperLeft = CExtentsPoint(CPoint(0,0)); 
    m_exPtLowerRight = CExtentsPoint(CPoint(300,300));

    m_listWidgetPropPages.push_back(CHeaderPage::CreateObject);
}

CListWidget::~CListWidget()
{
    _FSI_STL::list<HeaderData*>::iterator lIt = m_listHeaderData.begin();
    _FSI_STL::list<HeaderData*>::iterator lendIt = m_listHeaderData.end();
    while (lIt != lendIt)
    {
        delete (*lIt);
        lIt++;
    }
    m_listHeaderData.clear();
}


BEGIN_MESSAGE_MAP(CListWidget, CWnd)
	//{{AFX_MSG_MAP(CListWidget)
	ON_WM_LBUTTONDBLCLK()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_SETCURSOR()
	ON_WM_WINDOWPOSCHANGED()
	ON_WM_RBUTTONUP()
	ON_WM_DESTROY()
	ON_WM_PAINT()
    ON_NOTIFY_REFLECT(NM_RCLICK, OnRClickNotify)
	ON_WM_ERASEBKGND()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CListWidget message handlers
void CListWidget::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                               const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    if (rpXMLWidget != NULL)
    {
        ResetProperties();
    }

    if (GetSafeHwnd() == NULL)
    {
        Create(WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE | LVS_OWNERDRAWFIXED | 
               LVS_REPORT | CS_OWNDC,
               CRect(m_exPtUpperLeft, m_exPtLowerRight),
               (CWnd*)pWnd, lId);
    }
    else
    {
        SetParent(pWnd);
        MoveWindow(m_exPtUpperLeft.X(), m_exPtUpperLeft.Y(),
                   m_exPtLowerRight.X() - m_exPtUpperLeft.X(),
                   m_exPtLowerRight.Y() - m_exPtUpperLeft.Y(), FALSE);
        ShowWindow(SW_NORMAL);
    }

    _FSI_STL::list<HeaderData*>::iterator lIt = m_listHeaderData.begin();
    _FSI_STL::list<HeaderData*>::iterator lendIt = m_listHeaderData.end();
    while (lIt != lendIt)
    {
        InsertColumn((*lIt)->m_ushPosition, (*lIt)->m_stlStrHeader.c_str(), 
                     LVCFMT_LEFT, (*lIt)->m_ushSize);

        lIt++;
    }

    m_pWnd = this;
    m_mapValidAddresses[this] = m_pWnd->GetSafeHwnd();
}

CWidget* CListWidget::CreateObject()
{
    return new CListWidget();
}

void CListWidget::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
    if (pCV == NULL || IsValidAddress(this) != VALID)
    {
        return;
    }

    if (rstrElementVar == "Default")
    {
        m_listEntriesToAdd_cv.push_back((_FSI_STL::string)*(pCV->Variant()));
    }
    else
    {
        CWidget::ChangeValue(rstrElementVar, pCV);
    }
/*
    HTREEITEM hTreeSel = m_tree.GetSelectedItem();
    HTREEITEM hItem = GetItemByName(m_tree.GetSafeHwnd(), NULL, 
                                    ((_FSI_STL::string)*(pCV->Variant())).c_str());

    if (hItem == NULL)
   {
        if (hTreeSel != NULL)
        {
            m_tree.InsertItem(((_FSI_STL::string)*(pCV->Variant())).c_str(), 0, 0, hTreeSel);
        }
        else
        {
            m_tree.InsertItem(((_FSI_STL::string)*(pCV->Variant())).c_str(),0,0);
        }
    }
*/
}

CVariant* CListWidget::GetValue(const CString &rstrValue)
{
/*
    HTREEITEM hTreeSel = m_tree.GetSelectedItem();
    if (hTreeSel != NULL)
    {
        CString strSel = m_tree.GetItemText(hTreeSel, 0);

        m_variant.Value(_FSI_STL::string((LPCTSTR)strSel));
    }
    else
    {
        m_variant.Value(_FSI_STL::string(""));
    }
*/
    return &m_variant;
}

void CListWidget::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	OnLButtonDown(nFlags, point);
}


void CListWidget::OnLButtonDown(UINT nFlags, CPoint point) 
{
    if (m_bEditing == true)
    {
        CWidget::Track(point);
    }
    else
    {
        if (m_bFocus != true)
        {
	        m_bFocus = true;
            m_bRedraw = true;
        }

        if (nFlags & MK_LBUTTON)
        {
            if (m_bLButtonDown != true)
            {
                m_bRedraw = true;
                m_bLButtonDown = true;
            }
        }
        else
        {
            if (m_bLButtonDown != false)
            {
                m_bRedraw = true;
                m_bLButtonDown = false;
            }
        }
    }
}

void CListWidget::OnLButtonUp(UINT nFlags, CPoint point) 
{
    if (m_bEditing == true)
    {
    }
    else
    {
        if (m_bFocus != true)
        {
	        m_bFocus = true;
            m_bRedraw = true;
        }

        if (m_bLButtonDown != false)
        {
            m_bRedraw = true;
            m_bLButtonDown = false;
        }

        if (m_bEditing == false)
        {
            _FSI_STL::list<CAction*>::iterator lIt = m_listActions.begin();
            _FSI_STL::list<CAction*>::iterator lendIt = m_listActions.end();
            while (lIt != lendIt)
            {
                (*lIt)->OnLButtonUp();
                lIt++;
            }
        }
    }
}

void CListWidget::OnRButtonUp(UINT nFlags, CPoint point) 
{
	CWidget::RButtonUp(nFlags, point);
}

BOOL CListWidget::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
    if (m_bEditing == true && m_pTracker != NULL)
    {
        if (pWnd == this && m_pTracker->SetCursor(pWnd, nHitTest))
        {
            return TRUE;
        }
    }
	
	return CListCtrl::OnSetCursor(pWnd, nHitTest, message);
}


void CListWidget::OnWindowPosChanged(WINDOWPOS* lpwndpos) 
{
    CWidget::PosChanged(CRect(lpwndpos->x, lpwndpos->y,
                              lpwndpos->x + lpwndpos->cx,
                              lpwndpos->y + lpwndpos->cy));
}

void CListWidget::ResetProperties()
{
    CWidget::ResetProperties();
    CWidget::ExtentsProperties();

    CXMLElement* pXMLElement = NULL;
    POSITION pos = NULL;

    _FSI_STL::list<HeaderData*>::iterator lIt = m_listHeaderData.begin();
    _FSI_STL::list<HeaderData*>::iterator lendIt = m_listHeaderData.end();
    while (lIt != lendIt)
    {
        delete (*lIt);
        lIt++;
    }
    m_listHeaderData.clear();

    while (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("HEADER")) == true)
    {
        HeaderData* pData = new HeaderData;

        pData->m_stlStrHeader = pXMLElement->ElementValue();

        STRING2STRING_MAP::iterator s2sIt = NULL;
        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("POSITION")) == true)
        {
            pData->m_ushPosition = (unsigned short)atoi((*s2sIt).second.c_str());
        }
        else
        {
            pXMLElement->AddAttribute(_FSI_STL::string("POSITION"),
                                      _FSI_STL::string("0"));
        }

        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SIZE")) == true)
        {
            pData->m_ushSize = (unsigned short)atoi((*s2sIt).second.c_str());
        }
        else
        {
            pXMLElement->AddAttribute(_FSI_STL::string("SIZE"),
                                  _FSI_STL::string("100"));
        }
        m_listHeaderData.push_back(pData);
    }

    if (m_listHeaderData.size() == 0)
    {
        // No element was found.  
        CString strValue;
        m_pXMLWidget->AddElement(_FSI_STL::string("HEADER"), 
                                 _FSI_STL::string("Blank"),
                                 NULL);
        pXMLElement = NULL;
        if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("HEADER")) == true)
        {
            strValue.Format("%d",0);
            pXMLElement->AddAttribute(_FSI_STL::string("POSITION"),
                                  _FSI_STL::string((LPCTSTR)strValue));
            strValue.Format("%d",100);
            pXMLElement->AddAttribute(_FSI_STL::string("SIZE"),
                                  _FSI_STL::string((LPCTSTR)strValue));
        }
    }

    if (GetSafeHwnd() != NULL)
    {
        long lId = GetDlgCtrlID();
        CWnd* pWnd = GetParent();
        DestroyWindow();

        Create(WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE | LVS_OWNERDRAWFIXED | 
               LVS_REPORT | CS_OWNDC,
               CRect(m_exPtUpperLeft, m_exPtLowerRight),
               (CWnd*)pWnd, lId);

        m_mapValidAddresses[this] = m_pWnd->GetSafeHwnd();

        _FSI_STL::list<HeaderData*>::iterator lIt = m_listHeaderData.begin();
        _FSI_STL::list<HeaderData*>::iterator lendIt = m_listHeaderData.end();
        while (lIt != lendIt)
        {
            InsertColumn((*lIt)->m_ushPosition, (*lIt)->m_stlStrHeader.c_str(), 
                                LVCFMT_LEFT, (*lIt)->m_ushSize);
            lIt++;
        }
    }

}
/*
HTREEITEM CListWidget::GetItemByName(HWND hWnd, HTREEITEM hItem, LPCTSTR szItemName)
{
    // If hItem is NULL, start search from root item.
    if (hItem == NULL)
    {
        hItem = m_tree.GetNextItem(TVGN_ROOT, 0);
    }

    while (hItem != NULL)
    {
        CString strBuffer;
        TV_ITEM item;

        item.hItem = hItem;
        item.mask = TVIF_CHILDREN | TVIF_PARAM;
        m_tree.GetItem(&item);

        // Did we find it?
        if (item.lParam != NULL)
        {
            CTLItem* tlItem = (CTLItem*)item.lParam;
            strBuffer = tlItem->GetItemString();
            if (strBuffer == CString(szItemName))
            {
                return hItem;
            }
        }


        // Check whether we have child items.
        if (item.cChildren)
        {
            // Recursively traverse child items.
            HTREEITEM hItemFound, hItemChild;

            hItemChild = m_tree.GetNextItem(hItem, TVGN_CHILD);

            hItemFound = GetItemByName(hWnd, hItemChild, szItemName);

            // Did we find it?
            if (hItemFound != NULL)
                return hItemFound;
        }

        // Go to next sibling item.
        hItem = m_tree.GetNextItem(hItem, TVGN_NEXT);
    }

    // Not found.
    return NULL;
} 
*/

void CListWidget::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
    CDC* pDC = CDC::FromHandle(lpDrawItemStruct->hDC);
    CRect rcItem(lpDrawItemStruct->rcItem);
    int nItem = lpDrawItemStruct->itemID;
    CImageList* pImageList;

    // Save dc state
    int nSavedDC = pDC->SaveDC();

    // Get item image and state info
    LV_ITEM lvi;
    lvi.mask = LVIF_IMAGE | LVIF_STATE;
    lvi.iItem = nItem;
    lvi.iSubItem = 0;
    lvi.stateMask = 0xFFFF;         // get all state flags
    GetItem(&lvi);

    // Should the item be highlighted
    BOOL bHighlight =((lvi.state & LVIS_DROPHILITED)
                            || ( (lvi.state & LVIS_SELECTED)
                                    && ((GetFocus() == this)
                                            || (GetStyle() & LVS_SHOWSELALWAYS)
                                            )
                                    )
                            );


    // Get rectangles for drawing
    CRect rcBounds, rcLabel, rcIcon;
    GetItemRect(nItem, rcBounds, LVIR_BOUNDS);
    GetItemRect(nItem, rcLabel, LVIR_LABEL);
    GetItemRect(nItem, rcIcon, LVIR_ICON);
    CRect rcCol( rcBounds ); 



    CString sLabel = GetItemText( nItem, 0 );

    // Labels are offset by a certain amount  
    // This offset is related to the width of a space character
    int offset = pDC->GetTextExtent(_T(" "), 1 ).cx*2;

    CRect rcHighlight;
    CRect rcWnd;
/*
    int nExt;

    switch( m_nHighlight )
    {
    case 0: 
            nExt = pDC->GetOutputTextExtent(sLabel).cx + offset;
            rcHighlight = rcLabel;
            if( rcLabel.left + nExt < rcLabel.right )
                    rcHighlight.right = rcLabel.left + nExt;
            break;
    case 1:
            rcHighlight = rcBounds;
            rcHighlight.left = rcLabel.left;
            break;
    case 2:
            GetClientRect(&rcWnd);
            rcHighlight = rcBounds;
            rcHighlight.left = rcLabel.left;
            rcHighlight.right = rcWnd.right;
            break;
    default:
            rcHighlight = rcLabel;
    }
*/
    // Draw the background color
//    if( bHighlight )
//    {
//            pDC->SetTextColor(::GetSysColor(COLOR_HIGHLIGHTTEXT));
//            pDC->SetBkColor(::GetSysColor(COLOR_HIGHLIGHT));

//            pDC->FillRect(rcHighlight, &CBrush(::GetSysColor(COLOR_HIGHLIGHT)));
//    }
//    else
//            pDC->FillRect(rcHighlight, &CBrush(::GetSysColor(COLOR_WINDOW)));
            pDC->FillSolidRect(rcHighlight,GetSysColor(COLOR_WINDOW));

    

    // Set clip region
    rcCol.right = rcCol.left + GetColumnWidth(0);
    CRgn rgn;
    rgn.CreateRectRgnIndirect(&rcCol);
    pDC->SelectClipRgn(&rgn);
    rgn.DeleteObject();

    // Draw state icon
    if (lvi.state & LVIS_STATEIMAGEMASK)
    {
            int nImage = ((lvi.state & LVIS_STATEIMAGEMASK)>>12) - 1;
            pImageList = GetImageList(LVSIL_STATE);
            if (pImageList)
            {
                    pImageList->Draw(pDC, nImage,
                            CPoint(rcCol.left, rcCol.top), ILD_TRANSPARENT);
            }
    }
    
    // Draw normal and overlay icon
    pImageList = GetImageList(LVSIL_SMALL);
    if (pImageList)
    {
            UINT nOvlImageMask=lvi.state & LVIS_OVERLAYMASK;
            pImageList->Draw(pDC, lvi.iImage, 
                    CPoint(rcIcon.left, rcIcon.top),
                    (bHighlight?ILD_BLEND50:0) | ILD_TRANSPARENT | nOvlImageMask );
    }

    
    
    // Draw item label - Column 0
    rcLabel.left += offset/2;
    rcLabel.right -= offset;

    pDC->DrawText(sLabel,-1,rcLabel,DT_LEFT | DT_SINGLELINE | DT_NOPREFIX | DT_NOCLIP 
                            | DT_VCENTER | DT_END_ELLIPSIS);


    // Draw labels for remaining columns
    LV_COLUMN lvc;
    lvc.mask = LVCF_FMT | LVCF_WIDTH;
/*
    if( m_nHighlight == 0 )         // Highlight only first column
    {
            pDC->SetTextColor(::GetSysColor(COLOR_WINDOWTEXT));
            pDC->SetBkColor(::GetSysColor(COLOR_WINDOW));
    }
*/  
    rcBounds.right = rcHighlight.right > rcBounds.right ? rcHighlight.right :
                                                    rcBounds.right;
    rgn.CreateRectRgnIndirect(&rcBounds);
    pDC->SelectClipRgn(&rgn);
           
    int nColumn = 1; 
    while (GetColumn(nColumn, &lvc))
    {
        rcCol.left = rcCol.right;
        rcCol.right += lvc.cx;

        // Draw the background if needed
//        if( m_nHighlight == HIGHLIGHT_NORMAL )
//                pDC->FillRect(rcCol, &CBrush(::GetSysColor(COLOR_WINDOW)));

        sLabel = GetItemText(nItem, nColumn);
        if (sLabel.GetLength() == 0)
                continue;

        // Get the text justification
        UINT nJustify = DT_LEFT;
        switch(lvc.fmt & LVCFMT_JUSTIFYMASK)
        {
        case LVCFMT_RIGHT:
                nJustify = DT_RIGHT;
                break;
        case LVCFMT_CENTER:
                nJustify = DT_CENTER;
                break;
        default:
                break;
        }

        rcLabel = rcCol;
        rcLabel.left += offset;
        rcLabel.right -= offset;

        pDC->DrawText(sLabel, -1, rcLabel, nJustify | DT_SINGLELINE | 
                                DT_NOPREFIX | DT_VCENTER | DT_END_ELLIPSIS);

        nColumn++;
    }

    // Draw focus rectangle if item has focus
    if (lvi.state & LVIS_FOCUSED && (GetFocus() == this))
            pDC->DrawFocusRect(rcHighlight);

    
    // Restore dc
    pDC->RestoreDC( nSavedDC );
}

void CListWidget::OnRClickNotify(NMHDR * pNotifyStruct, LRESULT * result)
{
    if (m_bEditing == true)
    {
        OnRButtonUp(0, CPoint(15, 15));
    }

    *result = 0;
}

BOOL CListWidget::PreCreateWindow(CREATESTRUCT& cs) 
{
    cs.dwExStyle |= WS_EX_CLIENTEDGE;
	
	return CWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CListWidget::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : status of whether the update was successful
//
// Date             : 16 July 1999
//
// Engineer         : Billy Baker
//
// Description      : CListWidget::UpdateRenderVariables() is an 
//                    override of a common framework method.  It is 
//                    called before any scheduled redraw of the list widget. 
//
/////////////////////////////////////////////////////////////////////////////
bool CListWidget::UpdateRenderVariables()
{
    bool bRetVal = CWidget::UpdateRenderVariables();

    if (bRetVal == true)
    {
        m_listEntriesToAdd = m_listEntriesToAdd_cv;

        m_listEntriesToAdd_cv.clear();
    }


    return bRetVal;
}


void CListWidget::Deleting(bool bDeleting)
{
    CWidget::Deleting(bDeleting);
}

void CListWidget::OnDestroy() 
{
	CWnd::OnDestroy();
	
	// TODO: Add your message handler code here
	
}

void CListWidget::OnPaint() 
{
    _FSI_STL::list<_FSI_STL::string>::iterator lIt = 
                                                m_listEntriesToAdd.begin();
    _FSI_STL::list<_FSI_STL::string>::iterator lendIt = 
                                                m_listEntriesToAdd.end();

    SetRedraw(false);
    while (lIt != lendIt)
    {
        if (IsValidAddress(this) == VALID)
        {
            if (GetSafeHwnd() != NULL)
            {
                InsertItem(GetItemCount(), (*lIt).c_str());
            }
        }

        lIt++;
    }

    m_listEntriesToAdd.clear();

    SetItemState(GetItemCount() - 1, LVIS_SELECTED | LVIS_FOCUSED, LVIS_SELECTED | LVIS_FOCUSED);
    EnsureVisible(GetItemCount() - 1, FALSE);
    SetRedraw(true);

    CPaintDC dc(this);

    CDC dcMem;
    dcMem.CreateCompatibleDC(&dc);

    CRect rectClient;
    GetClientRect(rectClient);

    CBitmap bm;
    bm.CreateCompatibleBitmap(&dc, rectClient.Width(), rectClient.Height());

//    CBitmap* pOldBitmap = dcMem.SelectObject(&bm);

    CBrush brushBackground(::GetSysColor(COLOR_WINDOW));
//    pDC->FillRect(r,&brushBackground);

//    CWnd::DefWindowProc(WM_PAINT, (WPARAM)dcMem.GetSafeHdc(), 0);

//    dc.BitBlt(0, 0, rectClient.Width(), rectClient.Height(), &dcMem, 0, 0, SRCCOPY);


	// Do not call CWnd::OnPaint() for painting messages

//    CListCtrl::OnPaint();
}

BOOL CListWidget::OnEraseBkgnd(CDC* pDC) 
{
	return TRUE; //CWnd::OnEraseBkgnd(pDC);
}
