// ImageWidget.cpp : implementation file
//

#include "..\core\stdafx.h"
#include "ImageWidget.h"

#include "..\core\dib.h"
#include "..\core\LinkPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CImageWidget

CImageWidget::CImageWidget()
{
    m_stlStrWidgetName = _FSI_STL::string("Image");

    m_listWidgetPropPages.push_back(CLinkPage::CreateObject);

    // Must be set once for InitReinit() to work correctly.
    m_pDib          = NULL;

    CImageWidget::InitReinit();
}

void CImageWidget::InitReinit()
{
    if (m_pDib != NULL)
    {
        m_pDib->DeleteObject();
        delete m_pDib;
    }

    m_bFileLoaded       = FALSE;
    m_pDib              = NULL;
    m_strImage          = "Untitled.bmp";
    m_strComponent      = "IOS";
    m_strSubComponent   = "PAGES";
}

CImageWidget::~CImageWidget()
{
    if (m_pDib != NULL)
    {
        m_pDib->DeleteObject();
        delete m_pDib;
    }
}


BEGIN_MESSAGE_MAP(CImageWidget, CButtonWidget)
	//{{AFX_MSG_MAP(CImageWidget)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CImageWidget message handlers
void CImageWidget::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                               const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    CImageWidget::InitReinit();

    if (rpXMLWidget != NULL)
    {
        ResetProperties();
    }

    if (GetSafeHwnd() == NULL)
    {
        Create(NULL,
            WS_CHILD | WS_VISIBLE  | BS_OWNERDRAW | CS_OWNDC, 
                 CRect(m_exPtUpperLeft, m_exPtLowerRight),
                 (CWnd*)pWnd, lId);
    }
    else
    {
        SetParent(pWnd);
        MoveWindow(m_exPtUpperLeft.X(), m_exPtUpperLeft.Y(),
                   m_exPtLowerRight.X() - m_exPtUpperLeft.X(),
                   m_exPtLowerRight.Y() - m_exPtUpperLeft.Y(), FALSE);
        ShowWindow(SW_NORMAL);
    }

    m_pWnd = this;
    m_mapValidAddresses[this] = m_pWnd->GetSafeHwnd();
}

CWidget* CImageWidget::CreateObject()
{
    return new CImageWidget();
}

void CImageWidget::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	// TODO: Add your code to draw the specified item
    CRect rect(&(lpDrawItemStruct->rcItem));
    CDC *pDC = CDC::FromHandle(lpDrawItemStruct->hDC);

    pDC->SetBkMode(TRANSPARENT);

    if (m_pDib != NULL && m_bFileLoaded == TRUE)
    {
        m_pDib->Draw(*pDC, &rect, NULL);
    }
    else
    {
        pDC->Rectangle(rect);
        pDC->DrawText("Image", 5, rect, DT_CENTER | DT_VCENTER | DT_SINGLELINE);
    }

    // Move and invalidate the children for the different states.
    if (m_bLButtonDown != m_bLButtonDownLastPass)
    {
        m_bLButtonDownLastPass = m_bLButtonDown;
        if (m_bTraverseUpdate == false)
        {
            TraverseBaseWidgets((CWidget*)this, true);
        }
    }
    else
    {
        if (m_bTraverseUpdate == false)
        {
            TraverseBaseWidgets((CWidget*)this, false);
        }
    }

    m_bTraverseUpdate = false;
}

void CImageWidget::ResetProperties()
{
    CWidget::ResetProperties();
    CWidget::ExtentsProperties();

    CXMLElement* pXMLElement = NULL;
    POSITION pos = NULL;

    // Find the element.
    if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("LINK")) == true)
    {
        m_strImage = pXMLElement->ElementValue().c_str();
        STRING2STRING_MAP::iterator s2sIt = NULL;
        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("COMPONENT")) == true)
        {
            m_strComponent = (*s2sIt).second.c_str();
        }
        else
        {
            pXMLElement->AddAttribute(_FSI_STL::string("COMPONENT"),
                                      _FSI_STL::string("IOS"));
        }

        if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SUBCOMPONENT")) == true)
        {
            m_strSubComponent = (*s2sIt).second.c_str();
        }
        else
        {
            pXMLElement->AddAttribute(_FSI_STL::string("SUBCOMPONENT"),
                                      _FSI_STL::string("PAGES"));
        }
    }
    else
    {
        // No element.  Add a new one.
        m_pXMLWidget->AddElement(_FSI_STL::string("LINK"), 
                                 _FSI_STL::string((LPCTSTR)m_strImage),
                                 NULL);
        pXMLElement = NULL;
        if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("LINK")) == true)
        {
            pXMLElement->AddAttribute(_FSI_STL::string("COMPONENT"),
                                      _FSI_STL::string("IOS"));
            pXMLElement->AddAttribute(_FSI_STL::string("SUBCOMPONENT"),
                                      _FSI_STL::string("PAGES"));
        }
    }

    if (m_pDib != NULL)
    {
        m_pDib->DeleteObject();
        delete m_pDib;
    }
    m_pDib = new CDib;
    CString strFileName(m_strComponent + "^" + m_strSubComponent + "^" + 
                        m_strImage);

    ExpandPath(strFileName);

    if (m_pDib != NULL)
    {
        m_bFileLoaded = m_pDib->Load(strFileName);
    }
}

void CImageWidget::OnLButtonDown(UINT nFlags, CPoint point) 
{
    if (m_bEditing == true)
    {
        CButtonWidget::OnLButtonDown(nFlags, point);    
    }
    else
    {
        CButtonWidget::OnLButtonDown(nFlags, point);

        NMHDR nmhdr;
        nmhdr.idFrom = GetDlgCtrlID();
        nmhdr.hwndFrom = GetSafeHwnd();
        nmhdr.code = WM_LBUTTONDOWN;
        GetParent()->SendMessage(WM_NOTIFY,GetDlgCtrlID(),(long)&nmhdr);
    }
}

void CImageWidget::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
    if (m_bEditing == true)
    {
    }
    else
    {
        CButtonWidget::OnLButtonUp(nFlags, point);

        CButton::OnLButtonUp(nFlags, point);
        NMHDR nmhdr;
        nmhdr.idFrom = GetDlgCtrlID();
        nmhdr.hwndFrom = GetSafeHwnd();
        nmhdr.code = WM_LBUTTONUP;
        GetParent()->SendMessage(WM_NOTIFY,GetDlgCtrlID(),(long)&nmhdr);
    }
}

