// HeaderPage.h: interface for the CHeaderPage class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(_HEADERPAGE_H_)
#define _HEADERPAGE_H_

#include "resource.h"

#include "..\core\BasePage.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

struct HeaderData
{
    unsigned short      m_ushPosition;
    unsigned short      m_ushSize;
    _FSI_STL::string         m_stlStrHeader;
};

class CHeaderPage : public CBasePage  
{
private:
    _FSI_STL::list<HeaderData*>      m_listHeaderData;

public:
	CHeaderPage();
	virtual ~CHeaderPage();
    static CBasePage* CreateObject();

// Dialog Data
	//{{AFX_DATA(CHeaderPage)
	enum { IDD = IDD_GENERAL_PAGE_TREE_HEADER };
	CListCtrl	m_ctrlHeaderList;
	CString	m_strHeading;
	long	m_lHeaderSize;
	long	m_lHeaderPos;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CHeaderPage)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CHeaderPage)
	afx_msg void OnAddHeader();
	afx_msg void OnChangeHeader();
	afx_msg void OnDeleteHeader();
	virtual BOOL OnInitDialog();
	afx_msg void OnClickHeaderList(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

    virtual void SetProperties(void* pWidget);
    virtual void UpdateProperties(void* pWidget);
};

#endif // !defined(_HEADERPAGE_H_)
