// HeaderPage.cpp: implementation of the CHeaderPage class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "HeaderPage.h"

#include "..\core\widget.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CHeaderPage::CHeaderPage() : CBasePage(CHeaderPage::IDD)
{
	//{{AFX_DATA_INIT(CHeaderPage)
    m_strHeading = "";
	m_lHeaderSize = 0;
	m_lHeaderPos = 0;
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Headers");
}

CHeaderPage::~CHeaderPage()
{
    _FSI_STL::list<HeaderData*>::iterator lIt = m_listHeaderData.begin();
    _FSI_STL::list<HeaderData*>::iterator lendIt = m_listHeaderData.end();
    while (lIt != lendIt)
    {
        delete (*lIt);
        lIt++;
    }
    m_listHeaderData.clear();
}

void CHeaderPage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHeaderPage)
	DDX_Control(pDX, IDC_HEADER_LIST, m_ctrlHeaderList);
	DDX_Text(pDX, IDC_HEADING, m_strHeading);
	DDX_Text(pDX, IDC_HEADER_SIZE, m_lHeaderSize);
	DDX_Text(pDX, IDC_HEADER_POSITION, m_lHeaderPos);
	DDV_MinMaxLong(pDX, m_lHeaderPos, 0, 100);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CHeaderPage, CBasePage)
	//{{AFX_MSG_MAP(CHeaderPage)
	ON_BN_CLICKED(IDC_ADD_HEADER_BUTTON, OnAddHeader)
	ON_BN_CLICKED(IDC_CHANGE_HEADER_BUTTON, OnChangeHeader)
	ON_BN_CLICKED(IDC_DELETE_HEADER_BUTTON, OnDeleteHeader)
	ON_NOTIFY(NM_CLICK, IDC_HEADER_LIST, OnClickHeaderList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//
// CBasePage* CHeaderPage::CreateObject()
//
// Inputs           : None.
//
// Return Values    : A pointer to a new instance of the CHeaderPage class.
//
// Date             : 22 November 1998
//
// Engineer         : Billy Baker
//
// Description      : CreateObject is a static member method that 
//                    creates a new instance of the CHeaderPage.  
//                    Every class derived from CBasePage must 
//                    implmement CreateObject as each Widget contains a 
//                    list of pointers to the CreateObject methods that 
//                    correspond to the property pages needed for that Widget.
//
/////////////////////////////////////////////////////////////////////////////
CBasePage* CHeaderPage::CreateObject()
{
    return new CHeaderPage;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CHeaderPage::SetProperties()
//
// Inputs           : void* pWidget - a pointer to be cast to a CWidget*
//
// Return Values    : None.
//
// Date             : 29 January 1999
//
// Engineer         : Billy Baker
//
// Description      : CHeaderPage::SetProperties is the standard 
//                    interface for initializing the dialog controls 
//                    with data from the CXMLWidget instance that is 
//                    associated with the CWidget instance that is 
//                    passed to the method.  Every ...::SetProperties 
//                    method does has a similar implmemenation--find 
//                    each element that is used in the property page 
//                    and for each find their attributes if there are 
//                    any.  Note: UpdateData is not called here since 
//                    SetProperties is called before Create.
//
/////////////////////////////////////////////////////////////////////////////
void CHeaderPage::SetProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL)
    {
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        while (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("HEADER")) == true)
        {
            HeaderData* pData = new HeaderData;

            pData->m_stlStrHeader = pXMLElement->ElementValue();

            STRING2STRING_MAP::iterator s2sIt = NULL;
            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("POSITION")) == true)
            {
                pData->m_ushPosition = (unsigned short)atoi((*s2sIt).second.c_str());
            }
            else
            {
                pXMLElement->AddAttribute(_FSI_STL::string("POSITION"),
                                          _FSI_STL::string("0"));
            }

            if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SIZE")) == true)
            {
                pData->m_ushSize = (unsigned short)atoi((*s2sIt).second.c_str());
            }
            else
            {
                pXMLElement->AddAttribute(_FSI_STL::string("SIZE"),
                                      _FSI_STL::string("100"));
            }
            m_listHeaderData.push_back(pData);
        }
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CHeaderPage::UpdateProperties()
//
// Inputs           : void* pWidget - a void pointer to be case to a CWidget*
//
// Return Values    : None.
//
// Date             : 29 January 1999
//
// Engineer         : Billy Baker
//
// Description      : CHeaderPage::UpdateProperties is another 
//                    standard interface method for dealing with 
//                    property pages derived from CBasePage.  When the 
//                    data from the property page needs to be applied, 
//                    the UpdateProperties method is called.  The 
//                    implementatin is similar in every CBasePage 
//                    derived class--find the elements in the 
//                    CXMLWidget that is associated with the CWidget 
//                    that is passed and update each element and any 
//                    associated attributes.
//
/////////////////////////////////////////////////////////////////////////////
void CHeaderPage::UpdateProperties(void* pWidget)
{
    CXMLWidget* pXMLWidget = ((CWidget*)pWidget)->XMLWidget();
    if (pXMLWidget != NULL && GetSafeHwnd() != NULL)
    {
        UpdateData(TRUE);
        long int lHeaderCount = m_ctrlHeaderList.GetItemCount();
        long int lHeaderStep = 0;

        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;

        // Erase all of the "HEADER" elements.
        while (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("HEADER")) == true)
        {
            pXMLWidget->DeleteItem(pXMLElement);
            pXMLElement = NULL;
        }

        while (lHeaderStep < lHeaderCount)
        {
            _FSI_STL::string stlStrValue((LPCTSTR)m_ctrlHeaderList.GetItemText(lHeaderStep,0));

            pXMLWidget->AddElement(_FSI_STL::string("HEADER"), stlStrValue, 
                                   NULL);
            lHeaderStep++;
        }

        pXMLElement = NULL;
        lHeaderStep = 0;
        CString strValue;
        STRING2STRING_MAP::iterator s2sIt;
        while (lHeaderStep < lHeaderCount)
        {
            if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("HEADER")) == true)
            {
                _FSI_STL::string stlStrValue((LPCTSTR)m_ctrlHeaderList.GetItemText(lHeaderStep,0));

                s2sIt = NULL;
                pXMLElement->AddElementValue(stlStrValue);
                if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("POSITION")) == true)
                {
                    (*s2sIt).second = 
                        _FSI_STL::string((LPCTSTR)m_ctrlHeaderList.GetItemText(lHeaderStep,1));
                }
                else
                {
                    strValue = m_ctrlHeaderList.GetItemText(lHeaderStep,
                                                                             1);
                    pXMLElement->AddAttribute(_FSI_STL::string("POSITION"),
                                              _FSI_STL::string((LPCTSTR)strValue));
                }

                if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SIZE")) == true)
                {
                    (*s2sIt).second = 
                        _FSI_STL::string((LPCTSTR)m_ctrlHeaderList.GetItemText(lHeaderStep,2));
                }
                else
                {
                    strValue = m_ctrlHeaderList.GetItemText(lHeaderStep,
                                                                             2);
                    pXMLElement->AddAttribute(_FSI_STL::string("SIZE"), 
                                              _FSI_STL::string((LPCTSTR)strValue));
                }
            }

            lHeaderStep++;
        }
    }
}

void CHeaderPage::OnAddHeader() 
{
	// TODO: Add your control notification handler code here
    UpdateData(TRUE);
    
    if (m_strHeading.GetLength() > 0)
    {
        LVFINDINFO lvfi;
        lvfi.flags = LVFI_STRING;

        lvfi.psz = (LPCTSTR)m_strHeading;
        if (m_ctrlHeaderList.FindItem(&lvfi,-1) == -1)
        {
            long int lItemCount = m_ctrlHeaderList.GetItemCount();
            lItemCount = m_ctrlHeaderList.InsertItem(lItemCount, 
                                                     (LPCTSTR)m_strHeading);

            CString strValue;
            strValue.Format("%d",m_lHeaderPos);
            m_ctrlHeaderList.SetItemText(lItemCount, 1, (LPCTSTR)strValue);
            strValue.Format("%d",m_lHeaderSize);
            m_ctrlHeaderList.SetItemText(lItemCount, 2, (LPCTSTR)strValue);
        }
        else
        {
            ::MessageBox(GetSafeHwnd(), 
                         _T("Duplicate string encountered for heading."),
                         _T("Error"), 
                         MB_OK);
        }
    }
    else
    {
        ::MessageBox(GetSafeHwnd(),
                     _T("Null string encountered for heading."),
                     _T("Error"),
                     MB_OK);
    }
}

void CHeaderPage::OnChangeHeader()
{
    UpdateData(TRUE);

    if (m_strHeading.GetLength() > 0)
    {
        LVFINDINFO lvfi;
        lvfi.flags = LVFI_STRING;
        lvfi.psz = (LPCTSTR)m_strHeading;
        long int lHeaderIndex = m_ctrlHeaderList.FindItem(&lvfi,-1);
        if (lHeaderIndex > -1)
        {
            CString strValue;
            strValue.Format("%d",m_lHeaderPos);
            m_ctrlHeaderList.SetItemText(lHeaderIndex, 1, (LPCTSTR)strValue);
            strValue.Format("%d",m_lHeaderSize);
            m_ctrlHeaderList.SetItemText(lHeaderIndex, 2, (LPCTSTR)strValue);
        }
        else
        {
            ::MessageBox(GetSafeHwnd(), 
                         _T("Header could not be found to change."),
                         _T("Error"), 
                         MB_OK);
            return;
        }
    }
    else
    {
        ::MessageBox(GetSafeHwnd(),
                     _T("Null string encountered for Header."),
                     _T("Error"),
                     MB_OK);
    }
}

void CHeaderPage::OnDeleteHeader() 
{
	// TODO: Add your control notification handler code here
    UpdateData(TRUE);

    if (m_strHeading.GetLength() > 0)
    {
        LVFINDINFO lvfi;
        lvfi.flags = LVFI_STRING;
        lvfi.psz = (LPCTSTR)m_strHeading;
        long int lHeaderIndex = m_ctrlHeaderList.FindItem(&lvfi,-1);
        if (lHeaderIndex > -1)
        {
            m_ctrlHeaderList.DeleteItem(lHeaderIndex);
        }
        else
        {
            ::MessageBox(GetSafeHwnd(), 
                         _T("Header could not be found to delete."),
                         _T("Error"), 
                         MB_OK);
            return;
        }
    }
    else
    {
        ::MessageBox(GetSafeHwnd(),
                     _T("Null string encountered for Header."),
                     _T("Error"),
                     MB_OK);
    }
}

BOOL CHeaderPage::OnInitDialog() 
{
	CBasePage::OnInitDialog();
	
	// TODO: Add extra initialization here
    m_ctrlHeaderList.SetExtendedStyle(m_ctrlHeaderList.GetExtendedStyle() & 
                                  LVS_EX_FULLROWSELECT);

    m_ctrlHeaderList.InsertColumn(0,"Heading", LVCFMT_LEFT, 185);
    m_ctrlHeaderList.InsertColumn(1,"Position", LVCFMT_LEFT, 50);
    m_ctrlHeaderList.InsertColumn(2,"Size", LVCFMT_LEFT, 50);
	
	// TODO: Add extra initialization here
    _FSI_STL::list<HeaderData*>::iterator lIt = m_listHeaderData.begin();
    _FSI_STL::list<HeaderData*>::iterator lendIt = m_listHeaderData.end();
    long int lHeaderStep = 0;
    CString strValue;

    while (lIt != lendIt)
    {
        m_ctrlHeaderList.InsertItem(lHeaderStep, 
                                    (*lIt)->m_stlStrHeader.c_str());
        strValue.Format("%d",(*lIt)->m_ushPosition);
        m_ctrlHeaderList.SetItemText(lHeaderStep, 1, (LPCTSTR)strValue);
        strValue.Format("%d",(*lIt)->m_ushSize);
        m_ctrlHeaderList.SetItemText(lHeaderStep, 2, (LPCTSTR)strValue);

        lIt++;
        lHeaderStep++;
    }

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CHeaderPage::OnClickHeaderList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
    POSITION pos = m_ctrlHeaderList.GetFirstSelectedItemPosition();
    if (pos != NULL)
    {
        long int lSelectedIndex = m_ctrlHeaderList.GetNextSelectedItem(pos);
        m_strHeading = m_ctrlHeaderList.GetItemText(lSelectedIndex, 0);

        m_lHeaderPos = atoi(m_ctrlHeaderList.GetItemText(lSelectedIndex, 1));
        m_lHeaderSize = atoi(m_ctrlHeaderList.GetItemText(lSelectedIndex, 2));

        UpdateData(FALSE);
    }

	*pResult = 0;
}
