/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : GroupBoxWidget.h
//
// Date             : 25 September 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.3 $
//
// Description      : GroupBoxWidget.h contains the definition of 
//                    the CGroupBoxWidget class.  This class is used to 
//                    mimic the functionality of the standard windows 
//                    group box.  It supports a single line of text 
//                    that may be left, right, or center justified.  
//                    The box is composed of only two colors white and 
//                    128, 128, 128. 
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : _FSI_STL::string, CString, General::CTextWidget.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: GroupBoxWidget.h $                                                                   
// Revision 1.3  1999/10/21 01:35:46  billyb                                                                   
// Added override of ResetProperties.                                                                   
// Revision 1.2  1999/09/25 06:44:25  billyb                                                                   
// Added comments.  Implemented actual drawing of group box                                                                   
// and text rather than have a special member that would be a                                                                   
// child of an instance of CGroupBoxWidget and would actually                                                                   
// draw the group box.                                                                   
/////////////////////////////////////////////////////////////////////////////
#if !defined(_GROUPBOXWIDGET_H_)
#define _GROUPBOXWIDGET_H_

#include "TextWidget.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CGroupBoxWidget : public CTextWidget
{
// Construction
public:
	CGroupBoxWidget();

// Attributes
public:
   	enum { IDB = IDB_GROUP_WIDGET };

protected:

    virtual void InitReinit();

// Operations
public:
    virtual void Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                            const long int lId, bool bEditMode);
    static CWidget* CreateObject();
    virtual void ResetProperties();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CGroupBoxWidget)
	public:
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CGroupBoxWidget();

	// Generated message map functions
protected:
	//{{AFX_MSG(CGroupBoxWidget)
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(_GROUPBOXWIDGET_H_)
