/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : GroupBoxWidget.cpp
//
// Date             : 25 September 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.10 $
//
// Description      : GroupBoxWidget.cpp contains the implementation of 
//                    the CGroupBoxWidget class.  This class is used to 
//                    mimic the functionality of the standard windows 
//                    group box.  It supports a single line of text 
//                    that may be left, right, or center justified.  
//                    The box is composed of only two colors white and 
//                    128, 128, 128. 
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : _FSI_STL::string, CString, General::CTextWidget.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: GroupBoxWidget.cpp $                                                                   
// Revision 1.10  2000/03/07 20:40:36  billyb                                                                   
// Added casts to eliminate warnings.                                                                   
// Revision 1.9  1999/12/08 17:42:52  billyb                                                                   
// Added CS_OWNDC.                                                                   
// Revision 1.8  1999/11/09 21:13:16  billyb                                                                   
// Replaced FillRect with FillSolidRect or PatBlt.  Changed                                                                    
// BEGIN_MESSAGE_MAP to have CButtonWidget as base.                                                                   
// Drawing now occurs offscreen and then blts to onscreen.                                                                   
// Revision 1.7  1999/10/21 22:08:56  billyb                                                                   
// Fixed problem of sending a rectangle that was too small for                                                                   
// the offset shadow.                                                                   
// Revision 1.6  1999/10/21 01:37:43  billyb                                                                   
// Implemented ResetProperties to make sure that the text was                                                                   
// vertically centered.  Removed unneeded formatting code from                                                                   
// DrawItem.  Corrected problem with left or right justified text not                                                                   
// have a 3 pixel border.                                                                   
// Revision 1.5  1999/10/14 19:45:11  billyb                                                                   
// Made text draw using CTextWidget::DrawItem.                                                                   
// Revision 1.4  1999/09/30 16:44:40  billyb                                                                   
// Replaced WORDBREAK with SINGLELINE since the text                                                                   
// label for the group box should only be one line.                                                                   
// Revision 1.3  1999/09/25 06:44:23  billyb                                                                   
// Added comments.  Implemented actual drawing of group box                                                                   
// and text rather than have a special member that would be a                                                                   
// child of an instance of CGroupBoxWidget and would actually                                                                   
// draw the group box.                                                                   
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "GroupBoxWidget.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGroupBoxWidget

CGroupBoxWidget::CGroupBoxWidget()
{
    m_stlStrWidgetName = _FSI_STL::string("GroupBox");

    CGroupBoxWidget::InitReinit();
}

void CGroupBoxWidget::InitReinit()
{
    m_stlStrValue = _FSI_STL::string("Blank");
}

CGroupBoxWidget::~CGroupBoxWidget()
{
}


BEGIN_MESSAGE_MAP(CGroupBoxWidget, CButtonWidget)
	//{{AFX_MSG_MAP(CGroupBoxWidget)
	ON_WM_WINDOWPOSCHANGED()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//
// CWidget* CGroupBoxWidget::CreateObject()
//
// Inputs           : None.
//
// Return Values    : A pointer to a new instance of CGroupBoxWidget.
//
// Date             : 20 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CGroupBoxWidget::CreateObject() is a common 
//                    framework method used to create a new instance of 
//                    CGroupBoxWidget.  It is a static member.  The 
//                    address of this method is stored in a map of 
//                    widget name to CreateObject address in the 
//                    component interface for the DLL that contains the 
//                    CGroupBoxWidget.  Using this data structure, a 
//                    new instance of CGroupBoxWidget can be created 
//                    when one is encountered in the XML page 
//                    description file.
//
/////////////////////////////////////////////////////////////////////////////
CWidget* CGroupBoxWidget::CreateObject()
{
    return new CGroupBoxWidget();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CGroupBoxWidget::Initialize()
//
// Inputs           : CXMLWidget*& rpXMLWidget - reference to a pointer 
//                                               that holds the data to 
//                                               create a CGroupBoxWidget.
//                    CWnd* pWnd               - the parent CWnd object.
//                    const long lId           - identifier.
//                    bool bEditMode           - whether editing is taking 
//                                               place.
//
// Return Values    : None.
//
// Date             : 20 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CGroupBoxWidget::Initialize() is a common 
//                    framework method.  It is called after an instance 
//                    of CGroupBoxWidget has been created.  It is 
//                    responsible for initializing most of the internal 
//                    data members with data from the XMLWidget.  This 
//                    is done using the call to ResetProperties.  If 
//                    the XMLWidget pointer is NULL, a new XMLWidget 
//                    instance is created with default settings.  
//                    Generic help text is set here and any CWnd 
//                    derived Create() calls are made to create the 
//                    Windows object that allows for the use of the MFC 
//                    messages.  The HWND for the CWnd derived object 
//                    that is created is then added to a map in CWidget 
//                    that keeps track of what CWidget derived pointers 
//                    are valid.  This is to make sure that all of the 
//                    threads do not try to dereference bad pointers.
//
/////////////////////////////////////////////////////////////////////////////
void CGroupBoxWidget::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                 const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    CGroupBoxWidget::InitReinit();

    if (rpXMLWidget != NULL)
    {
        ResetProperties();
    }

    if (GetSafeHwnd() == NULL)
    {
        Create("",
               WS_CHILD | WS_VISIBLE | BS_OWNERDRAW | CS_OWNDC |  WS_CLIPCHILDREN   |  WS_CLIPSIBLINGS,
               CRect(m_exPtUpperLeft, m_exPtLowerRight),
               (CWnd*)pWnd, lId);
    }
    else
    {
        SetParent(pWnd);
        MoveWindow(m_exPtUpperLeft.X(), m_exPtUpperLeft.Y(),
                   m_exPtLowerRight.X() - m_exPtUpperLeft.X(),
                   m_exPtLowerRight.Y() - m_exPtUpperLeft.Y(), FALSE);
        ShowWindow(SW_NORMAL);
    }

    CDC* pDCur = GetDC();
    if (m_pDC->GetSafeHdc() != NULL)
    {
        m_pDC->DeleteDC();
    }
    m_pDC->CreateCompatibleDC(pDCur);

    if (m_pBMP->GetSafeHandle() != NULL)
    {
        m_pBMP->DeleteObject();
    }
    m_pBMP->CreateCompatibleBitmap(pDCur, m_exPtLowerRight.X() - m_exPtUpperLeft.X(),
                                    m_exPtLowerRight.Y() - m_exPtUpperLeft.Y());
    ReleaseDC(pDCur);

    m_pDC->SelectObject(m_pBMP);
    m_pDC->SetBkMode(TRANSPARENT);
    m_pDC->SelectObject(&m_font);

    m_pWnd = this;
    m_mapValidAddresses[this] = m_pWnd->GetSafeHwnd();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CGroupBoxWidget::ResetProperties()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 20 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CGroupBoxWidget::ResetProperties will call its 
//                    parent's ResetProperties method.  Afterwards, it
//                    will reset the alignment variables and call 
//                    TextFormat to reset the text formatting.
//
/////////////////////////////////////////////////////////////////////////////
void CGroupBoxWidget::ResetProperties()
{
    CTextWidget::ResetProperties();

    m_lVAlign   = 1;

    TextFormat();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CGroupBoxWidget::DrawItem()
//
// Inputs           : LPDRAWITEMSTRUCT lpDrawItemStruct - Windows 
//                    specific pointer.
//
// Return Values    : None.
//
// Date             : 25 September 1999
//
// Engineer         : Billy Baker
//
// Description      : CGroupBoxWidget::DrawItem() is an override of a 
//                    MFC defined function.  DrawItem is implemented when 
//                    a CWnd derived class has the BS_OWNERDRAW style.  
//                    Here, it draws a single line of text with a group box.
//
/////////////////////////////////////////////////////////////////////////////
void CGroupBoxWidget::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
    CRect rect(&(lpDrawItemStruct->rcItem));
    CDC *pDC = CDC::FromHandle(lpDrawItemStruct->hDC);

    CDC* pDCur = pDC;
    pDC = m_pDC;

    long int lSavedDC = pDC->SaveDC();

    // fill the extents rectangle with the color for the background
    pDC->SetBkColor(m_clrBack);

    // Get the size of the text.  Should really only be one line.
    CString strValue(m_stlStrValue.c_str());
    CSize sizeText = pDC->GetOutputTextExtent(strValue);

    CRect rectText(rect);

    // The text will always be horizontally centered in the
    // rectangle.  The rectangle for text will be at most the
    // width of the full rectangle minus 16 pixels.  That will
    // give 8 pixels of spacing on each side.  The gap between 
    // the text and the first part of the top bar is 3 pixels and
    // the sides of the group box are 2 pixels.  Thus, at least
    // 3 pixels will always be visible on the top from the left or
    // right side to the beginning of the rectangle for the text.

    // If the 16 changes, then change the 8's.
    if (sizeText.cx > (rectText.Width() - 16))
    {
        // Not all of the text will fit.  Make the
        // rectangle as large as possible.
        rectText.DeflateRect(8,0);
    }
    else
    {
        // All of the text will fit.  Computer the
        // minimum rectangle for the text.
        switch (m_lAlign)
        {
        case 0:
            {
                // Align left.
                rectText.left = rectText.left + 8;
                rectText.right = rectText.left + sizeText.cx;
            }
            break;
        case 1:
            {
                // Align horizontal center.
                rectText.left = rectText.Width()/2 - sizeText.cx/2;
                rectText.right = rectText.left + sizeText.cx;
            }
            break;
        case 2:
            {
                // Align right.
                rectText.right = rectText.right - 8;
                rectText.left = rectText.right - sizeText.cx;
            }
            break;
        default:
            {
                // Same as case 1.
                rectText.left = rectText.Width()/2 - sizeText.cx/2;
                rectText.right = rectText.left + sizeText.cx;
            }
            break;
        };
    }

    // Set the height.
    rectText.bottom = rectText.top + sizeText.cy;

    // Increase the width by 6 to give a pixel buffer
    // on the left and right between the text and the 
    // top line of the group box.
    rectText.InflateRect(3 + m_ucShadowOffset, m_ucShadowOffset);

    // Fill the entire background
    ::ExtTextOut(pDC->GetSafeHdc(), 0, 0, ETO_OPAQUE, (LPRECT)rect, NULL, 0, NULL);

    // Make the top lines hit the center of the text.
    rect.top = rectText.top + rectText.Height()/2;

    // put the white borders in.
    pDC->PatBlt(rect.left, rect.top, rect.Width(), rect.Height(), WHITENESS);

    // Leave two pixels on all sides of the white border.
    rect.DeflateRect(2, 2);

    // Fill the inside of the white border with the
    // background color.
    ::ExtTextOut(pDC->GetSafeHdc(), 0, 0, ETO_OPAQUE, (LPRECT)rect, NULL, 0, NULL);

    // Put the rectangle back to its size before the
    // deflate.
    rect.InflateRect(2, 2);

    // Fill in the darker portion of the group box.
    CPen penDarkerHighlight(PS_SOLID, 1, RGB(128, 128, 128));
    pDC->SelectObject(&penDarkerHighlight);

    pDC->MoveTo(rect.left, rect.top);
    pDC->LineTo(rect.right-2, rect.top);
    pDC->LineTo(rect.right-2, rect.bottom-2);
    pDC->LineTo(rect.left, rect.bottom-2);
    pDC->LineTo(rect.left, rect.top);

    ::ExtTextOut(pDC->GetSafeHdc(), 0, 0, ETO_OPAQUE, (LPRECT)rectText, NULL, 0, NULL);

    // Put rect back to its original size to do the blit.
    rect.top = rectText.top - rectText.Height()/2;

    pDCur->BitBlt(rect.left, rect.top, rect.Width(), rect.Height(), pDC, rect.left, rect.top, SRCCOPY);
    pDC->RestoreDC(lSavedDC);

    rectText.DeflateRect(3, 0);

    // Draw the text with the background color covering up
    // part of the top of the group box.
    m_bRepaint = true;
    CRect rectOld(&(lpDrawItemStruct->rcItem));
    lpDrawItemStruct->rcItem = rectText;
    CTextWidget::DrawItem(lpDrawItemStruct);
    lpDrawItemStruct->rcItem = rectOld;
}
