// GeneralComponentInterface.cpp: implementation of the CGeneralComponentInterface class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"

#include "GeneralComponentInterface.h"

#include "CheckBoxWidget.h"
#include "ComboWidget.h"
#include "EditWidget.h"
#include "GroupBoxWidget.h"
#include "ImageWidget.h"
#include "ListWidget.h"
#include "OpenGLWidget.h"
#include "ProgressWidget.h"
#include "PushButtonWidget.h"
#include "RadioWidget.h"
#include "RectButtonWidget.h"
#include "SliderWidget.h"
#include "TextWidget.h"
#include "TimePlotWidget.h"
#include "TreeWidget.h"
#include "XYPlotWidget.h"

#include "AirspeedSlewAction.h"
#include "FindAndCopyAction.h"
#include "FormationTrackingCommsAction.h"
#include "OverlayAction.h"
#include "PageAction.h"
#include "StartAppAction.h"
#include "StartSortieEditAppAction.h"
#include "VertCollarAction.h"
#include "TimeofDayAction.h"
#include "..\fsisuite\product_version.h"

// The following static members contain the date and time of the last
// compilation of this class.
const char CGeneralComponentInterface::m_cRevisionDate[] = __DATE__;
const char CGeneralComponentInterface::m_cRevisionTime[] = __TIME__;

CGeneralComponentInterface::CGeneralComponentInterface(
                                                  _FSI_STL::string stlStrPathName) :
                   CComponentInterface(_FSI_STL::string("General"),stlStrPathName)
{
    _FSI_STL::string stlStrDate(m_cRevisionDate);
    _FSI_STL::string stlStrTime(m_cRevisionTime);

    m_listWidgetCtrls.push_back(CRectButtonWidget::CreateObject);
    CBitmap* pBmp = new CBitmap;
    pBmp->LoadBitmap(CRectButtonWidget::IDB);
    m_listWidgetImages.push_back(pBmp);

    m_listWidgetCtrls.push_back(CCheckBoxWidget::CreateObject);
    pBmp = new CBitmap;
    pBmp->LoadBitmap(CCheckBoxWidget::IDB);
    m_listWidgetImages.push_back(pBmp);

    m_listWidgetCtrls.push_back(CComboWidget::CreateObject);
    pBmp = new CBitmap;
    pBmp->LoadBitmap(CComboWidget::IDB);
    m_listWidgetImages.push_back(pBmp);

    m_listWidgetCtrls.push_back(CEditWidget::CreateObject);
    pBmp = new CBitmap;
    pBmp->LoadBitmap(CEditWidget::IDB);
    m_listWidgetImages.push_back(pBmp);

    m_listWidgetCtrls.push_back(CGroupBoxWidget::CreateObject);
    pBmp = new CBitmap;
    pBmp->LoadBitmap(CGroupBoxWidget::IDB);
    m_listWidgetImages.push_back(pBmp);

    m_listWidgetCtrls.push_back(CImageWidget::CreateObject);
    pBmp = new CBitmap;
    pBmp->LoadBitmap(CImageWidget::IDB);
    m_listWidgetImages.push_back(pBmp);

//    m_listWidgetCtrls.push_back(CListWidget::CreateObject);
//    pBmp = new CBitmap;
//    pBmp->LoadBitmap(CListWidget::IDB);
//    m_listWidgetImages.push_back(pBmp);

    m_listWidgetCtrls.push_back(CProgressWidget::CreateObject);
    pBmp = new CBitmap;
    pBmp->LoadBitmap(CProgressWidget::IDB);
    m_listWidgetImages.push_back(pBmp);

    m_listWidgetCtrls.push_back(CPushButtonWidget::CreateObject);
    pBmp = new CBitmap;
    pBmp->LoadBitmap(CPushButtonWidget::IDB);
    m_listWidgetImages.push_back(pBmp);

    m_listWidgetCtrls.push_back(CRadioWidget::CreateObject);
    pBmp = new CBitmap;
    pBmp->LoadBitmap(CRadioWidget::IDB);
    m_listWidgetImages.push_back(pBmp);

    m_listWidgetCtrls.push_back(CSliderWidget::CreateObject);
    pBmp = new CBitmap;
    pBmp->LoadBitmap(CSliderWidget::IDB);
    m_listWidgetImages.push_back(pBmp);

    m_listWidgetCtrls.push_back(CTextWidget::CreateObject);
    pBmp = new CBitmap;
    pBmp->LoadBitmap(CTextWidget::IDB);
    m_listWidgetImages.push_back(pBmp);

    m_listWidgetCtrls.push_back(CTimePlotWidget::CreateObject);
    pBmp = new CBitmap;
    pBmp->LoadBitmap(CTimePlotWidget::IDB);
    m_listWidgetImages.push_back(pBmp);

//    m_listWidgetCtrls.push_back(CTreeWidget::CreateObject);
//    pBmp = new CBitmap;
//    pBmp->LoadBitmap(CTreeWidget::IDB);
//    m_listWidgetImages.push_back(pBmp);

    m_listWidgetCtrls.push_back(CXYPlotWidget::CreateObject);
    pBmp = new CBitmap;
    pBmp->LoadBitmap(CXYPlotWidget::IDB);
    m_listWidgetImages.push_back(pBmp);

    m_listActions.push_back(CAirspeedSlewAction::CreateObject);
    m_listActions.push_back(CFindAndCopyAction::CreateObject);
    m_listActions.push_back(CFormationTrackingCommsAction::CreateObject);
    m_listActions.push_back(COverlayAction::CreateObject);
    m_listActions.push_back(CPageAction::CreateObject);
    m_listActions.push_back(CStartAppAction::CreateObject);
    m_listActions.push_back(CStartSortieEditAppAction::CreateObject);
    m_listActions.push_back(CVertCollarAction::CreateObject);
	 m_listActions.push_back(CTimeofDayAction::CreateObject);

    m_stlStrDate = stlStrDate + " " + stlStrTime;
}

CGeneralComponentInterface::~CGeneralComponentInterface()
{
}

