// FindAndCopyPage2.cpp : implementation file
//

#include "..\core\stdafx.h"
#include "FindAndCopyPage2.h"
#include "..\core\widget.h"

#include "..\comms\CommsAction.h"
#include "..\comms\LocalCommsAction.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFindAndCopyPage2 dialog


CFindAndCopyPage2::CFindAndCopyPage2() : CBasePage(CFindAndCopyPage2::IDD)
{
	//{{AFX_DATA_INIT(CFindAndCopyPage2)
	m_CStr_variable_name = _T("");
	m_int_variable_to_monitor = -1;
	m_CStr_set_after_variable_name = _T("");
	m_int_variable_to_set = -1;
	m_CStr_remember_filename = _T("");
	m_int_variable_to_remember_filename = NO_VARIABLE;
	//}}AFX_DATA_INIT
   m_stlStrPageName = _FSI_STL::string("FindAndCopy2");
}

CFindAndCopyPage2::~CFindAndCopyPage2()
{
}

void CFindAndCopyPage2::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFindAndCopyPage2)
	DDX_Control(pDX, IDC_COMBO_VARIABLE_NAME_4, m_ctrl_variable_list_for_remembering_filename);
	DDX_Control(pDX, IDC_COMBO_VARIABLE_NAME_3, m_ctrl_set_after_variable_list);
	DDX_Control(pDX, IDC_COMBO_VARIABLE_NAME_2, m_ctrl_variable_list);
	DDX_CBString(pDX, IDC_COMBO_VARIABLE_NAME_2, m_CStr_variable_name);
	DDX_Radio(pDX, IDC_RADIO_NONE_2, m_int_variable_to_monitor);
	DDX_CBString(pDX, IDC_COMBO_VARIABLE_NAME_3, m_CStr_set_after_variable_name);
	DDX_Radio(pDX, IDC_RADIO_NONE_3, m_int_variable_to_set);
	DDX_CBString(pDX, IDC_COMBO_VARIABLE_NAME_4, m_CStr_remember_filename);
	DDX_Radio(pDX, IDC_RADIO_NONE_4, m_int_variable_to_remember_filename);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFindAndCopyPage2, CDialog)
	//{{AFX_MSG_MAP(CFindAndCopyPage2)
	ON_BN_CLICKED(IDC_RADIO_HOST_2, OnRadioHost)
	ON_BN_CLICKED(IDC_RADIO_LOCAL_2, OnRadioLocal)
	ON_BN_CLICKED(IDC_RADIO_NONE_2, OnRadioNone)
	ON_BN_CLICKED(IDC_RADIO_NONE_3, OnRadioNone3)
	ON_BN_CLICKED(IDC_RADIO_LOCAL_3, OnRadioLocal3)
	ON_BN_CLICKED(IDC_RADIO_HOST_3, OnRadioHost3)
	ON_BN_CLICKED(IDC_RADIO_NONE_4, OnRadioNone4)
	ON_BN_CLICKED(IDC_RADIO_HOST_4, OnRadioHost4)
	ON_BN_CLICKED(IDC_RADIO_LOCAL_4, OnRadioLocal4)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFindAndCopyPage2 message handlers

CBasePage* CFindAndCopyPage2::CreateObject()
{
    return new CFindAndCopyPage2;
}


/////////////////////////////////////////////////////////////////////////////
//
// void CFindAndCopyPage2::SetProperties()
//
// Inputs           : void* pWidget - a pointer to be cast to a CWidget*
//
// Return Values    : None.
//
// Date             : 26 May 2000
//
// Engineer         : Charles Brissey
//
// Description      : CFindAndCopyPage2::SetProperties is the standard 
//                    interface for initializing the dialog controls 
//                    with data from the CXMLWidget instance that is 
//                    associated with the CWidget instance that is 
//                    passed to the method.  Every ...::SetProperties 
//                    method does has a similar implmemenation--find 
//                    each element that is used in the property page 
//                    and for each find their attributes if there are 
//                    any.  Note: UpdateData is not called here since 
//                    SetProperties is called before Create.
//
/////////////////////////////////////////////////////////////////////////////
void CFindAndCopyPage2::SetProperties(void* pWidget)
{
   CXMLWidget  *pXMLWidget =  ((CWidget*)pWidget)->XMLWidget();
   if (pXMLWidget != NULL)
   {
      CXMLElement *pXMLElement   =  NULL;
      POSITION pos   =  NULL;
      if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("OPTIONS_FROM_PAGE_2")) == true)
      {
         STRING2STRING_MAP::iterator s2sIt   =  NULL;

         if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("VARIABLE_TO_MONITOR"))  == true)
         {
            if ((*s2sIt).second.c_str()      == _FSI_STL::string("NONE"))
               m_int_variable_to_monitor     =  NO_VARIABLE;
            else if ((*s2sIt).second.c_str() == _FSI_STL::string("LOCAL"))
               m_int_variable_to_monitor     =  LOCAL_VARIABLE;
            else if ((*s2sIt).second.c_str() == _FSI_STL::string("HOST"))
               m_int_variable_to_monitor     =  HOST_VARIABLE;
         }
         else
         {
            switch   (m_int_variable_to_monitor)
            {
               case  NO_VARIABLE:
                  pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_MONITOR"),   _FSI_STL::string("NONE"));
                  break;
               case  LOCAL_VARIABLE:
                  pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_MONITOR"),   _FSI_STL::string("LOCAL"));
                  break;
               case  HOST_VARIABLE:
                  pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_MONITOR"),   _FSI_STL::string("HOST"));
                  break;
            }
         }

         if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("VARIABLE_NAME"))  == true)
         {
            m_CStr_variable_name =  (*s2sIt).second.c_str();
         }
         else
         {
            pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_NAME"),   _FSI_STL::string(m_CStr_variable_name));
         }


         if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("VARIABLE_TO_SET"))  == true)
         {
            if ((*s2sIt).second.c_str()      == _FSI_STL::string("NONE"))
               m_int_variable_to_set         =  NO_VARIABLE;
            else if ((*s2sIt).second.c_str() == _FSI_STL::string("LOCAL"))
               m_int_variable_to_set         =  LOCAL_VARIABLE;
            else if ((*s2sIt).second.c_str() == _FSI_STL::string("HOST"))
               m_int_variable_to_set         =  HOST_VARIABLE;
         }
         else
         {
            switch   (m_int_variable_to_set)
            {
               case  NO_VARIABLE:
                  pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_SET"),   _FSI_STL::string("NONE"));
                  break;
               case  LOCAL_VARIABLE:
                  pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_SET"),   _FSI_STL::string("LOCAL"));
                  break;
               case  HOST_VARIABLE:
                  pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_SET"),   _FSI_STL::string("HOST"));
                  break;
            }
         }

         if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("SET_VARIABLE_NAME"))  == true)
         {
            m_CStr_set_after_variable_name   =  (*s2sIt).second.c_str();
         }
         else
         {
            pXMLElement->AddAttribute(_FSI_STL::string("SET_VARIABLE_NAME"),   _FSI_STL::string(m_CStr_set_after_variable_name));
         }

      
      
         if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("VARIABLE_TO_REMEMBER_FILENAME"))  == true)
         {
            if ((*s2sIt).second.c_str()      == _FSI_STL::string("NONE"))
               m_int_variable_to_remember_filename =  NO_VARIABLE;
            else if ((*s2sIt).second.c_str() == _FSI_STL::string("LOCAL"))
               m_int_variable_to_remember_filename =  LOCAL_VARIABLE;
            else if ((*s2sIt).second.c_str() == _FSI_STL::string("HOST"))
               m_int_variable_to_remember_filename =  HOST_VARIABLE;
         }
         else
         {
            switch   (m_int_variable_to_remember_filename)
            {
               case  NO_VARIABLE:
                  pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_REMEMBER_FILENAME"),   _FSI_STL::string("NONE"));
                  break;
               case  LOCAL_VARIABLE:
                  pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_REMEMBER_FILENAME"),   _FSI_STL::string("LOCAL"));
                  break;
               case  HOST_VARIABLE:
                  pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_REMEMBER_FILENAME"),   _FSI_STL::string("HOST"));
                  break;
            }
         }

         if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("VARIABLE_FOR_FILENAME"))  == true)
         {
            m_CStr_remember_filename   =  (*s2sIt).second.c_str();
         }
         else
         {
            pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_FOR_FILENAME"),   _FSI_STL::string(m_CStr_remember_filename));
         }
      }
   }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CFindAndCopyPage2::UpdateProperties()
//
// Inputs           : void* pWidget - a void pointer to be case to a CWidget*
//
// Return Values    : None.
//
// Date             : 26 May 2000
//
// Engineer         : Charles Brissey
//
// Description      : CFindAndCopyPage2::UpdateProperties is another 
//                    standard interface method for dealing with 
//                    property pages derived from CBasePage.  When the 
//                    data from the property page needs to be applied, 
//                    the UpdateProperties method is called.  The 
//                    implementatin is similar in every CBasePage 
//                    derived class--find the elements in the 
//                    CXMLWidget that is associated with the CWidget 
//                    that is passed and update each element and any 
//                    associated attributes.
//
/////////////////////////////////////////////////////////////////////////////
void CFindAndCopyPage2::UpdateProperties(void* pWidget)
{
   CXMLWidget  *pXMLWidget =  ((CWidget*)pWidget)->XMLWidget();
   if (pXMLWidget != NULL  && GetSafeHwnd()  != NULL)
   {
      UpdateData(TRUE);

      CXMLElement *pXMLElement   =  NULL;
      POSITION pos   =  NULL;
      if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("OPTIONS_FROM_PAGE_2")) == true)
      {
         pXMLElement->AddElementValue(_FSI_STL::string(""));

         STRING2STRING_MAP::iterator s2sIt = NULL;

         if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("VARIABLE_TO_MONITOR"))  == true)
         {
            switch   (m_int_variable_to_monitor)
            {
               case  NO_VARIABLE:
                  (*s2sIt).second   = _FSI_STL::string("NONE");
                  break;
               case  LOCAL_VARIABLE:
                  (*s2sIt).second   = _FSI_STL::string("LOCAL");
                  break;
               case  HOST_VARIABLE:
                  (*s2sIt).second   = _FSI_STL::string("HOST");
                  break;
            }
         }

         if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("VARIABLE_NAME"))  == true)
         {
            (*s2sIt).second   =  m_CStr_variable_name;
         }


         if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("VARIABLE_TO_SET"))  == true)
         {
            switch   (m_int_variable_to_set)
            {
               case  NO_VARIABLE:
                  (*s2sIt).second   = _FSI_STL::string("NONE");
                  break;
               case  LOCAL_VARIABLE:
                  (*s2sIt).second   = _FSI_STL::string("LOCAL");
                  break;
               case  HOST_VARIABLE:
                  (*s2sIt).second   = _FSI_STL::string("HOST");
                  break;
            }
         }

         if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("SET_VARIABLE_NAME"))  == true)
         {
            (*s2sIt).second   =  m_CStr_set_after_variable_name;
         }


         if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("VARIABLE_TO_REMEMBER_FILENAME"))  == true)
         {
            switch   (m_int_variable_to_remember_filename)
            {
               case  NO_VARIABLE:
                  (*s2sIt).second   = _FSI_STL::string("NONE");
                  break;
               case  LOCAL_VARIABLE:
                  (*s2sIt).second   = _FSI_STL::string("LOCAL");
                  break;
               case  HOST_VARIABLE:
                  (*s2sIt).second   = _FSI_STL::string("HOST");
                  break;
            }
         }

         if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("VARIABLE_FOR_FILENAME"))  == true)
         {
            (*s2sIt).second   =  m_CStr_remember_filename;
         }
      }
   }
}


void CFindAndCopyPage2::OnRadioHost() 
{
   CWnd  *pWnd = GetDlgItem(IDC_COMBO_VARIABLE_NAME_2);
   pWnd->EnableWindow(true);

   m_ctrl_variable_list.ResetContent();

   // Attempt to fill in the variables from the comms system.
   if (CCommsAction::m_pCommsSystemInterface != NULL)
   {
      _FSI_STL::map<_FSI_STL::string,  CVariableData*>::iterator mIt;
      mIt = CCommsAction::m_pCommsSystemInterface->m_mapVarName2Data.begin();
      _FSI_STL::map<_FSI_STL::string,  CVariableData*>::iterator mendIt;
      mendIt = CCommsAction::m_pCommsSystemInterface->m_mapVarName2Data.end();

      // Fill the combobox with the variables from the current CCommsSystemInterface derived class.
      while (mIt != mendIt)
      {
         m_ctrl_variable_list.AddString(CString((*mIt).first.c_str()));
         mIt++;
      }

      m_ctrl_variable_list.SelectString(-1, m_CStr_variable_name);
   }
}

void CFindAndCopyPage2::OnRadioLocal() 
{
   CWnd  *pWnd = GetDlgItem(IDC_COMBO_VARIABLE_NAME_2);
   pWnd->EnableWindow(true);

   m_ctrl_variable_list.ResetContent();
   if (CLocalCommsAction::m_pLocalCommsSystemInterface != NULL)
   {
      _FSI_STL::map<_FSI_STL::string,  CVariableData*>::iterator mIt;
      mIt = CLocalCommsAction::m_pLocalCommsSystemInterface->m_mapVarName2Data.begin();
      _FSI_STL::map<_FSI_STL::string,  CVariableData*>::iterator mendIt;
      mendIt = CLocalCommsAction::m_pLocalCommsSystemInterface->m_mapVarName2Data.end();

      // Fill the combobox with the variables from the current CCommsSystemInterface derived class.
      while (mIt != mendIt) 
      {
         m_ctrl_variable_list.AddString(CString((*mIt).first.c_str()));
         mIt++;
      }

      m_ctrl_variable_list.SelectString(-1, m_CStr_variable_name);
   }
}

void CFindAndCopyPage2::OnRadioNone() 
{
   m_ctrl_variable_list.ResetContent();
   CWnd  *pWnd = GetDlgItem(IDC_COMBO_VARIABLE_NAME_2);
   pWnd->EnableWindow(false);
}


BOOL CFindAndCopyPage2::OnInitDialog() 
{
   CBasePage::OnInitDialog();

   switch   (m_int_variable_to_monitor)
   {
      case  NO_VARIABLE:
         OnRadioNone();
         break;

      case  LOCAL_VARIABLE:
         OnRadioLocal();
         break;

      case  HOST_VARIABLE:
         OnRadioHost();
         break;
   }

   switch   (m_int_variable_to_set)
   {
      case  NO_VARIABLE:
         OnRadioNone3();
         break;

      case  LOCAL_VARIABLE:
         OnRadioLocal3();
         break;

      case  HOST_VARIABLE:
         OnRadioHost3();
         break;
   }
	
   switch   (m_int_variable_to_remember_filename)
   {
      case  NO_VARIABLE:
         OnRadioNone4();
         break;

      case  LOCAL_VARIABLE:
         OnRadioLocal4();
         break;

      case  HOST_VARIABLE:
         OnRadioHost4();
         break;
   }

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CFindAndCopyPage2::OnRadioNone3() 
{
   m_ctrl_set_after_variable_list.ResetContent();
   CWnd  *pWnd = GetDlgItem(IDC_COMBO_VARIABLE_NAME_3);
   pWnd->EnableWindow(false);
}

void CFindAndCopyPage2::OnRadioLocal3() 
{
   CWnd  *pWnd = GetDlgItem(IDC_COMBO_VARIABLE_NAME_3);
   pWnd->EnableWindow(true);

   m_ctrl_set_after_variable_list.ResetContent();
   if (CLocalCommsAction::m_pLocalCommsSystemInterface != NULL)
   {
      _FSI_STL::map<_FSI_STL::string,  CVariableData*>::iterator mIt;
      mIt = CLocalCommsAction::m_pLocalCommsSystemInterface->m_mapVarName2Data.begin();
      _FSI_STL::map<_FSI_STL::string,  CVariableData*>::iterator mendIt;
      mendIt = CLocalCommsAction::m_pLocalCommsSystemInterface->m_mapVarName2Data.end();

      // Fill the combobox with the variables from the current CCommsSystemInterface derived class.
      while (mIt != mendIt) 
      {
         m_ctrl_set_after_variable_list.AddString(CString((*mIt).first.c_str()));
         mIt++;
      }

      m_ctrl_set_after_variable_list.SelectString(-1, m_CStr_set_after_variable_name);
   }
}

void CFindAndCopyPage2::OnRadioHost3() 
{
   CWnd  *pWnd = GetDlgItem(IDC_COMBO_VARIABLE_NAME_3);
   pWnd->EnableWindow(true);

   m_ctrl_set_after_variable_list.ResetContent();

   // Attempt to fill in the variables from the comms system.
   if (CCommsAction::m_pCommsSystemInterface != NULL)
   {
      _FSI_STL::map<_FSI_STL::string,  CVariableData*>::iterator mIt;
      mIt = CCommsAction::m_pCommsSystemInterface->m_mapVarName2Data.begin();
      _FSI_STL::map<_FSI_STL::string,  CVariableData*>::iterator mendIt;
      mendIt = CCommsAction::m_pCommsSystemInterface->m_mapVarName2Data.end();

      // Fill the combobox with the variables from the current CCommsSystemInterface derived class.
      while (mIt != mendIt)
      {
         m_ctrl_set_after_variable_list.AddString(CString((*mIt).first.c_str()));
         mIt++;
      }

      m_ctrl_set_after_variable_list.SelectString(-1, m_CStr_set_after_variable_name);
   }
}

void CFindAndCopyPage2::OnRadioNone4() 
{
   m_ctrl_variable_list_for_remembering_filename.ResetContent();
   CWnd  *pWnd = GetDlgItem(IDC_COMBO_VARIABLE_NAME_4);
   pWnd->EnableWindow(false);
}

void CFindAndCopyPage2::OnRadioHost4() 
{
   CWnd  *pWnd = GetDlgItem(IDC_COMBO_VARIABLE_NAME_4);
   pWnd->EnableWindow(true);

   m_ctrl_variable_list_for_remembering_filename.ResetContent();

   // Attempt to fill in the variables from the comms system.
   if (CCommsAction::m_pCommsSystemInterface != NULL)
   {
      _FSI_STL::map<_FSI_STL::string,  CVariableData*>::iterator mIt;
      mIt = CCommsAction::m_pCommsSystemInterface->m_mapVarName2Data.begin();
      _FSI_STL::map<_FSI_STL::string,  CVariableData*>::iterator mendIt;
      mendIt = CCommsAction::m_pCommsSystemInterface->m_mapVarName2Data.end();

      // Fill the combobox with the variables from the current CCommsSystemInterface derived class.
      while (mIt != mendIt)
      {
         m_ctrl_variable_list_for_remembering_filename.AddString(CString((*mIt).first.c_str()));
         mIt++;
      }

      m_ctrl_variable_list_for_remembering_filename.SelectString(-1, m_CStr_remember_filename);
   }
}

void CFindAndCopyPage2::OnRadioLocal4() 
{
   CWnd  *pWnd = GetDlgItem(IDC_COMBO_VARIABLE_NAME_4);
   pWnd->EnableWindow(true);

   m_ctrl_variable_list_for_remembering_filename.ResetContent();
   if (CLocalCommsAction::m_pLocalCommsSystemInterface != NULL)
   {
      _FSI_STL::map<_FSI_STL::string,  CVariableData*>::iterator mIt;
      mIt = CLocalCommsAction::m_pLocalCommsSystemInterface->m_mapVarName2Data.begin();
      _FSI_STL::map<_FSI_STL::string,  CVariableData*>::iterator mendIt;
      mendIt = CLocalCommsAction::m_pLocalCommsSystemInterface->m_mapVarName2Data.end();

      // Fill the combobox with the variables from the current CCommsSystemInterface derived class.
      while (mIt != mendIt) 
      {
         m_ctrl_variable_list_for_remembering_filename.AddString(CString((*mIt).first.c_str()));
         mIt++;
      }

      m_ctrl_variable_list_for_remembering_filename.SelectString(-1, m_CStr_remember_filename);
   }
}
