// FindAndCopyPage.cpp : implementation file
//

#include "..\core\stdafx.h"
#include "FindAndCopyPage.h"
#include "..\core\widget.h"

#include "..\comms\CommsAction.h"
#include "..\comms\LocalCommsAction.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFindAndCopyPage dialog

CFindAndCopyPage::CFindAndCopyPage() : CBasePage(CFindAndCopyPage::IDD)
{
	//{{AFX_DATA_INIT(CFindAndCopyPage)
	m_CStr_host_path_and_file = _T("");
	m_CStr_ios_path = _T("");
	m_int_use_variable_for_filename = -1;
	m_int_copy_direction = -1;
	m_CStr_variable_name = _T("");
	m_CStr_primary_extension = _T("");
	m_CStr_secondary_extension = _T("");
	//}}AFX_DATA_INIT
   m_stlStrPageName = _FSI_STL::string("FindAndCopy");
	m_int_use_variable_for_filename  =  NONE;
	m_int_copy_direction             =  HOST_TO_IOS;
}

CFindAndCopyPage::~CFindAndCopyPage()
{
}

void CFindAndCopyPage::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFindAndCopyPage)
	DDX_Control(pDX, IDC_COMBO_VARIABLE_NAME, m_ctrl_variable_list);
	DDX_Text(pDX, IDC_EDIT_FINDANDCOPY_HOST_PATH_AND_FILE, m_CStr_host_path_and_file);
	DDX_Text(pDX, IDC_EDIT_FINDANDCOPY_IOS_PATH, m_CStr_ios_path);
	DDX_Radio(pDX, IDC_RADIO_NONE, m_int_use_variable_for_filename);
	DDX_Radio(pDX, IDC_RADIO_HOST_TO_IOS, m_int_copy_direction);
	DDX_CBString(pDX, IDC_COMBO_VARIABLE_NAME, m_CStr_variable_name);
	DDX_Text(pDX, IDC_EDIT_PRIMARY_EXT, m_CStr_primary_extension);
	DDX_Text(pDX, IDC_EDIT_SECONDARY_EXT, m_CStr_secondary_extension);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFindAndCopyPage, CDialog)
	//{{AFX_MSG_MAP(CFindAndCopyPage)
	ON_BN_CLICKED(IDC_BUTTON_FINDANDCOPY_BROWSE, OnButtonFindandcopyBrowse)
	ON_BN_CLICKED(IDC_RADIO_HOST, OnRadioHost)
	ON_BN_CLICKED(IDC_RADIO_LOCAL, OnRadioLocal)
	ON_BN_CLICKED(IDC_RADIO_NONE, OnRadioNone)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFindAndCopyPage message handlers

CBasePage* CFindAndCopyPage::CreateObject()
{
    return new CFindAndCopyPage;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CFindAndCopyPage::SetProperties()
//
// Inputs           : void* pWidget - a pointer to be cast to a CWidget*
//
// Return Values    : None.
//
// Date             : 10 May 2000
//
// Engineer         : Charles Brissey
//
// Description      : CFindAndCopyPage::SetProperties is the standard 
//                    interface for initializing the dialog controls 
//                    with data from the CXMLWidget instance that is 
//                    associated with the CWidget instance that is 
//                    passed to the method.  Every ...::SetProperties 
//                    method does has a similar implmemenation--find 
//                    each element that is used in the property page 
//                    and for each find their attributes if there are 
//                    any.  Note: UpdateData is not called here since 
//                    SetProperties is called before Create.
//
/////////////////////////////////////////////////////////////////////////////
void CFindAndCopyPage::SetProperties(void* pWidget)
{
   CXMLWidget  *pXMLWidget =  ((CWidget*)pWidget)->XMLWidget();
   if (pXMLWidget != NULL)
   {
      CXMLElement *pXMLElement   =  NULL;
      POSITION pos   =  NULL;
      if (pXMLWidget->FindElement(pXMLElement,  pos,  _FSI_STL::string("HOST_PATH_AND_FILE")) == true)
      {
         m_CStr_host_path_and_file  =  (pXMLElement->ElementValue().c_str());
      }

      pXMLElement =  NULL;
      if (pXMLWidget->FindElement(pXMLElement,  pos,  _FSI_STL::string("IOS_PATH")) == true)
      {
         m_CStr_ios_path            =  (pXMLElement->ElementValue().c_str());
      }

      pXMLElement =  NULL;
      if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("OPTIONS")) == true)
      {
         STRING2STRING_MAP::iterator s2sIt      =  NULL;

         if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("USE_VARIABLE_FOR_FILENAME"))  == true)
         {
            if ((*s2sIt).second.c_str()         == _FSI_STL::string("NONE"))
               m_int_use_variable_for_filename  =  NONE;
            else if ((*s2sIt).second.c_str()    == _FSI_STL::string("LOCAL"))
               m_int_use_variable_for_filename  =  LOCAL;
            else if ((*s2sIt).second.c_str()    == _FSI_STL::string("HOST"))
               m_int_use_variable_for_filename  =  HOST;
         }
         else
         {
            switch   (m_int_use_variable_for_filename)
            {
               case  NONE:
                  pXMLElement->AddAttribute(_FSI_STL::string("USE_VARIABLE_FOR_FILENAME"),   _FSI_STL::string("NONE"));
                  break;
               case  LOCAL:
                  pXMLElement->AddAttribute(_FSI_STL::string("USE_VARIABLE_FOR_FILENAME"),   _FSI_STL::string("LOCAL"));
                  break;
               case  HOST:
                  pXMLElement->AddAttribute(_FSI_STL::string("USE_VARIABLE_FOR_FILENAME"),   _FSI_STL::string("HOST"));
                  break;
            }
         }

         
         if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("COPY_DIRECTION"))  == true)
         {
            if ((*s2sIt).second.c_str()         == _FSI_STL::string("HOST_TO_IOS"))
               m_int_copy_direction             =  HOST_TO_IOS;
            else if ((*s2sIt).second.c_str()    == _FSI_STL::string("IOS_TO_HOST"))
               m_int_copy_direction             =  IOS_TO_HOST;
         }
         else
         {
            switch   (m_int_copy_direction)
            {
               case  HOST_TO_IOS:
                  pXMLElement->AddAttribute(_FSI_STL::string("COPY_DIRECTION"),   _FSI_STL::string("HOST_TO_IOS"));
                  break;
               case  IOS_TO_HOST:
                  pXMLElement->AddAttribute(_FSI_STL::string("COPY_DIRECTION"),   _FSI_STL::string("IOS_TO_HOST"));
                  break;
            }
         }


         if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("VARIABLE_NAME"))  == true)
         {
            m_CStr_variable_name =  (*s2sIt).second.c_str();
         }
         else
         {
            pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_NAME"),   _FSI_STL::string(m_CStr_variable_name));
         }


         if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("PRIMARY_EXTENSION"))  == true)
         {
            m_CStr_primary_extension   =  (*s2sIt).second.c_str();
         }
         else
         {
            pXMLElement->AddAttribute(_FSI_STL::string("PRIMARY_EXTENSION"),   _FSI_STL::string(m_CStr_primary_extension));
         }


         if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("SECONDARY_EXTENSION"))  == true)
         {
            m_CStr_secondary_extension =  (*s2sIt).second.c_str();
         }
         else
         {
            pXMLElement->AddAttribute(_FSI_STL::string("SECONDARY_EXTENSION"),   _FSI_STL::string(m_CStr_secondary_extension));
         }
      }
   }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CFindAndCopyPage::UpdateProperties()
//
// Inputs           : void* pWidget - a void pointer to be case to a CWidget*
//
// Return Values    : None.
//
// Date             : 10 May 2000
//
// Engineer         : Charles Brissey
//
// Description      : CFindAndCopyPage::UpdateProperties is another 
//                    standard interface method for dealing with 
//                    property pages derived from CBasePage.  When the 
//                    data from the property page needs to be applied, 
//                    the UpdateProperties method is called.  The 
//                    implementatin is similar in every CBasePage 
//                    derived class--find the elements in the 
//                    CXMLWidget that is associated with the CWidget 
//                    that is passed and update each element and any 
//                    associated attributes.
//
/////////////////////////////////////////////////////////////////////////////
void CFindAndCopyPage::UpdateProperties(void* pWidget)
{
   CXMLWidget  *pXMLWidget =  ((CWidget*)pWidget)->XMLWidget();
   if (pXMLWidget != NULL  && GetSafeHwnd()  != NULL)
   {
      UpdateData(TRUE);

      CXMLElement *pXMLElement   =  NULL;
      POSITION pos   =  NULL;
      if (pXMLWidget->FindElement(pXMLElement,  pos,  _FSI_STL::string("HOST_PATH_AND_FILE"))   == true)
      {
         pXMLElement->AddElementValue(_FSI_STL::string((LPCTSTR)m_CStr_host_path_and_file));
      }

      pXMLElement =  NULL;
      if (pXMLWidget->FindElement(pXMLElement,  pos,  _FSI_STL::string("IOS_PATH")) == true)
      {
         pXMLElement->AddElementValue(_FSI_STL::string((LPCTSTR)m_CStr_ios_path));
      }

      pXMLElement =  NULL;
      if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("OPTIONS")) == true)
      {
         pXMLElement->AddElementValue(_FSI_STL::string(""));

         STRING2STRING_MAP::iterator s2sIt = NULL;

         if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("USE_VARIABLE_FOR_FILENAME"))  == true)
         {
            switch   (m_int_use_variable_for_filename)
            {
               case  NONE:
                  (*s2sIt).second   = _FSI_STL::string("NONE");
                  break;
               case  LOCAL:
                  (*s2sIt).second   = _FSI_STL::string("LOCAL");
                  break;
               case  HOST:
                  (*s2sIt).second   = _FSI_STL::string("HOST");
                  break;
            }
         }


         if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("COPY_DIRECTION"))  == true)
         {
            switch   (m_int_copy_direction)
            {
               case  HOST_TO_IOS:
                  (*s2sIt).second   = _FSI_STL::string("HOST_TO_IOS");
                  break;
               case  IOS_TO_HOST:
                  (*s2sIt).second   = _FSI_STL::string("IOS_TO_HOST");
                  break;
            }
         }


         if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("VARIABLE_NAME"))  == true)
         {
            (*s2sIt).second   =  m_CStr_variable_name;
         }


         if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("PRIMARY_EXTENSION"))  == true)
         {
            (*s2sIt).second   =  m_CStr_primary_extension;
         }


         if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("SECONDARY_EXTENSION"))  == true)
         {
            (*s2sIt).second   =  m_CStr_secondary_extension;
         }
      }
   }
}


void CFindAndCopyPage::OnButtonFindandcopyBrowse() 
{
   // Get all of the current data.
   UpdateData(TRUE);

   CFileDialog cfd(TRUE, NULL, NULL, OFN_SHAREAWARE | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY, "All Files (*.*)|*.*||", this);

   long  int   lRetVal     =  cfd.DoModal();

   // If ok was clicked, then update the name of the file.
   if (lRetVal == IDOK)
   {
      m_CStr_host_path_and_file   = cfd.GetPathName();
      UpdateData(FALSE);
   }
}


BOOL CFindAndCopyPage::OnInitDialog() 
{
   CBasePage::OnInitDialog();

   switch   (m_int_use_variable_for_filename)
   {
      case  NONE:
         OnRadioNone();
         break;

      case  LOCAL:
         OnRadioLocal();
         break;

      case  HOST:
         OnRadioHost();
         break;
   }


   return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CFindAndCopyPage::OnRadioHost() 
{
   CWnd  *pWnd = GetDlgItem(IDC_COMBO_VARIABLE_NAME);
   pWnd->EnableWindow(true);

   m_ctrl_variable_list.ResetContent();

   // Attempt to fill in the variables from the comms system.
   if (CCommsAction::m_pCommsSystemInterface != NULL)
   {
      _FSI_STL::map<_FSI_STL::string,  CVariableData*>::iterator mIt;
      mIt = CCommsAction::m_pCommsSystemInterface->m_mapVarName2Data.begin();
      _FSI_STL::map<_FSI_STL::string,  CVariableData*>::iterator mendIt;
      mendIt = CCommsAction::m_pCommsSystemInterface->m_mapVarName2Data.end();

      // Fill the combobox with the variables from the current CCommsSystemInterface derived class.
      while (mIt != mendIt)
      {
         m_ctrl_variable_list.AddString(CString((*mIt).first.c_str()));
         mIt++;
      }

      m_ctrl_variable_list.SelectString(-1, m_CStr_variable_name);
   }
}

void CFindAndCopyPage::OnRadioLocal() 
{
   CWnd  *pWnd = GetDlgItem(IDC_COMBO_VARIABLE_NAME);
   pWnd->EnableWindow(true);

   m_ctrl_variable_list.ResetContent();
   if (CLocalCommsAction::m_pLocalCommsSystemInterface != NULL)
   {
      _FSI_STL::map<_FSI_STL::string,  CVariableData*>::iterator mIt;
      mIt = CLocalCommsAction::m_pLocalCommsSystemInterface->m_mapVarName2Data.begin();
      _FSI_STL::map<_FSI_STL::string,  CVariableData*>::iterator mendIt;
      mendIt = CLocalCommsAction::m_pLocalCommsSystemInterface->m_mapVarName2Data.end();

      // Fill the combobox with the variables from the current CCommsSystemInterface derived class.
      while (mIt != mendIt) 
      {
         m_ctrl_variable_list.AddString(CString((*mIt).first.c_str()));
         mIt++;
      }

      m_ctrl_variable_list.SelectString(-1, m_CStr_variable_name);
   }
}

void CFindAndCopyPage::OnRadioNone() 
{
   m_ctrl_variable_list.ResetContent();
   CWnd  *pWnd = GetDlgItem(IDC_COMBO_VARIABLE_NAME);
   pWnd->EnableWindow(false);
}
