// FindAndCopyAction.h: interface for the CFindAndCopyAction class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(_FINDANDCOPYACTION_H_)
#define _FINDANDCOPYACTION_H_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\core\Action.h"
#include "..\core\Widget.h"

   
class CFindAndCopyAction : public CAction, public CWidget
{
public:
   CFindAndCopyAction();
   virtual ~CFindAndCopyAction();

   virtual void Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                            const long int lId, bool bEditMode);
   static CWidget* CreateObject();
   virtual void ResetProperties();

   virtual enum LButtonUpReturn OnLButtonUp();

   virtual void OnUpdate();

   static   UINT  ThreadWaitBeforeCopying(LPVOID param);

private:
   void  GetReadyToCopyFileAndReportErrors(CString &source, CString &destination);
   _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> >   m_list_of_files;

   CString  m_CStr_host_path_and_file;
   CString  m_CStr_ios_path;
	int		m_int_use_variable_for_filename;
	int		m_int_copy_direction;
   CString  m_CStr_variable_name;
	CString	m_CStr_primary_extension;
	CString	m_CStr_secondary_extension;
	int		m_int_variable_to_monitor;
   CString  m_CStr_variable_to_monitor_name;
   int		m_int_variable_to_set;
   CString  m_CStr_variable_to_set_name;
   int		m_int_variable_to_remember_filename;
   CString  m_CStr_variable_to_remember_filename;

   typedef  struct   copy_parameters
   {
      CString  source;
      CString  destination;
      CString  variable;
      int      type_of_variable;
      CString  primary_extension;
      CString  secondary_extension;
      CString  variable_to_set;
      int      type_of_variable_to_set;
   }  COPY_PARAMETERS;

   COPY_PARAMETERS   m_copy_param;
};

#endif // !defined(_FINDANDCOPYACTION_H_)
