// FindAndCopyAction.cpp: implementation of the CFindAndCopyAction class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "ComboWidget.h"
#include "FindAndCopyAction.h"
#include "FindAndCopyPage.h"
#include "FindAndCopyPage2.h"
#include "..\comms\CommsShared.h"
#include "WorkingDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CFindAndCopyAction::CFindAndCopyAction()
{
   m_stlStrWidgetName = _FSI_STL::string("FindAndCopy");

   m_listWidgetPropPages.push_back(CFindAndCopyPage::CreateObject);
   m_listWidgetPropPages.push_back(CFindAndCopyPage2::CreateObject);
   
   m_int_use_variable_for_filename  =  NONE;
   m_int_copy_direction             =  HOST_TO_IOS;
   m_int_variable_to_monitor        =  NO_VARIABLE;
}


CFindAndCopyAction::~CFindAndCopyAction()
{
}


void CFindAndCopyAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, const long lId, bool bEditMode)
{
   CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

   if (rpXMLWidget != NULL)
   {
      ResetProperties();
   }

   m_pAction = this;
   m_pWidget = (CWidget*)this;

   if (!m_bEditing)
      OnUpdate();
}


CWidget* CFindAndCopyAction::CreateObject()
{
   return   new   CFindAndCopyAction();
}


enum LButtonUpReturn CFindAndCopyAction::OnLButtonUp()
{
   m_sync.Lock();

   if (m_bDeleting == true)
   {
      // Since memory is going away, the parent is probably going away as well.  Let the parent think that
      // everything went ok.  Or, no write can take place
      m_sync.Unlock();
      return LBU_OK;
   }

   // Make sure this instance is attached to a graphical element.
   if (CWidget::IsValidAddress(m_pParentWidget) != VALID)
   {
      m_sync.Unlock();
      return LBU_OK;
   }

   switch   (m_int_use_variable_for_filename)
   {
      case  NONE:
         {
            CVariant *pVarSelection =  ((CComboWidget *)m_pParentWidget)->GetValue("Default");
            long     selection      =  (long)*pVarSelection;
            CString  ios_filename(m_CStr_ios_path);
            _FSI_STL::list<_FSI_STL::string>::iterator   list_iter   =  m_list_of_files[selection].begin();
            if (list_iter  != m_list_of_files[selection].end())
            {
               CString  name  =  (*list_iter).c_str();
               ios_filename   += name;

               CVariant var;
               _FSI_STL::string  stlStrVariable;
               stlStrVariable =  (LPCTSTR)m_CStr_variable_to_remember_filename;
               CCommsShared::GetLocalValue(var, stlStrVariable);
               long  old_type =  var.Type();
               var.Value((char *)(LPCTSTR)name, old_type, name.GetLength());
               var.ChangeType(old_type);
               CCommsShared::SetLocalValue(var, stlStrVariable, 0);

               // m_CStr_variable_name is normally not referenced in the case
               // of NONE but if it is defined we can use it here to set a Host
               // variable for the file name. This makes the strategy for a
               // Formation Demo possible as we can tell the Host what Lead Profile
               // filename to write to the bytestream when recording a Formation
               // Demo.
               if (! m_CStr_variable_name.IsEmpty())
               {
                  CCommsShared::SetHostVariable((char *)(LPCTSTR)m_CStr_variable_name, (char *)(LPCTSTR)name, -1);
               }

               if (m_int_copy_direction      == HOST_TO_IOS)
                  GetReadyToCopyFileAndReportErrors(m_CStr_host_path_and_file, ios_filename);
               else if (m_int_copy_direction == IOS_TO_HOST)
                  GetReadyToCopyFileAndReportErrors(ios_filename,  m_CStr_host_path_and_file);

               m_ChangeValue.Variant(pVarSelection);
               m_ChangeValue.UseRange(false);

               m_pParentWidget->ChangeValue("Default", &m_ChangeValue);

               if (CCommsShared::m_pCommsSystemInterface != NULL)
                  CCommsShared::m_pCommsSystemInterface->ToRefresh(m_pParentWidget);
            }
         }
         break;

      case  LOCAL:
         {
            CVariant CVar_filename;
            CCommsShared::GetLocalValue(CVar_filename,   _FSI_STL::string(m_CStr_variable_name));
            
            CString  ios_filename(m_CStr_ios_path);
            ios_filename   += ((_FSI_STL::string)CVar_filename).c_str();

            if (m_int_copy_direction      == HOST_TO_IOS)
               GetReadyToCopyFileAndReportErrors(m_CStr_host_path_and_file, ios_filename);
            else if (m_int_copy_direction == IOS_TO_HOST)
               GetReadyToCopyFileAndReportErrors(ios_filename,  m_CStr_host_path_and_file);
         }
         break;

      case  HOST:
         {
            CVariant CVar_filename;
            CCommsShared::GetHostValue(CVar_filename,   _FSI_STL::string(m_CStr_variable_name));
            
            CString  ios_filename(m_CStr_ios_path);
            ios_filename   += ((_FSI_STL::string)CVar_filename).c_str();
            ios_filename.TrimRight();

            if (m_int_copy_direction      == HOST_TO_IOS)
               GetReadyToCopyFileAndReportErrors(m_CStr_host_path_and_file, ios_filename);
            else if (m_int_copy_direction == IOS_TO_HOST)
               GetReadyToCopyFileAndReportErrors(ios_filename,  m_CStr_host_path_and_file);
         }
         break;
   }

   m_sync.Unlock();
   return   LBU_OK;
}


void  CFindAndCopyAction::OnUpdate()
{
   m_sync.Lock();

   if (m_bDeleting == true)
   {
      m_sync.Unlock();
      return;
   }

   // Make sure this instance is attached to a graphical element.
   if (CWidget::IsValidAddress(m_pParentWidget) != VALID)
   {
      m_sync.Unlock();
      return;
   }

   if (m_int_use_variable_for_filename == NONE)
   {
      CVariant var;
      _FSI_STL::string  stlStrVariable;
      stlStrVariable =  (LPCTSTR)m_CStr_variable_to_remember_filename;
      CCommsShared::GetLocalValue(var, stlStrVariable);
      CString     current_filename(((_FSI_STL::string)var).c_str());

      // Look up file list here.
      CString     ios_filename(m_CStr_ios_path  +  "*."  +  m_CStr_primary_extension);
      CFileFind   finder;
      BOOL  bWorking =  finder.FindFile(ios_filename);
      long  index    =  0;
      if (current_filename.IsEmpty())
         m_list_of_files[index].push_back((LPCTSTR)"Please make a selection...");
      else
         m_list_of_files[index].push_back((LPCTSTR)current_filename);

      index++;
      while (bWorking)
      {
         bWorking =  finder.FindNextFile();
         CString  filename(finder.GetFileTitle());
         if (current_filename == filename)
            continue;
         m_list_of_files[index].push_back((LPCTSTR)filename);
         index++;
      }

      ((CComboWidget *)m_pParentWidget)->Entries(m_list_of_files);
   }

   m_sync.Unlock();
}


void  CFindAndCopyAction::ResetProperties()
{
   CWidget::ResetProperties();
   CXMLElement   *pXMLElement   =  NULL;
   POSITION      pos            =  NULL;

   // Find the element.
   if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("HOST_PATH_AND_FILE")) == true)
   {
      m_CStr_host_path_and_file = pXMLElement->ElementValue().c_str();
   }
   else    // No element.  Add a new one.
   {
      m_pXMLWidget->AddElement(_FSI_STL::string("HOST_PATH_AND_FILE"), _FSI_STL::string((LPCTSTR)m_CStr_host_path_and_file), NULL);
   }

   pXMLElement = NULL;
   if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("IOS_PATH")) == true)
   {
      m_CStr_ios_path   = pXMLElement->ElementValue().c_str();
   }
   else    // No element.  Add a new one.
   {
      m_pXMLWidget->AddElement(_FSI_STL::string("IOS_PATH"), _FSI_STL::string((LPCTSTR)m_CStr_ios_path), NULL);
   }


   if (m_CStr_ios_path  != "")
   {
      BOOL  bRetVal  =  CreateDirectory(LPCTSTR(m_CStr_ios_path),  NULL);
      if (!bRetVal)
      {
         DWORD dwLastErr   =  GetLastError();
         if (dwLastErr     != ERROR_ALREADY_EXISTS)
         {
            CString  strErrNum;
            strErrNum.Format("%d", dwLastErr);
            CString  msg   =  "Error #" + strErrNum + " attempting to create " + m_CStr_ios_path;
            ::MessageBox(NULL,   "FILE ERROR",  (LPCTSTR)msg,  MB_OK | MB_ICONINFORMATION);
         }
      }
   }


   pXMLElement =  NULL;
   if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("OPTIONS")) == true)
   {
      STRING2STRING_MAP::iterator   s2sIt =  NULL;

      if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("USE_VARIABLE_FOR_FILENAME"))  == true)
      {
         if ((*s2sIt).second.c_str()         == _FSI_STL::string("NONE"))
            m_int_use_variable_for_filename  =  NONE;
         else if ((*s2sIt).second.c_str()    == _FSI_STL::string("LOCAL"))
            m_int_use_variable_for_filename  =  LOCAL;
         else if ((*s2sIt).second.c_str()    == _FSI_STL::string("HOST"))
            m_int_use_variable_for_filename  =  HOST;
      }
      else
      {
         switch   (m_int_use_variable_for_filename)
         {
            case  NONE:
               pXMLElement->AddAttribute(_FSI_STL::string("USE_VARIABLE_FOR_FILENAME"),   _FSI_STL::string("NONE"));
               break;
            case  LOCAL:
               pXMLElement->AddAttribute(_FSI_STL::string("USE_VARIABLE_FOR_FILENAME"),   _FSI_STL::string("LOCAL"));
               break;
            case  HOST:
               pXMLElement->AddAttribute(_FSI_STL::string("USE_VARIABLE_FOR_FILENAME"),   _FSI_STL::string("HOST"));
               break;
         }
      }

      if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("COPY_DIRECTION"))  == true)
      {
         if ((*s2sIt).second.c_str()      == _FSI_STL::string("HOST_TO_IOS"))
            m_int_copy_direction          =  HOST_TO_IOS;
         else if ((*s2sIt).second.c_str() == _FSI_STL::string("IOS_TO_HOST"))
            m_int_copy_direction          =  IOS_TO_HOST;
      }
      else
      {
         switch   (m_int_copy_direction)
         {
            case  HOST_TO_IOS:
               pXMLElement->AddAttribute(_FSI_STL::string("COPY_DIRECTION"),   _FSI_STL::string("HOST_TO_IOS"));
               break;
            case  IOS_TO_HOST:
               pXMLElement->AddAttribute(_FSI_STL::string("COPY_DIRECTION"),   _FSI_STL::string("IOS_TO_HOST"));
               break;
         }
      }


      if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("VARIABLE_NAME"))  == true)
      {
         m_CStr_variable_name =  (*s2sIt).second.c_str();
      }
      else
      {
         pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_NAME"),   _FSI_STL::string(m_CStr_variable_name));
      }


      if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("PRIMARY_EXTENSION"))  == true)
      {
         m_CStr_primary_extension   =  (*s2sIt).second.c_str();
      }
      else
      {
         pXMLElement->AddAttribute(_FSI_STL::string("PRIMARY_EXTENSION"),   _FSI_STL::string(m_CStr_primary_extension));
      }


      if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("SECONDARY_EXTENSION"))  == true)
      {
         m_CStr_secondary_extension =  (*s2sIt).second.c_str();
      }
      else
      {
         pXMLElement->AddAttribute(_FSI_STL::string("SECONDARY_EXTENSION"),   _FSI_STL::string(m_CStr_secondary_extension));
      }
   }
   else  // No element was found.  Add an OPTIONS element and set it to the default options.
   {
      m_pXMLWidget->AddElement(_FSI_STL::string("OPTIONS"), _FSI_STL::string(""), NULL);
      pXMLElement =  NULL;
      if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("OPTIONS")) == true)
      {
         switch   (m_int_use_variable_for_filename)
         {
            case  NONE:
               pXMLElement->AddAttribute(_FSI_STL::string("USE_VARIABLE_FOR_FILENAME"),   _FSI_STL::string("NONE"));
               break;
            case  LOCAL:
               pXMLElement->AddAttribute(_FSI_STL::string("USE_VARIABLE_FOR_FILENAME"),   _FSI_STL::string("LOCAL"));
               break;
            case  HOST:
               pXMLElement->AddAttribute(_FSI_STL::string("USE_VARIABLE_FOR_FILENAME"),   _FSI_STL::string("HOST"));
               break;
         }


         switch   (m_int_copy_direction)
         {
            case  HOST_TO_IOS:
               pXMLElement->AddAttribute(_FSI_STL::string("COPY_DIRECTION"),  _FSI_STL::string("HOST_TO_IOS"));
               break;
            case  IOS_TO_HOST:
               pXMLElement->AddAttribute(_FSI_STL::string("COPY_DIRECTION"),  _FSI_STL::string("IOS_TO_HOST"));
               break;
         }


         pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_NAME"),         _FSI_STL::string(m_CStr_variable_name));


         pXMLElement->AddAttribute(_FSI_STL::string("PRIMARY_EXTENSION"),     _FSI_STL::string(m_CStr_primary_extension));

         pXMLElement->AddAttribute(_FSI_STL::string("SECONDARY_EXTENSION"),   _FSI_STL::string(m_CStr_secondary_extension));
      }
   }


   pXMLElement =  NULL;
   if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("OPTIONS_FROM_PAGE_2")) == true)
   {
      STRING2STRING_MAP::iterator   s2sIt =  NULL;

      if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("VARIABLE_TO_MONITOR"))  == true)
      {
         if ((*s2sIt).second.c_str()      == _FSI_STL::string("NONE"))
            m_int_variable_to_monitor     =  NO_VARIABLE;
         else if ((*s2sIt).second.c_str() == _FSI_STL::string("LOCAL"))
            m_int_variable_to_monitor     =  LOCAL_VARIABLE;
         else if ((*s2sIt).second.c_str() == _FSI_STL::string("HOST"))
            m_int_variable_to_monitor     =  HOST_VARIABLE;
      }
      else
      {
         switch   (m_int_use_variable_for_filename)
         {
            case  NO_VARIABLE:
               pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_MONITOR"),   _FSI_STL::string("NONE"));
               break;
            case  LOCAL_VARIABLE:
               pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_MONITOR"),   _FSI_STL::string("LOCAL"));
               break;
            case  HOST_VARIABLE:
               pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_MONITOR"),   _FSI_STL::string("HOST"));
               break;
         }
      }

      if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("VARIABLE_NAME"))  == true)
      {
         m_CStr_variable_to_monitor_name  =  (*s2sIt).second.c_str();
      }
      else
      {
         pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_NAME"),   _FSI_STL::string(m_CStr_variable_to_monitor_name));
      }
////////////////////////

      if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("VARIABLE_TO_SET"))  == true)
      {
         if ((*s2sIt).second.c_str()      == _FSI_STL::string("NONE"))
            m_int_variable_to_set         =  NO_VARIABLE;
         else if ((*s2sIt).second.c_str() == _FSI_STL::string("LOCAL"))
            m_int_variable_to_set         =  LOCAL_VARIABLE;
         else if ((*s2sIt).second.c_str() == _FSI_STL::string("HOST"))
            m_int_variable_to_set         =  HOST_VARIABLE;
      }
      else
      {
         switch   (m_int_use_variable_for_filename)
         {
            case  NO_VARIABLE:
               pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_SET"),   _FSI_STL::string("NONE"));
               break;
            case  LOCAL_VARIABLE:
               pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_SET"),   _FSI_STL::string("LOCAL"));
               break;
            case  HOST_VARIABLE:
               pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_SET"),   _FSI_STL::string("HOST"));
               break;
         }
      }


      if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("SET_VARIABLE_NAME"))  == true)
      {
         m_CStr_variable_to_set_name   =  (*s2sIt).second.c_str();
      }
      else
      {
         pXMLElement->AddAttribute(_FSI_STL::string("SET_VARIABLE_NAME"),   _FSI_STL::string(m_CStr_variable_to_set_name));
      }

////////////////////////

      if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("VARIABLE_TO_REMEMBER_FILENAME"))  == true)
      {
         if ((*s2sIt).second.c_str()      == _FSI_STL::string("NONE"))
            m_int_variable_to_remember_filename =  NO_VARIABLE;
         else if ((*s2sIt).second.c_str() == _FSI_STL::string("LOCAL"))
            m_int_variable_to_remember_filename =  LOCAL_VARIABLE;
         else if ((*s2sIt).second.c_str() == _FSI_STL::string("HOST"))
            m_int_variable_to_remember_filename =  HOST_VARIABLE;
      }
      else
      {
         switch   (m_int_variable_to_remember_filename)
         {
            case  NO_VARIABLE:
               pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_REMEMBER_FILENAME"),   _FSI_STL::string("NONE"));
               break;
            case  LOCAL_VARIABLE:
               pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_REMEMBER_FILENAME"),   _FSI_STL::string("LOCAL"));
               break;
            case  HOST_VARIABLE:
               pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_REMEMBER_FILENAME"),   _FSI_STL::string("HOST"));
               break;
         }
      }


      if (pXMLElement->FindAttribute(s2sIt,  _FSI_STL::string("VARIABLE_FOR_FILENAME"))  == true)
      {
         m_CStr_variable_to_remember_filename   =  (*s2sIt).second.c_str();
      }
      else
      {
         pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_FOR_FILENAME"),   _FSI_STL::string(m_CStr_variable_to_remember_filename));
      }

   }
   else  // No element was found.  Add an OPTIONS element and set it to the default options.
   {
      m_pXMLWidget->AddElement(_FSI_STL::string("OPTIONS_FROM_PAGE_2"), _FSI_STL::string(""), NULL);
      pXMLElement =  NULL;
      if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("OPTIONS_FROM_PAGE_2")) == true)
      {
         switch   (m_int_variable_to_monitor)
         {
            case  NO_VARIABLE:
               pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_MONITOR"),   _FSI_STL::string("NONE"));
               break;
            case  LOCAL_VARIABLE:
               pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_MONITOR"),   _FSI_STL::string("LOCAL"));
               break;
            case  HOST_VARIABLE:
               pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_MONITOR"),   _FSI_STL::string("HOST"));
               break;
         }

         pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_NAME"),   _FSI_STL::string(m_CStr_variable_to_monitor_name));

////////////////////////
         switch   (m_int_variable_to_set)
         {
            case  NO_VARIABLE:
               pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_SET"),   _FSI_STL::string("NONE"));
               break;
            case  LOCAL_VARIABLE:
               pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_SET"),   _FSI_STL::string("LOCAL"));
               break;
            case  HOST_VARIABLE:
               pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_SET"),   _FSI_STL::string("HOST"));
               break;
         }


         pXMLElement->AddAttribute(_FSI_STL::string("SET_VARIABLE_NAME"),   _FSI_STL::string(m_CStr_variable_to_set_name));


////////////////////////
         switch   (m_int_variable_to_remember_filename)
         {
            case  NO_VARIABLE:
               pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_REMEMBER_FILENAME"),   _FSI_STL::string("NONE"));
               break;
            case  LOCAL_VARIABLE:
               pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_REMEMBER_FILENAME"),   _FSI_STL::string("LOCAL"));
               break;
            case  HOST_VARIABLE:
               pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_TO_REMEMBER_FILENAME"),   _FSI_STL::string("HOST"));
               break;
         }


         pXMLElement->AddAttribute(_FSI_STL::string("VARIABLE_FOR_FILENAME"),   _FSI_STL::string(m_CStr_variable_to_set_name));

      }
   }
}


void  CFindAndCopyAction::GetReadyToCopyFileAndReportErrors(CString &source, CString &destination)
{
   switch   (m_int_variable_to_set)
   {
      case  NO_VARIABLE:
         {
            m_copy_param.variable_to_set           =  NONE;
         }
         break;

      case  LOCAL_VARIABLE:
         {
            m_copy_param.variable_to_set           =  m_CStr_variable_to_set_name;
            m_copy_param.type_of_variable_to_set   =  m_int_variable_to_set;
         }
         break;

      case  HOST_VARIABLE:
         {
            m_copy_param.variable_to_set           =  m_CStr_variable_to_set_name;
            m_copy_param.type_of_variable_to_set   =  m_int_variable_to_set;
         }
         break;
   }

   switch   (m_int_variable_to_monitor)
   {
      case  NO_VARIABLE:
         {
            m_copy_param.source              =  source;
            m_copy_param.destination         =  destination;
            m_copy_param.variable            =  m_CStr_variable_to_monitor_name;
            m_copy_param.type_of_variable    =  m_int_variable_to_monitor;
            m_copy_param.primary_extension   =  m_CStr_primary_extension;
            m_copy_param.secondary_extension =  m_CStr_secondary_extension;

            AfxBeginThread(ThreadWaitBeforeCopying, (LPVOID)&m_copy_param);
         }
         break;

      case  LOCAL_VARIABLE:
         {
            m_copy_param.source              =  source;
            m_copy_param.destination         =  destination;
            m_copy_param.variable            =  m_CStr_variable_to_monitor_name;
            m_copy_param.type_of_variable    =  m_int_variable_to_monitor;
            m_copy_param.primary_extension   =  m_CStr_primary_extension;
            m_copy_param.secondary_extension =  m_CStr_secondary_extension;

            AfxBeginThread(ThreadWaitBeforeCopying, (LPVOID)&m_copy_param);
         }
         break;

      case  HOST_VARIABLE:
         {
            m_copy_param.source              =  source;
            m_copy_param.destination         =  destination;
            m_copy_param.variable            =  m_CStr_variable_to_monitor_name;
            m_copy_param.type_of_variable    =  m_int_variable_to_monitor;
            m_copy_param.primary_extension   =  m_CStr_primary_extension;
            m_copy_param.secondary_extension =  m_CStr_secondary_extension;

            AfxBeginThread(ThreadWaitBeforeCopying, (LPVOID)&m_copy_param);
         }
         break;
   }
}


UINT CFindAndCopyAction::ThreadWaitBeforeCopying(LPVOID param)
{
   COPY_PARAMETERS   *copy_param;
   copy_param     =  (COPY_PARAMETERS  *)param;
   bool  retval;

   // If there is a variable to set - set it to false before copying...
   switch   (copy_param->type_of_variable_to_set)
   {
      case  NO_VARIABLE:
         break;

      case  LOCAL_VARIABLE:
         {
            CVariant var;
            _FSI_STL::string  stlStrVariable;
            stlStrVariable =  (LPCTSTR)copy_param->variable_to_set;

            CCommsShared::GetLocalValue(var, stlStrVariable);
            long  old_type =  var.Type();
            var.Value(false);
            var.ChangeType(old_type);
            CCommsShared::SetLocalValue(var, stlStrVariable, 0);
         }
         break;

      case  HOST_VARIABLE:
         {
            CVariant var;
            _FSI_STL::string  stlStrVariable;
            stlStrVariable =  (LPCTSTR)copy_param->variable_to_set;

            CCommsShared::GetHostValue(var, stlStrVariable);
            long  old_type =  var.Type();
            var.Value(false);
            var.ChangeType(old_type);
            if (old_type   == 0)
               CCommsShared::SetHostValue(var, stlStrVariable, -1);
            else
               CCommsShared::SetHostValue(var, stlStrVariable, 0);
         }
         break;
   }

   // Copy the file...
   switch   (copy_param->type_of_variable)
   {
      case  NO_VARIABLE:
         {
            CWorkingDlg    workingDlg;
            workingDlg.m_CStr_source               =  copy_param->source;
            workingDlg.m_CStr_destination          =  copy_param->destination;
            workingDlg.m_CStr_primary_extension    =  copy_param->primary_extension;
            workingDlg.m_CStr_secondary_extension  =  copy_param->secondary_extension;
            workingDlg.m_CStr_start_caption        =  "Copying data...";
            workingDlg.m_CStr_finish_caption       =  "Finished copying data.";

            if (workingDlg.DoModal()   == IDOK)
               retval   =  true;
            else
               retval   =  false;
         }
         break;

      case  LOCAL_VARIABLE:
         {
            CVariant CVar_flag;
            CVar_flag.Value(true);
            
            while ((bool)CVar_flag)
            {
               CCommsShared::GetLocalValue(CVar_flag,  _FSI_STL::string(copy_param->variable));
               Sleep(500);
            }
            CWorkingDlg    workingDlg;
            workingDlg.m_CStr_source               =  copy_param->source;
            workingDlg.m_CStr_destination          =  copy_param->destination;
            workingDlg.m_CStr_primary_extension    =  copy_param->primary_extension;
            workingDlg.m_CStr_secondary_extension  =  copy_param->secondary_extension;
            workingDlg.m_CStr_start_caption        =  "Copying data...";
            workingDlg.m_CStr_finish_caption       =  "Finished copying data.";

            if (workingDlg.DoModal()   == IDOK)
               retval   =  true;
            else
               retval   =  false;
         }
         break;

      case  HOST_VARIABLE:
         {
            CVariant CVar_flag;
            CVar_flag.Value(true);
            
            while ((bool)CVar_flag)
            {
               CCommsShared::GetHostValue(CVar_flag,  _FSI_STL::string(copy_param->variable));
               Sleep(500);
            }
            CWorkingDlg    workingDlg;
            workingDlg.m_CStr_source               =  copy_param->source;
            workingDlg.m_CStr_destination          =  copy_param->destination;
            workingDlg.m_CStr_primary_extension    =  copy_param->primary_extension;
            workingDlg.m_CStr_secondary_extension  =  copy_param->secondary_extension;
            workingDlg.m_CStr_start_caption        =  "Copying data...";
            workingDlg.m_CStr_finish_caption       =  "Finished copying data.";
      
            if (workingDlg.DoModal()   == IDOK)
               retval   =  true;
            else
               retval   =  false;
         }
         break;
   }


   // If there is a variable to set - set it to true after copying - if the copy was successful...
   switch   (copy_param->type_of_variable_to_set)
   {
      case  NO_VARIABLE:
         break;

      case  LOCAL_VARIABLE:
         {
            CVariant var;
            _FSI_STL::string  stlStrVariable;
            stlStrVariable =  (LPCTSTR)copy_param->variable_to_set;

            CCommsShared::GetLocalValue(var, stlStrVariable);
            long  old_type =  var.Type();
            var.Value(retval);
            var.ChangeType(old_type);
            CCommsShared::SetLocalValue(var, stlStrVariable, 0);
         }
         break;

      case  HOST_VARIABLE:
         {
            CVariant var;
            _FSI_STL::string  stlStrVariable;
            stlStrVariable =  (LPCTSTR)copy_param->variable_to_set;

            CCommsShared::GetHostValue(var, stlStrVariable);
            long  old_type =  var.Type();
            var.Value(retval);
            var.ChangeType(old_type);
            if (old_type   == 0)
               CCommsShared::SetHostValue(var, stlStrVariable, -1);
            else
               CCommsShared::SetHostValue(var, stlStrVariable, 0);
         }
         break;
   }

   return 0;
}
