/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : EditWidget.h
//
// Date             : 30 August 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.6 $
//
// Description      : EditWidget.h contains the definition of the 
//                    CEditWidget class.  This class will create a 
//                    CEdit control for entering data.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CVariant, CEdit, Core::CWidget.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: EditWidget.h $                                                                   
// Revision 1.6  2000/03/07 20:40:09  billyb                                                                   
// Changed function signatures to eliminate warnings.                                                                   
// Revision 1.5  2000/02/03 23:57:45  billyb                                                                   
// Corrected blanking of edit widget once a value is accepted.                                                                   
// Revision 1.4  2000/01/24 08:54:00  billyb                                                                   
// Added OnPaint message handler.                                                                   
// Revision 1.3  1999/10/05 00:53:03  billyb                                                                   
// Removed ResetProperties.                                                                   
// Revision 1.2  1999/08/30 22:11:10  billyb                                                                   
// Added comments.  Added two strings for data to set the window text of the                                                                   
// edit control.                                                                   
/////////////////////////////////////////////////////////////////////////////
#if !defined(_EDITWIDGET_H_)
#define _EDITWIDGET_H_

#include "..\core\Widget.h"

#include "resource.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CEditWidget : public CEdit, public CWidget
{
// Construction
public:
	CEditWidget();
   virtual void ResetProperties();

// Attributes
protected:
    bool                m_bUpperCase;
    bool                m_bClearEdit;
    _FSI_STL::string    m_stlStrText;
    _FSI_STL::string    m_stlStrText_cv;

    virtual void InitReinit();

public:
   	enum { IDB = IDB_EDIT_WIDGET };

// Operations
public:
    static CWidget* CreateObject();
    virtual void    Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                               const long int lId, bool bEditMode);
    virtual void    Draw();

    virtual void    ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);
    virtual bool    UpdateRenderVariables();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CEditWidget)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual CVariant * GetValue(const CString &rstrValue);
	virtual ~CEditWidget();

	// Generated message map functions
protected:
	//{{AFX_MSG(CEditWidget)
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnWindowPosChanged(WINDOWPOS FAR* lpwndpos);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnPaint();
	afx_msg void OnNcPaint();
    afx_msg void OnSetFocus(CWnd* pOldWnd);
    afx_msg void OnKillFocus(CWnd* pNewWnd);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

private:
    bool UpdateActions();
    bool m_dataHasChanged;
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_EDITWIDGET_H__E25DDA76_54ED_11D2_9E47_00600801EDCF__INCLUDED_)
