/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : EditWidget.cpp
//
// Date             : 30 August 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.13 $
//
// Description      : EditWidget.cpp contains the implementation of the 
//                    CEditWidget class.  This class will create a 
//                    CEdit control for entering data.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CVariant, CEdit, Core::CWidget.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: EditWidget.cpp $                                                                   
// Revision 1.13  2000/03/07 20:40:09  billyb                                                                   
// Changed function signatures to eliminate warnings.                                                                   
// Revision 1.12  2000/02/04 19:39:28  billyb                                                                   
// Put WS_BORDER style back in.                                                                   
// Revision 1.11  2000/02/03 23:57:41  billyb                                                                   
// Corrected blanking of edit widget once a value is accepted.                                                                   
// Revision 1.10  2000/02/03 07:28:05  billyb                                                                   
// Removed WS_BORDER to fix some drawing problems.                                                                   
// Revision 1.9  2000/01/24 08:56:12  billyb                                                                   
// Added OnPaint message handler to tell the update system                                                                   
// to add the widget instance to the list to update if the view                                                                   
// that contains the edit widget is not already drawing.                                                                   
// Revision 1.8  1999/11/09 21:12:05  billyb                                                                   
// Optimized loop.  Added WS_CLIPCHILDREN.                                                                   
// Revision 1.7  1999/10/20 18:42:55  billyb                                                                   
// Made PreTranslateMessage watch for an invalid range from                                                                   
// the attached actions.  If one is found, then the data in edit                                                                   
// window is not cleared.                                                                   
// Revision 1.6  1999/10/05 00:53:01  billyb                                                                   
// Removed ResetProperties.                                                                   
// Revision 1.5  1999/09/14 19:58:32  billyb                                                                   
// Added null handling of return key down in                                                                    
// PreTranslateMessage to prevent a beep from occurring.                                                                   
// Revision 1.4  1999/09/03 19:45:04  billyb                                                                   
// Fixed PreTranslateMessage to only process return keystrokes                                                                   
// when the WM_KEYUP message occurs.                                                                   
// Revision 1.3  1999/08/30 22:12:57  billyb                                                                   
// Added comments.  Removed unneeded code in PreTranslateMessage when a RETURN is detected.  Made ChangeValue and UpdateRenderVariables work like CTextWidget.                                                                    
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "EditWidget.h"
#include "..\core\UpdateList.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CEditWidget

CEditWidget::CEditWidget()  : CWidget()
{
    m_stlStrWidgetName  = _FSI_STL::string("Edit");

    CEditWidget::InitReinit();
}

void CEditWidget::InitReinit()
{
    m_bUpperCase        = false;
    m_bClearEdit        = false;
    m_stlStrText        = _FSI_STL::string("");
    m_stlStrText_cv     = m_stlStrText;
    m_dataHasChanged    = false;
}

CEditWidget::~CEditWidget()
{
}


BEGIN_MESSAGE_MAP(CEditWidget, CEdit)
	//{{AFX_MSG_MAP(CEditWidget)
	ON_WM_LBUTTONDBLCLK()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_SETCURSOR()
	ON_WM_WINDOWPOSCHANGED()
	ON_WM_RBUTTONUP()
	ON_WM_CHAR()
	ON_WM_PAINT()
	ON_WM_NCPAINT()
	ON_WM_SETFOCUS()
	ON_WM_KILLFOCUS()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEditWidget message handlers
CWidget* CEditWidget::CreateObject()
{
    return new CEditWidget();
}

void CEditWidget::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                               const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    CEditWidget::InitReinit();

    if (rpXMLWidget != NULL)
    {
        ResetProperties();
    }

    if (GetSafeHwnd() == NULL)
    {
        if (m_bUpperCase == true)
        {
            CreateEx(WS_EX_CLIENTEDGE, "EDIT", "", 
                     WS_TABSTOP | WS_CHILD | WS_VISIBLE | WS_BORDER | ES_AUTOHSCROLL | ES_LEFT | ES_UPPERCASE | WS_CLIPCHILDREN, 
                     CRect(m_exPtUpperLeft, m_exPtLowerRight),
                     (CWnd*)pWnd,lId);
        }
        else
        {
            CreateEx(WS_EX_CLIENTEDGE, "EDIT", "", 
                     WS_TABSTOP | WS_CHILD | WS_VISIBLE | WS_BORDER | ES_AUTOHSCROLL | ES_LEFT | WS_CLIPCHILDREN, 
                     CRect(m_exPtUpperLeft, m_exPtLowerRight),
                     (CWnd*)pWnd,lId);
        }
    }
    else
    {
        if (m_bUpperCase == true)
        {
            ModifyStyle(0, ES_UPPERCASE);
        }
        else
        {
            ModifyStyle(ES_UPPERCASE, 0);
        }

        SetParent(pWnd);
        MoveWindow(m_exPtUpperLeft.X(), m_exPtUpperLeft.Y(),
                   m_exPtLowerRight.X() - m_exPtUpperLeft.X(),
                   m_exPtLowerRight.Y() - m_exPtUpperLeft.Y(), FALSE);
        ShowWindow(SW_NORMAL);
    }

    m_pWnd = this;
    m_mapValidAddresses[this] = m_pWnd->GetSafeHwnd();    
}

void CEditWidget::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	CEdit::OnLButtonDblClk(nFlags, point);
}

void CEditWidget::OnLButtonDown(UINT nFlags, CPoint point) 
{
    if (m_bEditing == true)
    {
        CWidget::Track(point);
    }
    else
    {
       CEdit::OnLButtonDown(nFlags, point);
       CEdit::SetSel(0, -1);
    }
	
}

void CEditWidget::OnLButtonUp(UINT nFlags, CPoint point) 
{
    if (m_bEditing == true)
    {
    }
    else
    {
    	CEdit::OnLButtonUp(nFlags, point);
    }
}

BOOL CEditWidget::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
    if (m_bEditing == true && m_pTracker != NULL)
    {
        if (pWnd == this && m_pTracker->SetCursor(pWnd, nHitTest))
        {
            return TRUE;
        }
    }
	
	return CEdit::OnSetCursor(pWnd, nHitTest, message);
}

void CEditWidget::OnWindowPosChanged(WINDOWPOS FAR* lpwndpos) 
{
	CEdit::OnWindowPosChanged(lpwndpos);

    CWidget::PosChanged(CRect(lpwndpos->x, lpwndpos->y,
                              lpwndpos->x + lpwndpos->cx,
                              lpwndpos->y + lpwndpos->cy));
}

void CEditWidget::OnRButtonUp(UINT nFlags, CPoint point) 
{
    CWidget::RButtonUp(nFlags, point);
}

CVariant * CEditWidget::GetValue(const CString &rstrValue)
{
   CString  edit_value;
   GetWindowText(edit_value);

   m_variant.Value(_FSI_STL::string((LPCTSTR)edit_value));
   return(&m_variant);
}

void CEditWidget::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
    if (nChar == VK_TAB)
    {
        CWnd* pWnd = NULL;
        if (GetKeyState(VK_SHIFT) < 0)
        {
            CFrameWnd* pFrame = GetParentFrame();

            pFrame->SendMessage(WM_GET_PREV_TAB, (long)(&pWnd), (long)this);
            if (pWnd != NULL)
            {
                pWnd->SetFocus();
            }
        }
        else
        {
            CFrameWnd* pFrame = GetParentFrame();

            pFrame->SendMessage(WM_GET_NEXT_TAB, (long)(&pWnd), (long)this);
            if (pWnd != NULL)
            {
                pWnd->SetFocus();
            }
        }
    }
    else
    {
        CEdit::OnChar(nChar, nRepCnt, nFlags);
        m_dataHasChanged = true;
    }
}

BOOL CEditWidget::PreTranslateMessage(MSG* pMsg) 
{
    if (pMsg->wParam   == VK_RETURN && pMsg->message == WM_KEYUP)
    {
        if (m_bEditing == false)
        {
            m_bClearEdit = UpdateActions();
            if (m_bClearEdit == true)
            {
                Invalidate();
            }
        }

        return TRUE;
    }
    else if (pMsg->wParam   == VK_RETURN && pMsg->message == WM_KEYDOWN)
    {
        return TRUE;
    }
    else if (pMsg->wParam   == VK_TAB    && pMsg->message == WM_KEYDOWN)
    {
        CWnd      *pWnd =  GetParentOwner();
  
        CString   test;
        while (test  != "class COverlayDlg"  && pWnd)
        {
           pWnd =  pWnd->GetParentOwner();
           
           if (test  == "class CMainFrame")
               return FALSE;

           type_info   &t =  (type_info   &)typeid(*pWnd);
           test  =  t.name();
        }

        if (pWnd != NULL)
        {
           if (GetKeyState(VK_SHIFT) < 0)
           {
               pWnd->SendMessage(WM_GET_PREV_TAB, (long)(&pWnd), (long)this);
               if (pWnd != NULL)
               {
                  pWnd->SetFocus();
               }
           }
           else
           {
               pWnd->SendMessage(WM_GET_NEXT_TAB, (long)(&pWnd), (long)this);
               if (pWnd != NULL)
               {
                  pWnd->SetFocus();
               }
           }
        }
        return TRUE;
    }
    else
    {
        return CEdit::PreTranslateMessage(pMsg);
    }
}

void CEditWidget::OnPaint() 
{
    HWND hWnd = BaseWidget()->Wnd()->GetParent()->GetSafeHwnd();
    if (CWidget::ScreenRedrawing(hWnd) == true)
    {
    }
    else
    {
        CUpdateList::AddPaintWidget(hWnd, this);
    }
}

void CEditWidget::Draw()
{
    if (IsWindowEnabled() == TRUE  && m_bEnabled == false ||
        IsWindowEnabled() == FALSE && m_bEnabled == true)
    {
        m_bRepaint = true;

        SetRedraw(FALSE);
        EnableWindow(m_bEnabled);
        SetRedraw(TRUE);
    }

    // We want to have the whole field highlighted even if the host is changing
    // the data.
    SetRedraw(FALSE);
    SetWindowText(m_stlStrText.c_str());
    CEdit::SetSel(0, -1);
    SetRedraw(TRUE);

    Invalidate();
    DefWindowProc(WM_NCPAINT, 1, 0);
    DefWindowProc(WM_PAINT, 0, 0);
}
/*
void CEditWidget::OnPaint() 
{
    HWND hWnd = BaseWidget()->Wnd()->GetParent()->GetSafeHwnd();
    if (CWidget::ScreenRedrawing(hWnd) == true)
    {
        if (IsWindowEnabled() == TRUE  && m_bEnabled == false ||
            IsWindowEnabled() == FALSE && m_bEnabled == true)
        {
            m_bRepaint = true;

            SetRedraw(FALSE);
            EnableWindow(m_bEnabled);
            SetRedraw(TRUE);
        }

        DefWindowProc(WM_NCPAINT, 1, 0);
        DefWindowProc(WM_PAINT, 0, 0);
    }
    else
    {
        CUpdateList::AddPaintWidget(hWnd, this);
    }

}
*/
//////////////////////////////////////////////////////////////////////
// Methods called from Comms thread
//////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
// void CEditWidget::ChangeValue()
//
// Inputs           : CString& rstrElementVar - the internal name of a 
//                                              variable that needs to be 
//                                              updated.
//                    CChangeValue* pCV       - pointer to data used to 
//                                              update an internal 
//                                              variable.
//
// Return Values    : None.
//
// Date             : 3 February 2000
//
// Engineer         : Billy Baker
//
// Description      : CEdit::ChangeValue() is a common framework 
//                    method that is used by the Comms thread to send 
//                    new data to the graphical elements.  Since it is 
//                    called from another thread, the special internal 
//                    variables are used to store the updates.  Before 
//                    the graphical element is redrawn, 
//                    UpdateRenderVariables is called to copy the 
//                    updated values to the values used for rendering.  
//                    This causes more memory to be used but prevents 
//                    the use of synchronization objects that may stall 
//                    the Comms thread.
//
/////////////////////////////////////////////////////////////////////////////
void CEditWidget::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
    if (pCV == NULL)
    {
        return;
    }


    if (rstrElementVar == "Default")
    {
        m_bClearEdit = false;

        if (pCV->UseRange() == true)
        {
            m_stlStrText_cv = pCV->Text();
        }
        else
        {
            m_stlStrText_cv = (_FSI_STL::string)*(pCV->Variant());
        }
    }
    else
    {
        CWidget::ChangeValue(rstrElementVar, pCV);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CEditWidget::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : status of whether the update was successful
//
// Date             : 16 July 1999
//
// Engineer         : Billy Baker
//
// Description      : CEditWidget::UpdateRenderVariables() is an 
//                    override of a common framework method.  It is 
//                    called before any scheduled redraw of the edit 
//                    box.  
//
/////////////////////////////////////////////////////////////////////////////
bool CEditWidget::UpdateRenderVariables()
{
    bool bRetVal = CWidget::UpdateRenderVariables();

    if (bRetVal == true)
    {
        if (m_bClearEdit == true)
        {
            m_stlStrText = _FSI_STL::string("");
            m_stlStrText_cv = m_stlStrText;
            m_bClearEdit = false;
        }
        else
        {
            m_stlStrText = m_stlStrText_cv;
        }
//        SetWindowText(m_stlStrText.c_str());
//        ::PostMessage(m_hWnd, WM_SETTEXT, NULL, (long)(LPCTSTR)m_stlStrText.c_str());
    }

    return bRetVal;
}

void CEditWidget::OnNcPaint() 
{
    // Do not do anything.  OnPaint will take care of 
    // drawing what would need to be drawn here.
}

void CEditWidget::OnSetFocus(CWnd* pOldWnd) 
{
   
	CEdit::OnSetFocus(pOldWnd);
    m_dataHasChanged = false;
}

void CEditWidget::OnKillFocus(CWnd* pNewWnd) 
{  
   CEdit::OnKillFocus(pNewWnd);
	
   if (m_dataHasChanged)
   {
        if (m_bEditing == false)
        {
            m_bClearEdit = UpdateActions();
            if (m_bClearEdit == true)
            {
                Invalidate();
            }
        }
   }
}

bool CEditWidget::UpdateActions(void)
{
//   bool  bClearEdit = true;
   bool  bClearEdit = false;

   _FSI_STL::list<CAction*>::iterator lIt = m_listActions.begin();
   _FSI_STL::list<CAction*>::iterator lendIt = m_listActions.end();
   while (lIt != lendIt)
   {
       if ((*lIt)->OnLButtonUp() == LBU_NOT_IN_RANGE)
       {
           bClearEdit = false;
       }

       lIt++;
   }
   m_dataHasChanged = false;

   return   bClearEdit;
}

void CEditWidget::ResetProperties()
{
   CWidget::ResetProperties();
   CWidget::ExtentsProperties();
}
