// PageAction.cpp: implementation of the CDynamicPageAction class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "DynamicPageAction.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

CString CDynamicPageAction::m_strPageInfo;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CDynamicPageAction::CDynamicPageAction()
{
    m_stlStrWidgetName = _FSI_STL::string("Dynamic_Change_Pages");
}

CDynamicPageAction::~CDynamicPageAction()
{
}

void CDynamicPageAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                const long lId, bool bEditMode)
{
    m_strPage = "Untitled.fml";
    m_strComponent = "IOS";
    m_strSubComponent = "PAGES";

    if (rpXMLWidget == NULL)
    {
        m_stlStrHelpText = "The " + m_stlStrName + " " + 
                           m_stlStrWidgetName.c_str() + 
                           " action will attempt to change the main page.";
        m_stlStrName = m_stlStrName + " " + m_stlStrWidgetName.c_str();
        m_stlStrHelpKeywords = m_stlStrName;
    }

    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    if (rpXMLWidget != NULL)
    {
        ResetProperties();
    }

    m_pAction = this;
    m_pWidget = (CWidget*)this;
}

CWidget* CDynamicPageAction::CreateObject()
{
    return new CDynamicPageAction();
}

void CDynamicPageAction::ResetProperties()
{
    CWidget::ResetProperties();
}

void CDynamicPageAction::OnLButtonUp()
{
    if (m_pParentWidget == NULL)
    {
        return;
    }

    CVariant m_pParentWidget->GetValue("Default");
    m_strPageInfo = CString(m_strComponent + "^" + m_strSubComponent + 
							"^" + m_strPage);

    CFrameWnd* pFrame = m_pBaseWidget->Wnd()->GetParent()->GetParentFrame();

	pFrame->PostMessage(WM_CHANGE_PAGE, 0, (long)(LPCTSTR)m_strPageInfo); 
}
