/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : ComboWidget.h
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.6 $
//
// Description      : ComboWidget.h contains the definition of 
//                    the CComboWidget class.  This class draws a 
//                    common Windows combo box and allows the user to 
//                    make a selection that will then be sent to the 
//                    comms system.  Only the simple and drop down list 
//                    styles are supported.
//
//                    The droplist version will allow "real" selection
//                    changes only when the return key is pressed or the
//                    mouse is clicked in the droplist.  Pressing the
//                    escape button will reset the combo box to the last
//                    values that was set in UpdateRenderVariables.
//
//                    The CComboListSpecial class is also implemented here.
//                    It is used to subclass the listbox protion of the
//                    combobox to get mouse clicks on the listbox portion.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CWidget, _FSI_STL::string, _FSI_STL::list, 
//                    CComboBox, CString.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: ComboWidget.h $                                                                   
// Revision 1.6  2000/03/07 20:39:46  billyb                                                                   
// Changed function signatures to eliminate warnings.                                                                   
// Revision 1.5  2000/01/05 07:16:21  billyb                                                                   
// Added OnPaint method and m_bDataChanged member.                                                                   
// Revision 1.4  1999/12/16 08:12:48  billyb                                                                   
// Changed data structure for entries and the way that the entries                                                                   
// are added to the combobox.                                                                   
// Revision 1.3  1999/11/30 06:58:20  billyb                                                                   
// Added CComboListSpecial.  Added methods to use range                                                                   
// data to fill combobox.  Added methods to handle key                                                                   
// presses and mouse clicks for droplists.                                                                   
// Revision 1.2  1999/10/04 04:09:50  billyb                                                                   
// Added comments.  Fixed the lack of the drop down when                                                                   
// using a dropdownlist.  Added all of the methods needed                                                                   
// for use with comms.  Added OnSelchange to tell comms                                                                   
// of new data.                                                                   
/////////////////////////////////////////////////////////////////////////////
#if !defined(_COMBOWIDGET_H_)
#define _COMBOWIDGET_H_

#include "..\core\Widget.h"

#include "resource.h"

#ifdef GENERAL
#define GENERALAPI __declspec( dllexport )
#else
#define GENERALAPI __declspec( dllimport )
#endif

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CComboListSpecial : public CListBox
{
// Construction
public:
	CComboListSpecial();

// Attributes
private:
    bool                m_bNewValue;

public:

// Operations
public:

    // Accessors
    bool    NewValue();

    // Mutators
    void    NewValue(const bool bNewValue);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CComboListSpecial)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CComboListSpecial();

	// Generated message map functions
protected:
	//{{AFX_MSG(CComboListSpecial)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

class GENERALAPI  CComboWidget : public CComboBox, public CWidget
{
// Construction
public:
	CComboWidget();

// Attributes
private:
    long int                m_lOptions;

    CComboListSpecial       m_wndListBox;

    _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> > m_mapEntries;

    _FSI_STL::string        m_stlStrSelection;
    _FSI_STL::string        m_stlStrTextForSelection;
    bool                    m_bDataChanged;

protected:

    virtual void InitReinit();

public:
   	enum { IDB = IDB_COMBO_WIDGET };

// Operations
public:
    static CWidget*     CreateObject();
    virtual void        Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                   const long int lId, bool bEditMode);
    virtual void        ResetProperties();
    virtual void        Draw();

    virtual void        AddRangeData(const CRange* pRange, const _FSI_STL::string stlStrVariable);
    _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> > Entries();
    void                Entries(_FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> > &);


	virtual CVariant*   GetValue(const CString &rstrValue);

    virtual void        ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);
    virtual bool        UpdateRenderVariables();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CComboWidget)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CComboWidget();

	// Generated message map functions
protected:
	//{{AFX_MSG(CComboWidget)
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnDestroy();
	afx_msg void OnWindowPosChanged(WINDOWPOS FAR* lpwndpos);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);
	afx_msg void OnCloseup();
	afx_msg void OnPaint();
	afx_msg void OnNcPaint();
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(_COMBOWIDGET_H_)
