/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : ComboWidget.cpp
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.11 $
//
// Description      : ComboWidget.cpp contains the implementation of 
//                    the CComboWidget class.  This class draws a 
//                    common Windows combo box and allows the user to 
//                    make a selection that will then be sent to the 
//                    comms system.  Only the simple and drop down list 
//                    styles are supported.
//
//                    The droplist version will allow "real" selection
//                    changes only when the return key is pressed or the
//                    mouse is clicked in the droplist.  Pressing the
//                    escape button will reset the combo box to the last
//                    values that was set in UpdateRenderVariables.
//
//                    The CComboListSpecial class is also implemented here.
//                    It is used to subclass the listbox protion of the
//                    combobox to get mouse clicks on the listbox portion.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CWidget, _FSI_STL::string, _FSI_STL::list, 
//                    CComboBox, CString.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: ComboWidget.cpp $                                                                   
// Revision 1.11  2000/03/07 20:39:58  billyb                                                                   
// Changed function signatures to eliminate warnings.                                                                   
// Revision 1.10  2000/01/27 17:03:37  billyb                                                                   
// Added code to OnPaint to make sure that drawing only occurs                                                                   
// when the view/collar/overlay parent is upating the screen.                                                                   
// Revision 1.8  1999/12/16 08:12:45  billyb                                                                   
// Changed data structure for entries and the way that the entries                                                                   
// are added to the combobox.                                                                   
// Revision 1.7  1999/12/08 17:42:20  billyb                                                                   
// Added CS_OWNDC.                                                                   
// Revision 1.6  1999/11/30 06:58:12  billyb                                                                   
// Added CComboListSpecial.  Added methods to use range                                                                   
// data to fill combobox.  Added methods to handle key                                                                   
// presses and mouse clicks for droplists.                                                                   
// Revision 1.5  1999/11/09 21:03:05  billyb                                                                   
// Optimized loops.  Added WS_CLIPCHILDREN.                                                                   
// Revision 1.4  1999/10/14 19:44:31  billyb                                                                   
// Added WS_VSCROLL style to all combo widgets.                                                                   
// Revision 1.3  1999/10/05 00:53:38  billyb                                                                   
// Added SetRedraw calls to Initialize so that adding strings                                                                   
// would not cause extra repaints.                                                                   
// Revision 1.2  1999/10/04 04:09:49  billyb                                                                   
// Added comments.  Fixed the lack of the drop down when                                                                   
// using a dropdownlist.  Added all of the methods needed                                                                   
// for use with comms.  Added OnSelchange to tell comms                                                                   
// of new data.                                                                   
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "..\core\Range.h"
#include "ComboWidget.h"
#include "..\core\UpdateList.h"

#include "ComboPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//////////////////////////////////////////////////////////////////////
// CComboListSpecial
//////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
// CComboListSpecial::CComboListSpecial
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 29 November 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.
//
/////////////////////////////////////////////////////////////////////////////
CComboListSpecial::CComboListSpecial()
{
    m_bNewValue = false;
}

/////////////////////////////////////////////////////////////////////////////
//
// CComboListSpecial::~CComboListSpecial
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 29 November 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.
//
/////////////////////////////////////////////////////////////////////////////
CComboListSpecial::~CComboListSpecial()
{
}


BEGIN_MESSAGE_MAP(CComboListSpecial, CListBox)
    //{{AFX_MSG_MAP(CComboListSpecial)
    ON_WM_LBUTTONDOWN()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//
// void CComboListSpecial::OnLButtonDown() 
//
// Inputs           : UINT nFlags  - flags that tell what other keys may 
//                                   have been pressed when the click 
//                                   occurred.
//                    CPoint point - the position of the click.
//
// Return Values    : None.
//
// Date             : 29 November 1999
//
// Engineer         : Billy Baker
//
// Description      : CComboWidget::OnLButtonDown() is an override of 
//                    the standard MFC method for CWnd derived classes. 
//                    Here, it is used to determine if the mouse click on
//                    the drop list portion of a combo box was on a piece
//                    of text.
//
/////////////////////////////////////////////////////////////////////////////
void CComboListSpecial::OnLButtonDown(UINT nFlags, CPoint point) 
{
    CRect rect;
    GetClientRect(&rect);

    if (rect.PtInRect(point) == TRUE)
    {
        m_bNewValue = true;
    }
    else
    {
        m_bNewValue = false;
    }

    CListBox::OnLButtonDown(nFlags, point);
}

//////////////////////////////////////////////////////////////////////
// Accessors
//////////////////////////////////////////////////////////////////////

bool CComboListSpecial::NewValue()
{
    return m_bNewValue;
}

//////////////////////////////////////////////////////////////////////
// Mutators
//////////////////////////////////////////////////////////////////////

void CComboListSpecial::NewValue(const bool bNewValue)
{
    m_bNewValue = bNewValue;
}

//////////////////////////////////////////////////////////////////////
// CComboWidget
//////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
// CComboWidget::CComboWidget()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  Set the name of the widget which
//                    is used in the XML data and under the icons in the 
//                    editor.  Initialize other member variables.
//
/////////////////////////////////////////////////////////////////////////////
CComboWidget::CComboWidget() : CWidget()
{
    m_stlStrWidgetName          = _FSI_STL::string("ComboBox");

    m_listWidgetPropPages.push_back(CComboPage::CreateObject);

    CComboWidget::InitReinit();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CComboWidget::InitReinit()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 28 March 2000
//
// Engineer         : Billy Baker
//
// Description      : InitReinit is used to initialize member variables 
//                    when a widget is first created and when 
//                    instances are reused.
//
/////////////////////////////////////////////////////////////////////////////
void CComboWidget::InitReinit()
{
    m_lOptions                  = DROPLIST;
    m_stlStrSelection           = _FSI_STL::string("");
    m_stlStrTextForSelection    = _FSI_STL::string("");
    m_bDataChanged              = false;
    m_mapEntries.clear();
}

/////////////////////////////////////////////////////////////////////////////
//
// CComboWidget::~CComboWidget()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.
//
/////////////////////////////////////////////////////////////////////////////
CComboWidget::~CComboWidget()
{
}


BEGIN_MESSAGE_MAP(CComboWidget, CComboBox)
	//{{AFX_MSG_MAP(CComboWidget)
	ON_WM_LBUTTONDBLCLK()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_SETCURSOR()
    ON_WM_DESTROY()
	ON_WM_WINDOWPOSCHANGED()
	ON_WM_RBUTTONUP()
	ON_WM_KEYUP()
	ON_WM_KEYDOWN()
    ON_WM_CTLCOLOR()
	ON_CONTROL_REFLECT(CBN_CLOSEUP, OnCloseup)
	ON_WM_PAINT()
	ON_WM_NCPAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//
// CWidget* CComboWidget::CreateObject()
//
// Inputs           : None.
//
// Return Values    : A pointer to a new instance of CComboWidget.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CComboWidget::CreateObject() is a common 
//                    framework method used to create a new instance of 
//                    CComboWidget.  It is a static member.  The 
//                    address of this method is stored in a map of 
//                    widget name to CreateObject address in the 
//                    component interface for the DLL that contains the 
//                    CComboWidget.  Using this data structure, a 
//                    new instance of CComboWidget can be created 
//                    when one is encountered in the XML page 
//                    description file.
//
/////////////////////////////////////////////////////////////////////////////
CWidget* CComboWidget::CreateObject()
{
    return new CComboWidget();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CComboWidget::Initialize()
//
// Inputs           : CXMLWidget*& rpXMLWidget - reference to a pointer 
//                                               that holds the data to 
//                                               create a CComboWidget.
//                    CWnd* pWnd               - the parent CWnd object.
//                    const long lId           - identifier.
//                    bool bEditMode           - whether editing is taking 
//                                               place.
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CComboWidget::Initialize() is a common 
//                    framework method.  It is called after an instance 
//                    of CComboWidget has been created.  It is 
//                    responsible for initializing most of the internal 
//                    data members with data from the XMLWidget.  This 
//                    is done using the call to ResetProperties.  If 
//                    the XMLWidget pointer is NULL, a new XMLWidget 
//                    instance is created with default settings.  
//                    Generic help text is set here and any CWnd 
//                    derived Create() calls are made to create the 
//                    Windows object that allows for the use of the MFC 
//                    messages.  The HWND for the CWnd derived object 
//                    that is created is then added to a map in CWidget 
//                    that keeps track of what CWidget derived pointers 
//                    are valid.  This is to make sure that all of the 
//                    threads do not try to dereference bad pointers.
//
/////////////////////////////////////////////////////////////////////////////
void CComboWidget::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                               const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    CComboWidget::InitReinit();

    if (rpXMLWidget != NULL)
    {
        ResetProperties();
    }

    long int lFormat = CBS_NOINTEGRALHEIGHT;
    CRect rect(m_exPtUpperLeft, m_exPtLowerRight);

//    if ((m_lOptions & SIMPLE) != 0)
    {
//        lFormat |= CBS_SIMPLE;
    }
//    else if ((m_lOptions & DROPLIST) != 0)
    {
        lFormat |= CBS_DROPDOWNLIST;

        // needed to get the drop down
        rect.bottom += 100;
    }

    if (GetSafeHwnd() == NULL)
    {
        Create(WS_VSCROLL | WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN | lFormat, rect,
               (CWnd*)pWnd, lId);
    }
    else
    {
        SetParent(pWnd);
        MoveWindow(rect, FALSE);
        ShowWindow(SW_NORMAL);
    }

    m_pWnd = this;

    // For use with CWidget::IsValidAddress().
    m_mapValidAddresses[this] = m_pWnd->GetSafeHwnd();

    // Fill the combo box with its strings.
    SetRedraw(FALSE);
    ResetContent();

    _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> >::iterator mIt = m_mapEntries.begin();
    _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> >::iterator mendIt = m_mapEntries.end();
    _FSI_STL::list<_FSI_STL::string>::iterator lIt = NULL;
    _FSI_STL::list<_FSI_STL::string>::iterator lendIt = NULL;
    int nPos = 0;

    while (mIt != mendIt)
    {
        lIt     = (*mIt).second.begin();
        lendIt  = (*mIt).second.end();
        while (lIt != lendIt)
        {
            InsertString(nPos, (*lIt).c_str());
            SetItemData(nPos, (*mIt).first);
            nPos++;
            lIt++;
        }
        mIt++;
    }
    SetRedraw(TRUE);
}

/////////////////////////////////////////////////////////////////////////////
//
// void CComboWidget::ResetProperties()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CComboWidget::ResetProperties() is a common 
//                    framework method.  It is called whenever the XML 
//                    in the CXMLWidget needs to be parsed for data 
//                    used by the ComboWidget.
//
/////////////////////////////////////////////////////////////////////////////
void CComboWidget::ResetProperties()
{
    CWidget::ResetProperties();
    CWidget::ExtentsProperties();

    // Find the OPTIONS element and get the options data.
    CXMLElement* pXMLElement = NULL;
    POSITION pos = NULL;
    if (m_pXMLWidget->FindElement(pXMLElement, pos, 
                                  _FSI_STL::string("OPTIONS")) == true)
    {
        m_lOptions = atoi(pXMLElement->ElementValue().c_str());
    }
    else
    {
        // No element was found.  Add an OPTIONS element and set it to
        // the default options.
        CString strOptions;
        strOptions.Format("%d",m_lOptions);
        m_pXMLWidget->AddElement(_FSI_STL::string("OPTIONS"), 
                                 _FSI_STL::string((LPCTSTR)strOptions),
                                 NULL);
    }

    if (GetSafeHwnd() != NULL)
    {
        ResetContent();

        _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> >::iterator mIt = m_mapEntries.begin();
        _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> >::iterator mendIt = m_mapEntries.end();
        _FSI_STL::list<_FSI_STL::string>::iterator lIt = NULL;
        _FSI_STL::list<_FSI_STL::string>::iterator lendIt = NULL;
        int nPos = 0;

        while (mIt != mendIt)
        {
            lIt     = (*mIt).second.begin();
            lendIt  = (*mIt).second.end();
            while (lIt != lendIt)
            {
                InsertString(nPos, (*lIt).c_str());
                SetItemData(nPos, (*mIt).first);
                nPos++;
                lIt++;
            }
            mIt++;
        }
    }
}

void CComboWidget::AddRangeData(const CRange* pRange, const _FSI_STL::string stlStrVariable)
{
    if (pRange == NULL)
    {
        return;
    }

    if (stlStrVariable  == "Default")
    {
        m_mapEntries[(long)const_cast<CRange*>(pRange)->Lower()].push_back(const_cast<CRange*>(pRange)->TextTrue());
    }

    m_bDataChanged = true;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CComboWidget::OnLButtonDblClk()
//
// Inputs           : UINT nFlags  - flags that tell what other keys may 
//                                   have been pressed when the click 
//                                   occurred.
//                    CPoint point - the position of the click.
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CComboWidget::OnLButtonDblClk() is an override of 
//                    the standard MFC method for CWnd derived classes. 
//
/////////////////////////////////////////////////////////////////////////////
void CComboWidget::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
    OnLButtonUp(nFlags, point);
}

/////////////////////////////////////////////////////////////////////////////
//
// void CComboWidget::OnLButtonDown()
//
// Inputs           : UINT nFlags  - flags that tell what other keys may 
//                                   have been pressed when the click 
//                                   occurred.
//                    CPoint point - the position of the click.
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CComboWidget::OnLButtonDown() is an override of 
//                    the standard MFC method for CWnd derived classes. 
//                    Here, it is used to showing a tracking rectangle in
//                    the editor or to show any focus or push down states
//                    in the runtime.
//
/////////////////////////////////////////////////////////////////////////////
void CComboWidget::OnLButtonDown(UINT nFlags, CPoint point) 
{
    if (m_bEditing == true)
    {
        CWidget::Track(point);
    }
    else
    {
    	CComboBox::OnLButtonDown(nFlags, point);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CComboWidget::OnLButtonUp()
//
// Inputs           : UINT nFlags  - flags that tell what other keys may 
//                                   have been pressed when the click 
//                                   occurred.
//                    CPoint point - the position of the click.
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CComboWidget::OnLButtonUp() is an override of 
//                    the standard MFC method for CWnd derived classes. 
//
/////////////////////////////////////////////////////////////////////////////
void CComboWidget::OnLButtonUp(UINT nFlags, CPoint point) 
{
    if (m_bEditing == true)
    {
    }
    else
    {
        if (m_bFocus != true)
        {
	        m_bFocus = true;
            m_bRedraw = true;
        }

        if (m_bLButtonDown != false)
        {
            m_bRedraw = true;
            m_bLButtonDown = false;
        }

        CComboBox::OnLButtonUp(nFlags, point);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CComboWidget::OnSetCursor()
//
// Inputs           : UINT nFlags  - flags that tell what other keys may 
//                                   have been pressed when the click 
//                                   occurred.
//                    CPoint point - the position of the click.
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CComboWidget::OnSetCursor() is an override of 
//                    the standard MFC method for CWnd derived classes. 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CComboWidget::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
    if (m_bEditing == true && m_pTracker != NULL)
    {
        if (pWnd == this && m_pTracker->SetCursor(pWnd, nHitTest))
        {
            return TRUE;
        }
    }
	
	return CComboBox::OnSetCursor(pWnd, nHitTest, message);
}

/////////////////////////////////////////////////////////////////////////////
//
// void CComboWidget::OnWindowPosChanged()
//
// Inputs           : UINT nFlags  - flags that tell what other keys may 
//                                   have been pressed when the click 
//                                   occurred.
//                    CPoint point - the position of the click.
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CComboWidget::OnWindowPosChanged() is an override of 
//                    the standard MFC method for CWnd derived classes. 
//
/////////////////////////////////////////////////////////////////////////////
void CComboWidget::OnWindowPosChanged(WINDOWPOS FAR* lpwndpos) 
{
	CComboBox::OnWindowPosChanged(lpwndpos);

    CWidget::PosChanged(CRect(lpwndpos->x, lpwndpos->y,
                              lpwndpos->x + lpwndpos->cx,
                              lpwndpos->y + lpwndpos->cy));
	
}

/////////////////////////////////////////////////////////////////////////////
//
// void CComboWidget::OnRButtonUp()
//
// Inputs           : UINT nFlags  - flags that tell what other keys may 
//                                   have been pressed when the click 
//                                   occurred.
//                    CPoint point - the position of the click.
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CComboWidget::OnRButtonUp() is an override of 
//                    the standard MFC method for CWnd derived classes. 
//
/////////////////////////////////////////////////////////////////////////////
void CComboWidget::OnRButtonUp(UINT nFlags, CPoint point) 
{
    CWidget::RButtonUp(nFlags, point);
}

/////////////////////////////////////////////////////////////////////////////
//
// CVariant* CComboWidget::GetValue()
//
// Inputs           : CString& rstrValue - the name of the internal 
//                                         variable whose value is needed
//                    .
//
// Return Values    : A pointer to CVariant instance that holds the 
//                    value for the requested internal variable.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CComboWidget::GetValue() is a common framework 
//                    method.  It is used when ever a user performs an 
//                    action like a button click or pressing a 
//                    return/enter key. These actions are performed on 
//                    the graphical element and signal that data needs 
//                    to go from the graphical element to somewhere 
//                    else.  Here, the somewhere else would either be a 
//                    local comms variable or a host variable.  Here, the
//                    value being sent is the status of the Combo button.
//
/////////////////////////////////////////////////////////////////////////////
CVariant* CComboWidget::GetValue(const CString &rstrValue)
{
    return (&m_variant);
}

/////////////////////////////////////////////////////////////////////////////
//
// void CComboWidget::OnKeyUp() 
//
// Inputs           : UINT nChar - the keyboard button that was pressed.
//
//                    UINT nRepCnt - the number of times it was pressed.
//
//                    UINT nFlags  - flags that tell what other keys may 
//                                   have been pressed when the click 
//                                   occurred.
//
// Return Values    : None.
//
// Date             : 29 November 1999
//
// Engineer         : Billy Baker
//
// Description      : CComboWidget::OnKeyUp() is an override of 
//                    the standard MFC method for CWnd derived classes. 
//                    Here, it is used to drop the list of a drop list for
//                    any key press.  It will also reset the combo box
//                    to the last value from UpdateRenderVariables when the 
//                    Escape key is pressed.  If the drop list is down and 
//                    Return is pressed, all of the attached actions will 
//                    have their OnLButtonUp methods invoked which may use 
//                    the new value.
//
/////////////////////////////////////////////////////////////////////////////
void CComboWidget::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
    if (m_bEditing == false)
    {
        if ((m_lOptions & DROPLIST) != 0)
        {
            // If the escape key is pressed when the droplist is
            // down, reset the combo box to the last selected text
            // as determined in UpdateRenderVariables.
            if (nChar == VK_ESCAPE && GetDroppedState() == TRUE)
            {
                ShowDropDown(FALSE);

                SelectString(-1, m_stlStrTextForSelection.c_str());

                return;
            }

            // If the return key is pressed when the droplist is
            // down, get the new value and invoke all of the OnLButtonUp
            // methods for any attached actions.
            if (nChar == VK_RETURN && GetDroppedState() == TRUE)
            {
                int n       = 0;
                long lValue = 0;
                if (m_wndListBox.GetSafeHwnd() != NULL)
                {
                    n = m_wndListBox.GetCurSel();
                    lValue = GetItemData(n);
                }

                m_variant.Value(lValue);

                ShowDropDown(FALSE);

                _FSI_STL::list<CAction*>::iterator lIt = m_listActions.begin();
                _FSI_STL::list<CAction*>::iterator lendIt = m_listActions.end();
                while (lIt != lendIt)
                {
                    (*lIt)->OnLButtonUp();
                    lIt++;
                }

                return;
            }

            // If the drop list has not been dropped, then any key will
            // drop it.
            ShowDropDown();
        }
    }

   	CComboBox::OnKeyUp(nChar, nRepCnt, nFlags);
}

/////////////////////////////////////////////////////////////////////////////
//
// void CComboWidget::OnKeyDown() 
//
// Inputs           : UINT nChar - the keyboard button that was pressed.
//
//                    UINT nRepCnt - the number of times it was pressed.
//
//                    UINT nFlags  - flags that tell what other keys may 
//                                   have been pressed when the click 
//                                   occurred.
//
// Return Values    : None.
//
// Date             : 29 November 1999
//
// Engineer         : Billy Baker
//
// Description      : CComboWidget::OnKeyDown() is an override of 
//                    the standard MFC method for CWnd derived classes. 
//                    Here, it is used to ignore the default behavior
//                    of pressing the Return or Escape keys.  These are
//                    handled in OnKeyUp.
//
/////////////////////////////////////////////////////////////////////////////
void CComboWidget::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
    if (m_bEditing == false)
    {
        if ((m_lOptions & DROPLIST) != 0)
        {
            // Ignore the key down for return and escape when in
            // droplist mode.  The key up for these are handled 
            // in OnKeyUp.
            if (nChar == VK_RETURN || nChar == VK_ESCAPE)
            {
                return;
            }
        }
    }

	CComboBox::OnKeyDown(nChar, nRepCnt, nFlags);
}

/////////////////////////////////////////////////////////////////////////////
//
// void CComboWidget::OnDestroy() 
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 29 November 1999
//
// Engineer         : Billy Baker
//
// Description      : CComboWidget::OnDestroy() is an override of 
//                    the standard MFC method for CWnd derived classes. 
//                    Here, it is used to unsubclass the m_wndListBox
//                    member if it was subclassed in OnCtlColor.
//
/////////////////////////////////////////////////////////////////////////////
void CComboWidget::OnDestroy() 
{
    // Unsubclass the list box portion of the
    // combo box.  The check is needed because the
    // combo box must be painted once for the subclass
    // to have taken place.
    if (m_wndListBox.GetSafeHwnd() != NULL)
        m_wndListBox.UnsubclassWindow();

    CComboBox::OnDestroy();
}

/////////////////////////////////////////////////////////////////////////////
//
// HBRUSH CComboWidget::OnCtlColor() 
//
// Inputs           : CDC* pDc - pointer to DC for child control.
//                   
//                    CWnd* pWnd - pointer to the control.
// 
//                    UINT nCtlColor - type of control.
//
// Return Values    : handle of brush to paint the background of the control.
//
// Date             : 29 November 1999
//
// Engineer         : Billy Baker
//
// Description      : CComboWidget::OnCtlColor() is an override of 
//                    the standard MFC method for CWnd derived classes. 
//                    Here, it is used to subclass the m_wndListBox
//                    member.  This member is important for determining
//                    whether a mouse click occurred on the droplist.
//
/////////////////////////////////////////////////////////////////////////////
HBRUSH CComboWidget::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
    if (nCtlColor == CTLCOLOR_LISTBOX)
    {
        // Subclass the list box portion of the combo box to get
        // the WM_LBUTTONDOWN message when the display list is dropped.
        if (m_wndListBox.GetSafeHwnd() == NULL)
            m_wndListBox.SubclassWindow(pWnd->GetSafeHwnd());
    }

    HBRUSH hbr = CComboBox::OnCtlColor(pDC, pWnd, nCtlColor);

    return hbr;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CComboWidget::OnCloseup() 
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 29 November 1999
//
// Engineer         : Billy Baker
//
// Description      : CComboWidget::OnCloseup() is a message handler for
//                    CBN_CLOSEUP.  It is responsible for invoking the
//                    OnLButtonUp methods of all attached actions when
//                    the mouse is clicked in the droplist.  If the
//                    mouse was clicked outside of the droplist, then
//                    the combo box is reset to the last value from
//                    UpdateRenderVariables.
//
/////////////////////////////////////////////////////////////////////////////
void CComboWidget::OnCloseup() 
{
    if (m_bEditing == false)
    {
        // A left button down occurred in the list box portion
        // of the combo box.  Thus, update with the text under the
        // mouse.  Else, reset the combo box to the last selected text.
        if (m_wndListBox.NewValue() == true)
        {
            m_wndListBox.NewValue(false);

            // Get the highlighted text under the mouse.
            int n       = 0;
            long lValue = 0;
            if (m_wndListBox.GetSafeHwnd() != NULL)
            {
                n = m_wndListBox.GetCurSel();
                lValue = GetItemData(n);
            }

            m_variant.Value(lValue);

            _FSI_STL::list<CAction*>::iterator lIt = m_listActions.begin();
            _FSI_STL::list<CAction*>::iterator lendIt = m_listActions.end();
            while (lIt != lendIt)
            {
                (*lIt)->OnLButtonUp();
                lIt++;
            }
        }
        else
        {
            SetCurSel(-1);
			int i = FindStringExact(-1, m_stlStrTextForSelection.c_str());
	        SetCurSel(i);
            //SelectString(-1, m_stlStrTextForSelection.c_str());
        }
    }
}

//////////////////////////////////////////////////////////////////////
// Accessors
//////////////////////////////////////////////////////////////////////

_FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> > CComboWidget::Entries()
{
    return m_mapEntries;
}

void  CComboWidget::Entries(_FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> >  &mapEntries)
{
   m_mapEntries   =  mapEntries;
   m_bDataChanged =  true;
}

//////////////////////////////////////////////////////////////////////
// Methods called from Comms thread
//////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
// void CComboWidget::ChangeValue()
//
// Inputs           : CString& rstrElementVar - the internal name of a 
//                                              variable that needs to be 
//                                              updated.
//                    CChangeValue* pCV       - pointer to data used to 
//                                              update an internal 
//                                              variable.
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CCombo::ChangeValue() is a common framework 
//                    method that is used by the Comms thread to send 
//                    new data to the graphical elements.  Since it is 
//                    called from another thread, the special internal 
//                    variables are used to store the updates.  Before 
//                    the graphical element is redrawn, 
//                    UpdateRenderVariables is called to copy the 
//                    updated values to the values used for rendering.  
//                    This causes more memory to be used but prevents 
//                    the use of synchronization objects that may stall 
//                    the Comms thread.
//
/////////////////////////////////////////////////////////////////////////////
void CComboWidget::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
    if (pCV == NULL)
    {
        return;
    }

    if (rstrElementVar == "Default")
    {
        m_stlStrSelection = (_FSI_STL::string)*(pCV->Variant());
    }
    else
    {
        CWidget::ChangeValue(rstrElementVar, pCV);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CComboWidget::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : true  - all of the render variables were updated.
//                    false - a problem occurred updating the render 
//                            variables.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CComboWidget::UpdateRenderVariables is a 
//                    common framework method that is called by the 
//                    Comms thread to make sure that all of the 
//                    variables used for rendering have the most up to 
//                    date data.
//
/////////////////////////////////////////////////////////////////////////////
bool CComboWidget::UpdateRenderVariables()
{
    bool bRetVal = CWidget::UpdateRenderVariables();

    if (bRetVal == true)
    {
        _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> >::iterator mIt = NULL;
        mIt = m_mapEntries.find(atoi(m_stlStrSelection.c_str()));

        if (mIt != m_mapEntries.end())
        {
            m_stlStrTextForSelection = (*mIt).second.front();
//            SelectString(-1, m_stlStrTextForSelection.c_str());
        }
        else
        {
           m_stlStrTextForSelection = "";
        }

    }

    return bRetVal;
}


void CComboWidget::OnPaint() 
{
    HWND hWnd = BaseWidget()->Wnd()->GetParent()->GetSafeHwnd();
    if (CWidget::ScreenRedrawing(hWnd) == true)
    {
    }
    else
    {
        CUpdateList::AddPaintWidget(hWnd, this);
    }
}

void CComboWidget::OnNcPaint() 
{
    // Do not do anything.  OnPaint will take care of 
    // drawing what would need to be drawn here.
}

void CComboWidget::Draw()
{
    if (m_bDataChanged == true)
    {
        m_bDataChanged = false;
        if (GetSafeHwnd() != NULL)
        {
            SetRedraw(FALSE);
            ResetContent();

            _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> >::iterator mIt = m_mapEntries.begin();
            _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> >::iterator mendIt = m_mapEntries.end();
            _FSI_STL::list<_FSI_STL::string>::iterator lIt = NULL;
            _FSI_STL::list<_FSI_STL::string>::iterator lendIt = NULL;
            int nPos = 0;

            while (mIt != mendIt)
            {
                lIt     = (*mIt).second.begin();
                lendIt  = (*mIt).second.end();
                while (lIt != lendIt)
                {
                    InsertString(nPos, (*lIt).c_str());
                    SetItemData(nPos, (*mIt).first);
                    nPos++;
                    lIt++;
                }
                mIt++;
            }
            SetCurSel(-1);
			int i = FindStringExact(-1, m_stlStrTextForSelection.c_str());
	        SetCurSel(i);
            //SelectString(-1, m_stlStrTextForSelection.c_str());
            SetRedraw(TRUE);
        }
    }

    if (IsWindowEnabled() == TRUE  && m_bEnabled == false ||
        IsWindowEnabled() == FALSE && m_bEnabled == true)
    {
        m_bRepaint = true;

        SetRedraw(FALSE);
        EnableWindow(m_bEnabled);
        SetRedraw(TRUE);
    }

    SetCurSel(-1);
	int j = FindStringExact(-1, m_stlStrTextForSelection.c_str());
	SetCurSel(j);
    //SelectString(-1, m_stlStrTextForSelection.c_str());

    Invalidate();
    DefWindowProc(WM_NCPAINT, 1, 0);
    DefWindowProc(WM_PAINT, 0, 0);
}
