/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : ComboPage.h
//
// Date             : 23 November 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.3 $
//
// Description      : ComboPage.h contains the definition of the 
//                    CComboPage class.  This class is derived from
//                    Core::CBasePage and is used to set the type of
//                    combo box to display.  It also shows any range
//                    data that will be used to populate the combo box.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : _FSI_STL::map, _FSI_STL::string, CListCtrl, 
//                    Core::CBasePage.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: ComboPage.h $                                                                   
// Revision 1.3  1999/12/16 08:12:41  billyb                                                                   
// Changed data structure for entries and the way that the entries                                                                   
// are added to the combobox.                                                                   
// Revision 1.2  1999/11/23 19:56:31  billyb                                                                   
// Added comments.  Changed functionality to display range                                                                   
// data that is used to populate a combobox.                                                                   
/////////////////////////////////////////////////////////////////////////////
#if !defined(_COMBOPAGE_H_)
#define _COMBOPAGE_H_

#include "resource.h"

#include "..\core\BasePage.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CComboPage : public CBasePage  
{
private:
    _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> >         m_mapEntries;

public:
	CComboPage();
	virtual ~CComboPage();
    static CBasePage* CreateObject();

// Dialog Data
	//{{AFX_DATA(CComboPage)
	enum { IDD = IDD_GENERAL_PAGE_COMBO };
	CListCtrl	m_ctrlEntryList;
	int		m_nType;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CComboPage)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CComboPage)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

    virtual void SetProperties(void* pWidget);
    virtual void UpdateProperties(void* pWidget);

};

#endif // !defined(_COMBOPAGE_H_)
