/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : ComboPage.cpp
//
// Date             : 23 November 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.5 $
//
// Description      : ComboPage.cpp contains the implementation of the 
//                    CComboPage class.  This class is derived from
//                    Core::CBasePage and is used to set the type of
//                    combo box to display.  It also shows any range
//                    data that will be used to populate the combo box.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : _FSI_STL::map, _FSI_STL::string, CListCtrl, 
//                    Core::CBasePage.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: ComboPage.cpp $                                                                   
// Revision 1.5  2000/03/07 20:39:32  billyb                                                                   
// Changed calls to AddElementValue.  Fixed warnings.                                                                   
// Revision 1.4  1999/12/16 08:12:37  billyb                                                                   
// Changed data structure for entries and the way that the entries                                                                   
// are added to the combobox.                                                                   
// Revision 1.3  1999/11/23 19:56:24  billyb                                                                   
// Added comments.  Changed functionality to display range                                                                   
// data that is used to populate a combobox.                                                                   
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "ComboPage.h"

#include "..\core\widget.h"
#include "ComboWidget.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
//
// CComboPage::CComboPage()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 23 November 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  Sets the name of the 
//                    property page.
//
/////////////////////////////////////////////////////////////////////////////
CComboPage::CComboPage() : CBasePage(CComboPage::IDD)
{
	//{{AFX_DATA_INIT(CComboPage)
	m_nType = -1;
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("ComboBox");
}

/////////////////////////////////////////////////////////////////////////////
//
// CComboPage::~CComboPage()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 23 November 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.
//
/////////////////////////////////////////////////////////////////////////////
CComboPage::~CComboPage()
{
}

void CComboPage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CComboPage)
	DDX_Control(pDX, IDC_COMBO_LIST, m_ctrlEntryList);
	DDX_Radio(pDX, IDC_COMBO_SIMPLE, m_nType);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CComboPage, CBasePage)
	//{{AFX_MSG_MAP(CComboPage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//
// CBasePage* CComboPage::CreateObject()
//
// Inputs           : None.
//
// Return Values    : A pointer to a new instance of the CComboPage class.
//
// Date             : 22 November 1998
//
// Engineer         : Billy Baker
//
// Description      : CreateObject is a static member method that 
//                    creates a new instance of the CComboPage.  
//                    Every class derived from CBasePage must 
//                    implmement CreateObject as each Widget contains a 
//                    list of pointers to the CreateObject methods that 
//                    correspond to the property pages needed for that Widget.
//
/////////////////////////////////////////////////////////////////////////////
CBasePage* CComboPage::CreateObject()
{
    return new CComboPage;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CComboPage::SetProperties()
//
// Inputs           : void* pWidget - a pointer to be cast to a CWidget*
//
// Return Values    : None.
//
// Date             : 29 January 1999
//
// Engineer         : Billy Baker
//
// Description      : CComboPage::SetProperties is the standard 
//                    interface for initializing the dialog controls 
//                    with data from the CXMLWidget instance that is 
//                    associated with the CWidget instance that is 
//                    passed to the method.  Every ...::SetProperties 
//                    method does has a similar implmemenation--find 
//                    each element that is used in the property page 
//                    and for each find their attributes if there are 
//                    any.  Note: UpdateData is not called here since 
//                    SetProperties is called before Create.
//
/////////////////////////////////////////////////////////////////////////////
void CComboPage::SetProperties(void* pWidget)
{
    if (static_cast<CWidget*>(pWidget) == NULL)
    {
        return;
    }

    CXMLWidget* pXMLWidget = static_cast<CWidget*>(pWidget)->XMLWidget();
    if (pXMLWidget != NULL)
    {
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, 
                                    _FSI_STL::string("OPTIONS")) == true)
        {
            long int lOptions = atoi(pXMLElement->ElementValue().c_str());

            if ((lOptions & SIMPLE) != 0)
            {
                m_nType = 0;
            }
            else if ((lOptions & DROPLIST) != 0)
            {
                m_nType = 1;
            }
        }
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CComboPage::UpdateProperties()
//
// Inputs           : void* pWidget - a void pointer to be case to a CWidget*
//
// Return Values    : None.
//
// Date             : 29 January 1999
//
// Engineer         : Billy Baker
//
// Description      : CComboPage::UpdateProperties is another 
//                    standard interface method for dealing with 
//                    property pages derived from CBasePage.  When the 
//                    data from the property page needs to be applied, 
//                    the UpdateProperties method is called.  The 
//                    implementatin is similar in every CBasePage 
//                    derived class--find the elements in the 
//                    CXMLWidget that is associated with the CWidget 
//                    that is passed and update each element and any 
//                    associated attributes.
//
/////////////////////////////////////////////////////////////////////////////
void CComboPage::UpdateProperties(void* pWidget)
{
    if (static_cast<CWidget*>(pWidget) == NULL)
    {
        return;
    }

    CXMLWidget* pXMLWidget = static_cast<CWidget*>(pWidget)->XMLWidget();
    if (pXMLWidget != NULL && GetSafeHwnd() != NULL)
    {
        UpdateData(TRUE);
        CXMLElement* pXMLElement = NULL;
        POSITION pos = NULL;
        if (pXMLWidget->FindElement(pXMLElement, pos, 
                                    _FSI_STL::string("OPTIONS")) == true) 
        {
            long int lOptions = 0;
            if (m_nType == 0)
            {
                lOptions |= SIMPLE;
            }
            else if (m_nType == 1)
            {
                lOptions |= DROPLIST;
            }

            CString strValue;
            strValue.Format("%d",lOptions);
            pXMLElement->AddElementValue(_FSI_STL::string((LPCTSTR)strValue));
        }
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// BOOL CComboPage::OnInitDialog()
//
// Inputs           : None.
//
// Return Values    : TRUE.
//
// Date             : 23 November 1999
//
// Engineer         : Billy Baker
//
// Description      : OnInitDialog is an override of the MFC framework method.
//                    The override is needed to initialize the list control
//                    on the property page with the values from the parent
//                    widget.
//
/////////////////////////////////////////////////////////////////////////////
BOOL CComboPage::OnInitDialog() 
{
	CBasePage::OnInitDialog();
	
    // Setup the list with two column headings.
    CRect rect;
    m_ctrlEntryList.GetClientRect(&rect);

    m_ctrlEntryList.InsertColumn(0, "Selection", LVCFMT_LEFT, 
                                                 (int)(rect.Width() * .6667f));

    m_ctrlEntryList.InsertColumn(1, "Value",     LVCFMT_LEFT, 
                                                 (int)(rect.Width() * .3333f));

    // Clean the list control.
    m_ctrlEntryList.DeleteAllItems();

    // Get all of the entries from the parent widget.
    CWidget* pWidget = static_cast<CWidget*>(m_pWidget);
    CComboWidget* pComboWidget = NULL;
    if (pWidget != NULL)
    {
        pComboWidget = static_cast<CComboWidget*>(pWidget);

        if (pComboWidget != NULL)
        {
            m_mapEntries = pComboWidget->Entries();
        }
    }

    // Fill the list control.
    _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> >::iterator mIt = m_mapEntries.begin();
    _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> >::iterator mendIt = m_mapEntries.end();
    _FSI_STL::list<_FSI_STL::string>::iterator lIt      = NULL;
    _FSI_STL::list<_FSI_STL::string>::iterator lendIt   = NULL;
    long int lEntryStep = 0;
    CString str;

    while (mIt != mendIt)
    {
        lIt = (*mIt).second.begin();
        lendIt = (*mIt).second.end();

        while (lIt != lendIt)
        {
            m_ctrlEntryList.InsertItem(lEntryStep, (*lIt).c_str(), 0);
            str.Format("%d", (*mIt).first);
            m_ctrlEntryList.SetItemText(lEntryStep, 1, (LPCTSTR)str);
            lEntryStep++;
            lIt++;
        }

        mIt++;
    }
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
