/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : CheckBoxWidget.h
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.4 $
//
// Description      : CheckBoxWidget.h contains the definition of the 
//                    CCheckBoxWidget class.  This class displays a 
//                    square to the left of a singleline of text.  The 
//                    text is always left justified and vertically 
//                    centered.  The square has a white background and 
//                    uses black, white and two shades of grey to give 
//                    the appearance of being sunken.  An 'x' appears 
//                    in the square when the member variable 
//                    m_varChecked is true or not zero.  The only 
//                    colors that may be changed in the editor are the 
//                    background color and the foreground text color.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CWidget, General::CButtonWidget, 
//                    General::CTextWidget, Core::CVariant.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: CheckBoxWidget.h $                                                                   
// Revision 1.4  2000/03/07 20:38:56  billyb                                                                   
// Changed function signatures to eliminate warnings.                                                                   
// Revision 1.3  1999/10/21 01:36:06  billyb                                                                   
// Added override of ResetProperties.                                                                   
// Revision 1.2  1999/10/04 00:37:21  billyb                                                                   
// Added comments.  Made owner drawn.  Corrected problems                                                                   
// with m_variant.                                                                   
/////////////////////////////////////////////////////////////////////////////
#if !defined(_CHECKBOXWIDGET_H_)
#define _CHECKBOXWIDGET_H_

#include "TextWidget.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CCheckBoxWidget : public CTextWidget
{
// Construction
public:
	CCheckBoxWidget();

// Attributes
protected:
    CVariant    m_varChecked_cv;
    CVariant    m_varChecked;

    virtual void InitReinit();

public:
  	enum { IDB = IDB_CHECKBOX_WIDGET };

// Operations
public:
    static  CWidget*  CreateObject();
    virtual void      Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                 const long int lId, bool bEditMode);
    virtual void ResetProperties();

	virtual CVariant* GetValue(const CString &rstrValue);

    virtual void      ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);
    virtual bool      UpdateRenderVariables();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCheckBoxWidget)
	public:
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CCheckBoxWidget();

	// Generated message map functions
protected:
	//{{AFX_MSG(CCheckBoxWidget)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(_CHECKBOXWIDGET_H_)
